# hl7.v2.uv.terminology.v251#0.1.0: HL7 v2.5.1 Vocabulary

## Pages

* [Homepage](index.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](download.md)

## Resources

### CodeSystems

* [Manufacturers of Vaccines (code=MVX) (2.5.1 - 1.2.0)](CodeSystem-PH_ManufacturersOfVaccinesMVX_CDC_NIP.md)
* [Vaccines Administered (2.5.1 - 1.4.0)](CodeSystem-PH_VaccinesAdministeredCVX_CDC_NIP.md)
* [Accept/Application Acknowledgment Conditions (2.5.1 - 1.0.0)](CodeSystem-accept-applicationAcknowledgmentConditions.md)
* [Acknowledgment Code (2.5.1 - 1.2.0)](CodeSystem-acknowledgmentCodes.md)
* [Action Code (2.5.1 - 1.1.0)](CodeSystem-actionCodes.md)
* [Action Taken in Response to the Event (2.5.1 - 1.0.0)](CodeSystem-actionTakenInResponseToTheEvent.md)
* [Active/Inactive (2.5.1 - 1.0.0)](CodeSystem-active-inactive.md)
* [Additive/Preservative (2.5.1 - 2.0.0)](CodeSystem-additivePreservative.md)
* [Address Type (2.5.1 - 1.3.0)](CodeSystem-addressType.md)
* [Administration Device (2.5.1 - 1.0.0)](CodeSystem-administrationDevice.md)
* [Administration Method (2.5.1 - 1.0.0)](CodeSystem-administrationMethod.md)
* [Administrative Sex (2.5.1 - 1.0.0)](CodeSystem-administrativeSex.md)
* [Admission Level of Care Code (2.5.1 - 1.0.0)](CodeSystem-admissionLevelOfCare.md)
* [Admission Type (2.5.1 - 1.1.0)](CodeSystem-admissionType.md)
* [Admit Source (2.5.1 - 1.0.0)](CodeSystem-admitSource.md)
* [Advanced Beneficiary Notice Code (2.5.1 - 1.0.0)](CodeSystem-advancedBeneficiaryNotice.md)
* [Alert Device Code (2.5.1 - 1.0.0)](CodeSystem-alertDevice.md)
* [Alert Level (2.5.1 - 1.0.0)](CodeSystem-alertLevel.md)
* [Allergen Type (2.5.1 - 1.1.0)](CodeSystem-allergenType.md)
* [Allergy Clinical Status (2.5.1 - 1.0.0)](CodeSystem-allergyClinicalStatus.md)
* [Allergy Severity (2.5.1 - 1.1.0)](CodeSystem-allergySeverity.md)
* [Allow Substitution Codes (2.5.1 - 1.1.0)](CodeSystem-allowSubstitution.md)
* [Alternate Character Set Handling Scheme (2.5.1 - 1.1.0)](CodeSystem-alternateCharacterSetHandlingScheme.md)
* [Alternate Character Sets (2.5.1 - 1.2.0)](CodeSystem-alternateCharacterSets.md)
* [Ambulatory Payment Classification Code (2.5.1 - 1.0.0)](CodeSystem-ambulatoryPaymentClassification.md)
* [Ambulatory Status (2.5.1 - 1.0.0)](CodeSystem-ambulatoryStatus.md)
* [Amount Class (2.5.1 - 1.0.0)](CodeSystem-amountClass.md)
* [Amount Type (2.5.1 - 1.0.0)](CodeSystem-amountType.md)
* [Analyte Repeat Status (2.5.1 - 1.0.0)](CodeSystem-analyteRepeatStatus.md)
* [Annotations (2.5.1 - 1.0.0)](CodeSystem-annotations.md)
* [Appointment Reason Codes (2.5.1 - 1.0.0)](CodeSystem-appointmentReason.md)
* [Appointment Type Codes (2.5.1 - 1.0.0)](CodeSystem-appointmentType.md)
* [Mode of Arrival Code (2.5.1 - 1.0.0)](CodeSystem-arrivalMode.md)
* [Artificial Blood (2.5.1 - 1.0.0)](CodeSystem-artificialBlood.md)
* [Assignment of Benefits (2.5.1 - 1.0.0)](CodeSystem-assignmentOfBenefits.md)
* [Authorization Mode (2.5.1 - 1.0.0)](CodeSystem-authorizationMode.md)
* [Bed Status (2.5.1 - 1.1.0)](CodeSystem-bedStatus.md)
* [Blood Product Code (2.5.1 - 1.0.0)](CodeSystem-bloodProduct.md)
* [Blood Product Dispense Status (2.5.1 - 1.0.0)](CodeSystem-bloodProductDispenseStatus.md)
* [Blood Product Processing Requirements (2.5.1 - 1.0.0)](CodeSystem-bloodProductProcessingRequirements.md)
* [Blood Product Transfusion/Disposition Status (2.5.1 - 1.0.0)](CodeSystem-bloodProductTransfusion-dispositionStatus.md)
* [Body Parts (2.5.1 - 1.0.0)](CodeSystem-bodyParts.md)
* [Body Site (2.5.1 - 1.2.0)](CodeSystem-bodySite.md)
* [Body Site Modifier (2.5.1 - 1.0.0)](CodeSystem-bodySiteModifier.md)
* [BP Observation Status Codes Interpretation (2.5.1 - 1.0.0)](CodeSystem-bpObservationStatusCodesInterpretation.md)
* [Calendar Alignment (2.5.1 - 1.0.0)](CodeSystem-calendarAlignment.md)
* [Causality Observations (2.5.1 - 1.0.0)](CodeSystem-causalityObservations.md)
* [Certificate Status (2.5.1 - 1.0.0)](CodeSystem-certificateStatus.md)
* [Certification Patient Type (2.5.1 - 1.0.0)](CodeSystem-certificationPatientType.md)
* [Certification Status (2.5.1 - 1.0.0)](CodeSystem-certificationStatus.md)
* [Charge On Indicator (2.5.1 - 1.0.0)](CodeSystem-chargeOnIndicator.md)
* [Charge Type (2.5.1 - 1.0.0)](CodeSystem-chargeType.md)
* [Charge Type Reason (2.5.1 - 1.0.0)](CodeSystem-chargeTypeReason.md)
* [Check Digit Scheme (2.5.1 - 1.2.0)](CodeSystem-checkDigitScheme.md)
* [Notify Clergy Code (2.5.1 - 1.0.0)](CodeSystem-clergyNotificationType.md)
* [OCE Edit Code (2.5.1 - 1.0.0)](CodeSystem-cms-OCEEditCode-cs.md)
* [Modifier Edit Code (2.5.1 - 1.0.0)](CodeSystem-cms-OCEModifierEditCode-cs.md)
* [Coding System (2.5.1 - 1.2.0)](CodeSystem-codingSystem.md)
* [Command Response (2.5.1 - 1.0.1)](CodeSystem-commandResponse.md)
* [Comment Type (2.5.1 - 1.0.0)](CodeSystem-commentType.md)
* [Completion Status (2.5.1 - 1.0.0)](CodeSystem-completionStatus.md)
* [Computation Type (2.5.1 - 1.0.0)](CodeSystem-computationType.md)
* [Confidentiality Code (2.5.1 - 1.0.0)](CodeSystem-confidentialityCodes.md)
* [Consent Bypass Reason (2.5.1 - 1.0.0)](CodeSystem-consentBypassReason.md)
* [Consent Disclosure Level (2.5.1 - 1.0.0)](CodeSystem-consentDisclosureLevel.md)
* [Consent Mode (2.5.1 - 1.0.0)](CodeSystem-consentMode.md)
* [Consent Non-Disclosure Reason (2.5.1 - 1.0.0)](CodeSystem-consentNon-disclosureReason.md)
* [Consent Status (2.5.1 - 1.0.0)](CodeSystem-consentStatus.md)
* [Consent Type (2.5.1 - 1.0.0)](CodeSystem-consentType.md)
* [Contact Role (2.5.1 - 1.0.0)](CodeSystem-contactRole2.md)
* [Container Status (2.5.1 - 1.0.0)](CodeSystem-containerStatus.md)
* [Continuation Style Code (2.5.1 - 1.0.0)](CodeSystem-continuationStyle.md)
* [Controlled Substance Schedule (2.5.1 - 1.0.0)](CodeSystem-controlledSubstanceSchedule.md)
* [Coordination of Benefits (2.5.1 - 1.0.0)](CodeSystem-coordinationOfBenefits.md)
* [Coverage Type (2.5.1 - 1.0.0)](CodeSystem-coverageType.md)
* [CP Range Type (2.5.1 - 1.0.0)](CodeSystem-cpRangeType.md)
* [CWE statuses (2.5.1 - 1.0.0)](CodeSystem-cweStatuses.md)
* [Cyclic Entry/Exit Indicator (2.5.1 - 1.0.0)](CodeSystem-cyclicEntryExitIndicator.md)
* [Data Types (2.5.1 - 1.1.0)](CodeSystem-dataTypes.md)
* [Date/Time Selection Qualifier (2.5.1 - 1.0.0)](CodeSystem-date-timeSelectionQualifier.md)
* [Day Type (2.5.1 - 1.0.0)](CodeSystem-dayType.md)
* [Days of the Week (2.5.1 - 1.0.0)](CodeSystem-daysOfTheWeek.md)
* [Deferred Response Type (2.5.1 - 1.0.0)](CodeSystem-deferredResponseType.md)
* [Degree/License/Certificate (2.5.1 - 1.2.0)](CodeSystem-degreeLicenseCertificate.md)
* [Denial or Rejection Code (2.5.1 - 1.0.0)](CodeSystem-denialOrRejectionType.md)
* [Derived Specimen (2.5.1 - 1.0.0)](CodeSystem-derivedSpecimen.md)
* [Diagnosis Classification (2.5.1 - 1.0.0)](CodeSystem-diagnosisClassification.md)
* [Diagnosis Priority (2.5.1 - 1.0.0)](CodeSystem-diagnosisPriority.md)
* [Diagnosis Type (2.5.1 - 1.0.0)](CodeSystem-diagnosisType.md)
* [Diagnostic Service Section ID (2.5.1 - 1.4.0)](CodeSystem-diagnosticServiceSectionId.md)
* [Diet Code Specification Type (2.5.1 - 1.0.0)](CodeSystem-dietCodeSpecificationType.md)
* [Disabled Person Code (2.5.1 - 1.0.0)](CodeSystem-disabilityInformationRelationship.md)
* [Discharge Disposition (2.5.1 - 1.0.0)](CodeSystem-dischargeDisposition.md)
* [Dispense Method (2.5.1 - 1.0.0)](CodeSystem-dispenseMethod.md)
* [Dispense Type (2.5.1 - 1.0.0)](CodeSystem-dispenseType.md)
* [Document Availability Status (2.5.1 - 1.1.0)](CodeSystem-documentAvailabilityStatus.md)
* [Document Completion Status (2.5.1 - 1.0.0)](CodeSystem-documentCompletionStatus.md)
* [Document Confidentiality Status (2.5.1 - 2.0.0)](CodeSystem-documentConfidentialityStatus2.md)
* [Document Storage Status (2.5.1 - 1.0.0)](CodeSystem-documentStorageStatus.md)
* [Document Type (2.5.1 - 1.0.0)](CodeSystem-documentType.md)
* [DRG Payor (2.5.1 - 1.0.0)](CodeSystem-drgPayor.md)
* [Transfer Type (2.5.1 - 1.0.0)](CodeSystem-drgTransferType.md)
* [Duration Categories (2.5.1 - 1.1.0)](CodeSystem-durationCategories.md)
* [Eligibility Source (2.5.1 - 1.0.0)](CodeSystem-eligibilitySource.md)
* [Employment Status (2.5.1 - 2.0.0)](CodeSystem-employmentStatus.md)
* [Encoding (2.5.1 - 1.0.0)](CodeSystem-encoding.md)
* [Equipment State (2.5.1 - 1.0.0)](CodeSystem-equipmentState.md)
* [Error Severity (2.5.1 - 1.0.0)](CodeSystem-errorSeverity.md)
* [Escort Required (2.5.1 - 1.0.0)](CodeSystem-escortRequired.md)
* [Event (2.5.1 - 1.6.0)](CodeSystem-event.md)
* [Event Consequence (2.5.1 - 1.0.0)](CodeSystem-eventConsequence.md)
* [Event Expected (2.5.1 - 1.0.0)](CodeSystem-eventExpected.md)
* [Event Qualification (2.5.1 - 1.0.0)](CodeSystem-eventQualification.md)
* [Event Reason (2.5.1 - 1.3.0)](CodeSystem-eventReason.md)
* [Event Related Period (2.5.1 - 1.0.0)](CodeSystem-eventRelatedPeriod.md)
* [Event Reported To (2.5.1 - 1.0.0)](CodeSystem-eventReportedTo.md)
* [Event Seriousness (2.5.1 - 1.0.0)](CodeSystem-eventSeriousness.md)
* [Event Type (2.5.1 - 1.0.0)](CodeSystem-eventType.md)
* [Expanded Yes/no Indicator (2.5.1 - 1.0.0)](CodeSystem-expandedYes-NoIndicator.md)
* [Extended Priority Codes (2.5.1 - 1.0.0)](CodeSystem-extendedPriorityCodes.md)
* [Facility Type (2.5.1 - 1.0.0)](CodeSystem-facilityType.md)
* [File Level Event Code (2.5.1 - 1.0.0)](CodeSystem-file-levelEvent.md)
* [Filler Status Codes (2.5.1 - 1.2.0)](CodeSystem-fillerStatus.md)
* [Formulary Status (2.5.1 - 1.0.0)](CodeSystem-formularyStatus.md)
* [Gestation Category Code (2.5.1 - 1.0.0)](CodeSystem-gestationCategory.md)
* [Health Care Provider Area of Specialization (2.5.1 - 1.0.0)](CodeSystem-healthCareProviderAreaOfSpecialization.md)
* [Health Care Provider Classification (2.5.1 - 1.0.0)](CodeSystem-healthCareProviderClassification.md)
* [Health Care Provider Type Code (2.5.1 - 1.0.0)](CodeSystem-healthCareProviderTypeCode.md)
* [Identifier Type (2.5.1 - 1.3.0)](CodeSystem-identifierType.md)
* [Identity May Be Divulged (2.5.1 - 1.0.0)](CodeSystem-identityMayBeDivulged.md)
* [Identity Reliability Code (2.5.1 - 1.0.0)](CodeSystem-identityReliability.md)
* [Immunization Registry Status (2.5.1 - 1.0.0)](CodeSystem-immunizationRegistryStatus.md)
* [Inactive Reason Code (2.5.1 - 1.0.0)](CodeSystem-inactiveReason.md)
* [Incident Type Code (2.5.1 - 1.0.0)](CodeSystem-incidentType.md)
* [Indirect Exposure Mechanism (2.5.1 - 1.0.0)](CodeSystem-indirectExposureMechanism.md)
* [Inform Person Code (2.5.1 - 1.0.0)](CodeSystem-informInstructions.md)
* [Institution Relationship Type (2.5.1 - 1.0.0)](CodeSystem-institutionRelationshipType.md)
* [Invocation Event (2.5.1 - 1.0.0)](CodeSystem-invocationEvent.md)
* [Job Status (2.5.1 - 1.0.0)](CodeSystem-jobStatus.md)
* [Jurisdictional Breadth (2.5.1 - 1.0.0)](CodeSystem-jurisdictionalBreadth.md)
* [Kind of Quantity (2.5.1 - 1.0.0)](CodeSystem-kindOfQuantity.md)
* [Language Ability (2.5.1 - 1.0.0)](CodeSystem-languageAbility.md)
* [Language Proficiency (2.5.1 - 1.0.0)](CodeSystem-languageProficiency.md)
* [Level of Care (2.5.1 - 1.0.0)](CodeSystem-levelOfCare.md)
* [Living Arrangement (2.5.1 - 1.1.0)](CodeSystem-livingArrangement.md)
* [Living Dependency (2.5.1 - 2.0.0)](CodeSystem-livingDependency2.md)
* [Living Will Code (2.5.1 - 1.0.0)](CodeSystem-livingWillCodes.md)
* [Local/Remote Control State (2.5.1 - 1.0.0)](CodeSystem-local-remoteControlState.md)
* [Location Characteristic ID (2.5.1 - 1.0.0)](CodeSystem-locationCharacteristic.md)
* [Location Equipment (2.5.1 - 1.0.0)](CodeSystem-locationEquipment.md)
* [Location Relationship ID (2.5.1 - 1.0.0)](CodeSystem-locationRelationship.md)
* [Location Service Code (2.5.1 - 1.0.0)](CodeSystem-locationServiceType.md)
* [Mail Claim Party (2.5.1 - 1.0.0)](CodeSystem-mailClaimParty.md)
* [Marital Status (2.5.1 - 1.1.0)](CodeSystem-maritalStatus.md)
* [Marketing Basis (2.5.1 - 1.0.0)](CodeSystem-marketingBasis.md)
* [Master File Identifier Code (2.5.1 - 1.2.0)](CodeSystem-masterFileIdentifierCodes.md)
* [Record-level Event Code (2.5.1 - 1.0.0)](CodeSystem-masterfileActionCode.md)
* [Match Reason (2.5.1 - 1.0.0)](CodeSystem-matchReason.md)
* [Message Error Condition Codes (2.5.1 - 1.0.0)](CodeSystem-messageErrorCondition.md)
* [Message Structure (2.5.1 - 4.0.0)](CodeSystem-messageStructure.md)
* [Message Type (2.5.1 - 1.5.0)](CodeSystem-messageType.md)
* [MFN Record-level Error Return (2.5.1 - 1.0.0)](CodeSystem-mfnRecord-levelErrorReturn.md)
* [Military Rank/Grade (2.5.1 - 2.0.0)](CodeSystem-militaryRank-Grade.md)
* [Military Service (2.5.1 - 1.1.0)](CodeSystem-militaryService.md)
* [Military Status (2.5.1 - 1.0.0)](CodeSystem-militaryStatus.md)
* [Modality (2.5.1 - 1.0.0)](CodeSystem-modality.md)
* [Modify Indicator (2.5.1 - 1.0.0)](CodeSystem-modifyIndicator.md)
* [Money or Percentage Indicator (2.5.1 - 1.0.0)](CodeSystem-moneyOrPercentageIndicator.md)
* [Name/Address Representation (2.5.1 - 1.0.0)](CodeSystem-name-addressRepresentation.md)
* [Name Assembly Order (2.5.1 - 1.0.0)](CodeSystem-nameAssemblyOrder.md)
* [Name Type (2.5.1 - 1.2.0)](CodeSystem-nameType2.md)
* [Nature of Abnormal Testing (2.5.1 - 1.1.0)](CodeSystem-natureOfAbnormalTesting.md)
* [Nature of Challenge (2.5.1 - 1.0.0)](CodeSystem-natureOfChallenge.md)
* [Nature of Service/Test/Observation (2.5.1 - 1.1.0)](CodeSystem-natureOfServiceTestObservation.md)
* [Newborn Code (2.5.1 - 1.0.0)](CodeSystem-newbornType.md)
* [Specimen Role (2.5.1 - 1.1.0)](CodeSystem-noOIDfound.md)
* [Non-Subject Consenter Reason (2.5.1 - 1.0.0)](CodeSystem-non-subjectConsenterReason.md)
* [Abnormal Flags (2.5.1 - 1.3.1)](CodeSystem-observationInterpretation.md)
* [Observation Result Handling (2.5.1 - 1.0.0)](CodeSystem-observationResultHandling.md)
* [Observation Result Status Codes Interpretation (2.5.1 - 1.2.1)](CodeSystem-observationResultStatusCodesInterpretation.md)
* [Order Control Codes (2.5.1 - 1.5.0)](CodeSystem-orderControlCodes.md)
* [Order Status (2.5.1 - 1.2.0)](CodeSystem-orderStatus.md)
* [Order Type (2.5.1 - 1.0.0)](CodeSystem-orderType.md)
* [Organ Donor Code (2.5.1 - 1.2.0)](CodeSystem-organDonorCodes.md)
* [Practitioner Organization Unit Type (2.5.1 - 2.0.0)](CodeSystem-organizationUnitType.md)
* [Organizational Name Type (2.5.1 - 1.0.0)](CodeSystem-organizationalNameType.md)
* [Outlier Type (2.5.1 - 1.0.0)](CodeSystem-outlierType.md)
* [Overall Claim Disposition Code (2.5.1 - 1.0.0)](CodeSystem-overallClaimDisposition.md)
* [Override (2.5.1 - 1.0.0)](CodeSystem-override.md)
* [Override Type (2.5.1 - 1.0.0)](CodeSystem-overrideType.md)
* [Packaging Status Code (2.5.1 - 1.0.0)](CodeSystem-packagingStatus.md)
* [Patient Class (2.5.1 - 1.2.0)](CodeSystem-patientClass.md)
* [Patient Condition Code (2.5.1 - 1.0.0)](CodeSystem-patientCondition.md)
* [Patient Location Type (2.5.1 - 1.0.0)](CodeSystem-patientLocationType.md)
* [Patient Outcome (2.5.1 - 1.0.0)](CodeSystem-patientOutcome.md)
* [Patient's Relationship to Insured (2.5.1 - 1.0.0)](CodeSystem-patientsRelationshipToInsured.md)
* [Payment Adjustment Code (2.5.1 - 1.0.0)](CodeSystem-paymentAdjustmentInformation.md)
* [Person Location Type (2.5.1 - 1.0.0)](CodeSystem-personLocationType.md)
* [Pharmacy Order Types (2.5.1 - 1.0.0)](CodeSystem-pharmacyOrderTypes.md)
* [Policy Type (2.5.1 - 1.0.0)](CodeSystem-policyType.md)
* [Practitioner ID Number Type (2.5.1 - 1.1.0)](CodeSystem-practitionerIdNumberType.md)
* [Precaution Code (2.5.1 - 1.0.0)](CodeSystem-precaution.md)
* [Precision (2.5.1 - 1.0.0)](CodeSystem-precision.md)
* [Preferred Method of Contact (2.5.1 - 1.1.0)](CodeSystem-preferredMethodOfContact.md)
* [Price Type (2.5.1 - 1.0.0)](CodeSystem-priceType.md)
* [Primary Key Value Type (2.5.1 - 1.0.0)](CodeSystem-primaryKeyValueType.md)
* [Primary Observer's Qualification (2.5.1 - 1.0.0)](CodeSystem-primaryObserverQualification.md)
* [Priority (2.5.1 - 1.2.0)](CodeSystem-priority.md)
* [Privacy Level (2.5.1 - 1.0.0)](CodeSystem-privacyLevel.md)
* [Problem/Goal Action Code (2.5.1 - 1.0.0)](CodeSystem-problem-goalAction.md)
* [Procedure DRG Type (2.5.1 - 1.0.0)](CodeSystem-procedureDrgType.md)
* [Procedure Functional Type (2.5.1 - 1.0.0)](CodeSystem-procedureFunctionalType.md)
* [Procedure Practitioner Identifier Type (2.5.1 - 1.2.0)](CodeSystem-procedurePractitionerIdentifierCodeType.md)
* [Procedure Priority (2.5.1 - 1.0.0)](CodeSystem-procedurePriority.md)
* [Processing ID (2.5.1 - 1.0.0)](CodeSystem-processingId.md)
* [Processing Mode (2.5.1 - 1.1.0)](CodeSystem-processingMode.md)
* [Processing Priority (2.5.1 - 1.0.0)](CodeSystem-processingPriority.md)
* [Processing Type (2.5.1 - 1.0.0)](CodeSystem-processingType.md)
* [Product Source (2.5.1 - 1.0.0)](CodeSystem-productSource.md)
* [Production Class Code (2.5.1 - 1.0.0)](CodeSystem-productionClass.md)
* [Provider Billing (2.5.1 - 1.0.0)](CodeSystem-providerBilling.md)
* [Provider Role (2.5.1 - 1.0.0)](CodeSystem-providerRole.md)
* [Purge Status Code (2.5.1 - 1.0.0)](CodeSystem-purgeStatus.md)
* [Quantity Limited Request (2.5.1 - 1.1.0)](CodeSystem-quantityLimitedRequest.md)
* [Quantity Method (2.5.1 - 1.0.0)](CodeSystem-quantityMethod.md)
* [Query Priority (2.5.1 - 1.0.0)](CodeSystem-queryPriority.md)
* [Query/Response Format Code (2.5.1 - 1.2.0)](CodeSystem-queryResponseFormat.md)
* [Query Response Status (2.5.1 - 1.1.0)](CodeSystem-queryResponseStatus.md)
* [Query Results Level (2.5.1 - 1.0.2)](CodeSystem-queryResultsLevel.md)
* [Recreational Drug Use Code (2.5.1 - 1.0.0)](CodeSystem-recreationalDrugType.md)
* [Referral Category (2.5.1 - 1.0.0)](CodeSystem-referralCategory.md)
* [Referral Disposition (2.5.1 - 1.0.0)](CodeSystem-referralDisposition.md)
* [Referral Priority (2.5.1 - 1.0.0)](CodeSystem-referralPriority.md)
* [Referral Reason (2.5.1 - 1.0.0)](CodeSystem-referralReason.md)
* [Referral Status (2.5.1 - 1.0.0)](CodeSystem-referralStatus.md)
* [Referral Type (2.5.1 - 1.0.0)](CodeSystem-referralType.md)
* [Reimbursement Action Code (2.5.1 - 1.0.0)](CodeSystem-reimbursementAction.md)
* [Reimbursement Type Code (2.5.1 - 1.0.0)](CodeSystem-reimbursementType.md)
* [Relatedness Assessment (2.5.1 - 1.0.0)](CodeSystem-relatednessAssessment.md)
* [Relational Conjunction (2.5.1 - 1.0.0)](CodeSystem-relationalConjunction.md)
* [Relational Operator (2.5.1 - 1.0.0)](CodeSystem-relationalOperator.md)
* [Relationship (2.5.1 - 1.0.0)](CodeSystem-relationship.md)
* [Relationship Modifier (2.5.1 - 1.0.0)](CodeSystem-relationshipModifier.md)
* [Religion (2.5.1 - 2.0.0)](CodeSystem-religion2.md)
* [Remote Control Command (2.5.1 - 1.0.0)](CodeSystem-remoteControlCommand.md)
* [Repeat Pattern (2.5.1 - 1.1.0)](CodeSystem-repeatPattern.md)
* [Report Priority (2.5.1 - 1.0.0)](CodeSystem-reportPriority.md)
* [Report Source (2.5.1 - 1.0.0)](CodeSystem-reportSource.md)
* [Report Timing (2.5.1 - 1.0.0)](CodeSystem-reportTiming.md)
* [Reporting Priority (2.5.1 - 1.0.0)](CodeSystem-reportingPriority.md)
* [Response Flag (2.5.1 - 1.0.0)](CodeSystem-responseFlag.md)
* [Response Level (2.5.1 - 1.0.0)](CodeSystem-responseLevel.md)
* [Response Modality (2.5.1 - 1.0.0)](CodeSystem-responseModality.md)
* [Result Status (2.5.1 - 1.2.0)](CodeSystem-resultStatus.md)
* [Risk Management Incident Code (2.5.1 - 1.0.0)](CodeSystem-riskManagementIncident.md)
* [Risk Codes (2.5.1 - 1.0.0)](CodeSystem-risks.md)
* [Room Type (2.5.1 - 1.0.0)](CodeSystem-roomType.md)
* [Route of Administration (2.5.1 - 3.0.1)](CodeSystem-routeOfAdministration.md)
* [RX Component Type (2.5.1 - 1.0.0)](CodeSystem-rxComponentType.md)
* [Segment Action Code (2.5.1 - 1.0.0)](CodeSystem-segmentAction.md)
* [Segment Group (2.5.1 - 3.0.0)](CodeSystem-segmentGroup.md)
* [Sensitivity to Causative Agent Code (2.5.1 - 1.0.0)](CodeSystem-sensitivityToCausativeAgent.md)
* [Sequence condition (2.5.1 - 1.0.0)](CodeSystem-sequenceCondition.md)
* [Sequence/Results Flag (2.5.1 - 1.0.0)](CodeSystem-sequenceResultsFlag.md)
* [Sequencing (2.5.1 - 1.0.0)](CodeSystem-sequencing.md)
* [Service Request Relationship (2.5.1 - 1.0.0)](CodeSystem-serviceRequestRelationship.md)
* [Severity of Illness Code (2.5.1 - 1.0.0)](CodeSystem-severityOfIllness.md)
* [Signatory's Relationship to Subject (2.5.1 - 1.0.0)](CodeSystem-signatorysRelationshipToSubject.md)
* [Signature Code (2.5.1 - 1.0.0)](CodeSystem-signatureType.md)
* [Source of Comment (2.5.1 - 1.1.0)](CodeSystem-sourceOfComment.md)
* [Source Type (2.5.1 - 1.0.0)](CodeSystem-sourceType.md)
* [Special Handling Code (2.5.1 - 1.1.0)](CodeSystem-specialHandling.md)
* [Specialty Type (2.5.1 - 1.0.0)](CodeSystem-specialtyType.md)
* [Specimen Action Code (2.5.1 - 2.1.0)](CodeSystem-specimenAction.md)
* [Specimen Appropriateness (2.5.1 - 1.0.0)](CodeSystem-specimenAppropriateness.md)
* [Specimen Child Role (2.5.1 - 1.0.0)](CodeSystem-specimenChildRole.md)
* [Specimen Collection Method (2.5.1 - 1.0.0)](CodeSystem-specimenCollectionMethod.md)
* [Specimen Component (2.5.1 - 1.0.0)](CodeSystem-specimenComponent.md)
* [Specimen Condition (2.5.1 - 1.0.0)](CodeSystem-specimenCondition.md)
* [Specimen Quality (2.5.1 - 1.0.0)](CodeSystem-specimenQuality.md)
* [Specimen Reject Reason (2.5.1 - 1.0.0)](CodeSystem-specimenRejectReason.md)
* [Specimen Source Codes (2.5.1 - 1.3.1)](CodeSystem-specimenSourceCodes.md)
* [Specimen Type (2.5.1 - 1.0.0)](CodeSystem-specimenType.md)
* [Status of Evaluation (2.5.1 - 1.0.0)](CodeSystem-statusOfEvaluation.md)
* [Student Status (2.5.1 - 1.0.0)](CodeSystem-studentStatus.md)
* [Substance Status (2.5.1 - 1.0.0)](CodeSystem-substanceStatus.md)
* [Substance Type (2.5.1 - 1.0.1)](CodeSystem-substanceType.md)
* [Substitution Status (2.5.1 - 1.1.0)](CodeSystem-substitutionStatus.md)
* [Subtype of Referenced Data (2.5.1 - 1.2.0)](CodeSystem-subtypeOfReferencedData.md)
* [Telecommunication Equipment Type (2.5.1 - 1.1.0)](CodeSystem-telecommunicationEquipmentType.md)
* [Telecommunication Use Code (2.5.1 - 1.1.0)](CodeSystem-telecommunicationUse.md)
* [Time Delay Post Challenge (2.5.1 - 1.0.0)](CodeSystem-timeDelayPostChallenge.md)
* [Time Selection Criteria Parameter Class Codes (2.5.1 - 1.1.0)](CodeSystem-timeSelectionCriteriaParameterClass.md)
* [Tissue Type Code (2.5.1 - 1.0.0)](CodeSystem-tissueType.md)
* [TQ Conjunction ID (2.5.1 - 1.1.0)](CodeSystem-tqConjunctionId.md)
* [Transaction Type (2.5.1 - 1.1.0)](CodeSystem-transactionType.md)
* [Transfusion Adverse Reaction (2.5.1 - 1.0.0)](CodeSystem-transfusionAdverseReaction.md)
* [Transport Arranged (2.5.1 - 1.0.0)](CodeSystem-transportArranged.md)
* [Transportation Mode (2.5.1 - 1.0.0)](CodeSystem-transportationMode.md)
* [Tray Type (2.5.1 - 1.0.0)](CodeSystem-trayType.md)
* [Treatment (2.5.1 - 1.0.0)](CodeSystem-treatment.md)
* [Triage Code (2.5.1 - 1.0.0)](CodeSystem-triageType.md)
* [Type of Referenced Data (2.5.1 - 1.3.0)](CodeSystem-typeOfReferencedData.md)
* [Universal ID Type (2.5.1 - 1.1.0)](CodeSystem-universalIdType.md)
* [Version ID (2.5.1 - 1.6.0)](CodeSystem-versionId.md)
* [Visit Indicator (2.5.1 - 1.0.0)](CodeSystem-visitIndicator.md)
* [Visit Priority Code (2.5.1 - 1.0.0)](CodeSystem-visitPriority.md)
* [Visit User Code (2.5.1 - 1.0.0)](CodeSystem-visitUserCodes.md)
* [What subject filter (2.5.1 - 1.5.0)](CodeSystem-whatSubjectFilter.md)
* [Which Date/Time Qualifier (2.5.1 - 1.1.0)](CodeSystem-whichDate-timeQualifier.md)
* [Which Date/Time Status Qualifier (2.5.1 - 1.0.0)](CodeSystem-whichDate-timeStatusQualifier.md)

### ValueSets

* [Manufacturers of Vaccines (code=MVX) (2.5.1 - 1.2.0)](ValueSet-PHVS_ManufacturersOfVaccinesMVX_CDC_NIP.md)
* [Vaccines Administered (2.5.1 - 1.4.0)](ValueSet-PH_VaccinesAdministeredCVX_CDC_NIP.md)
* [OCE Edit Code (2.5.1 - 1.0.0)](ValueSet-hl7VSOCEEditCode.md)
* [Discharge Disposition (2.5.1 - 1.0.0)](ValueSet-hl7VSVS-dischargeDisposition.md)
* [Accept/Application Acknowledgment Conditions (2.5.1 - 1.0.0)](ValueSet-hl7VSaccept-applicationAcknowledgmentConditions.md)
* [Acknowledgment Code (2.5.1 - 1.2.0)](ValueSet-hl7VSacknowledgmentCode.md)
* [Action Code (2.5.1 - 1.1.0)](ValueSet-hl7VSactionCode.md)
* [Action Taken in Response to the Event (2.5.1 - 1.0.0)](ValueSet-hl7VSactionTakenInResponseToTheEvent.md)
* [Active/Inactive (2.5.1 - 1.0.0)](ValueSet-hl7VSactive-inactive.md)
* [Additive/Preservative (2.5.1 - 2.0.0)](ValueSet-hl7VSadditivePreservative.md)
* [Address Type (2.5.1 - 1.3.0)](ValueSet-hl7VSaddressType.md)
* [Administration Device (2.5.1 - 1.0.0)](ValueSet-hl7VSadministrationDevice.md)
* [Administration Method (2.5.1 - 1.0.0)](ValueSet-hl7VSadministrationMethod.md)
* [Administrative Sex (2.5.1 - 1.0.0)](ValueSet-hl7VSadministrativeSex.md)
* [Body Site (2.5.1 - 1.2.0)](ValueSet-hl7VSadministriveSite.md)
* [Admission Level of Care Code (2.5.1 - 1.0.0)](ValueSet-hl7VSadmissionLevelOfCareCode.md)
* [Admission Type (2.5.1 - 1.1.0)](ValueSet-hl7VSadmissionType.md)
* [Admit Source (2.5.1 - 1.0.0)](ValueSet-hl7VSadmitSource.md)
* [Advanced Beneficiary Notice Code (2.5.1 - 1.0.0)](ValueSet-hl7VSadvancedBeneficiaryNoticeCode.md)
* [Alert Device Code (2.5.1 - 1.0.0)](ValueSet-hl7VSalertDeviceCode.md)
* [Alert Level (2.5.1 - 1.0.0)](ValueSet-hl7VSalertLevel.md)
* [Allergy Clinical Status (2.5.1 - 1.0.0)](ValueSet-hl7VSallergyClinicalStatus.md)
* [Allergy Severity (2.5.1 - 1.1.0)](ValueSet-hl7VSallergySeverity.md)
* [Allergen Type (2.5.1 - 1.1.0)](ValueSet-hl7VSallergyType.md)
* [Allow Substitution (2.5.1 - 1.0.0)](ValueSet-hl7VSallowSubstitution.md)
* [Allow Substitution Codes (2.5.1 - 1.1.0)](ValueSet-hl7VSallowSubstitutionCodes.md)
* [Alternate Character Set Handling Scheme (2.5.1 - 1.1.0)](ValueSet-hl7VSalternateCharacterSetHandlingScheme.md)
* [Alternate Character Sets (2.5.1 - 1.2.0)](ValueSet-hl7VSalternateCharacterSets.md)
* [Ambulatory Payment Classification Code (2.5.1 - 1.0.0)](ValueSet-hl7VSambulatoryPaymentClassificationCode.md)
* [Ambulatory Status (2.5.1 - 1.0.0)](ValueSet-hl7VSambulatoryStatus.md)
* [Amount Class (2.5.1 - 1.0.0)](ValueSet-hl7VSamountClass.md)
* [Amount Type (2.5.1 - 1.0.0)](ValueSet-hl7VSamountType.md)
* [Analyte Repeat Status (2.5.1 - 1.0.0)](ValueSet-hl7VSanalyteRepeatStatus.md)
* [Annotations (2.5.1 - 1.0.0)](ValueSet-hl7VSannotations.md)
* [Appointment Reason Codes (2.5.1 - 1.0.0)](ValueSet-hl7VSappointmentReasonCodes.md)
* [Appointment Type Codes (2.5.1 - 1.0.0)](ValueSet-hl7VSappointmentTypeCodes.md)
* [Artificial Blood (2.5.1 - 1.0.0)](ValueSet-hl7VSartificialBlood.md)
* [Assignment of Benefits (2.5.1 - 1.0.0)](ValueSet-hl7VSassignmentOfBenefits.md)
* [Authorization Mode (2.5.1 - 1.0.0)](ValueSet-hl7VSauthorizationMode.md)
* [Bed Status (2.5.1 - 1.1.0)](ValueSet-hl7VSbedStatus.md)
* [Blood Product Code (2.5.1 - 1.0.0)](ValueSet-hl7VSbloodProductCode.md)
* [Blood Product Dispense Status (2.5.1 - 1.0.0)](ValueSet-hl7VSbloodProductDispenseStatus.md)
* [Blood Product Processing Requirements (2.5.1 - 1.0.0)](ValueSet-hl7VSbloodProductProcessingRequirements.md)
* [Blood Product Transfusion/Disposition Status (2.5.1 - 1.0.0)](ValueSet-hl7VSbloodProductTransfusion-dispositionStatus.md)
* [Body Parts (2.5.1 - 1.0.0)](ValueSet-hl7VSbodyParts.md)
* [Body Site Modifier (2.5.1 - 1.0.0)](ValueSet-hl7VSbodySiteModifier.md)
* [BP Observation Status Codes Interpretation (2.5.1 - 1.0.0)](ValueSet-hl7VSbpObservationStatusCodesInterpretation.md)
* [Calendar Alignment (2.5.1 - 1.0.0)](ValueSet-hl7VScalendarAlignment.md)
* [Causality Observations (2.5.1 - 1.0.0)](ValueSet-hl7VScausalityObservations.md)
* [Certificate Status (2.5.1 - 1.0.0)](ValueSet-hl7VScertificateStatus.md)
* [Certification Status (2.5.1 - 1.0.0)](ValueSet-hl7VScertificationStatus.md)
* [Charge On Indicator (2.5.1 - 1.0.0)](ValueSet-hl7VSchargeOnIndicator.md)
* [Charge Type (2.5.1 - 1.0.0)](ValueSet-hl7VSchargeType.md)
* [Charge Type Reason (2.5.1 - 1.0.0)](ValueSet-hl7VSchargeTypeReason.md)
* [Check Digit Scheme (2.5.1 - 1.2.0)](ValueSet-hl7VScheckDigitScheme.md)
* [Coding System (2.5.1 - 1.2.0)](ValueSet-hl7VScodingSystem.md)
* [Command Response (2.5.1 - 1.0.1)](ValueSet-hl7VScommandResponse.md)
* [Comment Type (2.5.1 - 1.0.0)](ValueSet-hl7VScommentType.md)
* [Completion Status (2.5.1 - 1.0.0)](ValueSet-hl7VScompletionStatus.md)
* [Computation Type (2.5.1 - 1.0.0)](ValueSet-hl7VScomputationType.md)
* [Confidentiality Code (2.5.1 - 1.0.0)](ValueSet-hl7VSconfidentialityCode.md)
* [Consent Bypass Reason (2.5.1 - 1.0.0)](ValueSet-hl7VSconsentBypassReason.md)
* [Consent Disclosure Level (2.5.1 - 1.0.0)](ValueSet-hl7VSconsentDisclosureLevel.md)
* [Consent Mode (2.5.1 - 1.0.0)](ValueSet-hl7VSconsentMode.md)
* [Consent Non-Disclosure Reason (2.5.1 - 1.0.0)](ValueSet-hl7VSconsentNon-disclosureReason.md)
* [Consent Status (2.5.1 - 1.0.0)](ValueSet-hl7VSconsentStatus.md)
* [Consent Type (2.5.1 - 1.0.0)](ValueSet-hl7VSconsentType.md)
* [Contact Role (2.5.1 - 1.0.0)](ValueSet-hl7VScontactRole2.md)
* [Container Status (2.5.1 - 1.0.0)](ValueSet-hl7VScontainerStatus.md)
* [Continuation Style Code (2.5.1 - 1.0.0)](ValueSet-hl7VScontinuationStyleCode.md)
* [Controlled Substance Schedule (2.5.1 - 1.0.0)](ValueSet-hl7VScontrolledSubstanceSchedule.md)
* [Coordination of Benefits (2.5.1 - 1.0.0)](ValueSet-hl7VScoordinationOfBenefits.md)
* [Coverage Type (2.5.1 - 1.0.0)](ValueSet-hl7VScoverageType.md)
* [CWE statuses (2.5.1 - 1.0.0)](ValueSet-hl7VScweStatuses.md)
* [Cyclic Entry/Exit Indicator (2.5.1 - 1.0.0)](ValueSet-hl7VScyclicEntryExitIndicator.md)
* [Data Types (2.5.1 - 1.1.0)](ValueSet-hl7VSdataTypes.md)
* [Date/Time Selection Qualifier (2.5.1 - 1.0.0)](ValueSet-hl7VSdate-timeSelectionQualifier.md)
* [Day Type (2.5.1 - 1.0.0)](ValueSet-hl7VSdayType.md)
* [Days of the Week (2.5.1 - 1.0.0)](ValueSet-hl7VSdaysOfTheWeek.md)
* [Deferred Response Type (2.5.1 - 1.0.0)](ValueSet-hl7VSdeferredResponseType.md)
* [Degree/License/Certificate (2.5.1 - 1.2.0)](ValueSet-hl7VSdegreeLicenseCertificate.md)
* [Denial or Rejection Code (2.5.1 - 1.0.0)](ValueSet-hl7VSdenialOrRejectionCode.md)
* [Derived Specimen (2.5.1 - 1.0.0)](ValueSet-hl7VSderivedSpecimen.md)
* [Diagnosis Classification (2.5.1 - 1.0.0)](ValueSet-hl7VSdiagnosisClassification.md)
* [Diagnosis Priority (2.5.1 - 1.0.0)](ValueSet-hl7VSdiagnosisPriority.md)
* [Diagnosis Type (2.5.1 - 1.0.0)](ValueSet-hl7VSdiagnosisType.md)
* [Diagnostic Service Section ID (2.5.1 - 1.4.0)](ValueSet-hl7VSdiagnosticServiceSectionId.md)
* [Diet Code Specification Type (2.5.1 - 1.0.0)](ValueSet-hl7VSdietType.md)
* [Disabled Person Code (2.5.1 - 1.0.0)](ValueSet-hl7VSdisabledPerson.md)
* [Dispense Method (2.5.1 - 1.0.0)](ValueSet-hl7VSdispenseMethod.md)
* [Dispense Type (2.5.1 - 1.0.0)](ValueSet-hl7VSdispenseType.md)
* [Document Availability Status (2.5.1 - 1.1.0)](ValueSet-hl7VSdocumentAvailabilityStatus.md)
* [Document Completion Status (2.5.1 - 1.0.0)](ValueSet-hl7VSdocumentCompletionStatus.md)
* [Document Confidentiality Status (2.5.1 - 2.0.0)](ValueSet-hl7VSdocumentConfidentialityStatus.md)
* [Document Storage Status (2.5.1 - 1.0.0)](ValueSet-hl7VSdocumentStorageStatus.md)
* [Transfer Type (2.5.1 - 1.0.0)](ValueSet-hl7VSdrgTransferType.md)
* [Duration Categories (2.5.1 - 1.1.0)](ValueSet-hl7VSdurationCategories.md)
* [Eligibility Source (2.5.1 - 1.0.0)](ValueSet-hl7VSeligibilitySource.md)
* [Employment Status (2.5.1 - 2.0.0)](ValueSet-hl7VSemploymentStatus.md)
* [Encoding (2.5.1 - 1.0.0)](ValueSet-hl7VSencoding.md)
* [Equipment State (2.5.1 - 1.0.0)](ValueSet-hl7VSequipmentState.md)
* [Error Severity (2.5.1 - 1.0.0)](ValueSet-hl7VSerrorSeverity.md)
* [Escort Required (2.5.1 - 1.0.0)](ValueSet-hl7VSescortRequired.md)
* [Event (2.5.1 - 1.6.0)](ValueSet-hl7VSevent.md)
* [Event Consequence (2.5.1 - 1.0.0)](ValueSet-hl7VSeventConsequence.md)
* [Event Expected (2.5.1 - 1.0.0)](ValueSet-hl7VSeventExpected.md)
* [Event Qualification (2.5.1 - 1.0.0)](ValueSet-hl7VSeventQualification.md)
* [Event Reason (2.5.1 - 1.3.0)](ValueSet-hl7VSeventReason.md)
* [Event Related Period (2.5.1 - 1.0.0)](ValueSet-hl7VSeventRelatedPeriod.md)
* [Event Reported To (2.5.1 - 1.0.0)](ValueSet-hl7VSeventReportedTo.md)
* [Event Seriousness (2.5.1 - 1.0.0)](ValueSet-hl7VSeventSeriousness.md)
* [Event Type (2.5.1 - 1.0.0)](ValueSet-hl7VSeventType.md)
* [Expanded Yes/no Indicator (2.5.1 - 1.0.0)](ValueSet-hl7VSexpandedYes-NoIndicator.md)
* [Extended Priority Codes (2.5.1 - 1.0.0)](ValueSet-hl7VSextendedPriorityCodes.md)
* [Facility Type (2.5.1 - 1.0.0)](ValueSet-hl7VSfacilityType.md)
* [File Level Event Code (2.5.1 - 1.0.0)](ValueSet-hl7VSfile-levelEventCode.md)
* [Filler Status Codes (2.5.1 - 1.2.0)](ValueSet-hl7VSfillerStatusCodes.md)
* [Formulary Status (2.5.1 - 1.0.0)](ValueSet-hl7VSformularyStatus.md)
* [Gestation Category Code (2.5.1 - 1.0.0)](ValueSet-hl7VSgestationCategoryCode.md)
* [Health Care Provider Area of Specialization (2.5.1 - 1.0.0)](ValueSet-hl7VShealthCareProviderAreaOfSpecialization.md)
* [Health Care Provider Classification (2.5.1 - 1.0.0)](ValueSet-hl7VShealthCareProviderClassification.md)
* [Health Care Provider Type Code (2.5.1 - 1.0.0)](ValueSet-hl7VShealthCareProviderTypeCode.md)
* [Identifier Type (2.5.1 - 1.3.0)](ValueSet-hl7VSidentifierType.md)
* [Identity May Be Divulged (2.5.1 - 1.0.0)](ValueSet-hl7VSidentityMayBeDivulged.md)
* [Identity Reliability Code (2.5.1 - 1.0.0)](ValueSet-hl7VSidentityReliabilityCode.md)
* [Immunization Registry Status (2.5.1 - 1.0.0)](ValueSet-hl7VSimmunizationRegistryStatus.md)
* [Inactive Reason Code (2.5.1 - 1.0.0)](ValueSet-hl7VSinactiveReasonCode.md)
* [Incident Type Code (2.5.1 - 1.0.0)](ValueSet-hl7VSincidentTypeCode.md)
* [Indirect Exposure Mechanism (2.5.1 - 1.0.0)](ValueSet-hl7VSindirectExposureMechanism.md)
* [Inform Person Code (2.5.1 - 1.0.0)](ValueSet-hl7VSinformPersonCode.md)
* [Institution Relationship Type (2.5.1 - 1.0.0)](ValueSet-hl7VSinstitutionRelationshipType.md)
* [Abnormal Flags (2.5.1 - 1.3.1)](ValueSet-hl7VSinterpretationCode.md)
* [Job Status (2.5.1 - 1.0.0)](ValueSet-hl7VSjobStatus.md)
* [Jurisdictional Breadth (2.5.1 - 1.0.0)](ValueSet-hl7VSjurisdictionalBreadth.md)
* [Kind of Quantity (2.5.1 - 1.0.0)](ValueSet-hl7VSkindOfQuantity.md)
* [Language Ability (2.5.1 - 1.0.0)](ValueSet-hl7VSlanguageAbility.md)
* [Language Proficiency (2.5.1 - 1.0.0)](ValueSet-hl7VSlanguageProficiency.md)
* [Level of Care (2.5.1 - 1.0.0)](ValueSet-hl7VSlevelOfCare.md)
* [Living Arrangement (2.5.1 - 1.1.0)](ValueSet-hl7VSlivingArrangement.md)
* [Living Dependency (2.5.1 - 2.0.0)](ValueSet-hl7VSlivingDependency.md)
* [Living Will Code (2.5.1 - 1.0.0)](ValueSet-hl7VSlivingWill.md)
* [Local/Remote Control State (2.5.1 - 1.0.0)](ValueSet-hl7VSlocal-remoteControlState.md)
* [Location Characteristic ID (2.5.1 - 1.0.0)](ValueSet-hl7VSlocationCharacteristicId.md)
* [Location Equipment (2.5.1 - 1.0.0)](ValueSet-hl7VSlocationEquipment.md)
* [Location Relationship ID (2.5.1 - 1.0.0)](ValueSet-hl7VSlocationRelationshipId.md)
* [Location Service Code (2.5.1 - 1.0.0)](ValueSet-hl7VSlocationServiceCode.md)
* [Mail Claim Party (2.5.1 - 1.0.0)](ValueSet-hl7VSmailClaimParty.md)
* [Marital Status (2.5.1 - 1.1.0)](ValueSet-hl7VSmaritalStatus.md)
* [Marketing Basis (2.5.1 - 1.0.0)](ValueSet-hl7VSmarketingBasis.md)
* [Master File Identifier Code (2.5.1 - 1.2.0)](ValueSet-hl7VSmasterFileIdentifierCode.md)
* [Record-level Event Code (2.5.1 - 1.0.0)](ValueSet-hl7VSmasterfileActionCode.md)
* [Match Reason (2.5.1 - 1.0.0)](ValueSet-hl7VSmatchReason.md)
* [Message Error Condition Codes (2.5.1 - 1.0.0)](ValueSet-hl7VSmessageErrorConditionCodes.md)
* [Message Structure (2.5.1 - 4.0.0)](ValueSet-hl7VSmessageStructure.md)
* [Message Type (2.5.1 - 1.5.0)](ValueSet-hl7VSmessageType.md)
* [MFN Record-level Error Return (2.5.1 - 1.0.0)](ValueSet-hl7VSmfnRecode-levelErrorReturn.md)
* [Military Rank/Grade (2.5.1 - 2.0.0)](ValueSet-hl7VSmilitaryRank-Grade.md)
* [Military Service (2.5.1 - 1.1.0)](ValueSet-hl7VSmilitaryService.md)
* [Military Status (2.5.1 - 1.0.0)](ValueSet-hl7VSmilitaryStatus.md)
* [Modality (2.5.1 - 1.0.0)](ValueSet-hl7VSmodality.md)
* [Mode of Arrival Code (2.5.1 - 1.0.0)](ValueSet-hl7VSmodeOfArrivalCode.md)
* [Modifier Edit Code (2.5.1 - 1.0.0)](ValueSet-hl7VSmodifierEditCode.md)
* [Modify Indicator (2.5.1 - 1.0.0)](ValueSet-hl7VSmodifyIndicator.md)
* [Name/Address Representation (2.5.1 - 1.0.0)](ValueSet-hl7VSname-addressRepresentation.md)
* [Name Assembly Order (2.5.1 - 1.0.0)](ValueSet-hl7VSnameAssemblyOrder.md)
* [Name Type (2.5.1 - 1.2.0)](ValueSet-hl7VSnameType.md)
* [Nature of Abnormal Testing (2.5.1 - 1.1.0)](ValueSet-hl7VSnatureOfAbnormalTesting.md)
* [Nature of Challenge (2.5.1 - 1.0.0)](ValueSet-hl7VSnatureOfChallenge.md)
* [Nature of Service/Test/Observation (2.5.1 - 1.1.0)](ValueSet-hl7VSnatureOfServiceTestObservation.md)
* [Source Type (2.5.1 - 1.0.0)](ValueSet-hl7VSnetworkSourceType.md)
* [Newborn Code (2.5.1 - 1.0.0)](ValueSet-hl7VSnewbornCode.md)
* [Non-Subject Consenter Reason (2.5.1 - 1.0.0)](ValueSet-hl7VSnon-subjectConsenterReason.md)
* [Notify Clergy Code (2.5.1 - 1.0.0)](ValueSet-hl7VSnotifyClergyCode.md)
* [Observation Result Handling (2.5.1 - 1.0.0)](ValueSet-hl7VSobservationResultHandling.md)
* [Observation Result Status Codes Interpretation (2.5.1 - 1.2.1)](ValueSet-hl7VSobservationResultStatus.md)
* [Order Control Codes (2.5.1 - 1.5.0)](ValueSet-hl7VSorderControl.md)
* [Order Status (2.5.1 - 1.2.0)](ValueSet-hl7VSorderStatus.md)
* [Order Type (2.5.1 - 1.0.0)](ValueSet-hl7VSorderType.md)
* [Organ Donor Code (2.5.1 - 1.2.0)](ValueSet-hl7VSorganDonor.md)
* [Practitioner Organization Unit Type (2.5.1 - 2.0.0)](ValueSet-hl7VSorganizationUnitType-Org.md)
* [Participant Organization Unit Type (2.5.1 - 1.0.0)](ValueSet-hl7VSorganizationUnitType.md)
* [Organizational Name Type (2.5.1 - 1.0.0)](ValueSet-hl7VSorganizationalNameType.md)
* [DRG Payor (2.5.1 - 1.0.0)](ValueSet-hl7VSoutlierType.md)
* [Overall Claim Disposition Code (2.5.1 - 1.0.0)](ValueSet-hl7VSoverallClaimDispositionCode.md)
* [Override (2.5.1 - 1.0.0)](ValueSet-hl7VSoverride.md)
* [Override Type (2.5.1 - 1.0.0)](ValueSet-hl7VSoverrideType.md)
* [Packaging Status Code (2.5.1 - 1.0.0)](ValueSet-hl7VSpackagingStatusCode.md)
* [Patient Class (2.5.1 - 1.2.0)](ValueSet-hl7VSpatientClass.md)
* [Patient Condition Code (2.5.1 - 1.0.0)](ValueSet-hl7VSpatientConditionCode.md)
* [Patient Location Type (2.5.1 - 1.0.0)](ValueSet-hl7VSpatientLocationType.md)
* [Patient Outcome (2.5.1 - 1.0.0)](ValueSet-hl7VSpatientOutcome.md)
* [Patient's Relationship to Insured (2.5.1 - 1.0.0)](ValueSet-hl7VSpatient_sRelationshipToInsured.md)
* [Payment Adjustment Code (2.5.1 - 1.0.0)](ValueSet-hl7VSpaymentAdjustmentCode.md)
* [Money or Percentage Indicator (2.5.1 - 1.0.0)](ValueSet-hl7VSpenaltyType.md)
* [Person Location Type (2.5.1 - 1.0.0)](ValueSet-hl7VSpersonLocationType.md)
* [Pharmacy Order Types (2.5.1 - 1.0.0)](ValueSet-hl7VSpharmacyOrderTypes.md)
* [Policy Type (2.5.1 - 1.0.0)](ValueSet-hl7VSpolicyType.md)
* [Practitioner ID Number Type (2.5.1 - 1.1.0)](ValueSet-hl7VSpractitionerIdNumberType.md)
* [Precaution Code (2.5.1 - 1.0.0)](ValueSet-hl7VSprecautionCode.md)
* [Certification Patient Type (2.5.1 - 1.0.0)](ValueSet-hl7VSprecertificationPatientType.md)
* [Precision (2.5.1 - 1.0.0)](ValueSet-hl7VSprecision.md)
* [Preferred Method of Contact (2.5.1 - 1.1.0)](ValueSet-hl7VSpreferredMethodOfContrct.md)
* [Price Type (2.5.1 - 1.0.0)](ValueSet-hl7VSpriceType.md)
* [Primary Key Value Type (2.5.1 - 1.0.0)](ValueSet-hl7VSprimaryKeyValueType.md)
* [Primary Observer's Qualification (2.5.1 - 1.0.0)](ValueSet-hl7VSprimaryObserver_sQualification.md)
* [Priority (2.5.1 - 1.2.0)](ValueSet-hl7VSpriority.md)
* [Privacy Level (2.5.1 - 1.0.0)](ValueSet-hl7VSprivacyLevel.md)
* [Procedure DRG Type (2.5.1 - 1.0.0)](ValueSet-hl7VSprocedureDrgType.md)
* [Procedure Functional Type (2.5.1 - 1.0.0)](ValueSet-hl7VSprocedureFunctionalType.md)
* [Procedure Practitioner Identifier Type (2.5.1 - 1.2.0)](ValueSet-hl7VSprocedurePractitionerType.md)
* [Procedure Priority (2.5.1 - 1.0.0)](ValueSet-hl7VSprocedurePriority.md)
* [Processing ID (2.5.1 - 1.0.0)](ValueSet-hl7VSprocessingId.md)
* [Processing Mode (2.5.1 - 1.1.0)](ValueSet-hl7VSprocessingMode.md)
* [Processing Priority (2.5.1 - 1.0.0)](ValueSet-hl7VSprocessingPriority.md)
* [Processing Type (2.5.1 - 1.0.0)](ValueSet-hl7VSprocessingType.md)
* [Product Source (2.5.1 - 1.0.0)](ValueSet-hl7VSproductSource.md)
* [Production Class Code (2.5.1 - 1.0.0)](ValueSet-hl7VSproductionClassCode.md)
* [Provider Billing (2.5.1 - 1.0.0)](ValueSet-hl7VSproviderBilling.md)
* [Provider Role (2.5.1 - 1.0.0)](ValueSet-hl7VSproviderRole.md)
* [Purge Status Code (2.5.1 - 1.0.0)](ValueSet-hl7VSpurgeStatus.md)
* [Quantity Limited Request (2.5.1 - 1.1.0)](ValueSet-hl7VSquantityLimitedRequest.md)
* [Quantity Method (2.5.1 - 1.0.0)](ValueSet-hl7VSquantityMethod.md)
* [Query/Response Format Code (2.5.1 - 1.2.0)](ValueSet-hl7VSqueryFormatCode.md)
* [Query Priority (2.5.1 - 1.0.0)](ValueSet-hl7VSqueryPriority.md)
* [Query Response Status (2.5.1 - 1.1.0)](ValueSet-hl7VSqueryResponseStatus.md)
* [Query Results Level (2.5.1 - 1.0.2)](ValueSet-hl7VSqueryResultsLevel.md)
* [CP Range Type (2.5.1 - 1.0.0)](ValueSet-hl7VSrangeType.md)
* [Recreational Drug Use Code (2.5.1 - 1.0.0)](ValueSet-hl7VSrecreationalDrugUseCode.md)
* [Referral Category (2.5.1 - 1.0.0)](ValueSet-hl7VSreferralCategory.md)
* [Referral Disposition (2.5.1 - 1.0.0)](ValueSet-hl7VSreferralDisposition.md)
* [Referral Priority (2.5.1 - 1.0.0)](ValueSet-hl7VSreferralPriority.md)
* [Referral Reason (2.5.1 - 1.0.0)](ValueSet-hl7VSreferralReason.md)
* [Referral Status (2.5.1 - 1.0.0)](ValueSet-hl7VSreferralStatus.md)
* [Referral Type (2.5.1 - 1.0.0)](ValueSet-hl7VSreferralType.md)
* [Reimbursement Action Code (2.5.1 - 1.0.0)](ValueSet-hl7VSreimbursementActionCode.md)
* [Reimbursement Type Code (2.5.1 - 1.0.0)](ValueSet-hl7VSreimbursementTypeCode.md)
* [Relatedness Assessment (2.5.1 - 1.0.0)](ValueSet-hl7VSrelatednessAssessment.md)
* [Relational Conjunction (2.5.1 - 1.0.0)](ValueSet-hl7VSrelationalConjunction.md)
* [Relational Operator (2.5.1 - 1.0.0)](ValueSet-hl7VSrelationalOperator.md)
* [Relationship (2.5.1 - 1.0.0)](ValueSet-hl7VSrelationship.md)
* [Relationship Modifier (2.5.1 - 1.0.0)](ValueSet-hl7VSrelationshipModifier.md)
* [Religion (2.5.1 - 2.0.0)](ValueSet-hl7VSreligion2.md)
* [Remote Control Command (2.5.1 - 1.0.0)](ValueSet-hl7VSremoteControlCommand.md)
* [Repeat Pattern (2.5.1 - 1.1.0)](ValueSet-hl7VSrepeatPattern.md)
* [Report Priority (2.5.1 - 1.0.0)](ValueSet-hl7VSreportPriority.md)
* [Report Source (2.5.1 - 1.0.0)](ValueSet-hl7VSreportSource.md)
* [Report Timing (2.5.1 - 1.0.0)](ValueSet-hl7VSreportTiming.md)
* [Document Type (2.5.1 - 1.0.0)](ValueSet-hl7VSreportTypeCode.md)
* [Reporting Priority (2.5.1 - 1.0.0)](ValueSet-hl7VSreportingPriority.md)
* [Response Flag (2.5.1 - 1.0.0)](ValueSet-hl7VSresponseFlag.md)
* [Response Level (2.5.1 - 1.0.0)](ValueSet-hl7VSresponseLevel.md)
* [Response Modality (2.5.1 - 1.0.0)](ValueSet-hl7VSresponseModality.md)
* [Result Status (2.5.1 - 1.2.0)](ValueSet-hl7VSresultStatus-Obr.md)
* [Risk Codes (2.5.1 - 1.0.0)](ValueSet-hl7VSriskCodes.md)
* [Risk Management Incident Code (2.5.1 - 1.0.0)](ValueSet-hl7VSriskManagementIncidentCode.md)
* [Room Type (2.5.1 - 1.0.0)](ValueSet-hl7VSroomType.md)
* [Route of Administration (2.5.1 - 3.0.1)](ValueSet-hl7VSrouteOfAdministration.md)
* [RX Component Type (2.5.1 - 1.0.0)](ValueSet-hl7VSrxComponentType.md)
* [Segment Action Code (2.5.1 - 1.0.0)](ValueSet-hl7VSsegmentActionCode.md)
* [Segment Group (2.5.1 - 3.0.0)](ValueSet-hl7VSsegmentGroup.md)
* [Sensitivity to Causative Agent Code (2.5.1 - 1.0.0)](ValueSet-hl7VSsensitivityToCausativeAgentCode.md)
* [Sequence condition (2.5.1 - 1.0.0)](ValueSet-hl7VSsequenceCondition.md)
* [Sequence Condition Code (2.5.1 - 1.0.0)](ValueSet-hl7VSsequenceConditionCode.md)
* [Sequence/Results Flag (2.5.1 - 1.0.0)](ValueSet-hl7VSsequenceResultsFlag.md)
* [Sequencing (2.5.1 - 1.0.0)](ValueSet-hl7VSsequencing.md)
* [Service Request Relationship (2.5.1 - 1.0.0)](ValueSet-hl7VSserviceRequestRelationship.md)
* [Severity of Illness Code (2.5.1 - 1.0.0)](ValueSet-hl7VSseverityOfIllnessCode.md)
* [Signatory's Relationship to Subject (2.5.1 - 1.0.0)](ValueSet-hl7VSsignatory_sRelationshipToSubject.md)
* [Signature Code (2.5.1 - 1.0.0)](ValueSet-hl7VSsignatureCode.md)
* [Source of Comment (2.5.1 - 1.1.0)](ValueSet-hl7VSsourceOfComment.md)
* [Specimen Source Codes (2.5.1 - 1.3.1)](ValueSet-hl7VSsourceOfSpecimen.md)
* [Special Handling Code (2.5.1 - 1.1.0)](ValueSet-hl7VSspecialHandlingConsiderations.md)
* [Specialty Type (2.5.1 - 1.0.0)](ValueSet-hl7VSspecialtyType.md)
* [Specimen Appropriateness (2.5.1 - 1.0.0)](ValueSet-hl7VSspecimenAppropriateness.md)
* [Specimen Child Role (2.5.1 - 1.0.0)](ValueSet-hl7VSspecimenChildRole.md)
* [Specimen Collection Method (2.5.1 - 1.0.0)](ValueSet-hl7VSspecimenCollectionMethod.md)
* [Specimen Component (2.5.1 - 1.0.0)](ValueSet-hl7VSspecimenComponent.md)
* [Specimen Condition (2.5.1 - 1.0.0)](ValueSet-hl7VSspecimenCondition.md)
* [Specimen Quality (2.5.1 - 1.0.0)](ValueSet-hl7VSspecimenQuality.md)
* [Specimen Reject Reason (2.5.1 - 1.0.0)](ValueSet-hl7VSspecimenRejectReason.md)
* [Specimen Type (2.5.1 - 1.0.0)](ValueSet-hl7VSspecimenType.md)
* [Status of Evaluation (2.5.1 - 1.0.0)](ValueSet-hl7VSstartOfEvaluation.md)
* [Student Status (2.5.1 - 1.0.0)](ValueSet-hl7VSstudentStatus.md)
* [Substance Status (2.5.1 - 1.0.0)](ValueSet-hl7VSsubstanceStatus.md)
* [Substance Type (2.5.1 - 1.0.1)](ValueSet-hl7VSsubstanceType.md)
* [Substitution Status (2.5.1 - 1.1.0)](ValueSet-hl7VSsubstitutionStatus.md)
* [Subtype of Referenced Data (2.5.1 - 1.2.0)](ValueSet-hl7VSsubtypeOfReferencedData.md)
* [Telecommunication Equipment Type (2.5.1 - 1.1.0)](ValueSet-hl7VStelecommunicationEquipmentType.md)
* [Telecommunication Use Code (2.5.1 - 1.1.0)](ValueSet-hl7VStelecommunicationUseCode.md)
* [Time Delay Post Challenge (2.5.1 - 1.0.0)](ValueSet-hl7VStimeDelayPostChallenge.md)
* [Time Selection Criteria Parameter Class Codes (2.5.1 - 1.1.0)](ValueSet-hl7VStimeSelectionCriteriaParameterClassCodes.md)
* [Tissue Type Code (2.5.1 - 1.0.0)](ValueSet-hl7VStissueTypeCode.md)
* [TQ Conjunction ID (2.5.1 - 1.1.0)](ValueSet-hl7VStqConjunctionId.md)
* [Transaction Type (2.5.1 - 1.1.0)](ValueSet-hl7VStransactionType.md)
* [Transfusion Adverse Reaction (2.5.1 - 1.0.0)](ValueSet-hl7VStransfusionAdverseReaction.md)
* [Transport Arranged (2.5.1 - 1.0.0)](ValueSet-hl7VStransportArranged.md)
* [Transportation Mode (2.5.1 - 1.0.0)](ValueSet-hl7VStransportationMode.md)
* [Tray Type (2.5.1 - 1.0.0)](ValueSet-hl7VStrayType.md)
* [Treatment (2.5.1 - 1.0.0)](ValueSet-hl7VStreatment.md)
* [Triage Code (2.5.1 - 1.0.0)](ValueSet-hl7VStriageCode.md)
* [Type of Referenced Data (2.5.1 - 1.3.0)](ValueSet-hl7VStypeOfData.md)
* [Universal ID Type (2.5.1 - 1.1.0)](ValueSet-hl7VSuniversalIdType.md)
* [Version ID (2.5.1 - 1.6.0)](ValueSet-hl7VSversionControlTable.md)
* [Visit Indicator (2.5.1 - 1.0.0)](ValueSet-hl7VSvisitIndicator.md)
* [Visit Priority Code (2.5.1 - 1.0.0)](ValueSet-hl7VSvisitPriorityCode.md)
* [Visit User Code (2.5.1 - 1.0.0)](ValueSet-hl7VSvisitUserCode.md)
* [What subject filter (2.5.1 - 1.5.0)](ValueSet-hl7VSwhatSubjectFilter.md)
* [Invocation Event (2.5.1 - 1.0.0)](ValueSet-hl7VSwhenToCharge.md)
* [Which Date/Time Qualifier (2.5.1 - 1.1.0)](ValueSet-hl7VSwhichDate-timeQualifier.md)
* [Which Date/Time Status Qualifier (2.5.1 - 1.0.0)](ValueSet-hl7VSwhichDate-timeStatusQualifier.md)
* [Yes/No Indicator (2.5.1 - 1.0.0)](ValueSet-hl7VSyes-no-Indicator.md)
* [Specimen Role (2.5.1 - 1.1.0)](ValueSet-noOIDfound.md)

### Resource Profiles

* [V2CodeSystem](StructureDefinition-V2CodeSystem.md)

### ImplementationGuides

* [HL7 v2.5.1 Vocabulary](index.md)
