# Version ID (2.5.1 - 1.6.0) - HL7 v2.5.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Version ID (2.5.1 - 1.6.0)**

## CodeSystem: Version ID (2.5.1 - 1.6.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/versionId | *Version*:1.6.0 |
| Active as of 2026-01-27 | *Computable Name*:VersionId |
| *Other Identifiers:*OID:2.16.840.1.113883.18.41 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x family of published standards. Used in HL7 Version 2.x messaging in the VID segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSversionControlTable](ValueSet-hl7VSversionControlTable.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "versionId",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0104"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/versionId",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.41"
    }
  ],
  "version" : "1.6.0",
  "name" : "VersionId",
  "title" : "Version ID (2.5.1 - 1.6.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:29:18+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x family of published standards.  Used in HL7 Version 2.x messaging in the VID segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "2.0",
      "display" : "Release 2.0",
      "definition" : "Release 2.0",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "2.0D",
      "display" : "Demo 2.0",
      "definition" : "Demo 2.0",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "2.1",
      "display" : "Release 2. 1",
      "definition" : "Release 2. 1",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "2.2",
      "display" : "Release 2.2",
      "definition" : "Release 2.2",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "2.3",
      "display" : "Release 2.3",
      "definition" : "Release 2.3",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "2.3.1",
      "display" : "Release 2.3.1",
      "definition" : "Release 2.3.1",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "2.4",
      "display" : "Release 2.4",
      "definition" : "Release 2.4",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "2.5",
      "display" : "Release 2.5",
      "definition" : "Release 2.5",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "2.5.1",
      "display" : "Release 2.5.1",
      "definition" : "Release 2.5.1",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5.1"
        }
      ]
    }
  ]
}

```
