# Mode of Arrival Code (2.5.1 - 1.0.0) - HL7 v2.5.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Mode of Arrival Code (2.5.1 - 1.0.0)**

## CodeSystem: Mode of Arrival Code (2.5.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/arrivalMode | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ArrivalMode |
| *Other Identifiers:*OID:2.16.840.1.113883.18.271 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying how the patient was brought to the healthcare facility. Used in HL7 Version 2.x messaging in the PV2 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmodeOfArrivalCode](ValueSet-hl7VSmodeOfArrivalCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "arrivalMode",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0430"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/arrivalMode",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.271"
    }
  ],
  "version" : "1.0.0",
  "name" : "ArrivalMode",
  "title" : "Mode of Arrival Code (2.5.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:29:18+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying how the patient was brought to the healthcare facility.  Used in HL7 Version 2.x messaging in the PV2 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Ambulance",
      "definition" : "Ambulance",
      "designation" : [
        {
          "language" : "de",
          "value" : "Krankenwagen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Car",
      "definition" : "Car",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auto"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "On foot",
      "definition" : "On foot",
      "designation" : [
        {
          "language" : "de",
          "value" : "zu Fuß"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "H",
      "display" : "Helicopter",
      "definition" : "Helicopter",
      "designation" : [
        {
          "language" : "de",
          "value" : "Helicopter"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Other",
      "definition" : "Other",
      "designation" : [
        {
          "language" : "de",
          "value" : "andere"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Public Transport",
      "definition" : "Public Transport",
      "designation" : [
        {
          "language" : "de",
          "value" : "öffentliche Verkehrsmittel"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Unknown",
      "definition" : "Unknown",
      "designation" : [
        {
          "language" : "de",
          "value" : "unbekannt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
