# Ambulatory Status (2.5.1 - 1.0.0) - HL7 v2.5.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ambulatory Status (2.5.1 - 1.0.0)**

## CodeSystem: Ambulatory Status (2.5.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/ambulatoryStatus | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:AmbulatoryStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.11 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying permanent or transient handicapped conditions of a person. Used in HL7 Version 2.x messaging in the PV1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSambulatoryStatus](ValueSet-hl7VSambulatoryStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "ambulatoryStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0009"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/ambulatoryStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.11"
    }
  ],
  "version" : "1.0.0",
  "name" : "AmbulatoryStatus",
  "title" : "Ambulatory Status (2.5.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:29:18+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying permanent or transient handicapped conditions of a person.  Used in HL7 Version 2.x messaging in the PV1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A0",
      "display" : "No functional limitations",
      "definition" : "No functional limitations",
      "designation" : [
        {
          "language" : "de",
          "value" : "Keine funktionalen Einschränkungen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "A1",
      "display" : "Ambulates with assistive device",
      "definition" : "Ambulates with assistive device",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patient benötigt Hilfsmittel"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "A2",
      "display" : "Wheelchair/stretcher bound",
      "definition" : "Wheelchair/stretcher bound",
      "designation" : [
        {
          "language" : "de",
          "value" : "Rollstuhl / Trage notwendig"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "A3",
      "display" : "Comatose; non-responsive",
      "definition" : "Comatose; non-responsive",
      "designation" : [
        {
          "language" : "de",
          "value" : "Komatös; nicht ansprechbar"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "A4",
      "display" : "Disoriented",
      "definition" : "Disoriented",
      "designation" : [
        {
          "language" : "de",
          "value" : "Desorientiert"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "A5",
      "display" : "Vision impaired",
      "definition" : "Vision impaired",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sehstörung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "A6",
      "display" : "Hearing impaired",
      "definition" : "Hearing impaired",
      "designation" : [
        {
          "language" : "de",
          "value" : "Schwerhörigkeit"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "A7",
      "display" : "Speech impaired",
      "definition" : "Speech impaired",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sprachstörung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "A8",
      "display" : "Non-English speaking",
      "definition" : "Non-English speaking",
      "designation" : [
        {
          "language" : "de",
          "value" : "der Landessprache nicht mächtig"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "A9",
      "display" : "Functional level unknown",
      "definition" : "Functional level unknown",
      "designation" : [
        {
          "language" : "de",
          "value" : "Unbekannter Zustand"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "B1",
      "display" : "Oxygen therapy",
      "definition" : "Oxygen therapy",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sauerstofftherapie"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "B2",
      "display" : "Special equipment (tubes, IVs, catheters)",
      "definition" : "Special equipment (tubes, IVs, catheters)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Besondere Hilsfmittel"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "B3",
      "display" : "Amputee",
      "definition" : "Amputee",
      "designation" : [
        {
          "language" : "de",
          "value" : "Amputation"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "B4",
      "display" : "Mastectomy",
      "definition" : "Mastectomy",
      "designation" : [
        {
          "language" : "de",
          "value" : "Brustamputation"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "B5",
      "display" : "Paraplegic",
      "definition" : "Paraplegic",
      "designation" : [
        {
          "language" : "de",
          "value" : "(Querschnitt-) Lähmung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "B6",
      "display" : "Pregnant",
      "definition" : "Pregnant",
      "designation" : [
        {
          "language" : "de",
          "value" : "Schwanger"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
