# Advanced Beneficiary Notice Code (2.5.1 - 1.0.0) - HL7 v2.5.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Advanced Beneficiary Notice Code (2.5.1 - 1.0.0)**

## CodeSystem: Advanced Beneficiary Notice Code (2.5.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/advancedBeneficiaryNotice | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:AdvancedBeneficiaryNotice |
| *Other Identifiers:*OID:2.16.840.1.113883.18.209 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the status of the patient's or the patient's representative's consent for responsibility to pay for potentially uninsured services. This element was introduced to satisfy CMS Medical Necessity requirements for outpatient services in the United States. Includes concepts such as (a) whether the associated diagnosis codes for the service are subject to medical necessity procedures, (b) whether, for this type of service, the patient has been informed that they may be responsible for payment for the service, and (c) whether the patient agrees to be billed for this service. Used in HL7 Version 2.x messaging in the ORC and FT1 segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSadvancedBeneficiaryNoticeCode](ValueSet-hl7VSadvancedBeneficiaryNoticeCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "advancedBeneficiaryNotice",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0339"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/advancedBeneficiaryNotice",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.209"
    }
  ],
  "version" : "1.0.0",
  "name" : "AdvancedBeneficiaryNotice",
  "title" : "Advanced Beneficiary Notice Code (2.5.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:29:18+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the status of the patient's or the patient's representative's consent for responsibility to pay for potentially uninsured services. This element was introduced to satisfy CMS Medical Necessity requirements for outpatient services in the United States. Includes concepts such as (a) whether the associated diagnosis codes for the service are subject to medical necessity procedures, (b) whether, for this type of service, the patient has been informed that they may be responsible for payment for the service, and (c) whether the patient agrees to be billed for this service.  Used in HL7 Version 2.x messaging in the ORC and FT1 segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "1",
      "display" : "Service is subject to medical necessity procedures",
      "definition" : "Service is subject to medical necessity procedures",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zuzahlung muss abgeklärt werden"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "2",
      "display" : "Patient has been informed of responsibility, and agrees to pay for service",
      "definition" : "Patient has been informed of responsibility, and agrees to pay for service",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "3",
      "display" : "Patient has been informed of responsibility, and asks that the payer be billed",
      "definition" : "Patient has been informed of responsibility, and asks that the payer be billed",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patient fragt nach Rechnung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "4",
      "display" : "Advanced Beneficiary Notice has not been signed",
      "definition" : "Advanced Beneficiary Notice has not been signed",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zustimmung zur Zuzahlung liegt nicht vor"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
