# Provider Role (2.5 - 1.0.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Provider Role (2.5 - 1.0.0)**

## CodeSystem: Provider Role (2.5 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/providerRole | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ProviderRole |
| *Other Identifiers:*OID:2.16.840.1.113883.18.283 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.). Used in HL7 Version 2.x messaging in the ROL segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSproviderRole](ValueSet-hl7VSproviderRole.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "providerRole",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0443"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/providerRole",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.283"
    }
  ],
  "version" : "1.0.0",
  "name" : "ProviderRole",
  "title" : "Provider Role (2.5 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the functional involvement with the activity being transmitted (e.g., Case Manager, Evaluator, Transcriber, Nurse Care Practitioner, Midwife, Physician Assistant, etc.).  Used in HL7 Version 2.x messaging in the ROL segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AD",
      "display" : "Admitting",
      "definition" : "Admitting",
      "designation" : [
        {
          "language" : "de",
          "value" : "Einweisender Arzt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AT",
      "display" : "Attending",
      "definition" : "Attending",
      "designation" : [
        {
          "language" : "de",
          "value" : "Behandelnder Arzt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CP",
      "display" : "Consulting Provider",
      "definition" : "Consulting Provider",
      "designation" : [
        {
          "language" : "de",
          "value" : "Mitbehandelnder Arzt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FHCP",
      "display" : "Family Health Care Professional",
      "definition" : "Family Health Care Professional",
      "designation" : [
        {
          "language" : "de",
          "value" : "Hausarzt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PP",
      "display" : "Primary Care Provider",
      "definition" : "Primary Care Provider",
      "designation" : [
        {
          "language" : "de",
          "value" : "Erstbehandelnder Arzt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RP",
      "display" : "Referring Provider",
      "definition" : "Referring Provider",
      "designation" : [
        {
          "language" : "de",
          "value" : "überwiesen von"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RT",
      "display" : "Referred to Provider",
      "definition" : "Referred to Provider",
      "designation" : [
        {
          "language" : "de",
          "value" : "überwiesen nach"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
