# Certificate Status (2.5 - 1.0.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Certificate Status (2.5 - 1.0.0)**

## CodeSystem: Certificate Status (2.5 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/certificateStatus | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:CertificateStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.350 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the status of the certificate held by the health professional. Used in HL7 Version 2 messaging in the CER segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VScertificateStatus](ValueSet-hl7VScertificateStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "certificateStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0536"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/certificateStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.350"
    }
  ],
  "version" : "1.0.0",
  "name" : "CertificateStatus",
  "title" : "Certificate Status (2.5 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the status of the certificate held by the health professional.  Used in HL7 Version 2 messaging in the CER segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "E",
      "display" : "Expired",
      "definition" : "Expired",
      "designation" : [
        {
          "language" : "de",
          "value" : "abgelaufen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Inactive",
      "definition" : "Inactive",
      "designation" : [
        {
          "language" : "de",
          "value" : "inaktiv"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Provisional",
      "definition" : "Provisional",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Revoked",
      "definition" : "Revoked",
      "designation" : [
        {
          "language" : "de",
          "value" : "zurückgezogen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "V",
      "display" : "Active/Valid",
      "definition" : "Active/Valid",
      "designation" : [
        {
          "language" : "de",
          "value" : "aktiv/gültig"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
