# Name Type (2.5 - 1.2.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Name Type (2.5 - 1.2.0)**

## ValueSet: Name Type (2.5 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VSnameType | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:Hl7VSnameType |
| *Other Identifiers:*OID:2.16.840.1.113883.21.116 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Concepts for types of names for persons. 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "hl7VSnameType",
  "url" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VSnameType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.21.116"
    }
  ],
  "version" : "1.2.0",
  "name" : "Hl7VSnameType",
  "title" : "Name Type (2.5 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Concepts for types of names for persons.",
  "copyright" : "HL7 Inc., 2026",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/nameType",
        "version" : "0"
      }
    ]
  }
}

```
