# Special Handling Code (2.5 - 1.1.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Special Handling Code (2.5 - 1.1.0)**

## CodeSystem: Special Handling Code (2.5 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/specialHandling | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:SpecialHandling |
| *Other Identifiers:*OID:2.16.840.1.113883.18.234 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing. Used in HL7 Version 2.x messaging in the SPM, SAC, PAC and OM4 segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSspecialHandlingConsiderations](ValueSet-hl7VSspecialHandlingConsiderations.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "specialHandling",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0376"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/specialHandling",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.234"
    }
  ],
  "version" : "1.1.0",
  "name" : "SpecialHandling",
  "title" : "Special Handling Code (2.5 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts describing how a specimen and/or container needs to be handled from the time of collection through the initiation of testing.  Used in HL7 Version 2.x messaging in the SPM, SAC, PAC and OM4 segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AMB",
      "display" : "Ambient temperature",
      "definition" : "Ambient temperature",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "C37",
      "display" : "Body temperature",
      "definition" : "Body temperature",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CAMB",
      "display" : "Critical ambient temperature",
      "definition" : "Critical ambient temperature",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CATM",
      "display" : "Protect from air",
      "definition" : "Protect from air",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CFRZ",
      "display" : "Critical frozen temperature",
      "definition" : "Critical frozen temperature",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CREF",
      "display" : "Critical refrigerated temperature",
      "definition" : "Critical refrigerated temperature",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DFRZ",
      "display" : "Deep frozen",
      "definition" : "Deep frozen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DRY",
      "display" : "Dry",
      "definition" : "Dry",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "FRZ",
      "display" : "Frozen temperature",
      "definition" : "Frozen temperature",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MTLF",
      "display" : "Metal Free",
      "definition" : "Metal Free",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NTR",
      "display" : "Liquid nitrogen",
      "definition" : "Liquid nitrogen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PRTL",
      "display" : "Protect from light",
      "definition" : "Protect from light",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PSA",
      "display" : "Do not shake",
      "definition" : "Do not shake",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PSO",
      "display" : "No shock",
      "definition" : "No shock",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "REF",
      "display" : "Refrigerated temperature",
      "definition" : "Refrigerated temperature",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UFRZ",
      "display" : "Ultra frozen",
      "definition" : "Ultra frozen",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "UPR",
      "display" : "Upright",
      "definition" : "Upright",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
