# Risk Codes (2.5 - 1.0.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Risk Codes (2.5 - 1.0.0)**

## CodeSystem: Risk Codes (2.5 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/risks | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Risks |
| *Other Identifiers:*OID:2.16.840.1.113883.18.313 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient. Used in HL7 Version 2.x messaging in the SPM and PAC segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSriskCodes](ValueSet-hl7VSriskCodes.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "risks",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0489"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/risks",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.313"
    }
  ],
  "version" : "1.0.0",
  "name" : "Risks",
  "title" : "Risk Codes (2.5 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying any known or suspected specimen hazards, e.g., exceptionally infectious agent or blood from a hepatitis patient.  Used in HL7 Version 2.x messaging in the SPM and PAC segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AGG",
      "display" : "Aggressive",
      "definition" : "Aggressive",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BHZ",
      "display" : "Biohazard",
      "definition" : "Biohazard",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BIO",
      "display" : "Biological",
      "definition" : "Biological",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "COR",
      "display" : "Corrosive",
      "definition" : "Corrosive",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ESC",
      "display" : "Escape Risk",
      "definition" : "Escape Risk",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "EXP",
      "display" : "Explosive",
      "definition" : "Explosive",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "IFL",
      "display" : "MaterialDangerInflammable",
      "definition" : "MaterialDangerInflammable",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INF",
      "display" : "MaterialDangerInfectious",
      "definition" : "MaterialDangerInfectious",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "INJ",
      "display" : "Injury Hazard",
      "definition" : "Injury Hazard",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "POI",
      "display" : "Poison",
      "definition" : "Poison",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RAD",
      "display" : "Radioactive",
      "definition" : "Radioactive",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
