# Priority (2.5 - 1.2.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Priority (2.5 - 1.2.0)**

## CodeSystem: Priority (2.5 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/priority | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:Priority |
| *Other Identifiers:*OID:2.16.840.1.113883.18.15 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen. Used in HL7 Version 2.x messaging in the OM4 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSpriority](ValueSet-hl7VSpriority.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "priority",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0027"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/priority",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.15"
    }
  ],
  "version" : "1.2.0",
  "name" : "Priority",
  "title" : "Priority (2.5 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen.  Used in HL7 Version 2.x messaging in the OM4 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "As soon as possible",
      "definition" : "As soon as possible (a priority lower than stat)",
      "designation" : [
        {
          "language" : "de",
          "value" : "schnellstmöglich"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "a priority lower than stat"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-30"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Preoperative",
      "definition" : "Preoperative (to be done prior to surgery)",
      "designation" : [
        {
          "language" : "de",
          "value" : "präoperativ"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "to be done prior to surgery"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-30"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Routine",
      "definition" : "Routine",
      "designation" : [
        {
          "language" : "de",
          "value" : "Routine"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Stat",
      "definition" : "Stat (do immediately)",
      "designation" : [
        {
          "language" : "de",
          "value" : "sofort"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "do immediately"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-30"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Timing critical",
      "definition" : "Timing critical (do as near as possible to requested time)",
      "designation" : [
        {
          "language" : "de",
          "value" : "zum vereinbarten Zeitpunkt"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "do as near as possible to requested time"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-30"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
