# Policy Type (2.5 - 1.0.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Policy Type (2.5 - 1.0.0)**

## CodeSystem: Policy Type (2.5 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/policyType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:PolicyType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.68 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify the policy type. Used in HL7 Version 2.x messaging in the PTA segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSpolicyType](ValueSet-hl7VSpolicyType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "policyType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0147"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/policyType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.68"
    }
  ],
  "version" : "1.0.0",
  "name" : "PolicyType",
  "title" : "Policy Type (2.5 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts which specify the policy type.  Used in HL7 Version 2.x messaging in the PTA segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "2ANC",
      "display" : "Second ancillary",
      "definition" : "Second ancillary",
      "designation" : [
        {
          "language" : "de",
          "value" : "weitere Zusatzversicherung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "2MMD",
      "display" : "Second major medical",
      "definition" : "Second major medical",
      "designation" : [
        {
          "language" : "de",
          "value" : "weitere Hauptversicherung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "3MMD",
      "display" : "Third major medical",
      "definition" : "Third major medical",
      "designation" : [
        {
          "language" : "de",
          "value" : "weitere Hauptversicherung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "ANC",
      "display" : "Ancillary",
      "definition" : "Ancillary",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zusatzversicherung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "MMD",
      "display" : "Major medical",
      "definition" : "Major medical",
      "designation" : [
        {
          "language" : "de",
          "value" : "Hauptversicherung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
