# Observation Result Status Codes Interpretation (2.5 - 1.2.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Observation Result Status Codes Interpretation (2.5 - 1.2.0)**

## CodeSystem: Observation Result Status Codes Interpretation (2.5 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/observationResultStatusCodesInterpretation | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:ObservationResultStatusCodesInterpretation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.34 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. Used in HL7 Version 2.x messaging in the OBX segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSobservationResultStatus](ValueSet-hl7VSobservationResultStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "observationResultStatusCodesInterpretation",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0085"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/observationResultStatusCodesInterpretation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.34"
    }
  ],
  "version" : "1.2.0",
  "name" : "ObservationResultStatusCodesInterpretation",
  "title" : "Observation Result Status Codes Interpretation (2.5 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier.  Used in HL7 Version 2.x messaging in the OBX segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "C",
      "display" : "Record coming over is a correction and thus replaces a final result",
      "definition" : "Record coming over is a correction and thus replaces a final result",
      "designation" : [
        {
          "language" : "de",
          "value" : "Korrektur bereits gemeldeter Ergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Deletes the OBX record",
      "definition" : "Deletes the OBX record",
      "designation" : [
        {
          "language" : "de",
          "value" : "Gemeldete Ergebnisse löschen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "Final results; Can only be changed with a corrected result.",
      "definition" : "Final results; Can only be changed with a corrected result.",
      "designation" : [
        {
          "language" : "de",
          "value" : "Endergebnis"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "I",
      "display" : "Specimen in lab; results pending",
      "definition" : "Specimen in lab; results pending",
      "designation" : [
        {
          "language" : "de",
          "value" : "Probe im Labor - Ergebnisse stehen an"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "N",
      "display" : "Not asked; used to affirmatively document that the observation identified in the OBX was not sought when the universal service ID in OBR-4 implies that it would be sought.",
      "definition" : "Not asked; used to affirmatively document that the observation identified in the OBX was not sought when the universal service ID in OBR-4 implies that it would be sought.",
      "designation" : [
        {
          "language" : "de",
          "value" : "ungefragte Übertragung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "O",
      "display" : "Order detail description only (no result)",
      "definition" : "Order detail description only (no result)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderungsbeschreibung (ohne Ergebnisse)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Preliminary results",
      "definition" : "Preliminary results",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vorläufige Ergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Results entered -- not verified",
      "definition" : "Results entered -- not verified",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nicht validierte Ergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Partial results",
      "definition" : "Partial results",
      "designation" : [
        {
          "language" : "de",
          "value" : "Teilergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Results status change to final without retransmitting results already sent as 'preliminary'. E.g., radiology changes status from preliminary to final",
      "definition" : "Results status change to final without retransmitting results already sent as 'preliminary'.  E.g., radiology changes status from preliminary to final",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vorläufiges Ergebnis wird Endergebnis, da keine Änderung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "W",
      "display" : "Post original as wrong, e.g., transmitted for wrong patient",
      "definition" : "Post original as wrong, e.g., transmitted for wrong patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "fehlerhafte Übertragung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "X",
      "display" : "Results cannot be obtained for this observation",
      "definition" : "Results cannot be obtained for this observation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Untersuchung führt zu keinem Ergebnis"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
