# Identifier Type (2.5 - 1.3.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Identifier Type (2.5 - 1.3.0)**

## CodeSystem: Identifier Type (2.5 - 1.3.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/identifierType | *Version*:1.3.0 |
| Active as of 2026-01-27 | *Computable Name*:IdentifierType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.108 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messaging data types CX, PLN, PPN, XCN and XON. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSidentifierType](ValueSet-hl7VSidentifierType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "identifierType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0203"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/identifierType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.108"
    }
  ],
  "version" : "1.3.0",
  "name" : "IdentifierType",
  "title" : "Identifier Type (2.5 - 1.3.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messaging data types CX, PLN, PPN, XCN and XON.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "class",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#class",
      "description" : "class",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AM",
      "display" : "American Express",
      "definition" : "American Express",
      "designation" : [
        {
          "language" : "de",
          "value" : "American Express"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AN",
      "display" : "Account number",
      "definition" : "Account number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Kontonummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ANC",
      "display" : "Account number Creditor",
      "definition" : "Account number Creditor",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Class: Financial"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "AND",
      "display" : "Account number debitor",
      "definition" : "Account number debitor",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Class: Financial"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ANON",
      "display" : "Anonymous identifier",
      "definition" : "Anonymous identifier",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Justification: For public health reporting purposes, anonymous identifiers are occasionally used for protecting patient identity in reporting certain results. For instance, a state health department may choose to use a scheme for generating an anonymous i"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ANT",
      "display" : "Temporary Account Number",
      "definition" : "Temporary Account Number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Temporary version of an Account Number."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "APRN",
      "display" : "Advanced Practice Registered Nurse number",
      "definition" : "Advanced Practice Registered Nurse number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BA",
      "display" : "Bank Account Number",
      "definition" : "Bank Account Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "BC",
      "display" : "Bank Card Number",
      "definition" : "Bank Card Number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "An identifier that is unique to a person_s bank card. Replaces AM, DI, DS, MS, and VS beginning in v 2.5."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "BR",
      "display" : "Birth registry number",
      "definition" : "Birth registry number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Geburtsregisternummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BRN",
      "display" : "Breed Registry Number",
      "definition" : "Breed Registry Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CC",
      "display" : "Cost Center number",
      "definition" : "Cost Center number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use Case: needed especially for transmitting information about invoices."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "CY",
      "display" : "County number",
      "definition" : "County number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DDS",
      "display" : "Dentist license number",
      "definition" : "Dentist license number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DEA",
      "display" : "Drug Enforcement Administration registration number",
      "definition" : "Drug Enforcement Administration registration number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use case: This is a registration number that identifies an individual or organization relative to controlled substance regulation and transactions."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DFN",
      "display" : "Drug Furnishing or prescriptive authority Number",
      "definition" : "Drug Furnishing or prescriptive authority Number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use Case: A nurse practitioner has authorization to furnish or prescribe pharmaceutical substances; this identifier is in component 1."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DI",
      "display" : "Diner's Club card",
      "definition" : "Diner's Club card",
      "designation" : [
        {
          "language" : "de",
          "value" : "Diners Club"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DL",
      "display" : "Driver's license number",
      "definition" : "Driver's license number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Führerscheinnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DN",
      "display" : "Doctor number",
      "definition" : "Doctor number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Arztnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DO",
      "display" : "Osteopathic License number",
      "definition" : "Osteopathic License number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DPM",
      "display" : "Podiatrist license number",
      "definition" : "Podiatrist license number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "DR",
      "display" : "Donor Registration Number",
      "definition" : "Donor Registration Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DS",
      "display" : "Discover Card",
      "definition" : "Discover Card",
      "designation" : [
        {
          "language" : "de",
          "value" : "Discover Card"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "EI",
      "display" : "Employee number",
      "definition" : "Employee number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Arbeitnehmernummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "EN",
      "display" : "Employer number",
      "definition" : "Employer number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Arbeitgebernummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "FI",
      "display" : "Facility ID",
      "definition" : "Facility ID",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "GI",
      "display" : "Guarantor internal identifier",
      "definition" : "Guarantor internal identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "interne ID des Zahlungspflichtigen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "GL",
      "display" : "General ledger number",
      "definition" : "General ledger number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "GN",
      "display" : "Guarantor external  identifier",
      "definition" : "Guarantor external  identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "externe ID des Zahlungspflichtigen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "HC",
      "display" : "Health Card Number",
      "definition" : "Health Card Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IND",
      "display" : "Indigenous/Aboriginal",
      "definition" : "Indigenous/Aboriginal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "JHN",
      "display" : "Jurisdictional health number (Canada)",
      "definition" : "Jurisdictional health number (Canada)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "2 uses: a) UK jurisdictional CHI number; b) Canadian provincial health card number:"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LI",
      "display" : "Labor and industries number",
      "definition" : "Labor and industries number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "LN",
      "display" : "License number",
      "definition" : "License number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "LR",
      "display" : "Local Registry ID",
      "definition" : "Local Registry ID",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MA",
      "display" : "Patient Medicaid number",
      "definition" : "Patient Medicaid number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Armennummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MB",
      "display" : "Member Number",
      "definition" : "Member Number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use Case: Person is covered by an insurance policy. This person may or may not be the subscriber of the policy."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MC",
      "display" : "Patient's Medicare number",
      "definition" : "Patient's Medicare number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Rentnernummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MCD",
      "display" : "Practitioner Medicaid number",
      "definition" : "Practitioner Medicaid number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MCN",
      "display" : "Microchip Number",
      "definition" : "Microchip Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MCR",
      "display" : "Practitioner Medicare number",
      "definition" : "Practitioner Medicare number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MD",
      "display" : "Medical License number",
      "definition" : "Medical License number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use Case: These license numbers are sometimes used as identifiers. In some states, the same authority issues all three identifiers, e.g., medical, osteopathic, and physician assistant licenses all issued by one state medical board. For this case, the CX d"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MI",
      "display" : "Military ID number",
      "definition" : "Military ID number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MR",
      "display" : "Medical record number",
      "definition" : "Medical record number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Krankenaktennummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MRT",
      "display" : "Temporary Medical Record Number",
      "definition" : "Temporary Medical Record Number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use Case: An ancillary system that does not normally assign medical record numbers is the first time to register a patient. This ancillary system will generate a temporary medical record number that will only be used until an official medical record numbe"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "MS",
      "display" : "MasterCard",
      "definition" : "MasterCard",
      "designation" : [
        {
          "language" : "de",
          "value" : "MasterCard"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NE",
      "display" : "National employer identifier",
      "definition" : "National employer identifier",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "NH",
      "display" : "National Health Plan Identifier",
      "definition" : "National Health Plan Identifier",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Used for the UK NHS national identifier."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "NI",
      "display" : "National unique individual identifier",
      "definition" : "National unique individual identifier",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "In the US, the Assigning Authority for this value is typically CMS, but it may be used by all providers and insurance companies in HIPAA related transactions."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "NII",
      "display" : "National Insurance Organization Identifier",
      "definition" : "National Insurance Organization Identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "Institutskennzeichen der Krankenkasse"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NIIP",
      "display" : "National Insurance Payor Identifier (Payor)",
      "definition" : "National Insurance Payor Identifier (Payor)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vertragskassennummer (VKNR)"
        }
      ],
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Class: Insurance"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NNxxx",
      "display" : "National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) country code",
      "definition" : "National Person Identifier where the xxx is the ISO table 3166 3-character (alphabetic) country code",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "NP",
      "display" : "Nurse practitioner number",
      "definition" : "Nurse practitioner number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "NPI",
      "display" : "National provider identifier",
      "definition" : "National provider identifier",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "In the US, the Assigning Authority for this value is typically CMS, but it may be used by all providers and insurance companies in HIPAA related transactions."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "OD",
      "display" : "Optometrist license number",
      "definition" : "Optometrist license number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PA",
      "display" : "Physician Assistant number",
      "definition" : "Physician Assistant number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Assistenzarztnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PCN",
      "display" : "Penitentiary/correctional institution Number",
      "definition" : "Penitentiary/correctional institution Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PE",
      "display" : "Living Subject Enterprise Number",
      "definition" : "Living Subject Enterprise Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PEN",
      "display" : "Pension Number",
      "definition" : "Pension Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PI",
      "display" : "Patient internal identifier",
      "definition" : "Patient internal identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "interne Patienten-ID"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PN",
      "display" : "Person number",
      "definition" : "Person number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Personen-ID"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "PNT",
      "display" : "Temporary Living Subject Number",
      "definition" : "Temporary Living Subject Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PPN",
      "display" : "Passport number",
      "definition" : "Passport number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Passnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PRC",
      "display" : "Permanent Resident Card Number",
      "definition" : "Permanent Resident Card Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PRN",
      "display" : "Provider number",
      "definition" : "Provider number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use case: This allows PRN to represent either an individual (a nurse) or a group/organization (orthopedic surgery team)."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "PT",
      "display" : "Patient external identifier",
      "definition" : "Patient external identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "externe Patienten-ID"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "QA",
      "display" : "QA number",
      "definition" : "QA number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RI",
      "display" : "Resource identifier",
      "definition" : "Resource identifier",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use Case: An identifier type is needed to accommodate what are commonly known as resources. The resources can include human (e.g. a respiratory therapist), non-human (e.g., a companion animal), inanimate object (e.g., an exam room), organization (e.g., di"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RN",
      "display" : "Registered Nurse Number",
      "definition" : "Registered Nurse Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RPH",
      "display" : "Pharmacist license number",
      "definition" : "Pharmacist license number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "RR",
      "display" : "Railroad Retirement number",
      "definition" : "Railroad Retirement number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Seniorenkartennummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RRI",
      "display" : "Regional registry ID",
      "definition" : "Regional registry ID",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "SL",
      "display" : "State license",
      "definition" : "State license",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "SN",
      "display" : "Subscriber Number",
      "definition" : "Subscriber Number",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "An identifier for a subscriber of an insurance policy which is unique for, and usually assigned by, the insurance carrier."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "SR",
      "display" : "State registry ID",
      "definition" : "State registry ID",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "SS",
      "display" : "Social Security number",
      "definition" : "Social Security number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sozialversicherungsnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TAX",
      "display" : "Tax ID number",
      "definition" : "Tax ID number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Steueridentifikationsnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "TN",
      "display" : "Treaty Number/ (Canada)",
      "definition" : "Treaty Number/ (Canada)",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Use Case: First Nation."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Unspecified identifier",
      "definition" : "Unspecified identifier",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "UPIN",
      "display" : "Medicare/CMS (formerly HCFA)'s Universal Physician Identification numbers",
      "definition" : "Medicare/CMS (formerly HCFA)'s Universal Physician Identification numbers",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "VN",
      "display" : "Visit number",
      "definition" : "Visit number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Fallnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "VS",
      "display" : "VISA",
      "definition" : "VISA",
      "designation" : [
        {
          "language" : "de",
          "value" : "VISA"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "WC",
      "display" : "WIC identifier",
      "definition" : "WIC identifier",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "WCN",
      "display" : "Workers' Comp Number",
      "definition" : "Workers' Comp Number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "XX",
      "display" : "Organization identifier",
      "definition" : "Organization identifier",
      "designation" : [
        {
          "language" : "de",
          "value" : "Organisations-ID"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
