# Event Related Period (2.5 - 1.0.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Event Related Period (2.5 - 1.0.0)**

## CodeSystem: Event Related Period (2.5 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/eventRelatedPeriod | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:EventRelatedPeriod |
| *Other Identifiers:*OID:2.16.840.1.113883.18.344 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying a common (periodical) activity of daily living. Used in HL7 Version 2 messaging in the RPT segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSeventRelatedPeriod](ValueSet-hl7VSeventRelatedPeriod.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "eventRelatedPeriod",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0528"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/eventRelatedPeriod",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.344"
    }
  ],
  "version" : "1.0.0",
  "name" : "EventRelatedPeriod",
  "title" : "Event Related Period (2.5 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying a common (periodical) activity of daily living.  Used in HL7 Version 2 messaging in the RPT segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AC",
      "display" : "before meal (from lat. ante cibus)",
      "definition" : "before meal (from lat. ante cibus)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ACD",
      "display" : "before lunch (from lat. ante cibus diurnus)",
      "definition" : "before lunch (from lat. ante cibus diurnus)",
      "designation" : [
        {
          "language" : "de",
          "value" : "vor dem Mittagessen (from lat. Ante cibus diurnus)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ACM",
      "display" : "before breakfast (from lat. ante cibus matutinus)",
      "definition" : "before breakfast (from lat. ante cibus matutinus)",
      "designation" : [
        {
          "language" : "de",
          "value" : "vor dem Frühstück (from lat. Ante cibus matutinus)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ACV",
      "display" : "before dinner (from lat. ante cibus vespertinus)",
      "definition" : "before dinner (from lat. ante cibus vespertinus)",
      "designation" : [
        {
          "language" : "de",
          "value" : "vor dem Abendessen (from lat. Ante cibus vespertinus)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "HS",
      "display" : "the hour of sleep (e.g., H18-22)",
      "definition" : "the hour of sleep (e.g., H18-22)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "IC",
      "display" : "between meals (from lat. inter cibus)",
      "definition" : "between meals (from lat. inter cibus)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ICD",
      "display" : "between lunch and dinner",
      "definition" : "between lunch and dinner",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ICM",
      "display" : "between breakfast and lunch",
      "definition" : "between breakfast and lunch",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "ICV",
      "display" : "between dinner and the hour of sleep",
      "definition" : "between dinner and the hour of sleep",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PC",
      "display" : "after meal (from lat. post cibus)",
      "definition" : "after meal (from lat. post cibus)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PCD",
      "display" : "after lunch (from lat. post cibus diurnus)",
      "definition" : "after lunch (from lat. post cibus diurnus)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PCM",
      "display" : "after breakfast (from lat. post cibus matutinus)",
      "definition" : "after breakfast (from lat. post cibus matutinus)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    },
    {
      "code" : "PCV",
      "display" : "after dinner (from lat. post cibus vespertinus)",
      "definition" : "after dinner (from lat. post cibus vespertinus)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.5"
        }
      ]
    }
  ]
}

```
