# Eligibility Source (2.5 - 1.0.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Eligibility Source (2.5 - 1.0.0)**

## CodeSystem: Eligibility Source (2.5 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/eligibilitySource | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:EligibilitySource |
| *Other Identifiers:*OID:2.16.840.1.113883.18.65 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify the source of information about the insured's eligibility for benefits. Used in HL7 Version 2.x messaging in the IN2 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSeligibilitySource](ValueSet-hl7VSeligibilitySource.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "eligibilitySource",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0144"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/eligibilitySource",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.65"
    }
  ],
  "version" : "1.0.0",
  "name" : "EligibilitySource",
  "title" : "Eligibility Source (2.5 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts  which specify the source of information about the insured's eligibility for benefits.  Used in HL7 Version 2.x messaging in the IN2 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "1",
      "display" : "Insurance company",
      "definition" : "Insurance company",
      "designation" : [
        {
          "language" : "de",
          "value" : "Versicherung / Krankenkasse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "2",
      "display" : "Employer",
      "definition" : "Employer",
      "designation" : [
        {
          "language" : "de",
          "value" : "Arbeitgeber"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "3",
      "display" : "Insured presented policy",
      "definition" : "Insured presented policy",
      "designation" : [
        {
          "language" : "de",
          "value" : "vorgelegte Versicherungspolice"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "4",
      "display" : "Insured presented card",
      "definition" : "Insured presented card",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vorgelegte Krankenversichertenkarte (KVK)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "5",
      "display" : "Signed statement on file",
      "definition" : "Signed statement on file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Unterschriebenene Bestätigung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "6",
      "display" : "Verbal information",
      "definition" : "Verbal information",
      "designation" : [
        {
          "language" : "de",
          "value" : "mündliche Angabe"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "7",
      "display" : "None",
      "definition" : "None",
      "designation" : [
        {
          "language" : "de",
          "value" : "keine"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
