# Document Storage Status (2.5 - 1.0.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Document Storage Status (2.5 - 1.0.0)**

## CodeSystem: Document Storage Status (2.5 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/documentStorageStatus | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:DocumentStorageStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.168 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to describe the availability of a document in relation to the type of storage. Used in HL7 Version 2.x messaging in the TXA segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSdocumentStorageStatus](ValueSet-hl7VSdocumentStorageStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "documentStorageStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0275"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/documentStorageStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.168"
    }
  ],
  "version" : "1.0.0",
  "name" : "DocumentStorageStatus",
  "title" : "Document Storage Status (2.5 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to describe the availability of a document in relation to the type of storage.  Used in HL7 Version 2.x messaging in the TXA segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AA",
      "display" : "Active and archived",
      "definition" : "Active and archived",
      "designation" : [
        {
          "language" : "de",
          "value" : "Aktiv und archiviert"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AC",
      "display" : "Active",
      "definition" : "Active",
      "designation" : [
        {
          "language" : "de",
          "value" : "Aktiv"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AR",
      "display" : "Archived (not active)",
      "definition" : "Archived (not active)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Archiviert (inaktiv)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PU",
      "display" : "Purged",
      "definition" : "Purged",
      "designation" : [
        {
          "language" : "de",
          "value" : "Bereinigt (gelöscht)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
