# Document Completion Status (2.5 - 1.0.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Document Completion Status (2.5 - 1.0.0)**

## CodeSystem: Document Completion Status (2.5 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/documentCompletionStatus | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:DocumentCompletionStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.164 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to record the state of a document in a workflow. Used in HL7 Version 2.x messaging in the TXA segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSdocumentCompletionStatus](ValueSet-hl7VSdocumentCompletionStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "documentCompletionStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0271"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/documentCompletionStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.164"
    }
  ],
  "version" : "1.0.0",
  "name" : "DocumentCompletionStatus",
  "title" : "Document Completion Status (2.5 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to record the state of a document in a workflow.  Used in HL7 Version 2.x messaging in the TXA segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "nextStatus",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#nextStatus",
      "description" : "nextStatus",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "AU",
      "display" : "Authenticated",
      "definition" : "Authenticated",
      "designation" : [
        {
          "language" : "de",
          "value" : "Freigegeben"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DI",
      "display" : "Dictated",
      "definition" : "Dictated",
      "designation" : [
        {
          "language" : "de",
          "value" : "Diktiert"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DO",
      "display" : "Documented",
      "definition" : "Documented",
      "designation" : [
        {
          "language" : "de",
          "value" : "Dokumentiert"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "IN",
      "display" : "Incomplete",
      "definition" : "Incomplete",
      "designation" : [
        {
          "language" : "de",
          "value" : "Unvollständig"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "IP",
      "display" : "In Progress",
      "definition" : "In Progress",
      "designation" : [
        {
          "language" : "de",
          "value" : "In Bearbeitung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LA",
      "display" : "Legally authenticated",
      "definition" : "Legally authenticated",
      "designation" : [
        {
          "language" : "de",
          "value" : "unterschrieben"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PA",
      "display" : "Pre-authenticated",
      "definition" : "Pre-authenticated",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vorabfreigabe"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
