# Charge Type (2.5 - 1.0.0) - HL7 v2.5 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Charge Type (2.5 - 1.0.0)**

## CodeSystem: Charge Type (2.5 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/chargeType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ChargeType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.50 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify someone or something other than the patient to be billed for a service. Used in HL7 Version 2.x messaging in the BLG segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSchargeType](ValueSet-hl7VSchargeType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "chargeType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.5"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0122"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/chargeType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.50"
    }
  ],
  "version" : "1.0.0",
  "name" : "ChargeType",
  "title" : "Charge Type (2.5 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:43+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify someone or something other than the patient to be billed for a service.  Used in HL7 Version 2.x messaging in the BLG segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CH",
      "display" : "Charge",
      "definition" : "Charge",
      "designation" : [
        {
          "language" : "de",
          "value" : "Rechnung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "CO",
      "display" : "Contract",
      "definition" : "Contract",
      "designation" : [
        {
          "language" : "de",
          "value" : "Vertrag"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "CR",
      "display" : "Credit",
      "definition" : "Credit",
      "designation" : [
        {
          "language" : "de",
          "value" : "Kredit"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "DP",
      "display" : "Department",
      "definition" : "Department",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abteilung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "GR",
      "display" : "Grant",
      "definition" : "Grant",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zuschuß"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "NC",
      "display" : "No Charge",
      "definition" : "No Charge",
      "designation" : [
        {
          "language" : "de",
          "value" : "Keine Rechnung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "PC",
      "display" : "Professional",
      "definition" : "Professional",
      "designation" : [
        {
          "language" : "de",
          "value" : "Berufsgenossenschaft"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RS",
      "display" : "Research",
      "definition" : "Research",
      "designation" : [
        {
          "language" : "de",
          "value" : "Forschung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
