# Visit Indicator (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Visit Indicator (2.4 - 1.0.0)**

## ValueSet: Visit Indicator (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VSvisitIndicator | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Hl7VSvisitIndicator |
| *Other Identifiers:*OID:2.16.840.1.113883.21.211 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Value Set of codes that specify the level on which data are being sent. It is the indicator used to send data at two levels, visit and account. HL7 recommends sending an "A" or no value when the data in the message are at the account level or "V" to i 

 **References** 

This value set is not used here; it may be used elsewhere (e.g. specifications and/or implementations that use this content)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "hl7VSvisitIndicator",
  "url" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VSvisitIndicator",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.21.211"
    }
  ],
  "version" : "1.0.0",
  "name" : "Hl7VSvisitIndicator",
  "title" : "Visit Indicator (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Value Set of codes that specify the level on which data are being sent.  It is the indicator used to send data at two levels, visit and account.  HL7 recommends sending an \"A\" or no value when the data in the message are at the account level or \"V\" to i",
  "copyright" : "HL7 Inc., 2026",
  "compose" : {
    "include" : [
      {
        "system" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/visitIndicator",
        "version" : "0"
      }
    ]
  }
}

```
