# Room Type (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Room Type (2.4 - 1.0.0)**

## CodeSystem: Room Type (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/roomType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:RoomType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.66 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify the room type. Used in HL7 Version 2.x messaging in the RMC segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSroomType](ValueSet-hl7VSroomType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "roomType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0145"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/roomType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.66"
    }
  ],
  "version" : "1.0.0",
  "name" : "RoomType",
  "title" : "Room Type (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts  which specify the room type.  Used in HL7 Version 2.x messaging in the RMC segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "2ICU",
      "display" : "Second intensive care unit",
      "definition" : "Second intensive care unit",
      "designation" : [
        {
          "language" : "de",
          "value" : "nicht verwendet"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "2PRI",
      "display" : "Second private room",
      "definition" : "Second private room",
      "designation" : [
        {
          "language" : "de",
          "value" : "nicht verwendet"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "2SPR",
      "display" : "Second semi-private room",
      "definition" : "Second semi-private room",
      "designation" : [
        {
          "language" : "de",
          "value" : "nicht verwendet"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "ICU",
      "display" : "Intensive care unit",
      "definition" : "Intensive care unit",
      "designation" : [
        {
          "language" : "de",
          "value" : "Intensivstation"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "PRI",
      "display" : "Private room",
      "definition" : "Private room",
      "designation" : [
        {
          "language" : "de",
          "value" : "Einbettzimmer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SPR",
      "display" : "Semi-private room",
      "definition" : "Semi-private room",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zweibettzimmer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
