# Query/Response Format Code (2.4 - 1.2.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Query/Response Format Code (2.4 - 1.2.0)**

## CodeSystem: Query/Response Format Code (2.4 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/queryResponseFormat | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:QueryResponseFormat |
| *Other Identifiers:*OID:2.16.840.1.113883.18.43 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which specify which of several types of formats for data to be returned in response to a query. Used in HL7 Version 2 messaging in the EQL segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSqueryFormatCode](ValueSet-hl7VSqueryFormatCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "queryResponseFormat",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0106"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/queryResponseFormat",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.43"
    }
  ],
  "version" : "1.2.0",
  "name" : "QueryResponseFormat",
  "title" : "Query/Response Format Code (2.4 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which specify which of several types of formats for data to be returned in response to a query.  Used in HL7 Version 2 messaging in the EQL segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "D",
      "display" : "Response is in display format",
      "definition" : "Response is in display format",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort im Anzeige-Format"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Response is in record-oriented format",
      "definition" : "Response is in record-oriented format",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort im datensatzorientierten Format"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Response is in tabular format",
      "definition" : "Response is in tabular format",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort im tabellenorientierten Format"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
