# File Level Event Code (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **File Level Event Code (2.4 - 1.0.0)**

## CodeSystem: File Level Event Code (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/file-levelEvent | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:File-levelEvent |
| *Other Identifiers:*OID:2.16.840.1.113883.18.93 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying file-level events for master files. Used in HL7 Version 2 messaging in the MFI segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSfile-levelEventCode](ValueSet-hl7VSfile-levelEventCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "file-levelEvent",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0178"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/file-levelEvent",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.93"
    }
  ],
  "version" : "1.0.0",
  "name" : "File-levelEvent",
  "title" : "File Level Event Code (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying file-level events for master files.  Used in HL7 Version 2 messaging in the MFI segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "REP",
      "display" : "Replace current version of this master file with the version contained in this message",
      "definition" : "Replace current version of this master file with the version contained in this message",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ersetzen der gesamten Datei"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "UPD",
      "display" : "Change file records as defined in the record-level event codes for each record that follows",
      "definition" : "Change file records as defined in the record-level event codes for each record that follows",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung einzelner Sätze"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
