# Facility Type (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Facility Type (2.4 - 1.0.0)**

## CodeSystem: Facility Type (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/facilityType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:FacilityType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.202 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x messaging in the Facility (FAC) segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSfacilityType](ValueSet-hl7VSfacilityType.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "facilityType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0331"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/facilityType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.202"
    }
  ],
  "version" : "1.0.0",
  "name" : "FacilityType",
  "title" : "Facility Type (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to specify the type of facility.   Used in HL7 Version 2.x messaging in the Facility (FAC) segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Agent for a foreign manufacturer",
      "definition" : "Agent for a foreign manufacturer",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Distributor",
      "definition" : "Distributor",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "M",
      "display" : "Manufacturer",
      "definition" : "Manufacturer",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "User",
      "definition" : "User",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
