# Condition Code (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition Code (2.4 - 1.0.0)**

## CodeSystem: Condition Code (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/conditionCodes | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ConditionCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.19 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the condition code. This field is defined by CMS or other regulartory agencies. Used in HL7 Version 2.x messaging in the UB2 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSconditionCode](ValueSet-hl7VSconditionCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "conditionCodes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0043"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/conditionCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.19"
    }
  ],
  "version" : "1.0.0",
  "name" : "ConditionCodes",
  "title" : "Condition Code (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the condition code.  This field is defined by CMS or other regulartory agencies.  Used in HL7 Version 2.x messaging in the UB2 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "01",
      "display" : "Military service related",
      "definition" : "Military service related",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "02",
      "display" : "Condition is employment related",
      "definition" : "Condition is employment related",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "03",
      "display" : "Patient covered by insurance not reflected here",
      "definition" : "Patient covered by insurance not reflected here",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "04",
      "display" : "HMO enrollee",
      "definition" : "HMO enrollee",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "05",
      "display" : "Lien has been filed",
      "definition" : "Lien has been filed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "06",
      "display" : "ESRD patient in first 18 months of entitlement covered by employer group health insurance",
      "definition" : "ESRD patient in first 18 months of entitlement covered by employer group health insurance",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "07",
      "display" : "Treatment of non-terminal condition for hospice patient",
      "definition" : "Treatment of non-terminal condition for hospice patient",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "08",
      "display" : "Beneficiary would not provide information concerning other insurance coverage",
      "definition" : "Beneficiary would not provide information concerning other insurance coverage",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "09",
      "display" : "Neither patient nor spouse is employed",
      "definition" : "Neither patient nor spouse is employed",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "10",
      "display" : "Patient and/or spouse is employed but no EGHP exists",
      "definition" : "Patient and/or spouse is employed but no EGHP exists",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "11",
      "display" : "Disabled beneficiary but no LGHP",
      "definition" : "Disabled beneficiary but no LGHP",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "12",
      "display" : "Payer codes.",
      "definition" : "Payer codes.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "13",
      "display" : "Payer codes.",
      "definition" : "Payer codes.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "14",
      "display" : "Payer codes.",
      "definition" : "Payer codes.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "15",
      "display" : "Payer codes.",
      "definition" : "Payer codes.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "16",
      "display" : "Payer codes.",
      "definition" : "Payer codes.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "18",
      "display" : "Maiden name retained",
      "definition" : "Maiden name retained",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "19",
      "display" : "Child retains mother's name",
      "definition" : "Child retains mother's name",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "20",
      "display" : "Beneficiary requested billing",
      "definition" : "Beneficiary requested billing",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "21",
      "display" : "Billing for Denial Notice",
      "definition" : "Billing for Denial Notice",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "26",
      "display" : "VA eligible patient chooses to receive services in a Medicare certified facility",
      "definition" : "VA eligible patient chooses to receive services in a Medicare certified facility",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "27",
      "display" : "Patient referred to a sole community hospital for a diagnostic laboratory test",
      "definition" : "Patient referred to a sole community hospital for a diagnostic laboratory test",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "28",
      "display" : "Patient and/or spouse’s EGHP is secondary to Medicare",
      "definition" : "Patient and/or spouse’s EGHP is secondary to Medicare",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "29",
      "display" : "Disabled beneficiary and/or family member’s LGHP is secondary to Medicare",
      "definition" : "Disabled beneficiary and/or family member’s LGHP is secondary to Medicare",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "31",
      "display" : "Patient is student (full time-day)",
      "definition" : "Patient is student (full time-day)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "32",
      "display" : "Patient is student (cooperative/work study program)",
      "definition" : "Patient is student (cooperative/work study program)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "33",
      "display" : "Patient is student (full time-night)",
      "definition" : "Patient is student (full time-night)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "34",
      "display" : "Patient is student (Part time)",
      "definition" : "Patient is student (Part time)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "36",
      "display" : "General care patient in a special unit",
      "definition" : "General care patient in a special unit",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "37",
      "display" : "Ward accommodation as patient request",
      "definition" : "Ward accommodation as patient request",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "38",
      "display" : "Semi-private room not available",
      "definition" : "Semi-private room not available",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "39",
      "display" : "Private room medically necessary",
      "definition" : "Private room medically necessary",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "40",
      "display" : "Same day transfer",
      "definition" : "Same day transfer",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "41",
      "display" : "Partial hospitalization",
      "definition" : "Partial hospitalization",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "46",
      "display" : "Non-availability statement on file",
      "definition" : "Non-availability statement on file",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "48",
      "display" : "Psychiatric residential treatment centers for children and adolescents",
      "definition" : "Psychiatric residential treatment centers for children and adolescents",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "55",
      "display" : "SNF bed not available",
      "definition" : "SNF bed not available",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "56",
      "display" : "Medical appropriateness",
      "definition" : "Medical appropriateness",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "57",
      "display" : "SNF readmission",
      "definition" : "SNF readmission",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "60",
      "display" : "Day outlier",
      "definition" : "Day outlier",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "61",
      "display" : "Cost outlier",
      "definition" : "Cost outlier",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "62",
      "display" : "Payer code",
      "definition" : "Payer code",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "66",
      "display" : "Provider does not wish cost outlier payment",
      "definition" : "Provider does not wish cost outlier payment",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "67",
      "display" : "Beneficiary elects not to use life time reserve (LTR) days",
      "definition" : "Beneficiary elects not to use life time reserve (LTR) days",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "68",
      "display" : "Beneficiary elects to use life time reserve (LTR) days",
      "definition" : "Beneficiary elects to use life time reserve (LTR) days",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "70",
      "display" : "Self-administered EPO",
      "definition" : "Self-administered EPO",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "71",
      "display" : "Full care in unit",
      "definition" : "Full care in unit",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "72",
      "display" : "Self-care in unit",
      "definition" : "Self-care in unit",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "73",
      "display" : "Self-care training",
      "definition" : "Self-care training",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "74",
      "display" : "Home",
      "definition" : "Home",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "75",
      "display" : "Home - 100% reimbursement",
      "definition" : "Home - 100% reimbursement",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "76",
      "display" : "Back-up in facility dialysis",
      "definition" : "Back-up in facility dialysis",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "77",
      "display" : "Provider accepts or is obligated/required due to a contractual arrangement or law to accept payment by a primary payer as payment in full",
      "definition" : "Provider accepts or is obligated/required due to a contractual arrangement or law to accept payment by a primary payer as payment in full",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "78",
      "display" : "New coverage not implemented by HMO",
      "definition" : "New coverage not implemented by HMO",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "79",
      "display" : "Corf services provided off-site",
      "definition" : "Corf services provided off-site",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "80",
      "display" : "Pregnant",
      "definition" : "Pregnant",
      "designation" : [
        {
          "language" : "de",
          "value" : "schwanger"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
