# Coding System (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Coding System (2.4 - 1.0.0)**

## CodeSystem: Coding System (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/codingSystem | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:CodingSystem |
| *Other Identifiers:*OID:2.16.840.1.113883.18.247 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the coding system. This table is maintained outside of the published Version 2 standards, and may be found at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm. Used in HL7 Version 2.x messaging in the CWE segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VScodingSystem](ValueSet-hl7VScodingSystem.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "codingSystem",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0396"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/codingSystem",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.247"
    }
  ],
  "version" : "1.0.0",
  "name" : "CodingSystem",
  "title" : "Coding System (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the coding system.  This table is maintained outside of the published Version 2 standards, and may be found at http://www.hl7.org/Special/committees/vocab/table_0396/index.cfm.  Used in HL7 Version 2.x messaging in the CWE segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "code" : "category",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#category",
      "description" : "category",
      "type" : "string"
    },
    {
      "code" : "country",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#country",
      "description" : "country",
      "type" : "string"
    }
  ],
  "concept" : [
    {
      "code" : "99zzz",
      "display" : "Local general code where z is an alphanumeric character",
      "definition" : "Local general code where z is an alphanumeric character",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Locally defined codes for purpose of sender or receiver - 99zzz (where z is an alphanumeric character)."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ACR",
      "display" : "American College of Radiology finding codes",
      "definition" : "American College of Radiology finding codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ART",
      "display" : "WHO Adverse Reaction Terms",
      "definition" : "WHO Adverse Reaction Terms",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AS4",
      "display" : "ASTM E1238/ E1467 Universal",
      "definition" : "ASTM E1238/ E1467 Universal",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "AS4E",
      "display" : "AS4 Neurophysiology Codes",
      "definition" : "AS4 Neurophysiology Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ATC",
      "display" : "American Type Culture Collection",
      "definition" : "American Type Culture Collection",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "C4",
      "display" : "CPT-4",
      "definition" : "CPT-4",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "C5",
      "display" : "CPT-5",
      "definition" : "CPT-5",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CAS",
      "display" : "Chemical abstract codes",
      "definition" : "Chemical abstract codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CD2",
      "display" : "CDT-2 Codes",
      "definition" : "CDT-2 Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CDCA",
      "display" : "CDC Analyte Codes",
      "definition" : "CDC Analyte Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "country",
          "valueString" : "US"
        }
      ]
    },
    {
      "code" : "CDCM",
      "display" : "CDC Methods/Instruments Codes",
      "definition" : "CDC Methods/Instruments Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "country",
          "valueString" : "US"
        }
      ]
    },
    {
      "code" : "CDS",
      "display" : "CDC Surveillance",
      "definition" : "CDC Surveillance",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CE",
      "display" : "CEN ECG diagnostic codes",
      "definition" : "CEN ECG diagnostic codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CLP",
      "display" : "CLIP",
      "definition" : "CLIP",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CPTM",
      "display" : "CPT Modifier Code",
      "definition" : "CPT Modifier Code",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CST",
      "display" : "COSTART",
      "definition" : "COSTART",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "CVX",
      "display" : "CDC Vaccine Codes",
      "definition" : "CDC Vaccine Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DCL",
      "display" : "DICOM Class Label",
      "definition" : "DICOM Class Label",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DCM",
      "display" : "DICOM modality codes",
      "definition" : "DICOM modality codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "DQL",
      "display" : "DICOM Query Label",
      "definition" : "DICOM Query Label",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E",
      "display" : "EUCLIDES",
      "definition" : "EUCLIDES",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E5",
      "display" : "Euclides  quantity codes",
      "definition" : "Euclides  quantity codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E6",
      "display" : "Euclides Lab method codes",
      "definition" : "Euclides Lab method codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "E7",
      "display" : "Euclides Lab equipment codes",
      "definition" : "Euclides Lab equipment codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ENZC",
      "display" : "Enzyme Codes",
      "definition" : "Enzyme Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FDDC",
      "display" : "First DataBank Drug Codes",
      "definition" : "First DataBank Drug Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FDDX",
      "display" : "First DataBank Diagnostic Codes",
      "definition" : "First DataBank Diagnostic Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "FDK",
      "display" : "FDA K10",
      "definition" : "FDA K10",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HB",
      "display" : "HIBCC",
      "definition" : "HIBCC",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HCPCS",
      "display" : "HCFA Common Procedure Coding System",
      "definition" : "HCFA Common Procedure Coding System",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HHC",
      "display" : "Home Health Care",
      "definition" : "Home Health Care",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HI",
      "display" : "Health Outcomes",
      "definition" : "Health Outcomes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HL7nnnn",
      "display" : "HL7 Defined Codes where nnnn is the HL7 table number",
      "definition" : "HL7 Defined Codes where nnnn is the HL7 table number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "HPC",
      "display" : "HCFA Procedure Codes (HCPCS)",
      "definition" : "HCFA Procedure Codes (HCPCS)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I10",
      "display" : "ICD-10",
      "definition" : "ICD-10",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I10P",
      "display" : "ICD-10  Procedure Codes",
      "definition" : "ICD-10  Procedure Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I9",
      "display" : "ICD9",
      "definition" : "ICD9",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "I9C",
      "display" : "ICD-9CM",
      "definition" : "ICD-9CM",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IBT",
      "display" : "ISBT",
      "definition" : "ISBT",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IC2",
      "display" : "ICHPPC-2",
      "definition" : "ICHPPC-2",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ICDO",
      "display" : "International Classification of Diseases for Oncology",
      "definition" : "International Classification of Diseases for Oncology",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ICS",
      "display" : "ICCS",
      "definition" : "ICCS",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ICSD",
      "display" : "International Classification of Sleep Disorders",
      "definition" : "International Classification of Sleep Disorders",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ISOnnnn",
      "display" : "ISO Defined Codes where nnnn is the ISO table number",
      "definition" : "ISO Defined Codes where nnnn is the ISO table number",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IUPC",
      "display" : "IUPAC/IFCC Component Codes",
      "definition" : "IUPAC/IFCC Component Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "IUPP",
      "display" : "IUPAC/IFCC Property Codes",
      "definition" : "IUPAC/IFCC Property Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "JC8",
      "display" : "Japanese Chemistry",
      "definition" : "Japanese Chemistry",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "L",
      "display" : "Local general code",
      "definition" : "Local general code",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "Locally defined codes for purpose of sender or receiver. Local codes can be identified by L (for backward compatibility)"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-08-09"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LB",
      "display" : "Local billing code",
      "definition" : "Local billing code",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "LN",
      "display" : "Logical Observation Identifier Names and Codes (LOINC(r))",
      "definition" : "Logical Observation Identifier Names and Codes (LOINC(r))",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MCD",
      "display" : "Medicaid",
      "definition" : "Medicaid",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MCR",
      "display" : "Medicare",
      "definition" : "Medicare",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MDDX",
      "display" : "Medispan Diagnostic Codes",
      "definition" : "Medispan Diagnostic Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MEDC",
      "display" : "Medical Economics Drug Codes",
      "definition" : "Medical Economics Drug Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MEDR",
      "display" : "Medical Dictionary for Drug Regulatory Affairs (MEDDRA)",
      "definition" : "Medical Dictionary for Drug Regulatory Affairs (MEDDRA)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MEDX",
      "display" : "Medical Economics Diagnostic Codes",
      "definition" : "Medical Economics Diagnostic Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MGPI",
      "display" : "Medispan GPI",
      "definition" : "Medispan GPI",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "MVX",
      "display" : "CDC Vaccine Manufacturer Codes",
      "definition" : "CDC Vaccine Manufacturer Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NDA",
      "display" : "NANDA",
      "definition" : "NANDA",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NDC",
      "display" : "National drug codes",
      "definition" : "National drug codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NIC",
      "display" : "Nursing Interventions Classification",
      "definition" : "Nursing Interventions Classification",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "NPI",
      "display" : "National Provider Identifier",
      "definition" : "National Provider Identifier",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "OHA",
      "display" : "Omaha System",
      "definition" : "Omaha System",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "POS",
      "display" : "POS Codes",
      "definition" : "POS Codes",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RC",
      "display" : "Read Classification",
      "definition" : "Read Classification",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SDM",
      "display" : "SNOMED- DICOM Microglossary",
      "definition" : "SNOMED- DICOM Microglossary",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SNM",
      "display" : "Systemized Nomenclature of Medicine (SNOMED)",
      "definition" : "Systemized Nomenclature of Medicine (SNOMED)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SNM3",
      "display" : "SNOMED International",
      "definition" : "SNOMED International",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "SNT",
      "display" : "SNOMED topology codes (anatomic sites)",
      "definition" : "SNOMED topology codes (anatomic sites)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UC",
      "display" : "UCDS",
      "definition" : "UCDS",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UMD",
      "display" : "MDNS",
      "definition" : "MDNS",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UML",
      "display" : "Unified Medical Language",
      "definition" : "Unified Medical Language",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UPC",
      "display" : "Universal Product Code",
      "definition" : "Universal Product Code",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "UPIN",
      "display" : "UPIN",
      "definition" : "UPIN",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "W1",
      "display" : "WHO record # drug codes (6 digit)",
      "definition" : "WHO record # drug codes (6 digit)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "W2",
      "display" : "WHO record # drug codes (8 digit)",
      "definition" : "WHO record # drug codes (8 digit)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "W4",
      "display" : "WHO record # code with ASTM extension",
      "definition" : "WHO record # code with ASTM extension",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "WC",
      "display" : "WHO ATC",
      "definition" : "WHO ATC",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    }
  ]
}

```
