# Action Code (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Action Code (2.4 - 1.0.0)**

## CodeSystem: Action Code (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/actionCodes | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:ActionCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.196 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of status codes of record operation. Used in Version 2 messaging, these are used in the RXA segment in the vaccine messages, where a method of correcting vaccination information transmitted with incorrect patient identifying information is needed. As of version 2.6, this table was replaced with table 0206, whose values are defined by code system xxxx. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSactionCode](ValueSet-hl7VSactionCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "actionCodes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0323"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/actionCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.196"
    }
  ],
  "version" : "1.0.0",
  "name" : "ActionCodes",
  "title" : "Action Code (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of status codes of record operation. Used in Version 2 messaging, these are used in the RXA segment in the vaccine messages, where a method of correcting vaccination information transmitted with incorrect patient identifying information is needed.  As of version 2.6, this table was replaced with table 0206, whose values are defined by code system xxxx.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Add/Insert",
      "definition" : "Add/Insert",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "D",
      "display" : "Delete",
      "definition" : "Delete",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "U",
      "display" : "Update",
      "definition" : "Update",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
