# Accept/Application Acknowledgment Conditions (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Accept/Application Acknowledgment Conditions (2.4 - 1.0.0)**

## CodeSystem: Accept/Application Acknowledgment Conditions (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/accept-applicationAcknowledgmentConditions | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Accept-applicationAcknowledgmentConditions |
| *Other Identifiers:*OID:2.16.840.1.113883.18.73 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. Used in HL7 Versions 2 messaging in the MSH segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSaccept-applicationAcknowledgmentConditions](ValueSet-hl7VSaccept-applicationAcknowledgmentConditions.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "accept-applicationAcknowledgmentConditions",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0155"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/accept-applicationAcknowledgmentConditions",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.73"
    }
  ],
  "version" : "1.0.0",
  "name" : "Accept-applicationAcknowledgmentConditions",
  "title" : "Accept/Application Acknowledgment Conditions (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. Used in HL7 Versions 2 messaging in the MSH segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AL",
      "display" : "Always",
      "definition" : "Always",
      "designation" : [
        {
          "language" : "de",
          "value" : "immer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "ER",
      "display" : "Error/reject conditions only",
      "definition" : "Error/reject conditions only",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nur bei Auftreten von Fehlerbedingungen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "NE",
      "display" : "Never",
      "definition" : "Never",
      "designation" : [
        {
          "language" : "de",
          "value" : "niemals"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SU",
      "display" : "Successful completion only",
      "definition" : "Successful completion only",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nur bei erfolgreichem Abschluß"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
