# Downloads - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* **Downloads**

## Downloads

You can also download:

* [this entire guide](full-ig.zip),

The expanded value sets can be found:

* [Expansion in XML](expansions.xml.zip)
* [Expansion in JSON](expansions.json.zip)

The source code for this Implementation Guide will be found shortly on [IHE GitHub](https://github.com/IHE/ITI.PDQm)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.v2.uv.terminology.v24.r4)](package.r4.tgz) and [R4B (hl7.v2.uv.terminology.v24.r4b)](package.r4b.tgz) are available.

#### Dependency Table



#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* HL7 Inc., 2026

* [Accept/Application Acknowledgment Conditions (2.4 - 1.0.0)](CodeSystem-accept-applicationAcknowledgmentConditions.md): [Hl7VSaccept-applicationAcknowledgmentConditions](ValueSet-hl7VSaccept-applicationAcknowledgmentConditions.md)
* [Acknowledgment Code (2.4 - 1.2.0)](CodeSystem-acknowledgmentCodes.md): [Hl7VSacknowledgmentCode](ValueSet-hl7VSacknowledgmentCode.md)
* [Action Code (2.4 - 1.0.0)](CodeSystem-actionCodes.md): [Hl7VSactionCode](ValueSet-hl7VSactionCode.md)
* [Action Taken in Response to the Event (2.4 - 1.0.0)](CodeSystem-actionTakenInResponseToTheEvent.md): [Hl7VSactionTakenInResponseToTheEvent](ValueSet-hl7VSactionTakenInResponseToTheEvent.md)
* [Active/Inactive (2.4 - 1.0.0)](CodeSystem-active-inactive.md): [Hl7VSactive-inactive](ValueSet-hl7VSactive-inactive.md)
* [Additive (2.4 - 1.0.0)](CodeSystem-additivePreservative.md): [Hl7VSadditivePreservative](ValueSet-hl7VSadditivePreservative.md)
* [Address Type (2.4 - 1.2.0)](CodeSystem-addressType.md): [Hl7VSaddressType](ValueSet-hl7VSaddressType.md)
* [Administration Device (2.4 - 1.0.0)](CodeSystem-administrationDevice.md): [Hl7VSadministrationDevice](ValueSet-hl7VSadministrationDevice.md)
* [Administration Method (2.4 - 1.0.0)](CodeSystem-administrationMethod.md): [Hl7VSadministrationMethod](ValueSet-hl7VSadministrationMethod.md)
* [Administrative Sex (2.4 - 1.0.0)](CodeSystem-administrativeSex.md): [Hl7VSadministrativeSex](ValueSet-hl7VSadministrativeSex.md)
* [Admission Level of Care Code (2.4 - 1.0.0)](CodeSystem-admissionLevelOfCare.md): [Hl7VSadmissionLevelOfCareCode](ValueSet-hl7VSadmissionLevelOfCareCode.md)
* [Admission Type (2.4 - 1.1.0)](CodeSystem-admissionType.md): [Hl7VSadmissionType](ValueSet-hl7VSadmissionType.md)
* [Admit Source (2.4 - 1.0.0)](CodeSystem-admitSource.md): [Hl7VSadmitSource](ValueSet-hl7VSadmitSource.md)
* [Advanced Beneficiary Notice Code (2.4 - 1.0.0)](CodeSystem-advancedBeneficiaryNotice.md): [Hl7VSadvancedBeneficiaryNoticeCode](ValueSet-hl7VSadvancedBeneficiaryNoticeCode.md)
* [Alert Device Code (2.4 - 1.0.0)](CodeSystem-alertDevice.md): [Hl7VSalertDeviceCode](ValueSet-hl7VSalertDeviceCode.md)
* [Alert Level (2.4 - 1.0.0)](CodeSystem-alertLevel.md): [Hl7VSalertLevel](ValueSet-hl7VSalertLevel.md)
* [Allergen Type (2.4 - 1.1.0)](CodeSystem-allergenType.md): [Hl7VSallergyType](ValueSet-hl7VSallergyType.md)
* [Allergy Clinical Status (2.4 - 1.0.0)](CodeSystem-allergyClinicalStatus.md): [Hl7VSallergyClinicalStatus](ValueSet-hl7VSallergyClinicalStatus.md)
* [Allergy Severity (2.4 - 1.1.0)](CodeSystem-allergySeverity.md): [Hl7VSallergySeverity](ValueSet-hl7VSallergySeverity.md)
* [Allow Substitution Codes (2.4 - 1.1.0)](CodeSystem-allowSubstitution.md): [Hl7VSallowSubstitution](ValueSet-hl7VSallowSubstitution.md) and [Hl7VSallowSubstitutionCodes](ValueSet-hl7VSallowSubstitutionCodes.md)
* [Alternate Character Set Handling Scheme (2.4 - 1.0.0)](CodeSystem-alternateCharacterSetHandlingScheme.md): [Hl7VSalternateCharacterSetHandlingScheme](ValueSet-hl7VSalternateCharacterSetHandlingScheme.md)
* [Alternate Character Sets (2.4 - 1.1.0)](CodeSystem-alternateCharacterSets.md): [Hl7VSalternateCharacterSets](ValueSet-hl7VSalternateCharacterSets.md)
* [Ambulatory Payment Classification Code (2.4 - 1.0.0)](CodeSystem-ambulatoryPaymentClassification.md): [Hl7VSambulatoryPaymentClassificationCode](ValueSet-hl7VSambulatoryPaymentClassificationCode.md)
* [Ambulatory Status (2.4 - 1.0.0)](CodeSystem-ambulatoryStatus.md): [Hl7VSambulatoryStatus](ValueSet-hl7VSambulatoryStatus.md)
* [Amount Class (2.4 - 1.0.0)](CodeSystem-amountClass.md): [Hl7VSamountClass](ValueSet-hl7VSamountClass.md)
* [Amount Type (2.4 - 1.0.0)](CodeSystem-amountType.md): [Hl7VSamountType](ValueSet-hl7VSamountType.md)
* [Analyte Repeat Status (2.4 - 1.0.0)](CodeSystem-analyteRepeatStatus.md): [Hl7VSanalyteRepeatStatus](ValueSet-hl7VSanalyteRepeatStatus.md)
* [Annotations (2.4 - 1.0.0)](CodeSystem-annotations.md): [Hl7VSannotations](ValueSet-hl7VSannotations.md)
* [Appointment Reason Codes (2.4 - 1.0.0)](CodeSystem-appointmentReason.md): [Hl7VSappointmentReasonCodes](ValueSet-hl7VSappointmentReasonCodes.md)
* [Appointment Type Codes (2.4 - 1.0.0)](CodeSystem-appointmentType.md): [Hl7VSappointmentTypeCodes](ValueSet-hl7VSappointmentTypeCodes.md)
* [PSRO/UR Approval Indicator (2.4 - 1.0.0)](CodeSystem-approvalIndicator.md): [Hl7VSpsro-urApprovalIndicator](ValueSet-hl7VSpsro-urApprovalIndicator.md)
* [Mode of Arrival Code (2.4 - 1.0.0)](CodeSystem-arrivalMode.md): [Hl7VSmodeOfArrivalCode](ValueSet-hl7VSmodeOfArrivalCode.md)
* [Artificial Blood (2.4 - 1.0.0)](CodeSystem-artificialBlood.md): [Hl7VSartificialBlood](ValueSet-hl7VSartificialBlood.md)
* [Assigning Authority (2.4 - 1.0.0)](CodeSystem-assigningAuthority.md): [Hl7VSassigningAuthority](ValueSet-hl7VSassigningAuthority.md)
* [Assignment of Benefits (2.4 - 1.0.0)](CodeSystem-assignmentOfBenefits.md): [Hl7VSassignmentOfBenefits](ValueSet-hl7VSassignmentOfBenefits.md)
* [Bed Status (2.4 - 1.1.0)](CodeSystem-bedStatus.md): [Hl7VSbedStatus](ValueSet-hl7VSbedStatus.md)
* [Blood Product Code (2.4 - 1.0.0)](CodeSystem-bloodProduct.md): [Hl7VSbloodProductCode](ValueSet-hl7VSbloodProductCode.md)
* [Body Site (2.4 - 1.2.0)](CodeSystem-bodySite.md): [Hl7VSadministriveSite](ValueSet-hl7VSadministriveSite.md)
* [Causality Observations (2.4 - 1.0.0)](CodeSystem-causalityObservations.md): [Hl7VScausalityObservations](ValueSet-hl7VScausalityObservations.md)
* [Certification Patient Type (2.4 - 1.0.0)](CodeSystem-certificationPatientType.md): [Hl7VSprecertificationPatientType](ValueSet-hl7VSprecertificationPatientType.md)
* [Certification Status (2.4 - 1.0.0)](CodeSystem-certificationStatus.md): [Hl7VScertificationStatus](ValueSet-hl7VScertificationStatus.md)
* [Charge On Indicator (2.4 - 1.0.0)](CodeSystem-chargeOnIndicator.md): [Hl7VSchargeOnIndicator](ValueSet-hl7VSchargeOnIndicator.md)
* [Charge Type (2.4 - 1.0.0)](CodeSystem-chargeType.md): [Hl7VSchargeType](ValueSet-hl7VSchargeType.md)
* [Check Digit Scheme (2.4 - 1.2.0)](CodeSystem-checkDigitScheme.md): [Hl7VScheckDigitScheme](ValueSet-hl7VScheckDigitScheme.md)
* [OCE Edit Code (2.4 - 1.0.0)](CodeSystem-cms-OCEEditCode-cs.md): [Hl7VSOCEEditCode](ValueSet-hl7VSOCEEditCode.md)
* [Modifier Edit Code (2.4 - 1.0.0)](CodeSystem-cms-OCEModifierEditCode-cs.md): [Hl7VSmodifierEditCode](ValueSet-hl7VSmodifierEditCode.md)
* [Coding System (2.4 - 1.0.0)](CodeSystem-codingSystem.md): [Hl7VScodingSystem](ValueSet-hl7VScodingSystem.md)
* [Command Response (2.4 - 1.0.0)](CodeSystem-commandResponse.md): [Hl7VScommandResponse](ValueSet-hl7VScommandResponse.md)
* [Comment Type (2.4 - 1.0.0)](CodeSystem-commentType.md): [Hl7VScommentType](ValueSet-hl7VScommentType.md)
* [Completion Status (2.4 - 1.0.0)](CodeSystem-completionStatus.md): [Hl7VScompletionStatus](ValueSet-hl7VScompletionStatus.md)
* [Condition Code (2.4 - 1.0.0)](CodeSystem-conditionCodes.md): [Hl7VSconditionCode](ValueSet-hl7VSconditionCode.md)
* [Confidentiality Code (2.4 - 1.0.0)](CodeSystem-confidentialityCodes.md): [Hl7VSconfidentialityCode](ValueSet-hl7VSconfidentialityCode.md)
* [Container Status (2.4 - 1.0.0)](CodeSystem-containerStatus.md): [Hl7VScontainerStatus](ValueSet-hl7VScontainerStatus.md)
* [Continuation Style Code (2.4 - 1.0.0)](CodeSystem-continuationStyle.md): [Hl7VScontinuationStyleCode](ValueSet-hl7VScontinuationStyleCode.md)
* [Coordination of Benefits (2.4 - 1.0.0)](CodeSystem-coordinationOfBenefits.md): [Hl7VScoordinationOfBenefits](ValueSet-hl7VScoordinationOfBenefits.md)
* [Coverage Type (2.4 - 1.0.0)](CodeSystem-coverageType.md): [Hl7VScoverageType](ValueSet-hl7VScoverageType.md)
* [CP Range Type (2.4 - 1.0.0)](CodeSystem-cpRangeType.md): [Hl7VSrangeType](ValueSet-hl7VSrangeType.md)
* [CWE statuses (2.4 - 1.0.0)](CodeSystem-cweStatuses.md): [Hl7VScweStatuses](ValueSet-hl7VScweStatuses.md)
* [Data Types (2.4 - 1.0.0)](CodeSystem-dataTypes.md): [Hl7VSdataTypes](ValueSet-hl7VSdataTypes.md)
* [Date/Time Selection Qualifier (2.4 - 1.0.0)](CodeSystem-date-timeSelectionQualifier.md): [Hl7VSdate-timeSelectionQualifier](ValueSet-hl7VSdate-timeSelectionQualifier.md)
* [Day Type (2.4 - 1.0.0)](CodeSystem-dayType.md): [Hl7VSdayType](ValueSet-hl7VSdayType.md)
* [Days of the Week (2.4 - 1.0.0)](CodeSystem-daysOfTheWeek.md): [Hl7VSdaysOfTheWeek](ValueSet-hl7VSdaysOfTheWeek.md)
* [Deferred Response Type (2.4 - 1.0.0)](CodeSystem-deferredResponseType.md): [Hl7VSdeferredResponseType](ValueSet-hl7VSdeferredResponseType.md)
* [Degree/license/certificate (2.4 - 1.1.0)](CodeSystem-degreeLicenseCertificate.md): [Hl7VSdegree](ValueSet-hl7VSdegree.md)
* [Delayed Acknowledgement Type (2.4 - 1.1.0)](CodeSystem-delayedAcknowledgmentType.md): [Hl7VSdelayedAcknowledgmentType](ValueSet-hl7VSdelayedAcknowledgmentType.md)
* [Denial or Rejection Code (2.4 - 1.0.0)](CodeSystem-denialOrRejectionType.md): [Hl7VSdenialOrRejectionCode](ValueSet-hl7VSdenialOrRejectionCode.md)
* [Derived Specimen (2.4 - 1.0.0)](CodeSystem-derivedSpecimen.md): [Hl7VSderivedSpecimen](ValueSet-hl7VSderivedSpecimen.md)
* [Diagnosis Classification (2.4 - 1.0.0)](CodeSystem-diagnosisClassification.md): [Hl7VSdiagnosisClassification](ValueSet-hl7VSdiagnosisClassification.md)
* [Diagnosis Priority (2.4 - 1.0.0)](CodeSystem-diagnosisPriority.md): [Hl7VSdiagnosisPriority](ValueSet-hl7VSdiagnosisPriority.md)
* [Diagnosis Type (2.4 - 1.0.0)](CodeSystem-diagnosisType.md): [Hl7VSdiagnosisType](ValueSet-hl7VSdiagnosisType.md)
* [Diagnostic Service Section ID (2.4 - 1.3.0)](CodeSystem-diagnosticServiceSectionId.md): [Hl7VSdiagnosticServiceSectionId](ValueSet-hl7VSdiagnosticServiceSectionId.md)
* [Diet Code Specification Type (2.4 - 1.0.0)](CodeSystem-dietCodeSpecificationType.md): [Hl7VSdietType](ValueSet-hl7VSdietType.md)
* [Disabled Person Code (2.4 - 1.0.0)](CodeSystem-disabilityInformationRelationship.md): [Hl7VSdisabledPerson](ValueSet-hl7VSdisabledPerson.md)
* [Discharge Disposition (2.4 - 1.0.0)](CodeSystem-dischargeDisposition.md): [Hl7VSVS-dischargeDisposition](ValueSet-hl7VSVS-dischargeDisposition.md)
* [Dispense Method (2.4 - 1.0.0)](CodeSystem-dispenseMethod.md): [Hl7VSdispenseMethod](ValueSet-hl7VSdispenseMethod.md)
* [Document Availability Status (2.4 - 1.1.0)](CodeSystem-documentAvailabilityStatus.md): [Hl7VSdocumentAvailabilityStatus](ValueSet-hl7VSdocumentAvailabilityStatus.md)
* [Document Completion Status (2.4 - 1.0.0)](CodeSystem-documentCompletionStatus.md): [Hl7VSdocumentCompletionStatus](ValueSet-hl7VSdocumentCompletionStatus.md)
* [Document Confidentiality Status (2.4 - 2.0.0)](CodeSystem-documentConfidentialityStatus2.md): [Hl7VSdocumentConfidentialityStatus](ValueSet-hl7VSdocumentConfidentialityStatus.md)
* [Document Storage Status (2.4 - 1.0.0)](CodeSystem-documentStorageStatus.md): [Hl7VSdocumentStorageStatus](ValueSet-hl7VSdocumentStorageStatus.md)
* [Document Type (2.4 - 1.0.0)](CodeSystem-documentType.md): [Hl7VSreportTypeCode](ValueSet-hl7VSreportTypeCode.md)
* [DRG Payor (2.4 - 1.0.0)](CodeSystem-drgPayor.md): [Hl7VSoutlierType](ValueSet-hl7VSoutlierType.md)
* [Transfer Type (2.4 - 1.0.0)](CodeSystem-drgTransferType.md): [Hl7VSdrgTransferType](ValueSet-hl7VSdrgTransferType.md)
* [Duration Categories (2.4 - 1.1.0)](CodeSystem-durationCategories.md): [Hl7VSdurationCategories](ValueSet-hl7VSdurationCategories.md)
* [Eligibility Source (2.4 - 1.0.0)](CodeSystem-eligibilitySource.md): [Hl7VSeligibilitySource](ValueSet-hl7VSeligibilitySource.md)
* [Employment status (2.4 - 1.0.0)](CodeSystem-employmentStatus.md): [Hl7VSemploymentStatus](ValueSet-hl7VSemploymentStatus.md)
* [Encoding (2.4 - 1.0.0)](CodeSystem-encoding.md): [Hl7VSencoding](ValueSet-hl7VSencoding.md)
* [Equipment State (2.4 - 1.0.0)](CodeSystem-equipmentState.md): [Hl7VSequipmentState](ValueSet-hl7VSequipmentState.md)
* [Escort Required (2.4 - 1.0.0)](CodeSystem-escortRequired.md): [Hl7VSescortRequired](ValueSet-hl7VSescortRequired.md)
* [Event (2.4 - 1.4.0)](CodeSystem-event.md): [Hl7VSevent](ValueSet-hl7VSevent.md)
* [Event Consequence (2.4 - 1.0.0)](CodeSystem-eventConsequence.md): [Hl7VSeventConsequence](ValueSet-hl7VSeventConsequence.md)
* [Event Expected (2.4 - 1.0.0)](CodeSystem-eventExpected.md): [Hl7VSeventExpected](ValueSet-hl7VSeventExpected.md)
* [Event Qualification (2.4 - 1.0.0)](CodeSystem-eventQualification.md): [Hl7VSeventQualification](ValueSet-hl7VSeventQualification.md)
* [Event Reason (2.4 - 1.2.0)](CodeSystem-eventReason.md): [Hl7VSeventReason](ValueSet-hl7VSeventReason.md)
* [Event Reported To (2.4 - 1.0.0)](CodeSystem-eventReportedTo.md): [Hl7VSeventReportedTo](ValueSet-hl7VSeventReportedTo.md)
* [Event Seriousness (2.4 - 1.0.0)](CodeSystem-eventSeriousness.md): [Hl7VSeventSeriousness](ValueSet-hl7VSeventSeriousness.md)
* [Event Type (2.4 - 1.0.0)](CodeSystem-eventType.md): [Hl7VSeventType](ValueSet-hl7VSeventType.md)
* [Yes/No Indicator (2.4 - 1.0.0)](CodeSystem-expandedYes-NoIndicator.md): [Hl7VSyes-no-Indicator](ValueSet-hl7VSyes-no-Indicator.md)
* [Facility Type (2.4 - 1.0.0)](CodeSystem-facilityType.md): [Hl7VSfacilityType](ValueSet-hl7VSfacilityType.md)
* [File Level Event Code (2.4 - 1.0.0)](CodeSystem-file-levelEvent.md): [Hl7VSfile-levelEventCode](ValueSet-hl7VSfile-levelEventCode.md)
* [Filler Status Codes (2.4 - 1.1.0)](CodeSystem-fillerStatus.md): [Hl7VSfillerStatusCodes](ValueSet-hl7VSfillerStatusCodes.md)
* [Formulary Status (2.4 - 1.0.0)](CodeSystem-formularyStatus.md): [Hl7VSformularyStatus](ValueSet-hl7VSformularyStatus.md)
* [Gestation Category Code (2.4 - 1.0.0)](CodeSystem-gestationCategory.md): [Hl7VSgestationCategoryCode](ValueSet-hl7VSgestationCategoryCode.md)
* [Health Care Provider Area of Specialization (2.4 - 1.0.0)](CodeSystem-healthCareProviderAreaOfSpecialization.md): [Hl7VShealthCareProviderAreaOfSpecialization](ValueSet-hl7VShealthCareProviderAreaOfSpecialization.md)
* [Health Care Provider Classification (2.4 - 1.0.0)](CodeSystem-healthCareProviderClassification.md): [Hl7VShealthCareProviderClassification](ValueSet-hl7VShealthCareProviderClassification.md)
* [Health Care Provider Type Code (2.4 - 1.0.0)](CodeSystem-healthCareProviderTypeCode.md): [Hl7VShealthCareProviderTypeCode](ValueSet-hl7VShealthCareProviderTypeCode.md)
* [Identifier Type (2.4 - 1.2.0)](CodeSystem-identifierType.md): [Hl7VSidentifierType](ValueSet-hl7VSidentifierType.md)
* [Identity May Be Divulged (2.4 - 1.0.0)](CodeSystem-identityMayBeDivulged.md): [Hl7VSidentityMayBeDivulged](ValueSet-hl7VSidentityMayBeDivulged.md)
* [Identity Reliability Code (2.4 - 1.0.0)](CodeSystem-identityReliability.md): [Hl7VSidentityReliabilityCode](ValueSet-hl7VSidentityReliabilityCode.md)
* [Immunization Registry Status (2.4 - 1.0.0)](CodeSystem-immunizationRegistryStatus.md): [Hl7VSimmunizationRegistryStatus](ValueSet-hl7VSimmunizationRegistryStatus.md)
* [Incident Type Code (2.4 - 1.0.0)](CodeSystem-incidentType.md): [Hl7VSincidentTypeCode](ValueSet-hl7VSincidentTypeCode.md)
* [Indirect Exposure Mechanism (2.4 - 1.0.0)](CodeSystem-indirectExposureMechanism.md): [Hl7VSindirectExposureMechanism](ValueSet-hl7VSindirectExposureMechanism.md)
* [Invocation Event (2.4 - 1.0.0)](CodeSystem-invocationEvent.md): [Hl7VSwhenToCharge](ValueSet-hl7VSwhenToCharge.md)
* [Job Status (2.4 - 1.0.0)](CodeSystem-jobStatus.md): [Hl7VSjobStatus](ValueSet-hl7VSjobStatus.md)
* [Kind of Quantity (2.4 - 1.0.0)](CodeSystem-kindOfQuantity.md): [Hl7VSkindOfQuantity](ValueSet-hl7VSkindOfQuantity.md)
* [Language Ability (2.4 - 1.0.0)](CodeSystem-languageAbility.md): [Hl7VSlanguageAbility](ValueSet-hl7VSlanguageAbility.md)
* [Language Proficiency (2.4 - 1.0.0)](CodeSystem-languageProficiency.md): [Hl7VSlanguageProficiency](ValueSet-hl7VSlanguageProficiency.md)
* [Level of Care (2.4 - 1.0.0)](CodeSystem-levelOfCare.md): [Hl7VSlevelOfCare](ValueSet-hl7VSlevelOfCare.md)
* [Living Arrangement (2.4 - 1.1.0)](CodeSystem-livingArrangement.md): [Hl7VSlivingArrangement](ValueSet-hl7VSlivingArrangement.md)
* [Living Dependency (2.4 - 1.1.0)](CodeSystem-livingDependency2.md): [Hl7VSlivingDependency](ValueSet-hl7VSlivingDependency.md)
* [Living Will Code (2.4 - 1.0.0)](CodeSystem-livingWillCodes.md): [Hl7VSlivingWill](ValueSet-hl7VSlivingWill.md)
* [Local/Remote Control State (2.4 - 1.0.0)](CodeSystem-local-remoteControlState.md): [Hl7VSlocal-remoteControlState](ValueSet-hl7VSlocal-remoteControlState.md)
* [Location Characteristic ID (2.4 - 1.0.0)](CodeSystem-locationCharacteristic.md): [Hl7VSlocationCharacteristicId](ValueSet-hl7VSlocationCharacteristicId.md)
* [Location Equipment (2.4 - 1.0.0)](CodeSystem-locationEquipment.md): [Hl7VSlocationEquipment](ValueSet-hl7VSlocationEquipment.md)
* [Location Relationship ID (2.4 - 1.0.0)](CodeSystem-locationRelationship.md): [Hl7VSlocationRelationshipId](ValueSet-hl7VSlocationRelationshipId.md)
* [Location Service Code (2.4 - 1.0.0)](CodeSystem-locationServiceType.md): [Hl7VSlocationServiceCode](ValueSet-hl7VSlocationServiceCode.md)
* [Mail Claim Party (2.4 - 1.0.0)](CodeSystem-mailClaimParty.md): [Hl7VSmailClaimParty](ValueSet-hl7VSmailClaimParty.md)
* [Manufacturers of Vaccines (code=MVX) (2.4 - 1.1.0)](CodeSystem-manufacturersOfVaccinesHL7.md): [Hl7VSmanufacturersOfVaccines](ValueSet-hl7VSmanufacturersOfVaccines.md)
* [Marital Status (2.4 - 1.1.0)](CodeSystem-maritalStatus.md): [Hl7VSmaritalStatus](ValueSet-hl7VSmaritalStatus.md)
* [Marketing Basis (2.4 - 1.0.0)](CodeSystem-marketingBasis.md): [Hl7VSmarketingBasis](ValueSet-hl7VSmarketingBasis.md)
* [Master File Identifier Code (2.4 - 1.1.0)](CodeSystem-masterFileIdentifierCodes.md): [Hl7VSmasterFileIdentifierCode](ValueSet-hl7VSmasterFileIdentifierCode.md)
* [Record-level Event Code (2.4 - 1.0.0)](CodeSystem-masterfileActionCode.md): [Hl7VSmasterfileActionCode](ValueSet-hl7VSmasterfileActionCode.md)
* [Match Reason (2.4 - 1.0.0)](CodeSystem-matchReason.md): [Hl7VSmatchReason](ValueSet-hl7VSmatchReason.md)
* [Message Error Condition Codes (2.4 - 1.0.0)](CodeSystem-messageErrorCondition.md): [Hl7VSmessageErrorConditionCodes](ValueSet-hl7VSmessageErrorConditionCodes.md)
* [Message Structure (2.4 - 2.0.0)](CodeSystem-messageStructure.md): [Hl7VSmessageStructure](ValueSet-hl7VSmessageStructure.md)
* [Message Type (2.4 - 1.4.0)](CodeSystem-messageType.md): [Hl7VSmessageType](ValueSet-hl7VSmessageType.md)
* [MFN Record-level Error Return (2.4 - 1.0.0)](CodeSystem-mfnRecord-levelErrorReturn.md): [Hl7VSmfnRecode-levelErrorReturn](ValueSet-hl7VSmfnRecode-levelErrorReturn.md)
* [Military Rank/Grade (2.4 - 2.0.0)](CodeSystem-militaryRank-Grade.md): [Hl7VSmilitaryRank-Grade](ValueSet-hl7VSmilitaryRank-Grade.md)
* [Military Service (2.4 - 1.1.0)](CodeSystem-militaryService.md): [Hl7VSmilitaryService](ValueSet-hl7VSmilitaryService.md)
* [Military Status (2.4 - 1.0.0)](CodeSystem-militaryStatus.md): [Hl7VSmilitaryStatus](ValueSet-hl7VSmilitaryStatus.md)
* [MIME base64 encoding Characters (2.4 - 1.0.0)](CodeSystem-mimeBase64EncodingCharacters.md): [Hl7VSmimeBase64EncodingCharacters](ValueSet-hl7VSmimeBase64EncodingCharacters.md)
* [Modality (2.4 - 1.0.0)](CodeSystem-modality.md): [Hl7VSmodality](ValueSet-hl7VSmodality.md)
* [Modify Indicator (2.4 - 1.0.0)](CodeSystem-modifyIndicator.md): [Hl7VSmodifyIndicator](ValueSet-hl7VSmodifyIndicator.md)
* [Money or Percentage Indicator (2.4 - 1.0.0)](CodeSystem-moneyOrPercentageIndicator.md): [Hl7VSpenaltyType](ValueSet-hl7VSpenaltyType.md)
* [Name/Address Representation (2.4 - 1.0.0)](CodeSystem-name-addressRepresentation.md): [Hl7VSname-addressRepresentation](ValueSet-hl7VSname-addressRepresentation.md)
* [Name Assembly Order (2.4 - 1.0.0)](CodeSystem-nameAssemblyOrder.md): [Hl7VSnameAssemblyOrder](ValueSet-hl7VSnameAssemblyOrder.md)
* [Name Type (2.4 - 1.2.0)](CodeSystem-nameType.md): [Hl7VSnameType](ValueSet-hl7VSnameType.md)
* [Nature of Abnormal Testing (2.4 - 1.0.0)](CodeSystem-natureOfAbnormalTesting.md): [Hl7VSnatureOfAbnormalTesting](ValueSet-hl7VSnatureOfAbnormalTesting.md)
* [Nature of Challenge (2.4 - 1.0.0)](CodeSystem-natureOfChallenge.md): [Hl7VSnatureOfChallenge](ValueSet-hl7VSnatureOfChallenge.md)
* [Nature of Service/Test/Observation (2.4 - 1.1.0)](CodeSystem-natureOfServiceTestObservation.md): [Hl7VSnatureOfServiceTestObservation](ValueSet-hl7VSnatureOfServiceTestObservation.md)
* [Newborn Code (2.4 - 1.0.0)](CodeSystem-newbornType.md): [Hl7VSnewbornCode](ValueSet-hl7VSnewbornCode.md)
* [Special Program Indicator (2.4 - 0.0.0)](CodeSystem-noOIDfound.md): [Hl7VSspecialProgramIndicator](ValueSet-hl7VSspecialProgramIndicator.md)
* [Occurrence Code (2.4 - 1.0.0)](CodeSystem-nubc-OccurrenceCode-cs.md): [Hl7VSoccurrenceCode](ValueSet-hl7VSoccurrenceCode.md)
* [Occurrence Span (2.4 - 1.0.0)](CodeSystem-nubc-OccurrenceSpan-cs.md): [Hl7VSoccurrenceSpan](ValueSet-hl7VSoccurrenceSpan.md)
* [Revenue code (2.4 - 1.0.0)](CodeSystem-nubc-ServiceLineRevenue-cs.md): [Hl7VSrevenueCode](ValueSet-hl7VSrevenueCode.md)
* [Abnormal Flags (2.4 - 1.3.0)](CodeSystem-observationInterpretation.md): [Hl7VSinterpretationCode](ValueSet-hl7VSinterpretationCode.md)
* [Observation Result Status Codes Interpretation (2.4 - 1.2.0)](CodeSystem-observationResultStatusCodesInterpretation.md): [Hl7VSobservationResultStatus](ValueSet-hl7VSobservationResultStatus.md)
* [Order Control Codes (2.4 - 1.4.0)](CodeSystem-orderControlCodes.md): [Hl7VSorderControl](ValueSet-hl7VSorderControl.md)
* [Order Status (2.4 - 1.2.0)](CodeSystem-orderStatus.md): [Hl7VSorderStatus](ValueSet-hl7VSorderStatus.md)
* [Organ Donor Code (2.4 - 1.2.0)](CodeSystem-organDonorCodes.md): [Hl7VSorganDonor](ValueSet-hl7VSorganDonor.md)
* [Practitioner Organization Unit Type (2.4 - 1.0.0)](CodeSystem-organizationUnitType.md): [Hl7VSorganizationUnitType](ValueSet-hl7VSorganizationUnitType.md) and [Hl7VSorganizationUnitType-Org](ValueSet-hl7VSorganizationUnitType-Org.md)
* [Organizational Name Type (2.4 - 1.0.0)](CodeSystem-organizationalNameType.md): [Hl7VSorganizationalNameType](ValueSet-hl7VSorganizationalNameType.md)
* [Overall Claim Disposition Code (2.4 - 1.0.0)](CodeSystem-overallClaimDisposition.md): [Hl7VSoverallClaimDispositionCode](ValueSet-hl7VSoverallClaimDispositionCode.md)
* [Override (2.4 - 1.0.0)](CodeSystem-override.md): [Hl7VSoverride](ValueSet-hl7VSoverride.md)
* [Packaging Status Code (2.4 - 1.0.0)](CodeSystem-packagingStatus.md): [Hl7VSpackagingStatusCode](ValueSet-hl7VSpackagingStatusCode.md)
* [Patient Class (2.4 - 1.2.0)](CodeSystem-patientClass.md): [Hl7VSpatientClass](ValueSet-hl7VSpatientClass.md)
* [Patient Condition Code (2.4 - 1.0.0)](CodeSystem-patientCondition.md): [Hl7VSpatientConditionCode](ValueSet-hl7VSpatientConditionCode.md)
* [Patient Location Type (2.4 - 1.0.0)](CodeSystem-patientLocationType.md): [Hl7VSpatientLocationType](ValueSet-hl7VSpatientLocationType.md)
* [Patient Outcome (2.4 - 1.0.0)](CodeSystem-patientOutcome.md): [Hl7VSpatientOutcome](ValueSet-hl7VSpatientOutcome.md)
* [Patient's Relationship to Insured (2.4 - 1.0.0)](CodeSystem-patientsRelationshipToInsured.md): [Hl7VSpatient_sRelationshipToInsured](ValueSet-hl7VSpatient_sRelationshipToInsured.md)
* [Payment Adjustment Code (2.4 - 1.0.0)](CodeSystem-paymentAdjustmentInformation.md): [Hl7VSpaymentAdjustmentCode](ValueSet-hl7VSpaymentAdjustmentCode.md)
* [Person Location Type (2.4 - 1.0.0)](CodeSystem-personLocationType.md): [Hl7VSpersonLocationType](ValueSet-hl7VSpersonLocationType.md)
* [Policy Type (2.4 - 1.0.0)](CodeSystem-policyType.md): [Hl7VSpolicyType](ValueSet-hl7VSpolicyType.md)
* [Practitioner ID Number Type (2.4 - 1.0.0)](CodeSystem-practitionerIdNumberType.md): [Hl7VSpractitionerIdNumberType](ValueSet-hl7VSpractitionerIdNumberType.md)
* [Precaution Code (2.4 - 1.0.0)](CodeSystem-precaution.md): [Hl7VSprecautionCode](ValueSet-hl7VSprecautionCode.md)
* [Preferred Method of Contact (2.4 - 1.1.0)](CodeSystem-preferredMethodOfContact.md): [Hl7VSpreferredMethodOfContrct](ValueSet-hl7VSpreferredMethodOfContrct.md)
* [Price Type (2.4 - 1.0.0)](CodeSystem-priceType.md): [Hl7VSpriceType](ValueSet-hl7VSpriceType.md)
* [Primary Key Value Type (2.4 - 1.0.0)](CodeSystem-primaryKeyValueType.md): [Hl7VSprimaryKeyValueType](ValueSet-hl7VSprimaryKeyValueType.md)
* [Primary Observer's Qualification (2.4 - 1.0.0)](CodeSystem-primaryObserverQualification.md): [Hl7VSprimaryObserver_sQualification](ValueSet-hl7VSprimaryObserver_sQualification.md)
* [Priority (2.4 - 1.2.0)](CodeSystem-priority.md): [Hl7VSpriority](ValueSet-hl7VSpriority.md)
* [Privacy Level (2.4 - 1.0.0)](CodeSystem-privacyLevel.md): [Hl7VSprivacyLevel](ValueSet-hl7VSprivacyLevel.md)
* [Procedure DRG Type (2.4 - 1.0.0)](CodeSystem-procedureDrgType.md): [Hl7VSprocedureDrgType](ValueSet-hl7VSprocedureDrgType.md)
* [Procedure Functional Type (2.4 - 1.0.0)](CodeSystem-procedureFunctionalType.md): [Hl7VSprocedureFunctionalType](ValueSet-hl7VSprocedureFunctionalType.md)
* [Procedure Practitioner Identifier Type (2.4 - 1.2.0)](CodeSystem-procedurePractitionerIdentifierCodeType.md): [Hl7VSprocedurePractitionerType](ValueSet-hl7VSprocedurePractitionerType.md)
* [Procedure Priority (2.4 - 1.0.0)](CodeSystem-procedurePriority.md): [Hl7VSprocedurePriority](ValueSet-hl7VSprocedurePriority.md)
* [Processing ID (2.4 - 1.0.0)](CodeSystem-processingId.md): [Hl7VSprocessingId](ValueSet-hl7VSprocessingId.md)
* [Processing Mode (2.4 - 1.1.0)](CodeSystem-processingMode.md): [Hl7VSprocessingMode](ValueSet-hl7VSprocessingMode.md)
* [Processing Priority (2.4 - 1.0.0)](CodeSystem-processingPriority.md): [Hl7VSprocessingPriority](ValueSet-hl7VSprocessingPriority.md)
* [Processing Type (2.4 - 1.0.0)](CodeSystem-processingType.md): [Hl7VSprocessingType](ValueSet-hl7VSprocessingType.md)
* [Product Source (2.4 - 1.0.0)](CodeSystem-productSource.md): [Hl7VSproductSource](ValueSet-hl7VSproductSource.md)
* [Production Class Code (2.4 - 1.0.0)](CodeSystem-productionClass.md): [Hl7VSproductionClassCode](ValueSet-hl7VSproductionClassCode.md)
* [Provider Billing (2.4 - 1.0.0)](CodeSystem-providerBilling.md): [Hl7VSproviderBilling](ValueSet-hl7VSproviderBilling.md)
* [Provider Role (2.4 - 1.0.0)](CodeSystem-providerRole.md): [Hl7VSproviderRole](ValueSet-hl7VSproviderRole.md)
* [Purge Status Code (2.4 - 1.0.0)](CodeSystem-purgeStatus.md): [Hl7VSpurgeStatus](ValueSet-hl7VSpurgeStatus.md)
* [Quantity Limited Request (2.4 - 1.1.0)](CodeSystem-quantityLimitedRequest.md): [Hl7VSquantityLimitedRequest](ValueSet-hl7VSquantityLimitedRequest.md)
* [Quantity Method (2.4 - 1.0.0)](CodeSystem-quantityMethod.md): [Hl7VSquantityMethod](ValueSet-hl7VSquantityMethod.md)
* [Query Priority (2.4 - 1.0.0)](CodeSystem-queryPriority.md): [Hl7VSqueryPriority](ValueSet-hl7VSqueryPriority.md)
* [Query/Response Format Code (2.4 - 1.2.0)](CodeSystem-queryResponseFormat.md): [Hl7VSqueryFormatCode](ValueSet-hl7VSqueryFormatCode.md)
* [Query Response Status (2.4 - 1.1.0)](CodeSystem-queryResponseStatus.md): [Hl7VSqueryResponseStatus](ValueSet-hl7VSqueryResponseStatus.md)
* [Query Results Level (2.4 - 1.0.2)](CodeSystem-queryResultsLevel.md): [Hl7VSqueryResultsLevel](ValueSet-hl7VSqueryResultsLevel.md)
* [Recreational Drug Use Code (2.4 - 1.0.0)](CodeSystem-recreationalDrugType.md): [Hl7VSrecreationalDrugUseCode](ValueSet-hl7VSrecreationalDrugUseCode.md)
* [Referral Category (2.4 - 1.0.0)](CodeSystem-referralCategory.md): [Hl7VSreferralCategory](ValueSet-hl7VSreferralCategory.md)
* [Referral Disposition (2.4 - 1.0.0)](CodeSystem-referralDisposition.md): [Hl7VSreferralDisposition](ValueSet-hl7VSreferralDisposition.md)
* [Referral Priority (2.4 - 1.0.0)](CodeSystem-referralPriority.md): [Hl7VSreferralPriority](ValueSet-hl7VSreferralPriority.md)
* [Referral Reason (2.4 - 1.0.0)](CodeSystem-referralReason.md): [Hl7VSreferralReason](ValueSet-hl7VSreferralReason.md)
* [Referral Status (2.4 - 1.0.0)](CodeSystem-referralStatus.md): [Hl7VSreferralStatus](ValueSet-hl7VSreferralStatus.md)
* [Referral Type (2.4 - 1.0.0)](CodeSystem-referralType.md): [Hl7VSreferralType](ValueSet-hl7VSreferralType.md)
* [Reimbursement Action Code (2.4 - 1.0.0)](CodeSystem-reimbursementAction.md): [Hl7VSreimbursementActionCode](ValueSet-hl7VSreimbursementActionCode.md)
* [Reimbursement Type Code (2.4 - 1.0.0)](CodeSystem-reimbursementType.md): [Hl7VSreimbursementTypeCode](ValueSet-hl7VSreimbursementTypeCode.md)
* [Relatedness Assessment (2.4 - 1.0.0)](CodeSystem-relatednessAssessment.md): [Hl7VSrelatednessAssessment](ValueSet-hl7VSrelatednessAssessment.md)
* [Relational Conjunction (2.4 - 1.0.0)](CodeSystem-relationalConjunction.md): [Hl7VSrelationalConjunction](ValueSet-hl7VSrelationalConjunction.md)
* [Relational Operator (2.4 - 1.0.0)](CodeSystem-relationalOperator.md): [Hl7VSrelationalOperator](ValueSet-hl7VSrelationalOperator.md)
* [Relationship (2.4 - 1.0.0)](CodeSystem-relationship.md): [Hl7VSrelationship](ValueSet-hl7VSrelationship.md)
* [Relationship Modifier (2.4 - 1.0.0)](CodeSystem-relationshipModifier.md): [Hl7VSrelationshipModifier](ValueSet-hl7VSrelationshipModifier.md)
* [Religion (2.4 - 2.0.0)](CodeSystem-religion2.md): [Hl7VSreligion2](ValueSet-hl7VSreligion2.md)
* [Remote Control Command (2.4 - 1.0.0)](CodeSystem-remoteControlCommand.md): [Hl7VSremoteControlCommand](ValueSet-hl7VSremoteControlCommand.md)
* [Repeat Pattern (2.4 - 1.0.0)](CodeSystem-repeatPattern.md): [Hl7VSrepeatPattern](ValueSet-hl7VSrepeatPattern.md)
* [Report Priority (2.4 - 1.0.0)](CodeSystem-reportPriority.md): [Hl7VSreportPriority](ValueSet-hl7VSreportPriority.md)
* [Report Source (2.4 - 1.0.0)](CodeSystem-reportSource.md): [Hl7VSreportSource](ValueSet-hl7VSreportSource.md)
* [Report Timing (2.4 - 1.0.0)](CodeSystem-reportTiming.md): [Hl7VSreportTiming](ValueSet-hl7VSreportTiming.md)
* [Reporting Priority (2.4 - 1.0.0)](CodeSystem-reportingPriority.md): [Hl7VSreportingPriority](ValueSet-hl7VSreportingPriority.md)
* [Response Flag (2.4 - 1.0.0)](CodeSystem-responseFlag.md): [Hl7VSresponseFlag](ValueSet-hl7VSresponseFlag.md)
* [Response Level (2.4 - 1.0.0)](CodeSystem-responseLevel.md): [Hl7VSresponseLevel](ValueSet-hl7VSresponseLevel.md)
* [Response Modality (2.4 - 1.0.0)](CodeSystem-responseModality.md): [Hl7VSresponseModality](ValueSet-hl7VSresponseModality.md)
* [Result Status (2.4 - 1.2.0)](CodeSystem-resultStatus.md): [Hl7VSresultStatus-Obr](ValueSet-hl7VSresultStatus-Obr.md)
* [Risk Management Incident Code (2.4 - 1.0.0)](CodeSystem-riskManagementIncident.md): [Hl7VSriskManagementIncidentCode](ValueSet-hl7VSriskManagementIncidentCode.md)
* [Room Type (2.4 - 1.0.0)](CodeSystem-roomType.md): [Hl7VSroomType](ValueSet-hl7VSroomType.md)
* [Route of Administration (2.4 - 3.0.0)](CodeSystem-routeOfAdministration.md): [Hl7VSrouteOfAdministration](ValueSet-hl7VSrouteOfAdministration.md)
* [RX Component Type (2.4 - 1.0.0)](CodeSystem-rxComponentType.md): [Hl7VSrxComponentType](ValueSet-hl7VSrxComponentType.md)
* [Segment Action Code (2.4 - 1.0.0)](CodeSystem-segmentAction.md): [Hl7VSsegmentActionCode](ValueSet-hl7VSsegmentActionCode.md)
* [Segment Group (2.4 - 1.0.0)](CodeSystem-segmentGroup.md): [Hl7VSsegmentGroup](ValueSet-hl7VSsegmentGroup.md)
* [Sensitivity to Causative Agent Code (2.4 - 1.0.0)](CodeSystem-sensitivityToCausativeAgent.md): [Hl7VSsensitivityToCausativeAgentCode](ValueSet-hl7VSsensitivityToCausativeAgentCode.md)
* [Sequencing (2.4 - 1.0.0)](CodeSystem-sequencing.md): [Hl7VSsequencing](ValueSet-hl7VSsequencing.md)
* [Severity of Illness Code (2.4 - 1.0.0)](CodeSystem-severityOfIllness.md): [Hl7VSseverityOfIllnessCode](ValueSet-hl7VSseverityOfIllnessCode.md)
* [Source of Comment (2.4 - 1.1.0)](CodeSystem-sourceOfComment.md): [Hl7VSsourceOfComment](ValueSet-hl7VSsourceOfComment.md)
* [Source Type (2.4 - 1.0.0)](CodeSystem-sourceType.md): [Hl7VSnetworkSourceType](ValueSet-hl7VSnetworkSourceType.md)
* [Special Handling Code (2.4 - 1.0.0)](CodeSystem-specialHandling.md): [Hl7VSspecialHandlingConsiderations](ValueSet-hl7VSspecialHandlingConsiderations.md)
* [Specialty Type (2.4 - 1.0.0)](CodeSystem-specialtyType.md): [Hl7VSspecialtyType](ValueSet-hl7VSspecialtyType.md)
* [Specimen Component (2.4 - 1.0.0)](CodeSystem-specimenComponent.md): [Hl7VSspecimenComponent](ValueSet-hl7VSspecimenComponent.md)
* [Specimen role (2.4 - 1.0.0)](CodeSystem-specimenRole.md): [Hl7VSspecimenRole](ValueSet-hl7VSspecimenRole.md)
* [Specimen Source Codes (2.4 - 1.3.0)](CodeSystem-specimenSourceCodes.md): [Hl7VSsourceOfSpecimen](ValueSet-hl7VSsourceOfSpecimen.md)
* [Status of Evaluation (2.4 - 1.0.0)](CodeSystem-statusOfEvaluation.md): [Hl7VSstartOfEvaluation](ValueSet-hl7VSstartOfEvaluation.md)
* [Student Status (2.4 - 1.0.0)](CodeSystem-studentStatus.md): [Hl7VSstudentStatus](ValueSet-hl7VSstudentStatus.md)
* [Substance Status (2.4 - 1.0.0)](CodeSystem-substanceStatus.md): [Hl7VSsubstanceStatus](ValueSet-hl7VSsubstanceStatus.md)
* [Substance Type (2.4 - 1.0.0)](CodeSystem-substanceType.md): [Hl7VSsubstanceType](ValueSet-hl7VSsubstanceType.md)
* [Substitution Status (2.4 - 1.1.0)](CodeSystem-substitutionStatus.md): [Hl7VSsubstitutionStatus](ValueSet-hl7VSsubstitutionStatus.md)
* [Subtype of Referenced Data (2.4 - 1.2.0)](CodeSystem-subtypeOfReferencedData.md): [Hl7VSsubtypeOfReferencedData](ValueSet-hl7VSsubtypeOfReferencedData.md)
* [Telecommunication Equipment Type (2.4 - 1.0.0)](CodeSystem-telecommunicationEquipmentType.md): [Hl7VStelecommunicationEquipmentType](ValueSet-hl7VStelecommunicationEquipmentType.md)
* [Telecommunication Use Code (2.4 - 1.1.0)](CodeSystem-telecommunicationUse.md): [Hl7VStelecommunicationUseCode](ValueSet-hl7VStelecommunicationUseCode.md)
* [Time Delay Post Challenge (2.4 - 1.0.0)](CodeSystem-timeDelayPostChallenge.md): [Hl7VStimeDelayPostChallenge](ValueSet-hl7VStimeDelayPostChallenge.md)
* [Time Selection Criteria Parameter Class Codes (2.4 - 1.1.0)](CodeSystem-timeSelectionCriteriaParameterClass.md): [Hl7VStimeSelectionCriteriaParameterClassCodes](ValueSet-hl7VStimeSelectionCriteriaParameterClassCodes.md)
* [Tissue Type Code (2.4 - 1.0.0)](CodeSystem-tissueType.md): [Hl7VStissueTypeCode](ValueSet-hl7VStissueTypeCode.md)
* [TQ Conjunction ID (2.4 - 1.0.0)](CodeSystem-tqConjunctionId.md): [Hl7VStqConjunctionId](ValueSet-hl7VStqConjunctionId.md)
* [Transaction Type (2.4 - 1.1.0)](CodeSystem-transactionType.md): [Hl7VStransactionType](ValueSet-hl7VStransactionType.md)
* [Transport Arranged (2.4 - 1.0.0)](CodeSystem-transportArranged.md): [Hl7VStransportArranged](ValueSet-hl7VStransportArranged.md)
* [Transportation Mode (2.4 - 1.0.0)](CodeSystem-transportationMode.md): [Hl7VStransportationMode](ValueSet-hl7VStransportationMode.md)
* [Tray Type (2.4 - 1.0.0)](CodeSystem-trayType.md): [Hl7VStrayType](ValueSet-hl7VStrayType.md)
* [Treatment (2.4 - 1.0.0)](CodeSystem-treatment.md): [Hl7VStreatment](ValueSet-hl7VStreatment.md)
* [Triage Code (2.4 - 1.0.0)](CodeSystem-triageType.md): [Hl7VStriageCode](ValueSet-hl7VStriageCode.md)
* [Type of Bill Code (2.4 - 1.0.0)](CodeSystem-typeOfBill.md): [Hl7VStypeOfBillCode](ValueSet-hl7VStypeOfBillCode.md)
* [Type of Referenced Data (2.4 - 1.3.0)](CodeSystem-typeOfReferencedData.md): [Hl7VStypeOfData](ValueSet-hl7VStypeOfData.md)
* [Universal ID Type (2.4 - 1.0.0)](CodeSystem-universalIdType.md): [Hl7VSuniversalIdType](ValueSet-hl7VSuniversalIdType.md)
* [Vaccines Administered (2.4 - 1.2.0)](CodeSystem-vaccinesAdministeredHL7.md): [Hl7VSvaccinesAdministered](ValueSet-hl7VSvaccinesAdministered.md)
* [Version ID (2.4 - 1.4.0)](CodeSystem-versionId.md): [Hl7VSversionControlTable](ValueSet-hl7VSversionControlTable.md)
* [Visit Indicator (2.4 - 1.0.0)](CodeSystem-visitIndicator.md): [Hl7VSvisitIndicator](ValueSet-hl7VSvisitIndicator.md)
* [Visit Priority Code (2.4 - 1.0.0)](CodeSystem-visitPriority.md): [Hl7VSvisitPriorityCode](ValueSet-hl7VSvisitPriorityCode.md)
* [Visit User Code (2.4 - 1.0.0)](CodeSystem-visitUserCodes.md): [Hl7VSvisitUserCode](ValueSet-hl7VSvisitUserCode.md)
* [What subject filter (2.4 - 1.4.0)](CodeSystem-whatSubjectFilter.md): [Hl7VSwhatSubjectFilter](ValueSet-hl7VSwhatSubjectFilter.md)
* [Which Date/Time Qualifier (2.4 - 1.1.0)](CodeSystem-whichDate-timeQualifier.md): [Hl7VSwhichDate-timeQualifier](ValueSet-hl7VSwhichDate-timeQualifier.md)
* [Which Date/Time Status Qualifier (2.4 - 1.0.0)](CodeSystem-whichDate-timeStatusQualifier.md): [Hl7VSwhichDate-timeStatusQualifier](ValueSet-hl7VSwhichDate-timeStatusQualifier.md)


