# Type of Bill Code (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Type of Bill Code (2.4 - 1.0.0)**

## CodeSystem: Type of Bill Code (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/typeOfBill | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:TypeOfBill |
| *Other Identifiers:*OID:2.16.840.1.113883.18.290 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7 published codes from the UB92 Form Locator 4 "Type of Bill"; note that the UB codes listed are not an exhaustive or current list; refer to a UB specification for additional information. This needs review by HTA and PA/FM; this may be a value set built on external CMS codes from the UB. Used in HL7 Version 2.x messaging in the GP1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VStypeOfBillCode](ValueSet-hl7VStypeOfBillCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "typeOfBill",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0455"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/typeOfBill",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.290"
    }
  ],
  "version" : "1.0.0",
  "name" : "TypeOfBill",
  "title" : "Type of Bill Code (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7 published codes from the UB92 Form Locator 4 \"Type of Bill\";  note that the UB codes listed are not an exhaustive or current list; refer to a UB specification for additional information. This needs  review by HTA and PA/FM; this may be a value set built on external CMS codes from the UB.  Used in HL7 Version 2.x messaging in the GP1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "131",
      "display" : "Hospital - Outpatient - Admit thru Discharge Claim",
      "definition" : "Hospital - Outpatient - Admit thru Discharge Claim"
    },
    {
      "code" : "141",
      "display" : "Hospital - Other - Admit thru Discharge Claim",
      "definition" : "Hospital - Other - Admit thru Discharge Claim"
    }
  ]
}

```
