# Segment Group (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Segment Group (2.4 - 1.0.0)**

## CodeSystem: Segment Group (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/segmentGroup | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:SegmentGroup |
| *Other Identifiers:*OID:2.16.840.1.113883.18.241 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the optional segment groups which are to be included in the response. This is a repeating field, to accommodate inclusion of multiple segment groups. The default for this field, not present, means that all relevant groups are included. Used in Version 2 messaging in the Response Control Parameter (RCP) segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSsegmentGroup](ValueSet-hl7VSsegmentGroup.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "segmentGroup",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0391"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/segmentGroup",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.241"
    }
  ],
  "version" : "1.0.0",
  "name" : "SegmentGroup",
  "title" : "Segment Group (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the optional segment groups which are to be included in the response.  This is a repeating field, to accommodate inclusion of multiple segment groups. The default for this field, not present, means that all relevant groups are included.  Used in Version 2 messaging in the Response Control Parameter (RCP) segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VShl7VSmessageStructure"
        }
      ],
      "code" : "msgstruct",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#msgstruct",
      "description" : "msgstruct",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "ADMINISTRATION",
      "display" : "ADMINISTRATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRA_O18"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        }
      ]
    },
    {
      "code" : "ALLERGY",
      "display" : "ALLERGY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        }
      ]
    },
    {
      "code" : "APP_STATS",
      "display" : "APP_STATS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMD_N02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMR_N01"
        }
      ]
    },
    {
      "code" : "APP_STATUS",
      "display" : "APP_STATUS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMD_N02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMR_N01"
        }
      ]
    },
    {
      "code" : "ASSOCIATED_PERSON",
      "display" : "ASSOCIATED_PERSON",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "ASSOCIATED_RX_ADMIN",
      "display" : "ASSOCIATED_RX_ADMIN",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "ASSOCIATED_RX_ORDER",
      "display" : "ASSOCIATED_RX_ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "AUTHORIZATION",
      "display" : "AUTHORIZATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        }
      ]
    },
    {
      "code" : "AUTHORIZATION_CONTACT",
      "display" : "AUTHORIZATION_CONTACT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        }
      ]
    },
    {
      "code" : "CHOICE",
      "display" : "CHOICE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORM_O01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "CLOCK",
      "display" : "CLOCK",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMD_N02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMR_N01"
        }
      ]
    },
    {
      "code" : "CLOCK_AND_STATISTICS",
      "display" : "CLOCK_AND_STATISTICS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMQ_N01"
        }
      ]
    },
    {
      "code" : "CLOCK_AND_STATS_WITH_NOTES",
      "display" : "CLOCK_AND_STATS_WITH_NOTES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMD_N02"
        }
      ]
    },
    {
      "code" : "CLOCK_AND_STATS_WITH_NOTES_ALT",
      "display" : "CLOCK_AND_STATS_WITH_NOTES_ALT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMR_N01"
        }
      ]
    },
    {
      "code" : "COMMAND_RESPONSE",
      "display" : "COMMAND_RESPONSE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EAR_U08"
        }
      ]
    },
    {
      "code" : "COMMON_ORDER",
      "display" : "COMMON_ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        }
      ]
    },
    {
      "code" : "COMPONENT",
      "display" : "COMPONENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        }
      ]
    },
    {
      "code" : "COMPONENTS",
      "display" : "COMPONENTS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        }
      ]
    },
    {
      "code" : "CONTAINER",
      "display" : "CONTAINER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R21"
        }
      ]
    },
    {
      "code" : "CONTAINER_1",
      "display" : "CONTAINER_1",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        }
      ]
    },
    {
      "code" : "CONTAINER_2",
      "display" : "CONTAINER_2",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        }
      ]
    },
    {
      "code" : "DEFINITION",
      "display" : "DEFINITION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAR_RAR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RER_RER"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ROR_ROR"
        }
      ]
    },
    {
      "code" : "DEFINTION",
      "display" : "DEFINTION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGR_RGR"
        }
      ]
    },
    {
      "code" : "DIET",
      "display" : "DIET",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        }
      ]
    },
    {
      "code" : "DISPENSE",
      "display" : "DISPENSE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRD_O14"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        }
      ]
    },
    {
      "code" : "ENCODED_ORDER",
      "display" : "ENCODED_ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        }
      ]
    },
    {
      "code" : "ENCODING",
      "display" : "ENCODING",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAR_RAR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGR_RGR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRE_O12"
        }
      ]
    },
    {
      "code" : "EXPERIENCE",
      "display" : "EXPERIENCE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "FACILITY",
      "display" : "FACILITY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SUR_P09"
        }
      ]
    },
    {
      "code" : "FACILITY_DETAIL",
      "display" : "FACILITY_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SUR_P09"
        }
      ]
    },
    {
      "code" : "FINANCIAL",
      "display" : "FINANCIAL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_COMMON_ORDER",
      "display" : "FINANCIAL_COMMON_ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_INSURANCE",
      "display" : "FINANCIAL_INSURANCE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_OBSERVATION",
      "display" : "FINANCIAL_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_ORDER",
      "display" : "FINANCIAL_ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "FINANCIAL_PROCEDURE",
      "display" : "FINANCIAL_PROCEDURE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        }
      ]
    },
    {
      "code" : "GENERAL_ORDER",
      "display" : "GENERAL_ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        }
      ]
    },
    {
      "code" : "GENERAL_RESOURCE",
      "display" : "GENERAL_RESOURCE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "GIVE",
      "display" : "GIVE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRG_O16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        }
      ]
    },
    {
      "code" : "GOAL",
      "display" : "GOAL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "GOAL_OBSERVATION",
      "display" : "GOAL_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "GOAL_PATHWAY",
      "display" : "GOAL_PATHWAY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        }
      ]
    },
    {
      "code" : "GOAL_ROLE",
      "display" : "GOAL_ROLE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "GUARANTOR_INSURANCE",
      "display" : "GUARANTOR_INSURANCE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQI_I01"
        }
      ]
    },
    {
      "code" : "INSURANCE",
      "display" : "INSURANCE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADR_A19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORM_O01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQI_I01"
        }
      ]
    },
    {
      "code" : "LOCATION_RESOURCE",
      "display" : "LOCATION_RESOURCE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "MERGE_INFO",
      "display" : "MERGE_INFO",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A45"
        }
      ]
    },
    {
      "code" : "MF",
      "display" : "MF",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M01"
        }
      ]
    },
    {
      "code" : "MF_CDM",
      "display" : "MF_CDM",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M04"
        }
      ]
    },
    {
      "code" : "MF_CLIN_STUDY",
      "display" : "MF_CLIN_STUDY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M06"
        }
      ]
    },
    {
      "code" : "MF_CLIN_STUDY_SCHED",
      "display" : "MF_CLIN_STUDY_SCHED",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M07"
        }
      ]
    },
    {
      "code" : "MF_LOCATION",
      "display" : "MF_LOCATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M05"
        }
      ]
    },
    {
      "code" : "MF_LOC_DEPT",
      "display" : "MF_LOC_DEPT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M05"
        }
      ]
    },
    {
      "code" : "MF_OBS_ATTRIBUTES",
      "display" : "MF_OBS_ATTRIBUTES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M12"
        }
      ]
    },
    {
      "code" : "MF_PHASE_SCHED_DETAIL",
      "display" : "MF_PHASE_SCHED_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M06"
        }
      ]
    },
    {
      "code" : "MF_QUERY",
      "display" : "MF_QUERY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFR_M01"
        }
      ]
    },
    {
      "code" : "MF_STAFF",
      "display" : "MF_STAFF",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M02"
        }
      ]
    },
    {
      "code" : "MF_TEST",
      "display" : "MF_TEST",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M03"
        }
      ]
    },
    {
      "code" : "MF_TEST_BATTERIES",
      "display" : "MF_TEST_BATTERIES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M10"
        }
      ]
    },
    {
      "code" : "MF_TEST_BATT_DETAIL",
      "display" : "MF_TEST_BATT_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M10"
        }
      ]
    },
    {
      "code" : "MF_TEST_CALCULATED",
      "display" : "MF_TEST_CALCULATED",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M11"
        }
      ]
    },
    {
      "code" : "MF_TEST_CALC_DETAIL",
      "display" : "MF_TEST_CALC_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M11"
        }
      ]
    },
    {
      "code" : "MF_TEST_CATEGORICAL",
      "display" : "MF_TEST_CATEGORICAL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M09"
        }
      ]
    },
    {
      "code" : "MF_TEST_CAT_DETAIL",
      "display" : "MF_TEST_CAT_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M09"
        }
      ]
    },
    {
      "code" : "MF_TEST_NUMERIC",
      "display" : "MF_TEST_NUMERIC",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M08"
        }
      ]
    },
    {
      "code" : "NOTIFICATION",
      "display" : "NOTIFICATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "EAN_U09"
        }
      ]
    },
    {
      "code" : "OBRG",
      "display" : "OBR group",
      "definition" : "OBR group",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "OBSERVATION",
      "display" : "OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORF_R04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORM_O01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RCI_I05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        }
      ]
    },
    {
      "code" : "OBSERVATION_PRIOR",
      "display" : "OBSERVATION_PRIOR",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        }
      ]
    },
    {
      "code" : "OBSERVATION_REQUEST",
      "display" : "OBSERVATION_REQUEST",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        }
      ]
    },
    {
      "code" : "ORCG",
      "display" : "ORC group",
      "definition" : "ORC group",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "ORDER",
      "display" : "ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORF_R04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORG_O20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORM_O01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORN_O08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORP_O10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORR_O02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORS_O06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAR_RAR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RER_RER"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGR_RGR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ROR_ROR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRA_O18"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRD_O14"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRE_O12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRG_O16"
        }
      ]
    },
    {
      "code" : "ORDER_DETAIL",
      "display" : "ORDER_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORM_O01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORP_O10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORR_O02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        }
      ]
    },
    {
      "code" : "ORDER_DETAIL_SUPPLEMENT",
      "display" : "ORDER_DETAIL_SUPPLEMENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        }
      ]
    },
    {
      "code" : "ORDER_DIET",
      "display" : "ORDER_DIET",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORD_O04"
        }
      ]
    },
    {
      "code" : "ORDER_ENCODED",
      "display" : "ORDER_ENCODED",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        }
      ]
    },
    {
      "code" : "ORDER_GENERAL",
      "display" : "ORDER_GENERAL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        }
      ]
    },
    {
      "code" : "ORDER_OBSERVATION",
      "display" : "ORDER_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "ORDER_PRIOR",
      "display" : "ORDER_PRIOR",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        }
      ]
    },
    {
      "code" : "ORDER_TRAY",
      "display" : "ORDER_TRAY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORD_O04"
        }
      ]
    },
    {
      "code" : "PATHWAY",
      "display" : "PATHWAY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "PATHWAY_ROLE",
      "display" : "PATHWAY_ROLE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "PATIENT",
      "display" : "PATIENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A39"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A43"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORD_O04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORF_R04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORG_O20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORM_O01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORN_O08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORP_O10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORR_O02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORS_O06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAR_RAR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RER_RER"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGR_RGR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ROR_ROR"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRA_O18"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRD_O14"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRE_O12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRG_O16"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "PATIENT_PRIOR",
      "display" : "PATIENT_PRIOR",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        }
      ]
    },
    {
      "code" : "PATIENT_RESULT",
      "display" : "PATIENT_RESULT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        }
      ]
    },
    {
      "code" : "PATIENT_VISIT",
      "display" : "PATIENT_VISIT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMD_O03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMN_O07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMP_O09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMS_O05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORM_O01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAS_O17"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDE_O11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDS_O13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGV_O15"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        }
      ]
    },
    {
      "code" : "PATIENT_VISIT_PRIOR",
      "display" : "PATIENT_VISIT_PRIOR",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        }
      ]
    },
    {
      "code" : "PERSONNEL_RESOURCE",
      "display" : "PERSONNEL_RESOURCE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "PEX_CAUSE",
      "display" : "PEX_CAUSE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "PEX_OBSERVATION",
      "display" : "PEX_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "PIDG",
      "display" : "PID group",
      "definition" : "PID group",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "PRIOR_RESULT",
      "display" : "PRIOR_RESULT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OMG_O19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OML_O21"
        }
      ]
    },
    {
      "code" : "PROBLEM",
      "display" : "PROBLEM",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "PROBLEM_OBSERVATION",
      "display" : "PROBLEM_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "PROBLEM_PATHWAY",
      "display" : "PROBLEM_PATHWAY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        }
      ]
    },
    {
      "code" : "PROBLEM_ROLE",
      "display" : "PROBLEM_ROLE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "PROCEDURE",
      "display" : "PROCEDURE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADR_A19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        }
      ]
    },
    {
      "code" : "PRODUCT",
      "display" : "PRODUCT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SUR_P09"
        }
      ]
    },
    {
      "code" : "PROVIDER",
      "display" : "PROVIDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RCI_I05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RCL_I06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPI_I04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPL_I02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPR_I03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQC_I05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQI_I01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQP_I04"
        }
      ]
    },
    {
      "code" : "PROVIDER_CONTACT",
      "display" : "PROVIDER_CONTACT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        }
      ]
    },
    {
      "code" : "QBP",
      "display" : "QBP",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QBP_Q13"
        }
      ]
    },
    {
      "code" : "QRY_WITH_DETAIL",
      "display" : "QRY_WITH_DETAIL",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NMQ_N01"
        }
      ]
    },
    {
      "code" : "QUERY_RESPONSE",
      "display" : "QUERY_RESPONSE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADR_A19"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z86"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        }
      ]
    },
    {
      "code" : "RESOURCES",
      "display" : "RESOURCES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "RESPONSE",
      "display" : "RESPONSE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORD_O04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORF_R04"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORG_O20"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORL_O22"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORN_O08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORP_O10"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORR_O02"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORS_O06"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRA_O18"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRD_O14"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRE_O12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRG_O16"
        }
      ]
    },
    {
      "code" : "RESULTS",
      "display" : "RESULTS",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RCI_I05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        }
      ]
    },
    {
      "code" : "RESULTS_NOTES",
      "display" : "RESULTS_NOTES",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RRI_I12"
        }
      ]
    },
    {
      "code" : "ROW_DEFINITION",
      "display" : "ROW_DEFINITION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QBP_K13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RTB_K13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RTB_Q13"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RTB_Z74"
        }
      ]
    },
    {
      "code" : "RXAG",
      "display" : "RXA group",
      "definition" : "RXA group",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RXDG",
      "display" : "RXD group",
      "definition" : "RXD group",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RXEG",
      "display" : "RXE group",
      "definition" : "RXE group",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RXOG",
      "display" : "RXO group",
      "definition" : "RXO group",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        }
      ]
    },
    {
      "code" : "RX_ADMIN",
      "display" : "RX_ADMIN",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "RX_ADMINISTRATION",
      "display" : "RX_ADMINISTRATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "RX_ORDER",
      "display" : "RX_ORDER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "SCHEDULE",
      "display" : "SCHEDULE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "SERVICE",
      "display" : "SERVICE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRR_S01"
        }
      ]
    },
    {
      "code" : "SPECIMEN_CONTAINER",
      "display" : "SPECIMEN_CONTAINER",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SSU_U03"
        }
      ]
    },
    {
      "code" : "STAFF",
      "display" : "STAFF",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_K25"
        }
      ]
    },
    {
      "code" : "STUDY",
      "display" : "STUDY",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "STUDY_OBSERVATION",
      "display" : "STUDY_OBSERVATION",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "STUDY_PHARM",
      "display" : "STUDY_PHARM",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "STUDY_PHASE",
      "display" : "STUDY_PHASE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "STUDY_SCHEDULE",
      "display" : "STUDY_SCHEDULE",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "TREATMENT",
      "display" : "TREATMENT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        }
      ]
    },
    {
      "code" : "VISIT",
      "display" : "VISIT",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "new"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2024-01-12"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.4"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P05"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P11"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OUL_R21"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RPA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z82"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z88"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RSP_Z90"
        }
      ]
    }
  ]
}

```
