# Revenue code (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Revenue code (2.4 - 1.0.0)**

## CodeSystem: Revenue code (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/nubc-ServiceLineRevenue-cs | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:Nubc-ServiceLineRevenue-cs |
| *Other Identifiers:*OID:2.16.840.1.113883.6.301.3 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying a revenue code as specified in the . National Uniform Billing Committee (NUBC) UB-04 manual, UB form locator 42, the service line revenue code. These are claim codes indicating the identifying number for the product or service provided. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the Revenue Code (GP1) value. Updated by NUBC annually; see the coding instructions for more detail. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSrevenueCode](ValueSet-hl7VSrevenueCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "nubc-ServiceLineRevenue-cs",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0456"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/nubc-ServiceLineRevenue-cs",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.6.301.3"
    }
  ],
  "version" : "1.0.0",
  "name" : "Nubc-ServiceLineRevenue-cs",
  "title" : "Revenue code (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying a revenue code as specified in the . National Uniform Billing Committee (NUBC) UB-04 manual, UB form locator 42, the service line revenue code.  These are claim codes indicating the identifying number for the product or service provided. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html.  Used in HL7 Version 2.x messaging in the Revenue Code (GP1) value. Updated by NUBC annually; see the coding instructions for more detail.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "260",
      "display" : "IV Therapy",
      "definition" : "IV Therapy"
    },
    {
      "code" : "280",
      "display" : "Oncology",
      "definition" : "Oncology"
    },
    {
      "code" : "301",
      "display" : "Lab/Chemistry",
      "definition" : "Lab/Chemistry"
    },
    {
      "code" : "991",
      "display" : "Cafeteria /Guest Tray",
      "definition" : "Cafeteria /Guest Tray"
    },
    {
      "code" : "993",
      "display" : "Telephone/Telegraph",
      "definition" : "Telephone/Telegraph"
    },
    {
      "code" : "994",
      "display" : "TV/Radio",
      "definition" : "TV/Radio"
    }
  ]
}

```
