# Manufacturers of Vaccines (code=MVX) (2.4 - 1.1.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Manufacturers of Vaccines (code=MVX) (2.4 - 1.1.0)**

## CodeSystem: Manufacturers of Vaccines (code=MVX) (2.4 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/manufacturersOfVaccinesHL7 | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:ManufacturersOfVaccinesHL7 |
| *Other Identifiers:*OID:2.16.840.1.113883.18.127 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control. Used in HL7 Version 2.x messaging in the RXA, RXD and RXG segments. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmanufacturersOfVaccines](ValueSet-hl7VSmanufacturersOfVaccines.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "manufacturersOfVaccinesHL7",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0227"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/manufacturersOfVaccinesHL7",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.127"
    }
  ],
  "version" : "1.1.0",
  "name" : "ManufacturersOfVaccinesHL7",
  "title" : "Manufacturers of Vaccines (code=MVX) (2.4 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control.  Used in HL7 Version 2.x messaging in the RXA, RXD and RXG segments.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AB",
      "display" : "Abbott Laboratories",
      "definition" : "Abbott Laboratories",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-31"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AD",
      "display" : "Adams Laboratories",
      "definition" : "Adams Laboratories",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ALP",
      "display" : "Alpha Therapeutic Corporation",
      "definition" : "Alpha Therapeutic Corporation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AR",
      "display" : "Armour",
      "definition" : "Armour",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Inactive-use CEN"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AVI",
      "display" : "Aviron",
      "definition" : "Aviron",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BA",
      "display" : "Baxter Healthcare Corporation",
      "definition" : "Baxter Healthcare Corporation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BAY",
      "display" : "Bayer Corporation",
      "definition" : "Bayer Corporation",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "includes Miles, Inc. and Cutter Laboratories"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-31"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BP",
      "display" : "Berna Products",
      "definition" : "Berna Products",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "use BPC"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-31"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BPC",
      "display" : "Berna Products Corporation",
      "definition" : "Berna Products Corporation",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "includes Swiss Serum and Vaccine Institute Berna"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-31"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "CEN",
      "display" : "Centeon L.L.C.",
      "definition" : "Centeon L.L.C.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "includes Armour Pharmaceutical Company"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-31"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "CHI",
      "display" : "Chiron Corporation",
      "definition" : "Chiron Corporation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "CON",
      "display" : "Connaught",
      "definition" : "Connaught [Inactive-use PMC]",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "[Inactive-use PMC"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "EVN",
      "display" : "Evans Medical Limited",
      "definition" : "Evans Medical Limited",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "an affiliate of Medeva Pharmaceuticals, Inc."
        },
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-31"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "GRE",
      "display" : "Greer Laboratories, Inc.",
      "definition" : "Greer Laboratories, Inc.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "IAG",
      "display" : "Immuno International AG",
      "definition" : "Immuno International AG",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "IM",
      "display" : "Merieux [Inactive-use PMC]",
      "definition" : "Merieux [Inactive-use PMC]",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "IUS",
      "display" : "Immuno-U.S., Inc.",
      "definition" : "Immuno-U.S., Inc.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "JPN",
      "display" : "The Research Foundation for Microbial Diseases of Osaka University (BIKEN)",
      "definition" : "The Research Foundation for Microbial Diseases of Osaka University (BIKEN)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "KGC",
      "display" : "Korea Green Cross Corporation",
      "definition" : "Korea Green Cross Corporation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LED",
      "display" : "Lederle",
      "definition" : "Lederle",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "use WAL"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MA",
      "display" : "Massachusetts Public Health Biologic Laboratories",
      "definition" : "Massachusetts Public Health Biologic Laboratories",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MED",
      "display" : "MedImmune, Inc.",
      "definition" : "MedImmune, Inc.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MIL",
      "display" : "Miles",
      "definition" : "Miles",
      "property" : [
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MIP",
      "display" : "Bioport Corporation (formerly Michigan Biologic Products Institute)",
      "definition" : "Bioport Corporation (formerly Michigan Biologic Products Institute)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "MSD",
      "display" : "Merck & Co., Inc.",
      "definition" : "Merck & Co., Inc.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NAB",
      "display" : "NABI (formerly North American Biologicals, Inc.)",
      "definition" : "NABI (formerly North American Biologicals, Inc.)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NAV",
      "display" : "North American Vaccine, Inc.",
      "definition" : "North American Vaccine, Inc.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "NOV",
      "display" : "Novartis Pharmaceutical Corporation (includes Ciba-Geigy Limited and Sandoz Limited)",
      "definition" : "Novartis Pharmaceutical Corporation (includes Ciba-Geigy Limited and Sandoz Limited)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "NYB",
      "display" : "New York Blood Center",
      "definition" : "New York Blood Center",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ORT",
      "display" : "Ortho Diagnostic Systems, Inc.",
      "definition" : "Ortho Diagnostic Systems, Inc.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "OTC",
      "display" : "Organon Teknika Corporation",
      "definition" : "Organon Teknika Corporation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OTH",
      "display" : "Other manufacturer",
      "definition" : "Other manufacturer",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PD",
      "display" : "Parkedale Pharmaceuticals (formerly Parke-Davis)",
      "definition" : "Parkedale Pharmaceuticals (formerly Parke-Davis)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PMC",
      "display" : "Aventis Pasteur Inc. (formerly Pasteur Merieux Connaught; includes Connaught Laboratories and Pasteur Merieux)",
      "definition" : "Aventis Pasteur Inc. (formerly Pasteur Merieux Connaught; includes Connaught Laboratories and Pasteur Merieux)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "PRX",
      "display" : "Praxis Biologics [Inactive-use WAL]",
      "definition" : "Praxis Biologics [Inactive-use WAL]",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SCL",
      "display" : "Sclavo, Inc.",
      "definition" : "Sclavo, Inc.",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SI",
      "display" : "Swiss Serum and Vaccine Inst. [Inactive-use BPC]",
      "definition" : "Swiss Serum and Vaccine Inst. [Inactive-use BPC]",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SKB",
      "display" : "SmithKline Beecham",
      "definition" : "SmithKline Beecham",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "UNK",
      "display" : "Unknown manufacturer",
      "definition" : "Unknown manufacturer",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "USA",
      "display" : "United States Army Medical Research and Materiel Command",
      "definition" : "United States Army Medical Research and Materiel Command",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "WA",
      "display" : "Wyeth-Ayerst [Inactive-use WAL]",
      "definition" : "Wyeth-Ayerst [Inactive-use WAL]",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "WAL",
      "display" : "Wyeth-Ayerst (includes Wyeth-Lederle Vaccines and Pediatrics, Wyeth Laboratories, Lederle Laboratories, and Praxis Biologics)",
      "definition" : "Wyeth-Ayerst (includes Wyeth-Lederle Vaccines and Pediatrics, Wyeth Laboratories, Lederle Laboratories, and Praxis Biologics)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
