# Alternate Character Set Handling Scheme (2.4 - 1.0.0) - HL7 v2.4 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alternate Character Set Handling Scheme (2.4 - 1.0.0)**

## CodeSystem: Alternate Character Set Handling Scheme (2.4 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/alternateCharacterSetHandlingScheme | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:AlternateCharacterSetHandlingScheme |
| *Other Identifiers:*OID:2.16.840.1.113883.18.216 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concept that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed. Used in HL7 Version 2.x messaging in the MSH segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSalternateCharacterSetHandlingScheme](ValueSet-hl7VSalternateCharacterSetHandlingScheme.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "alternateCharacterSetHandlingScheme",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.4"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0356"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/alternateCharacterSetHandlingScheme",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.216"
    }
  ],
  "version" : "1.0.0",
  "name" : "AlternateCharacterSetHandlingScheme",
  "title" : "Alternate Character Set Handling Scheme (2.4 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:23:17+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concept that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed.  Used in HL7 Version 2.x messaging in the MSH segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "2.3",
      "display" : "The character set switching mode specified in HL7 2.3",
      "definition" : "The character set switching mode specified in HL7 2.3, sections 2.8.28.6.1, and 2.9.2.  Note that the escape sequences used in this mode do not use the ASCII \"esc\" character. They are \"HL7 escape sequences\" as defined in HL7 2.3, sec.  2.9 as defined in I",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "Note that the escape sequences used in this mode are \"HL7 escapes sequences\" as defined in HL7 2.3, sec.  2.9, and do not use the ASCII \"esc\" character, as defined in ISO 2022-1994"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ISO 2022-1994",
      "display" : "This standard is titled \"Information Technology - Character Code Structure and Extension Technique\".",
      "definition" : "This standard is titled \"Information Technology - Character Code Structure and Extension Technique\". This standard specifies an escape sequence from basic one byte character set to specified other character set, and vice versa.",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "This standard specifies an escape sequence from basic one byte character set to specified other character set, and vice versa.  The escape sequence explicitly specifies what alternate character set to be evoked. Note that in this mode, the actual ASCII escape character is used as defined in the referenced ISO document. As noted in 1.6.1., escape sequences to/from alternate character set should occur within HL7 delimiters. In other words, HL7 delimiters are basic one byte characters only, and just before and just after delimiters, character encoding status should be the basic one byte set.  This value is allowed only for HL7 v. 2.3.1."
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
