# Type of Referenced Data (2.3.1 - 1.2.0) - HL7 v2.3.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Type of Referenced Data (2.3.1 - 1.2.0)**

## CodeSystem: Type of Referenced Data (2.3.1 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/typeOfReferencedData | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:TypeOfReferencedData |
| *Other Identifiers:*OID:2.16.840.1.113883.18.102 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts declaring the general type of media data that is encoded. Used in v2.5.1 interfaces and earlier, and replaced with the full set of IANA media types as a standard coding system for this after HL7 version 2.6 (see value set 2.16.840.1.113883.21.425 hl7VS-mimeTypes for HL7 table 0834 built on MIME types). More information may be found at http://www.iana.org/assignments/media-types/media-types.xhtml 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VStypeOfData](ValueSet-hl7VStypeOfData.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "typeOfReferencedData",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0191"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/typeOfReferencedData",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.102"
    }
  ],
  "version" : "1.2.0",
  "name" : "TypeOfReferencedData",
  "title" : "Type of Referenced Data (2.3.1 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:22:40+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts declaring the general type of media data that is encoded.  Used in v2.5.1 interfaces and earlier, and replaced with the full set of IANA media types as a standard coding system for this after HL7 version 2.6 (see value set 2.16.840.1.113883.21.425 hl7VS-mimeTypes for HL7 table 0834 built on MIME types).  More information may be found at http://www.iana.org/assignments/media-types/media-types.xhtml",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AP",
      "display" : "Other application data, typically uninterpreted binary data",
      "definition" : "Other application data, typically uninterpreted binary data",
      "property" : [
        {
          "code" : "comment",
          "valueString" : "HL7 V2.3 and later"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "AU",
      "display" : "Audio Data",
      "definition" : "Audio Data",
      "designation" : [
        {
          "language" : "de",
          "value" : "Audio-Daten"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "new with HL7 v 2.3"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "FT",
      "display" : "Formatted Text",
      "definition" : "Formatted Text",
      "designation" : [
        {
          "language" : "de",
          "value" : "Formatierter Text"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "HL7 V2.2 only"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IM",
      "display" : "Image Data",
      "definition" : "Image Data",
      "designation" : [
        {
          "language" : "de",
          "value" : "Bilddaten"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "new  with HL7 v 2.3"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "NS",
      "display" : "Non-scanned Image",
      "definition" : "Non-scanned Image",
      "designation" : [
        {
          "language" : "de",
          "value" : "Nicht über Scanner erzeugtes Bild"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "HL7 V2.2 only"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SD",
      "display" : "Scanned document",
      "definition" : "Scanned document",
      "designation" : [
        {
          "language" : "de",
          "value" : "Über Scanner eingelesenes Dokument"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "HL7 V2.2 only"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SI",
      "display" : "Scanned Image",
      "definition" : "Scanned Image",
      "designation" : [
        {
          "language" : "de",
          "value" : "Über Scanner eingelesenes Bild"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "HL7 V2.2 only"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "TEXT",
      "display" : "Machine readable text document",
      "definition" : "Machine readable text document",
      "designation" : [
        {
          "language" : "de",
          "value" : "maschinenlesbares Dokument"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "HL7 V2.3.1 and later"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "TX",
      "display" : "Machine Readable Text Document",
      "definition" : "Machine Readable Text Document",
      "designation" : [
        {
          "language" : "de",
          "value" : "Maschinenlesbarer Text"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "HL7 V2.2 only"
        },
        {
          "code" : "status",
          "valueCode" : "inactive"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
