# Query Results Level (2.3.1 - 1.0.2) - HL7 v2.3.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Query Results Level (2.3.1 - 1.0.2)**

## CodeSystem: Query Results Level (2.3.1 - 1.0.2) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/queryResultsLevel | *Version*:1.0.2 |
| Active as of 2026-01-27 | *Computable Name*:QueryResultsLevel |
| *Other Identifiers:*OID:2.16.840.1.113883.18.45 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which are used to control level of detail in query results. Used in HL7 Version 2 messaging in the URD segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSqueryResultsLevel](ValueSet-hl7VSqueryResultsLevel.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "queryResultsLevel",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0108"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/queryResultsLevel",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.45"
    }
  ],
  "version" : "1.0.2",
  "name" : "QueryResultsLevel",
  "title" : "Query Results Level (2.3.1 - 1.0.2)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:22:40+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which are used to control level of detail in query results.   Used in HL7 Version 2 messaging in the URD segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "O",
      "display" : "Order plus order status",
      "definition" : "Order plus order status",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag und Auftragsstatus"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "R",
      "display" : "Results without bulk text",
      "definition" : "Results without bulk text",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ergebnisse / Befunde ohne umfänglichen Text"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Status only",
      "definition" : "Status only",
      "designation" : [
        {
          "language" : "de",
          "value" : "nur Statusinformation"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "T",
      "display" : "Full results",
      "definition" : "Full results",
      "designation" : [
        {
          "language" : "de",
          "value" : "Komplette Ergebnisse / Befunde"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
