# Document Type (2.3.1 - 1.0.0) - HL7 v2.3.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Document Type (2.3.1 - 1.0.0)**

## CodeSystem: Document Type (2.3.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/documentType | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:DocumentType |
| *Other Identifiers:*OID:2.16.840.1.113883.18.163 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts used to identify the kind of patient document. Used in HL7 Version 2.x messaging in the TXA segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSreportTypeCode](ValueSet-hl7VSreportTypeCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "documentType",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0270"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/documentType",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.163"
    }
  ],
  "version" : "1.0.0",
  "name" : "DocumentType",
  "title" : "Document Type (2.3.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:22:40+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts used to identify the kind of patient document.  Used in HL7 Version 2.x messaging in the TXA segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AR",
      "display" : "Autopsy report",
      "definition" : "Autopsy report",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CD",
      "display" : "Cardiodiagnostics",
      "definition" : "Cardiodiagnostics",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CN",
      "display" : "Consultation",
      "definition" : "Consultation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DI",
      "display" : "Diagnostic imaging",
      "definition" : "Diagnostic imaging",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DS",
      "display" : "Discharge summary",
      "definition" : "Discharge summary",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "ED",
      "display" : "Emergency department report",
      "definition" : "Emergency department report",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "HP",
      "display" : "History and physical examination",
      "definition" : "History and physical examination",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OP",
      "display" : "Operative report",
      "definition" : "Operative report",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PC",
      "display" : "Psychiatric consultation",
      "definition" : "Psychiatric consultation",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PH",
      "display" : "Psychiatric history and physical examination",
      "definition" : "Psychiatric history and physical examination",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PN",
      "display" : "Procedure note",
      "definition" : "Procedure note",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PR",
      "display" : "Progress note",
      "definition" : "Progress note",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "SP",
      "display" : "Surgical pathology",
      "definition" : "Surgical pathology",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TS",
      "display" : "Transfer summary",
      "definition" : "Transfer summary",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
