# Degree/license/certificate (2.3.1 - 1.0.0) - HL7 v2.3.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Degree/license/certificate (2.3.1 - 1.0.0)**

## CodeSystem: Degree/license/certificate (2.3.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/degreeLicenseCertificate | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:DegreeLicenseCertificate |
| *Other Identifiers:*OID:2.16.840.1.113883.18.219 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging. Used in Version 2 messaging; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSdegree](ValueSet-hl7VSdegree.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "degreeLicenseCertificate",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0360"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/degreeLicenseCertificate",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.219"
    }
  ],
  "version" : "1.0.0",
  "name" : "DegreeLicenseCertificate",
  "title" : "Degree/license/certificate (2.3.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:22:40+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying an educational degree (e.g., MD).  Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging.  Used in Version 2 messaging; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "AA",
      "display" : "Associate of Arts",
      "definition" : "Associate of Arts",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "AAS",
      "display" : "Associate of Applied Science",
      "definition" : "Associate of Applied Science",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ABA",
      "display" : "Associate of Business Administration",
      "definition" : "Associate of Business Administration",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "AE",
      "display" : "Associate of Engineering",
      "definition" : "Associate of Engineering",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "AS",
      "display" : "Associate of Science",
      "definition" : "Associate of Science",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BA",
      "display" : "Bachelor of Arts",
      "definition" : "Bachelor of Arts",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BBA",
      "display" : "Bachelor of Business Administration",
      "definition" : "Bachelor of Business Administration",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BE",
      "display" : "Bachelor or Engineering",
      "definition" : "Bachelor or Engineering",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BFA",
      "display" : "Bachelor of Fine Arts",
      "definition" : "Bachelor of Fine Arts",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BN",
      "display" : "Bachelor of Nursing",
      "definition" : "Bachelor of Nursing",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BS",
      "display" : "Bachelor of Science",
      "definition" : "Bachelor of Science",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BSL",
      "display" : "Bachelor of Science – Law",
      "definition" : "Bachelor of Science – Law",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "BT",
      "display" : "Bachelor of Theology",
      "definition" : "Bachelor of Theology",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "CER",
      "display" : "Certificate",
      "definition" : "Certificate",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "DBA",
      "display" : "Doctor of Business Administration",
      "definition" : "Doctor of Business Administration",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "DED",
      "display" : "Doctor of Education",
      "definition" : "Doctor of Education",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "DIP",
      "display" : "Diploma",
      "definition" : "Diploma",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "DO",
      "display" : "Doctor of Osteopathy",
      "definition" : "Doctor of Osteopathy",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "HS",
      "display" : "High School Graduate",
      "definition" : "High School Graduate",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "JD",
      "display" : "Juris Doctor",
      "definition" : "Juris Doctor",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MA",
      "display" : "Master of Arts",
      "definition" : "Master of Arts",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MBA",
      "display" : "Master of Business Administration",
      "definition" : "Master of Business Administration",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MCE",
      "display" : "Master of Civil Engineering",
      "definition" : "Master of Civil Engineering",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MD",
      "display" : "Doctor of Medicine",
      "definition" : "Doctor of Medicine",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MDI",
      "display" : "Master of Divinity",
      "definition" : "Master of Divinity",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ME",
      "display" : "Master of Engineering",
      "definition" : "Master of Engineering",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MED",
      "display" : "Master of Education",
      "definition" : "Master of Education",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MEE",
      "display" : "Master of Electrical Engineering",
      "definition" : "Master of Electrical Engineering",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MFA",
      "display" : "Master of Fine Arts",
      "definition" : "Master of Fine Arts",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MME",
      "display" : "Master of Mechanical Engineering",
      "definition" : "Master of Mechanical Engineering",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MS",
      "display" : "Master of Science",
      "definition" : "Master of Science",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MSL",
      "display" : "Master of Science – Law",
      "definition" : "Master of Science – Law",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MT",
      "display" : "Master of Theology",
      "definition" : "Master of Theology",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "NG",
      "display" : "Non-Graduate",
      "definition" : "Non-Graduate",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "PHD",
      "display" : "Doctor of Philosophy",
      "definition" : "Doctor of Philosophy",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "PHE",
      "display" : "Doctor of Engineering",
      "definition" : "Doctor of Engineering",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "PHS",
      "display" : "Doctor of Science",
      "definition" : "Doctor of Science",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "SEC",
      "display" : "Secretarial Certificate",
      "definition" : "Secretarial Certificate",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "TS",
      "display" : "Trade School Graduate",
      "definition" : "Trade School Graduate",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    }
  ]
}

```
