# Administration Method (2.3.1 - 1.0.0) - HL7 v2.3.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Administration Method (2.3.1 - 1.0.0)**

## CodeSystem: Administration Method (2.3.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/administrationMethod | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:AdministrationMethod |
| *Other Identifiers:*OID:2.16.840.1.113883.18.83 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts which specify the specific method requested for the administration of the drug or treatment to the patient. Used in HL7 Version 2.x messaging in the RXR segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSadministrationMethod](ValueSet-hl7VSadministrationMethod.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "administrationMethod",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0165"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/administrationMethod",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.83"
    }
  ],
  "version" : "1.0.0",
  "name" : "AdministrationMethod",
  "title" : "Administration Method (2.3.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:22:40+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts  which specify the specific method requested for the administration of the drug or treatment to the patient.  Used in HL7 Version 2.x messaging in the RXR segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CH",
      "display" : "Chew",
      "definition" : "Chew",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "DI",
      "display" : "Dissolve",
      "definition" : "Dissolve",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "DU",
      "display" : "Dust",
      "definition" : "Dust",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IF",
      "display" : "Infiltrate",
      "definition" : "Infiltrate",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IR",
      "display" : "Irrigate",
      "definition" : "Irrigate",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IS",
      "display" : "Insert",
      "definition" : "Insert",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IVP",
      "display" : "IV Push",
      "definition" : "IV Push",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "IVPB",
      "display" : "IV Piggyback",
      "definition" : "IV Piggyback",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "NB",
      "display" : "Nebulized",
      "definition" : "Nebulized",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "PF",
      "display" : "Perfuse",
      "definition" : "Perfuse",
      "designation" : [
        {
          "language" : "de",
          "value" : "Perfundieren"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "PT",
      "display" : "Paint",
      "definition" : "Pain",
      "designation" : [
        {
          "language" : "de",
          "value" : "Schmerz"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-07-30"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SH",
      "display" : "Shampoo",
      "definition" : "Shampoo",
      "designation" : [
        {
          "language" : "de",
          "value" : "Shampoo"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SO",
      "display" : "Soak",
      "definition" : "Soak",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "WA",
      "display" : "Wash",
      "definition" : "Wash",
      "designation" : [
        {
          "language" : "de",
          "value" : "Waschen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "WI",
      "display" : "Wipe",
      "definition" : "Wipe",
      "designation" : [
        {
          "language" : "de",
          "value" : "Wischen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
