# hl7.v2.uv.terminology.v231#0.1.0: HL7 v2.3.1 Vocabulary

## Pages

* [Homepage](index.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](download.md)

## Resources

### CodeSystems

* [Accept/Application Acknowledgment Conditions (2.3.1 - 1.0.0)](CodeSystem-accept-applicationAcknowledgmentConditions.md)
* [Acknowledgment Code (2.3.1 - 1.2.0)](CodeSystem-acknowledgmentCodes.md)
* [Action Code (2.3.1 - 1.0.0)](CodeSystem-actionCodes.md)
* [Action Taken in Response to the Event (2.3.1 - 1.0.0)](CodeSystem-actionTakenInResponseToTheEvent.md)
* [Active/Inactive (2.3.1 - 1.0.0)](CodeSystem-active-inactive.md)
* [Address Type (2.3.1 - 1.2.0)](CodeSystem-addressType.md)
* [Administration Device (2.3.1 - 1.0.0)](CodeSystem-administrationDevice.md)
* [Administration Method (2.3.1 - 1.0.0)](CodeSystem-administrationMethod.md)
* [Admission Type (2.3.1 - 1.0.0)](CodeSystem-admissionType.md)
* [Admit Source (2.3.1 - 1.0.0)](CodeSystem-admitSource.md)
* [Advanced Beneficiary Notice Code (2.3.1 - 1.0.0)](CodeSystem-advancedBeneficiaryNotice.md)
* [Allergy Type (2.3.1 - 1.0.0)](CodeSystem-allergenType.md)
* [Allergy Severity (2.3.1 - 1.0.0)](CodeSystem-allergySeverity.md)
* [Allow Substitution Codes (2.3.1 - 1.1.0)](CodeSystem-allowSubstitution.md)
* [Alternate Character Set Handling Scheme (2.3.1 - 1.0.0)](CodeSystem-alternateCharacterSetHandlingScheme.md)
* [Alternate Character Sets (2.3.1 - 1.1.0)](CodeSystem-alternateCharacterSets.md)
* [Ambulatory Status (2.3.1 - 1.0.0)](CodeSystem-ambulatoryStatus.md)
* [Amount Class (2.3.1 - 1.0.0)](CodeSystem-amountClass.md)
* [Amount Type (2.3.1 - 1.0.0)](CodeSystem-amountType.md)
* [Annotations (2.3.1 - 1.0.0)](CodeSystem-annotations.md)
* [Appointment Reason Codes (2.3.1 - 1.0.0)](CodeSystem-appointmentReason.md)
* [Appointment Type Codes (2.3.1 - 1.0.0)](CodeSystem-appointmentType.md)
* [PSRO/UR Approval Indicator (2.3.1 - 1.0.0)](CodeSystem-approvalIndicator.md)
* [Assignment of Benefits (2.3.1 - 1.0.0)](CodeSystem-assignmentOfBenefits.md)
* [Bed Status (2.3.1 - 1.1.0)](CodeSystem-bedStatus.md)
* [Administrative Site (2.3.1 - 1.1.0)](CodeSystem-bodySite.md)
* [Causality Observations (2.3.1 - 1.0.0)](CodeSystem-causalityObservations.md)
* [Certification Patient Type (2.3.1 - 1.0.0)](CodeSystem-certificationPatientType.md)
* [Certification Status (2.3.1 - 1.0.0)](CodeSystem-certificationStatus.md)
* [Charge On Indicator (2.3.1 - 1.0.0)](CodeSystem-chargeOnIndicator.md)
* [Charge Type (2.3.1 - 1.0.0)](CodeSystem-chargeType.md)
* [Check Digit Scheme (2.3.1 - 1.2.0)](CodeSystem-checkDigitScheme.md)
* [Comment Type (2.3.1 - 1.0.0)](CodeSystem-commentType.md)
* [Completion Status (2.3.1 - 1.0.0)](CodeSystem-completionStatus.md)
* [Condition Code (2.3.1 - 1.0.0)](CodeSystem-conditionCodes.md)
* [Confidentiality Code (2.3.1 - 1.0.0)](CodeSystem-confidentialityCodes.md)
* [Coordination of Benefits (2.3.1 - 1.0.0)](CodeSystem-coordinationOfBenefits.md)
* [Coverage Type (2.3.1 - 1.0.0)](CodeSystem-coverageType.md)
* [CP Range Type (2.3.1 - 1.0.0)](CodeSystem-cpRangeType.md)
* [CWE statuses (2.3.1 - 1.0.0)](CodeSystem-cweStatuses.md)
* [Date/Time Selection Qualifier (2.3.1 - 1.0.0)](CodeSystem-date-timeSelectionQualifier.md)
* [Day Type (2.3.1 - 1.0.0)](CodeSystem-dayType.md)
* [Days of the Week (2.3.1 - 1.0.0)](CodeSystem-daysOfTheWeek.md)
* [Deferred Response Type (2.3.1 - 1.0.0)](CodeSystem-deferredResponseType.md)
* [Degree/license/certificate (2.3.1 - 1.0.0)](CodeSystem-degreeLicenseCertificate.md)
* [Delayed Acknowledgement Type (2.3.1 - 1.1.0)](CodeSystem-delayedAcknowledgmentType.md)
* [Derived Specimen (2.3.1 - 1.0.0)](CodeSystem-derivedSpecimen.md)
* [Diagnosis Classification (2.3.1 - 1.0.0)](CodeSystem-diagnosisClassification.md)
* [Diagnosis Priority (2.3.1 - 1.0.0)](CodeSystem-diagnosisPriority.md)
* [Diagnosis Type (2.3.1 - 1.0.0)](CodeSystem-diagnosisType.md)
* [Diagnostic Service Section ID (2.3.1 - 1.2.0)](CodeSystem-diagnosticServiceSectionId.md)
* [Diet Code Specification Type (2.3.1 - 1.0.0)](CodeSystem-dietCodeSpecificationType.md)
* [Disabled Person Code (2.3.1 - 1.0.0)](CodeSystem-disabilityInformationRelationship.md)
* [Discharge Disposition (2.3.1 - 1.0.0)](CodeSystem-dischargeDisposition.md)
* [Dispense Method (2.3.1 - 1.0.0)](CodeSystem-dispenseMethod.md)
* [Document Availability Status (2.3.1 - 1.1.0)](CodeSystem-documentAvailabilityStatus.md)
* [Document Completion Status (2.3.1 - 1.0.0)](CodeSystem-documentCompletionStatus.md)
* [Document Confidentiality Status (2.3.1 - 2.0.0)](CodeSystem-documentConfidentialityStatus2.md)
* [Document Storage Status (2.3.1 - 1.0.0)](CodeSystem-documentStorageStatus.md)
* [Document Type (2.3.1 - 1.0.0)](CodeSystem-documentType.md)
* [DRG Payor (2.3.1 - 1.0.0)](CodeSystem-drgPayor.md)
* [Duration Categories (2.3.1 - 1.0.1)](CodeSystem-durationCategories.md)
* [Eligibility Source (2.3.1 - 1.0.0)](CodeSystem-eligibilitySource.md)
* [Encoding (2.3.1 - 1.0.0)](CodeSystem-encoding.md)
* [Escort Required (2.3.1 - 1.0.0)](CodeSystem-escortRequired.md)
* [Event (2.3.1 - 1.3.0)](CodeSystem-event.md)
* [Event Consequence (2.3.1 - 1.0.0)](CodeSystem-eventConsequence.md)
* [Event Expected (2.3.1 - 1.0.0)](CodeSystem-eventExpected.md)
* [Event Qualification (2.3.1 - 1.0.0)](CodeSystem-eventQualification.md)
* [Event Reason (2.3.1 - 1.1.0)](CodeSystem-eventReason.md)
* [Event Reported To (2.3.1 - 1.0.0)](CodeSystem-eventReportedTo.md)
* [Event Seriousness (2.3.1 - 1.0.0)](CodeSystem-eventSeriousness.md)
* [Yes/No Indicator (2.3.1 - 1.0.0)](CodeSystem-expandedYes-NoIndicator.md)
* [Facility Type (2.3.1 - 1.0.0)](CodeSystem-facilityType.md)
* [File Level Event Code (2.3.1 - 1.0.0)](CodeSystem-file-levelEvent.md)
* [Filler Status Codes (2.3.1 - 1.1.0)](CodeSystem-fillerStatus.md)
* [Identifier Type (2.3.1 - 1.1.0)](CodeSystem-identifierType.md)
* [Identity May Be Divulged (2.3.1 - 1.0.0)](CodeSystem-identityMayBeDivulged.md)
* [Indirect Exposure Mechanism (2.3.1 - 1.0.0)](CodeSystem-indirectExposureMechanism.md)
* [Invocation Event (2.3.1 - 1.0.0)](CodeSystem-invocationEvent.md)
* [Kind of Quantity (2.3.1 - 1.0.0)](CodeSystem-kindOfQuantity.md)
* [Level of Care (2.3.1 - 1.0.0)](CodeSystem-levelOfCare.md)
* [Living Arrangement (2.3.1 - 1.1.0)](CodeSystem-livingArrangement.md)
* [Living Dependency (2.3.1 - 1.0.0)](CodeSystem-livingDependency.md)
* [Living Will Code (2.3.1 - 1.0.0)](CodeSystem-livingWillCodes.md)
* [Location Characteristic ID (2.3.1 - 1.0.0)](CodeSystem-locationCharacteristic.md)
* [Location Equipment (2.3.1 - 1.0.0)](CodeSystem-locationEquipment.md)
* [Location Relationship ID (2.3.1 - 1.0.0)](CodeSystem-locationRelationship.md)
* [Mail Claim Party (2.3.1 - 1.0.0)](CodeSystem-mailClaimParty.md)
* [Manufacturers of Vaccines (code=MVX) (2.3.1 - 1.1.0)](CodeSystem-manufacturersOfVaccinesHL7.md)
* [Marital Status (2.3.1 - 1.0.0)](CodeSystem-maritalStatus.md)
* [Marketing Basis (2.3.1 - 1.0.0)](CodeSystem-marketingBasis.md)
* [Master File Identifier Code (2.3.1 - 1.0.0)](CodeSystem-masterFileIdentifierCodes.md)
* [Record-level Event Code (2.3.1 - 1.0.0)](CodeSystem-masterfileActionCode.md)
* [Message Error Condition Codes (2.3.1 - 1.0.0)](CodeSystem-messageErrorCondition.md)
* [Message Structure (2.3.1 - 1.0.0)](CodeSystem-messageStructure.md)
* [Message Type (2.3.1 - 1.3.0)](CodeSystem-messageType.md)
* [MFN Record-level Error Return (2.3.1 - 1.0.0)](CodeSystem-mfnRecord-levelErrorReturn.md)
* [Military Rank/Grade (2.3.1 - 1.0.0)](CodeSystem-militaryRank-Grade.md)
* [Military Service (2.3.1 - 1.0.0)](CodeSystem-militaryService.md)
* [Military Status (2.3.1 - 1.0.0)](CodeSystem-militaryStatus.md)
* [MIME base64 encoding Characters (2.3.1 - 1.0.0)](CodeSystem-mimeBase64EncodingCharacters.md)
* [Modality (2.3.1 - 1.0.0)](CodeSystem-modality.md)
* [Money or Percentage Indicator (2.3.1 - 1.0.0)](CodeSystem-moneyOrPercentageIndicator.md)
* [NameAddress representation (2.3.1 - 1.0.0)](CodeSystem-name-addressRepresentation.md)
* [Name Type (2.3.1 - 1.1.0)](CodeSystem-nameType.md)
* [Nature of Abnormal Testing (2.3.1 - 1.0.0)](CodeSystem-natureOfAbnormalTesting.md)
* [Nature of Challenge (2.3.1 - 1.0.0)](CodeSystem-natureOfChallenge.md)
* [Nature of Service/Test/Observation (2.3.1 - 1.0.0)](CodeSystem-natureOfServiceTestObservation.md)
* [Occurrence Code (2.3.1 - 1.0.0)](CodeSystem-nubc-OccurrenceCode-cs.md)
* [Occurrence Span (2.3.1 - 1.0.0)](CodeSystem-nubc-OccurrenceSpan-cs.md)
* [Abnormal Flags (2.3.1 - 1.3.0)](CodeSystem-observationInterpretation.md)
* [Observation Result Status Codes Interpretation (2.3.1 - 1.2.0)](CodeSystem-observationResultStatusCodesInterpretation.md)
* [Order Control Codes (2.3.1 - 1.3.0)](CodeSystem-orderControlCodes.md)
* [Order Status (2.3.1 - 1.2.0)](CodeSystem-orderStatus.md)
* [Organ Donor Code (2.3.1 - 1.1.0)](CodeSystem-organDonorCodes.md)
* [Organizational Name Type (2.3.1 - 1.0.0)](CodeSystem-organizationalNameType.md)
* [Outlier Type (2.3.1 - 1.0.0)](CodeSystem-outlierType.md)
* [Override (2.3.1 - 1.0.0)](CodeSystem-override.md)
* [Patient Class (2.3.1 - 1.1.0)](CodeSystem-patientClass.md)
* [Patient Location Type (2.3.1 - 1.0.0)](CodeSystem-patientLocationType.md)
* [Patient Outcome (2.3.1 - 1.0.0)](CodeSystem-patientOutcome.md)
* [Patient's Relationship to Insured (2.3.1 - 1.0.0)](CodeSystem-patientsRelationshipToInsured.md)
* [Policy Type (2.3.1 - 1.0.0)](CodeSystem-policyType.md)
* [Practitioner ID Number Type (2.3.1 - 1.0.0)](CodeSystem-practitionerIdNumberType.md)
* [Preferred Method of Contact (2.3.1 - 1.1.0)](CodeSystem-preferredMethodOfContact.md)
* [Price Type (2.3.1 - 1.0.0)](CodeSystem-priceType.md)
* [Primary Key Value Type (2.3.1 - 1.0.0)](CodeSystem-primaryKeyValueType.md)
* [Primary Observer's Qualification (2.3.1 - 1.0.0)](CodeSystem-primaryObserverQualification.md)
* [Priority (2.3.1 - 1.2.0)](CodeSystem-priority.md)
* [Privacy Level (2.3.1 - 1.0.0)](CodeSystem-privacyLevel.md)
* [Problem/Goal Action Code (2.3.1 - 1.0.0)](CodeSystem-problem-goalAction.md)
* [Procedure Functional Type (2.3.1 - 1.0.0)](CodeSystem-procedureFunctionalType.md)
* [Procedure Practitioner Identifier Type (2.3.1 - 1.1.0)](CodeSystem-procedurePractitionerIdentifierCodeType.md)
* [Processing ID (2.3.1 - 1.0.0)](CodeSystem-processingId.md)
* [Processing Mode (2.3.1 - 1.1.0)](CodeSystem-processingMode.md)
* [Processing Priority (2.3.1 - 1.0.0)](CodeSystem-processingPriority.md)
* [Product Source (2.3.1 - 1.0.0)](CodeSystem-productSource.md)
* [Provider Billing (2.3.1 - 1.0.0)](CodeSystem-providerBilling.md)
* [Provider Role (2.3.1 - 1.0.0)](CodeSystem-providerRole.md)
* [Purge Status Code (2.3.1 - 1.0.0)](CodeSystem-purgeStatus.md)
* [Quantity Limited Request (2.3.1 - 1.1.0)](CodeSystem-quantityLimitedRequest.md)
* [Quantity Method (2.3.1 - 1.0.0)](CodeSystem-quantityMethod.md)
* [Query Priority (2.3.1 - 1.0.0)](CodeSystem-queryPriority.md)
* [Query/Response Format Code (2.3.1 - 1.2.0)](CodeSystem-queryResponseFormat.md)
* [Query Response Status (2.3.1 - 1.1.0)](CodeSystem-queryResponseStatus.md)
* [Query Results Level (2.3.1 - 1.0.2)](CodeSystem-queryResultsLevel.md)
* [Referral Category (2.3.1 - 1.0.0)](CodeSystem-referralCategory.md)
* [Referral Disposition (2.3.1 - 1.0.0)](CodeSystem-referralDisposition.md)
* [Referral Priority (2.3.1 - 1.0.0)](CodeSystem-referralPriority.md)
* [Referral Reason (2.3.1 - 1.0.0)](CodeSystem-referralReason.md)
* [Referral Status (2.3.1 - 1.0.0)](CodeSystem-referralStatus.md)
* [Referral Type (2.3.1 - 1.0.0)](CodeSystem-referralType.md)
* [Relatedness Assessment (2.3.1 - 1.0.0)](CodeSystem-relatednessAssessment.md)
* [Relational Conjunction (2.3.1 - 1.0.0)](CodeSystem-relationalConjunction.md)
* [Relational Operator (2.3.1 - 1.0.0)](CodeSystem-relationalOperator.md)
* [Relationship Modifier (2.3.1 - 1.0.0)](CodeSystem-relationshipModifier.md)
* [Report Priority (2.3.1 - 1.0.0)](CodeSystem-reportPriority.md)
* [Report Source (2.3.1 - 1.0.0)](CodeSystem-reportSource.md)
* [Report Timing (2.3.1 - 1.0.0)](CodeSystem-reportTiming.md)
* [Reporting Priority (2.3.1 - 1.0.0)](CodeSystem-reportingPriority.md)
* [Response Flag (2.3.1 - 1.0.0)](CodeSystem-responseFlag.md)
* [Response Level (2.3.1 - 1.0.0)](CodeSystem-responseLevel.md)
* [Result Status (2.3.1 - 1.2.0)](CodeSystem-resultStatus.md)
* [Room Type (2.3.1 - 1.0.0)](CodeSystem-roomType.md)
* [Route of Administration (2.3.1 - 3.0.0)](CodeSystem-routeOfAdministration.md)
* [RX Component Type (2.3.1 - 1.0.0)](CodeSystem-rxComponentType.md)
* [Segment Action Code (2.3.1 - 1.0.0)](CodeSystem-segmentAction.md)
* [Sex (2.3.1 - 1.0.0)](CodeSystem-sex.md)
* [Source of Comment (2.3.1 - 1.1.0)](CodeSystem-sourceOfComment.md)
* [Source Type (2.3.1 - 1.0.0)](CodeSystem-sourceType.md)
* [Specialty Type (2.3.1 - 1.0.0)](CodeSystem-specialtyType.md)
* [Specimen Action Code (2.3.1 - 2.1.0)](CodeSystem-specimenAction.md)
* [Specimen Source Codes (2.3.1 - 1.2.0)](CodeSystem-specimenSourceCodes.md)
* [Status of Evaluation (2.3.1 - 1.0.0)](CodeSystem-statusOfEvaluation.md)
* [Student Status (2.3.1 - 1.0.0)](CodeSystem-studentStatus.md)
* [Substitution Status (2.3.1 - 1.1.0)](CodeSystem-substitutionStatus.md)
* [Subtype of Referenced Data (2.3.1 - 1.1.0)](CodeSystem-subtypeOfReferencedData.md)
* [Telecommunication Equipment Type (2.3.1 - 1.0.0)](CodeSystem-telecommunicationEquipmentType.md)
* [Telecommunication Use Code (2.3.1 - 1.1.0)](CodeSystem-telecommunicationUse.md)
* [Time Delay Post Challenge (2.3.1 - 1.0.0)](CodeSystem-timeDelayPostChallenge.md)
* [Time Selection Criteria Parameter Class Codes (2.3.1 - 1.0.0)](CodeSystem-timeSelectionCriteriaParameterClass.md)
* [Transaction Type (2.3.1 - 1.0.0)](CodeSystem-transactionType.md)
* [Transport Arranged (2.3.1 - 1.0.0)](CodeSystem-transportArranged.md)
* [Transportation Mode (2.3.1 - 1.0.0)](CodeSystem-transportationMode.md)
* [Tray Type (2.3.1 - 1.0.0)](CodeSystem-trayType.md)
* [Type of Referenced Data (2.3.1 - 1.2.0)](CodeSystem-typeOfReferencedData.md)
* [Universal ID Type (2.3.1 - 1.0.0)](CodeSystem-universalIdType.md)
* [Vaccines Administered (2.3.1 - 1.1.0)](CodeSystem-vaccinesAdministeredHL7.md)
* [Version ID (2.3.1 - 1.3.0)](CodeSystem-versionId.md)
* [Visit Indicator (2.3.1 - 1.0.0)](CodeSystem-visitIndicator.md)
* [What subject filter (2.3.1 - 1.3.0)](CodeSystem-whatSubjectFilter.md)
* [Which Date/Time Qualifier (2.3.1 - 1.1.0)](CodeSystem-whichDate-timeQualifier.md)
* [Which Date/Time Status Qualifier (2.3.1 - 1.0.0)](CodeSystem-whichDate-timeStatusQualifier.md)

### ValueSets

* [Discharge Disposition (2.3.1 - 1.0.0)](ValueSet-hl7VSVS-dischargeDisposition.md)
* [Accept/Application Acknowledgment Conditions (2.3.1 - 1.0.0)](ValueSet-hl7VSaccept-applicationAcknowledgmentConditions.md)
* [Acknowledgment Code (2.3.1 - 1.2.0)](ValueSet-hl7VSacknowledgmentCode.md)
* [Action Code (2.3.1 - 1.0.0)](ValueSet-hl7VSactionCode.md)
* [Action Taken in Response to the Event (2.3.1 - 1.0.0)](ValueSet-hl7VSactionTakenInResponseToTheEvent.md)
* [Active/Inactive (2.3.1 - 1.0.0)](ValueSet-hl7VSactive-inactive.md)
* [Address Type (2.3.1 - 1.2.0)](ValueSet-hl7VSaddressType.md)
* [Administration Device (2.3.1 - 1.0.0)](ValueSet-hl7VSadministrationDevice.md)
* [Administration Method (2.3.1 - 1.0.0)](ValueSet-hl7VSadministrationMethod.md)
* [Administrative Site (2.3.1 - 1.1.0)](ValueSet-hl7VSadministriveSite.md)
* [Admission Type (2.3.1 - 1.0.0)](ValueSet-hl7VSadmissionType.md)
* [Admit Source (2.3.1 - 1.0.0)](ValueSet-hl7VSadmitSource.md)
* [Advanced Beneficiary Notice Code (2.3.1 - 1.0.0)](ValueSet-hl7VSadvancedBeneficiaryNoticeCode.md)
* [Allergy Severity (2.3.1 - 1.0.0)](ValueSet-hl7VSallergySeverity.md)
* [Allergy Type (2.3.1 - 1.0.0)](ValueSet-hl7VSallergyType.md)
* [Allow Substitution (2.3.1 - 1.0.0)](ValueSet-hl7VSallowSubstitution.md)
* [Allow Substitution Codes (2.3.1 - 1.1.0)](ValueSet-hl7VSallowSubstitutionCodes.md)
* [Alternate Character Set Handling Scheme (2.3.1 - 1.0.0)](ValueSet-hl7VSalternateCharacterSetHandlingScheme.md)
* [Alternate Character Sets (2.3.1 - 1.1.0)](ValueSet-hl7VSalternateCharacterSets.md)
* [Ambulatory Status (2.3.1 - 1.0.0)](ValueSet-hl7VSambulatoryStatus.md)
* [Amount Class (2.3.1 - 1.0.0)](ValueSet-hl7VSamountClass.md)
* [Amount Type (2.3.1 - 1.0.0)](ValueSet-hl7VSamountType.md)
* [Annotations (2.3.1 - 1.0.0)](ValueSet-hl7VSannotations.md)
* [Appointment Reason Codes (2.3.1 - 1.0.0)](ValueSet-hl7VSappointmentReasonCodes.md)
* [Appointment Type Codes (2.3.1 - 1.0.0)](ValueSet-hl7VSappointmentTypeCodes.md)
* [Assignment of Benefits (2.3.1 - 1.0.0)](ValueSet-hl7VSassignmentOfBenefits.md)
* [Bed Status (2.3.1 - 1.1.0)](ValueSet-hl7VSbedStatus.md)
* [Causality Observations (2.3.1 - 1.0.0)](ValueSet-hl7VScausalityObservations.md)
* [Certification Status (2.3.1 - 1.0.0)](ValueSet-hl7VScertificationStatus.md)
* [Charge On Indicator (2.3.1 - 1.0.0)](ValueSet-hl7VSchargeOnIndicator.md)
* [Charge Type (2.3.1 - 1.0.0)](ValueSet-hl7VSchargeType.md)
* [Check Digit Scheme (2.3.1 - 1.2.0)](ValueSet-hl7VScheckDigitScheme.md)
* [Comment Type (2.3.1 - 1.0.0)](ValueSet-hl7VScommentType.md)
* [Completion Status (2.3.1 - 1.0.0)](ValueSet-hl7VScompletionStatus.md)
* [Condition Code (2.3.1 - 1.0.0)](ValueSet-hl7VSconditionCode.md)
* [Confidentiality Code (2.3.1 - 1.0.0)](ValueSet-hl7VSconfidentialityCode.md)
* [Coordination of Benefits (2.3.1 - 1.0.0)](ValueSet-hl7VScoordinationOfBenefits.md)
* [Coverage Type (2.3.1 - 1.0.0)](ValueSet-hl7VScoverageType.md)
* [CWE statuses (2.3.1 - 1.0.0)](ValueSet-hl7VScweStatuses.md)
* [Date/Time Selection Qualifier (2.3.1 - 1.0.0)](ValueSet-hl7VSdate-timeSelectionQualifier.md)
* [Day Type (2.3.1 - 1.0.0)](ValueSet-hl7VSdayType.md)
* [Days of the Week (2.3.1 - 1.0.0)](ValueSet-hl7VSdaysOfTheWeek.md)
* [Deferred Response Type (2.3.1 - 1.0.0)](ValueSet-hl7VSdeferredResponseType.md)
* [Degree/license/certificate (2.3.1 - 1.0.0)](ValueSet-hl7VSdegree.md)
* [Delayed Acknowledgement Type (2.3.1 - 1.1.0)](ValueSet-hl7VSdelayedAcknowledgmentType.md)
* [Derived Specimen (2.3.1 - 1.0.0)](ValueSet-hl7VSderivedSpecimen.md)
* [Diagnosis Classification (2.3.1 - 1.0.0)](ValueSet-hl7VSdiagnosisClassification.md)
* [Diagnosis Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSdiagnosisPriority.md)
* [Diagnosis Type (2.3.1 - 1.0.0)](ValueSet-hl7VSdiagnosisType.md)
* [Diagnostic Service Section ID (2.3.1 - 1.2.0)](ValueSet-hl7VSdiagnosticServiceSectionId.md)
* [Diet Code Specification Type (2.3.1 - 1.0.0)](ValueSet-hl7VSdietType.md)
* [Disabled Person Code (2.3.1 - 1.0.0)](ValueSet-hl7VSdisabledPerson.md)
* [Dispense Method (2.3.1 - 1.0.0)](ValueSet-hl7VSdispenseMethod.md)
* [Document Availability Status (2.3.1 - 1.1.0)](ValueSet-hl7VSdocumentAvailabilityStatus.md)
* [Document Completion Status (2.3.1 - 1.0.0)](ValueSet-hl7VSdocumentCompletionStatus.md)
* [Document Confidentiality Status (2.3.1 - 2.0.0)](ValueSet-hl7VSdocumentConfidentialityStatus.md)
* [Document Storage Status (2.3.1 - 1.0.0)](ValueSet-hl7VSdocumentStorageStatus.md)
* [Duration Categories (2.3.1 - 1.0.1)](ValueSet-hl7VSdurationCategories.md)
* [Eligibility Source (2.3.1 - 1.0.0)](ValueSet-hl7VSeligibilitySource.md)
* [Encoding (2.3.1 - 1.0.0)](ValueSet-hl7VSencoding.md)
* [Escort Required (2.3.1 - 1.0.0)](ValueSet-hl7VSescortRequired.md)
* [Event (2.3.1 - 1.3.0)](ValueSet-hl7VSevent.md)
* [Event Consequence (2.3.1 - 1.0.0)](ValueSet-hl7VSeventConsequence.md)
* [Event Expected (2.3.1 - 1.0.0)](ValueSet-hl7VSeventExpected.md)
* [Event Qualification (2.3.1 - 1.0.0)](ValueSet-hl7VSeventQualification.md)
* [Event Reason (2.3.1 - 1.1.0)](ValueSet-hl7VSeventReason.md)
* [Event Reported To (2.3.1 - 1.0.0)](ValueSet-hl7VSeventReportedTo.md)
* [Event Seriousness (2.3.1 - 1.0.0)](ValueSet-hl7VSeventSeriousness.md)
* [Facility Type (2.3.1 - 1.0.0)](ValueSet-hl7VSfacilityType.md)
* [File Level Event Code (2.3.1 - 1.0.0)](ValueSet-hl7VSfile-levelEventCode.md)
* [Filler Status Codes (2.3.1 - 1.1.0)](ValueSet-hl7VSfillerStatusCodes.md)
* [Identifier Type (2.3.1 - 1.1.0)](ValueSet-hl7VSidentifierType.md)
* [Identity May Be Divulged (2.3.1 - 1.0.0)](ValueSet-hl7VSidentityMayBeDivulged.md)
* [Indirect Exposure Mechanism (2.3.1 - 1.0.0)](ValueSet-hl7VSindirectExposureMechanism.md)
* [Abnormal Flags (2.3.1 - 1.3.0)](ValueSet-hl7VSinterpretationCode.md)
* [Kind of Quantity (2.3.1 - 1.0.0)](ValueSet-hl7VSkindOfQuantity.md)
* [Level of Care (2.3.1 - 1.0.0)](ValueSet-hl7VSlevelOfCare.md)
* [Living Arrangement (2.3.1 - 1.1.0)](ValueSet-hl7VSlivingArrangement.md)
* [Living Dependency (2.3.1 - 1.0.0)](ValueSet-hl7VSlivingDependency.md)
* [Living Will Code (2.3.1 - 1.0.0)](ValueSet-hl7VSlivingWill.md)
* [Location Characteristic ID (2.3.1 - 1.0.0)](ValueSet-hl7VSlocationCharacteristicId.md)
* [Location Equipment (2.3.1 - 1.0.0)](ValueSet-hl7VSlocationEquipment.md)
* [Location Relationship ID (2.3.1 - 1.0.0)](ValueSet-hl7VSlocationRelationshipId.md)
* [Mail Claim Party (2.3.1 - 1.0.0)](ValueSet-hl7VSmailClaimParty.md)
* [Manufacturers of Vaccines (code=MVX) (2.3.1 - 1.1.0)](ValueSet-hl7VSmanufacturersOfVaccines.md)
* [Marital Status (2.3.1 - 1.0.0)](ValueSet-hl7VSmaritalStatus.md)
* [Marketing Basis (2.3.1 - 1.0.0)](ValueSet-hl7VSmarketingBasis.md)
* [Master File Identifier Code (2.3.1 - 1.0.0)](ValueSet-hl7VSmasterFileIdentifierCode.md)
* [Record-level Event Code (2.3.1 - 1.0.0)](ValueSet-hl7VSmasterfileActionCode.md)
* [Message Error Condition Codes (2.3.1 - 1.0.0)](ValueSet-hl7VSmessageErrorConditionCodes.md)
* [Message Structure (2.3.1 - 1.0.0)](ValueSet-hl7VSmessageStructure.md)
* [Message Type (2.3.1 - 1.3.0)](ValueSet-hl7VSmessageType.md)
* [MFN Record-level Error Return (2.3.1 - 1.0.0)](ValueSet-hl7VSmfnRecode-levelErrorReturn.md)
* [Military Rank/Grade (2.3.1 - 1.0.0)](ValueSet-hl7VSmilitaryRank-Grade.md)
* [Military Service (2.3.1 - 1.0.0)](ValueSet-hl7VSmilitaryService.md)
* [Military Status (2.3.1 - 1.0.0)](ValueSet-hl7VSmilitaryStatus.md)
* [MIME base64 encoding Characters (2.3.1 - 1.0.0)](ValueSet-hl7VSmimeBase64EncodingCharacters.md)
* [Modality (2.3.1 - 1.0.0)](ValueSet-hl7VSmodality.md)
* [NameAddress representation (2.3.1 - 1.0.0)](ValueSet-hl7VSname-addressRepresentation.md)
* [Name Type (2.3.1 - 1.1.0)](ValueSet-hl7VSnameType.md)
* [Nature of Abnormal Testing (2.3.1 - 1.0.0)](ValueSet-hl7VSnatureOfAbnormalTesting.md)
* [Nature of Challenge (2.3.1 - 1.0.0)](ValueSet-hl7VSnatureOfChallenge.md)
* [Nature of Service/Test/Observation (2.3.1 - 1.0.0)](ValueSet-hl7VSnatureOfServiceTestObservation.md)
* [Source Type (2.3.1 - 1.0.0)](ValueSet-hl7VSnetworkSourceType.md)
* [Observation Result Status Codes Interpretation (2.3.1 - 1.2.0)](ValueSet-hl7VSobservationResultStatus.md)
* [Occurrence Code (2.3.1 - 1.0.0)](ValueSet-hl7VSoccurrenceCode.md)
* [Occurrence Span (2.3.1 - 1.0.0)](ValueSet-hl7VSoccurrenceSpan.md)
* [Order Control Codes (2.3.1 - 1.3.0)](ValueSet-hl7VSorderControl.md)
* [Order Status (2.3.1 - 1.2.0)](ValueSet-hl7VSorderStatus.md)
* [Organ Donor Code (2.3.1 - 1.1.0)](ValueSet-hl7VSorganDonor.md)
* [Organizational Name Type (2.3.1 - 1.0.0)](ValueSet-hl7VSorganizationalNameType.md)
* [DRG Payor (2.3.1 - 1.0.0)](ValueSet-hl7VSoutlierType.md)
* [Override (2.3.1 - 1.0.0)](ValueSet-hl7VSoverride.md)
* [Patient Class (2.3.1 - 1.1.0)](ValueSet-hl7VSpatientClass.md)
* [Patient Location Type (2.3.1 - 1.0.0)](ValueSet-hl7VSpatientLocationType.md)
* [Patient Outcome (2.3.1 - 1.0.0)](ValueSet-hl7VSpatientOutcome.md)
* [Patient's Relationship to Insured (2.3.1 - 1.0.0)](ValueSet-hl7VSpatient_sRelationshipToInsured.md)
* [Money or Percentage Indicator (2.3.1 - 1.0.0)](ValueSet-hl7VSpenaltyType.md)
* [Policy Type (2.3.1 - 1.0.0)](ValueSet-hl7VSpolicyType.md)
* [Practitioner ID Number Type (2.3.1 - 1.0.0)](ValueSet-hl7VSpractitionerIdNumberType.md)
* [Certification Patient Type (2.3.1 - 1.0.0)](ValueSet-hl7VSprecertificationPatientType.md)
* [Preferred Method of Contact (2.3.1 - 1.1.0)](ValueSet-hl7VSpreferredMethodOfContrct.md)
* [Price Type (2.3.1 - 1.0.0)](ValueSet-hl7VSpriceType.md)
* [Primary Key Value Type (2.3.1 - 1.0.0)](ValueSet-hl7VSprimaryKeyValueType.md)
* [Primary Observer's Qualification (2.3.1 - 1.0.0)](ValueSet-hl7VSprimaryObserver_sQualification.md)
* [Priority (2.3.1 - 1.2.0)](ValueSet-hl7VSpriority.md)
* [Privacy Level (2.3.1 - 1.0.0)](ValueSet-hl7VSprivacyLevel.md)
* [Procedure Functional Type (2.3.1 - 1.0.0)](ValueSet-hl7VSprocedureFunctionalType.md)
* [Procedure Practitioner Identifier Type (2.3.1 - 1.1.0)](ValueSet-hl7VSprocedurePractitionerType.md)
* [Processing ID (2.3.1 - 1.0.0)](ValueSet-hl7VSprocessingId.md)
* [Processing Mode (2.3.1 - 1.1.0)](ValueSet-hl7VSprocessingMode.md)
* [Processing Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSprocessingPriority.md)
* [Product Source (2.3.1 - 1.0.0)](ValueSet-hl7VSproductSource.md)
* [Provider Billing (2.3.1 - 1.0.0)](ValueSet-hl7VSproviderBilling.md)
* [Provider Role (2.3.1 - 1.0.0)](ValueSet-hl7VSproviderRole.md)
* [PSRO/UR Approval Indicator (2.3.1 - 1.0.0)](ValueSet-hl7VSpsro-urApprovalIndicator.md)
* [Purge Status Code (2.3.1 - 1.0.0)](ValueSet-hl7VSpurgeStatus.md)
* [Quantity Limited Request (2.3.1 - 1.1.0)](ValueSet-hl7VSquantityLimitedRequest.md)
* [Quantity Method (2.3.1 - 1.0.0)](ValueSet-hl7VSquantityMethod.md)
* [Query/Response Format Code (2.3.1 - 1.2.0)](ValueSet-hl7VSqueryFormatCode.md)
* [Query Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSqueryPriority.md)
* [Query Response Status (2.3.1 - 1.1.0)](ValueSet-hl7VSqueryResponseStatus.md)
* [Query Results Level (2.3.1 - 1.0.2)](ValueSet-hl7VSqueryResultsLevel.md)
* [CP Range Type (2.3.1 - 1.0.0)](ValueSet-hl7VSrangeType.md)
* [Referral Category (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralCategory.md)
* [Referral Disposition (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralDisposition.md)
* [Referral Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralPriority.md)
* [Referral Reason (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralReason.md)
* [Referral Status (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralStatus.md)
* [Referral Type (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralType.md)
* [Relatedness Assessment (2.3.1 - 1.0.0)](ValueSet-hl7VSrelatednessAssessment.md)
* [Relational Conjunction (2.3.1 - 1.0.0)](ValueSet-hl7VSrelationalConjunction.md)
* [Relational Operator (2.3.1 - 1.0.0)](ValueSet-hl7VSrelationalOperator.md)
* [Relationship Modifier (2.3.1 - 1.0.0)](ValueSet-hl7VSrelationshipModifier.md)
* [Report Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSreportPriority.md)
* [Report Source (2.3.1 - 1.0.0)](ValueSet-hl7VSreportSource.md)
* [Report Timing (2.3.1 - 1.0.0)](ValueSet-hl7VSreportTiming.md)
* [Document Type (2.3.1 - 1.0.0)](ValueSet-hl7VSreportTypeCode.md)
* [Reporting Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSreportingPriority.md)
* [Response Flag (2.3.1 - 1.0.0)](ValueSet-hl7VSresponseFlag.md)
* [Response Level (2.3.1 - 1.0.0)](ValueSet-hl7VSresponseLevel.md)
* [Result Status (2.3.1 - 1.2.0)](ValueSet-hl7VSresultStatus-Obr.md)
* [Room Type (2.3.1 - 1.0.0)](ValueSet-hl7VSroomType.md)
* [Route of Administration (2.3.1 - 3.0.0)](ValueSet-hl7VSrouteOfAdministration.md)
* [RX Component Type (2.3.1 - 1.0.0)](ValueSet-hl7VSrxComponentType.md)
* [Segment Action Code (2.3.1 - 1.0.0)](ValueSet-hl7VSsegmentActionCode.md)
* [Sex (2.3.1 - 1.0.0)](ValueSet-hl7VSsex.md)
* [Source of Comment (2.3.1 - 1.1.0)](ValueSet-hl7VSsourceOfComment.md)
* [Specimen Source Codes (2.3.1 - 1.2.0)](ValueSet-hl7VSsourceOfSpecimen.md)
* [Specialty Type (2.3.1 - 1.0.0)](ValueSet-hl7VSspecialtyType.md)
* [Status of Evaluation (2.3.1 - 1.0.0)](ValueSet-hl7VSstartOfEvaluation.md)
* [Student Status (2.3.1 - 1.0.0)](ValueSet-hl7VSstudentStatus.md)
* [Substitution Status (2.3.1 - 1.1.0)](ValueSet-hl7VSsubstitutionStatus.md)
* [Subtype of Referenced Data (2.3.1 - 1.1.0)](ValueSet-hl7VSsubtypeOfReferencedData.md)
* [Telecommunication Equipment Type (2.3.1 - 1.0.0)](ValueSet-hl7VStelecommunicationEquipmentType.md)
* [Telecommunication Use Code (2.3.1 - 1.1.0)](ValueSet-hl7VStelecommunicationUseCode.md)
* [Time Delay Post Challenge (2.3.1 - 1.0.0)](ValueSet-hl7VStimeDelayPostChallenge.md)
* [Time Selection Criteria Parameter Class Codes (2.3.1 - 1.0.0)](ValueSet-hl7VStimeSelectionCriteriaParameterClassCodes.md)
* [Transaction Type (2.3.1 - 1.0.0)](ValueSet-hl7VStransactionType.md)
* [Transport Arranged (2.3.1 - 1.0.0)](ValueSet-hl7VStransportArranged.md)
* [Transportation Mode (2.3.1 - 1.0.0)](ValueSet-hl7VStransportationMode.md)
* [Tray Type (2.3.1 - 1.0.0)](ValueSet-hl7VStrayType.md)
* [Type of Referenced Data (2.3.1 - 1.2.0)](ValueSet-hl7VStypeOfData.md)
* [Universal ID Type (2.3.1 - 1.0.0)](ValueSet-hl7VSuniversalIdType.md)
* [Vaccines Administered (2.3.1 - 1.1.0)](ValueSet-hl7VSvaccinesAdministered.md)
* [Version ID (2.3.1 - 1.3.0)](ValueSet-hl7VSversionControlTable.md)
* [Visit Indicator (2.3.1 - 1.0.0)](ValueSet-hl7VSvisitIndicator.md)
* [What subject filter (2.3.1 - 1.3.0)](ValueSet-hl7VSwhatSubjectFilter.md)
* [Invocation Event (2.3.1 - 1.0.0)](ValueSet-hl7VSwhenToCharge.md)
* [Which Date/Time Qualifier (2.3.1 - 1.1.0)](ValueSet-hl7VSwhichDate-timeQualifier.md)
* [Which Date/Time Status Qualifier (2.3.1 - 1.0.0)](ValueSet-hl7VSwhichDate-timeStatusQualifier.md)
* [Yes/No Indicator (2.3.1 - 1.0.0)](ValueSet-hl7VSyes-no-Indicator.md)

### Resource Profiles

* [V2CodeSystem](StructureDefinition-V2CodeSystem.md)

### Extensions

* [Codesystem tableNo](StructureDefinition-codesystem-tableNo.md)
* [Codesystem v2versionCreated](StructureDefinition-codesystem-v2versionCreated.md)
* [Codesystem versionHistory](StructureDefinition-codesystem-versionHistory.md)
* [Codesystem versionIntroduced](StructureDefinition-codesystem-versionIntroduced.md)

### ImplementationGuides

* [HL7 v2.3.1 Vocabulary](index.md)
