# Downloads - HL7 v2.3.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* **Downloads**

## Downloads

You can also download:

* [this entire guide](full-ig.zip),

The expanded value sets can be found:

* [Expansion in XML](expansions.xml.zip)
* [Expansion in JSON](expansions.json.zip)

The source code for this Implementation Guide will be found shortly on [IHE GitHub](https://github.com/IHE/ITI.PDQm)

#### Cross Version Analysis

This is an R4 IG. None of the features it uses are changed in R4B, so it can be used as is with R4B systems. Packages for both [R4 (hl7.v2.uv.terminology.v231.r4)](package.r4.tgz) and [R4B (hl7.v2.uv.terminology.v231.r4b)](package.r4b.tgz) are available.

#### Dependency Table



#### Globals Table

*There are no Global profiles defined*

#### IP Statements

This publication includes IP covered under the following statements.

* HL7 Inc., 2026

* [Accept/Application Acknowledgment Conditions (2.3.1 - 1.0.0)](CodeSystem-accept-applicationAcknowledgmentConditions.md): [Hl7VSaccept-applicationAcknowledgmentConditions](ValueSet-hl7VSaccept-applicationAcknowledgmentConditions.md)
* [Acknowledgment Code (2.3.1 - 1.2.0)](CodeSystem-acknowledgmentCodes.md): [Hl7VSacknowledgmentCode](ValueSet-hl7VSacknowledgmentCode.md)
* [Action Code (2.3.1 - 1.0.0)](CodeSystem-actionCodes.md): [Hl7VSactionCode](ValueSet-hl7VSactionCode.md)
* [Action Taken in Response to the Event (2.3.1 - 1.0.0)](CodeSystem-actionTakenInResponseToTheEvent.md): [Hl7VSactionTakenInResponseToTheEvent](ValueSet-hl7VSactionTakenInResponseToTheEvent.md)
* [Active/Inactive (2.3.1 - 1.0.0)](CodeSystem-active-inactive.md): [Hl7VSactive-inactive](ValueSet-hl7VSactive-inactive.md)
* [Address Type (2.3.1 - 1.2.0)](CodeSystem-addressType.md): [Hl7VSaddressType](ValueSet-hl7VSaddressType.md)
* [Administration Device (2.3.1 - 1.0.0)](CodeSystem-administrationDevice.md): [Hl7VSadministrationDevice](ValueSet-hl7VSadministrationDevice.md)
* [Administration Method (2.3.1 - 1.0.0)](CodeSystem-administrationMethod.md): [Hl7VSadministrationMethod](ValueSet-hl7VSadministrationMethod.md)
* [Admission Type (2.3.1 - 1.0.0)](CodeSystem-admissionType.md): [Hl7VSadmissionType](ValueSet-hl7VSadmissionType.md)
* [Admit Source (2.3.1 - 1.0.0)](CodeSystem-admitSource.md): [Hl7VSadmitSource](ValueSet-hl7VSadmitSource.md)
* [Advanced Beneficiary Notice Code (2.3.1 - 1.0.0)](CodeSystem-advancedBeneficiaryNotice.md): [Hl7VSadvancedBeneficiaryNoticeCode](ValueSet-hl7VSadvancedBeneficiaryNoticeCode.md)
* [Allergy Type (2.3.1 - 1.0.0)](CodeSystem-allergenType.md): [Hl7VSallergyType](ValueSet-hl7VSallergyType.md)
* [Allergy Severity (2.3.1 - 1.0.0)](CodeSystem-allergySeverity.md): [Hl7VSallergySeverity](ValueSet-hl7VSallergySeverity.md)
* [Allow Substitution Codes (2.3.1 - 1.1.0)](CodeSystem-allowSubstitution.md): [Hl7VSallowSubstitution](ValueSet-hl7VSallowSubstitution.md) and [Hl7VSallowSubstitutionCodes](ValueSet-hl7VSallowSubstitutionCodes.md)
* [Alternate Character Set Handling Scheme (2.3.1 - 1.0.0)](CodeSystem-alternateCharacterSetHandlingScheme.md): [Hl7VSalternateCharacterSetHandlingScheme](ValueSet-hl7VSalternateCharacterSetHandlingScheme.md)
* [Alternate Character Sets (2.3.1 - 1.1.0)](CodeSystem-alternateCharacterSets.md): [Hl7VSalternateCharacterSets](ValueSet-hl7VSalternateCharacterSets.md)
* [Ambulatory Status (2.3.1 - 1.0.0)](CodeSystem-ambulatoryStatus.md): [Hl7VSambulatoryStatus](ValueSet-hl7VSambulatoryStatus.md)
* [Amount Class (2.3.1 - 1.0.0)](CodeSystem-amountClass.md): [Hl7VSamountClass](ValueSet-hl7VSamountClass.md)
* [Amount Type (2.3.1 - 1.0.0)](CodeSystem-amountType.md): [Hl7VSamountType](ValueSet-hl7VSamountType.md)
* [Annotations (2.3.1 - 1.0.0)](CodeSystem-annotations.md): [Hl7VSannotations](ValueSet-hl7VSannotations.md)
* [Appointment Reason Codes (2.3.1 - 1.0.0)](CodeSystem-appointmentReason.md): [Hl7VSappointmentReasonCodes](ValueSet-hl7VSappointmentReasonCodes.md)
* [Appointment Type Codes (2.3.1 - 1.0.0)](CodeSystem-appointmentType.md): [Hl7VSappointmentTypeCodes](ValueSet-hl7VSappointmentTypeCodes.md)
* [PSRO/UR Approval Indicator (2.3.1 - 1.0.0)](CodeSystem-approvalIndicator.md): [Hl7VSpsro-urApprovalIndicator](ValueSet-hl7VSpsro-urApprovalIndicator.md)
* [Assignment of Benefits (2.3.1 - 1.0.0)](CodeSystem-assignmentOfBenefits.md): [Hl7VSassignmentOfBenefits](ValueSet-hl7VSassignmentOfBenefits.md)
* [Bed Status (2.3.1 - 1.1.0)](CodeSystem-bedStatus.md): [Hl7VSbedStatus](ValueSet-hl7VSbedStatus.md)
* [Administrative Site (2.3.1 - 1.1.0)](CodeSystem-bodySite.md): [Hl7VSadministriveSite](ValueSet-hl7VSadministriveSite.md)
* [Causality Observations (2.3.1 - 1.0.0)](CodeSystem-causalityObservations.md): [Hl7VScausalityObservations](ValueSet-hl7VScausalityObservations.md)
* [Certification Patient Type (2.3.1 - 1.0.0)](CodeSystem-certificationPatientType.md): [Hl7VSprecertificationPatientType](ValueSet-hl7VSprecertificationPatientType.md)
* [Certification Status (2.3.1 - 1.0.0)](CodeSystem-certificationStatus.md): [Hl7VScertificationStatus](ValueSet-hl7VScertificationStatus.md)
* [Charge On Indicator (2.3.1 - 1.0.0)](CodeSystem-chargeOnIndicator.md): [Hl7VSchargeOnIndicator](ValueSet-hl7VSchargeOnIndicator.md)
* [Charge Type (2.3.1 - 1.0.0)](CodeSystem-chargeType.md): [Hl7VSchargeType](ValueSet-hl7VSchargeType.md)
* [Check Digit Scheme (2.3.1 - 1.2.0)](CodeSystem-checkDigitScheme.md): [Hl7VScheckDigitScheme](ValueSet-hl7VScheckDigitScheme.md)
* [Comment Type (2.3.1 - 1.0.0)](CodeSystem-commentType.md): [Hl7VScommentType](ValueSet-hl7VScommentType.md)
* [Completion Status (2.3.1 - 1.0.0)](CodeSystem-completionStatus.md): [Hl7VScompletionStatus](ValueSet-hl7VScompletionStatus.md)
* [Condition Code (2.3.1 - 1.0.0)](CodeSystem-conditionCodes.md): [Hl7VSconditionCode](ValueSet-hl7VSconditionCode.md)
* [Confidentiality Code (2.3.1 - 1.0.0)](CodeSystem-confidentialityCodes.md): [Hl7VSconfidentialityCode](ValueSet-hl7VSconfidentialityCode.md)
* [Coordination of Benefits (2.3.1 - 1.0.0)](CodeSystem-coordinationOfBenefits.md): [Hl7VScoordinationOfBenefits](ValueSet-hl7VScoordinationOfBenefits.md)
* [Coverage Type (2.3.1 - 1.0.0)](CodeSystem-coverageType.md): [Hl7VScoverageType](ValueSet-hl7VScoverageType.md)
* [CP Range Type (2.3.1 - 1.0.0)](CodeSystem-cpRangeType.md): [Hl7VSrangeType](ValueSet-hl7VSrangeType.md)
* [CWE statuses (2.3.1 - 1.0.0)](CodeSystem-cweStatuses.md): [Hl7VScweStatuses](ValueSet-hl7VScweStatuses.md)
* [Date/Time Selection Qualifier (2.3.1 - 1.0.0)](CodeSystem-date-timeSelectionQualifier.md): [Hl7VSdate-timeSelectionQualifier](ValueSet-hl7VSdate-timeSelectionQualifier.md)
* [Day Type (2.3.1 - 1.0.0)](CodeSystem-dayType.md): [Hl7VSdayType](ValueSet-hl7VSdayType.md)
* [Days of the Week (2.3.1 - 1.0.0)](CodeSystem-daysOfTheWeek.md): [Hl7VSdaysOfTheWeek](ValueSet-hl7VSdaysOfTheWeek.md)
* [Deferred Response Type (2.3.1 - 1.0.0)](CodeSystem-deferredResponseType.md): [Hl7VSdeferredResponseType](ValueSet-hl7VSdeferredResponseType.md)
* [Degree/license/certificate (2.3.1 - 1.0.0)](CodeSystem-degreeLicenseCertificate.md): [Hl7VSdegree](ValueSet-hl7VSdegree.md)
* [Delayed Acknowledgement Type (2.3.1 - 1.1.0)](CodeSystem-delayedAcknowledgmentType.md): [Hl7VSdelayedAcknowledgmentType](ValueSet-hl7VSdelayedAcknowledgmentType.md)
* [Derived Specimen (2.3.1 - 1.0.0)](CodeSystem-derivedSpecimen.md): [Hl7VSderivedSpecimen](ValueSet-hl7VSderivedSpecimen.md)
* [Diagnosis Classification (2.3.1 - 1.0.0)](CodeSystem-diagnosisClassification.md): [Hl7VSdiagnosisClassification](ValueSet-hl7VSdiagnosisClassification.md)
* [Diagnosis Priority (2.3.1 - 1.0.0)](CodeSystem-diagnosisPriority.md): [Hl7VSdiagnosisPriority](ValueSet-hl7VSdiagnosisPriority.md)
* [Diagnosis Type (2.3.1 - 1.0.0)](CodeSystem-diagnosisType.md): [Hl7VSdiagnosisType](ValueSet-hl7VSdiagnosisType.md)
* [Diagnostic Service Section ID (2.3.1 - 1.2.0)](CodeSystem-diagnosticServiceSectionId.md): [Hl7VSdiagnosticServiceSectionId](ValueSet-hl7VSdiagnosticServiceSectionId.md)
* [Diet Code Specification Type (2.3.1 - 1.0.0)](CodeSystem-dietCodeSpecificationType.md): [Hl7VSdietType](ValueSet-hl7VSdietType.md)
* [Disabled Person Code (2.3.1 - 1.0.0)](CodeSystem-disabilityInformationRelationship.md): [Hl7VSdisabledPerson](ValueSet-hl7VSdisabledPerson.md)
* [Discharge Disposition (2.3.1 - 1.0.0)](CodeSystem-dischargeDisposition.md): [Hl7VSVS-dischargeDisposition](ValueSet-hl7VSVS-dischargeDisposition.md)
* [Dispense Method (2.3.1 - 1.0.0)](CodeSystem-dispenseMethod.md): [Hl7VSdispenseMethod](ValueSet-hl7VSdispenseMethod.md)
* [Document Availability Status (2.3.1 - 1.1.0)](CodeSystem-documentAvailabilityStatus.md): [Hl7VSdocumentAvailabilityStatus](ValueSet-hl7VSdocumentAvailabilityStatus.md)
* [Document Completion Status (2.3.1 - 1.0.0)](CodeSystem-documentCompletionStatus.md): [Hl7VSdocumentCompletionStatus](ValueSet-hl7VSdocumentCompletionStatus.md)
* [Document Confidentiality Status (2.3.1 - 2.0.0)](CodeSystem-documentConfidentialityStatus2.md): [Hl7VSdocumentConfidentialityStatus](ValueSet-hl7VSdocumentConfidentialityStatus.md)
* [Document Storage Status (2.3.1 - 1.0.0)](CodeSystem-documentStorageStatus.md): [Hl7VSdocumentStorageStatus](ValueSet-hl7VSdocumentStorageStatus.md)
* [Document Type (2.3.1 - 1.0.0)](CodeSystem-documentType.md): [Hl7VSreportTypeCode](ValueSet-hl7VSreportTypeCode.md)
* [DRG Payor (2.3.1 - 1.0.0)](CodeSystem-drgPayor.md): [Hl7VSoutlierType](ValueSet-hl7VSoutlierType.md)
* [Duration Categories (2.3.1 - 1.0.1)](CodeSystem-durationCategories.md): [Hl7VSdurationCategories](ValueSet-hl7VSdurationCategories.md)
* [Eligibility Source (2.3.1 - 1.0.0)](CodeSystem-eligibilitySource.md): [Hl7VSeligibilitySource](ValueSet-hl7VSeligibilitySource.md)
* [Encoding (2.3.1 - 1.0.0)](CodeSystem-encoding.md): [Hl7VSencoding](ValueSet-hl7VSencoding.md)
* [Escort Required (2.3.1 - 1.0.0)](CodeSystem-escortRequired.md): [Hl7VSescortRequired](ValueSet-hl7VSescortRequired.md)
* [Event (2.3.1 - 1.3.0)](CodeSystem-event.md): [Hl7VSevent](ValueSet-hl7VSevent.md)
* [Event Consequence (2.3.1 - 1.0.0)](CodeSystem-eventConsequence.md): [Hl7VSeventConsequence](ValueSet-hl7VSeventConsequence.md)
* [Event Expected (2.3.1 - 1.0.0)](CodeSystem-eventExpected.md): [Hl7VSeventExpected](ValueSet-hl7VSeventExpected.md)
* [Event Qualification (2.3.1 - 1.0.0)](CodeSystem-eventQualification.md): [Hl7VSeventQualification](ValueSet-hl7VSeventQualification.md)
* [Event Reason (2.3.1 - 1.1.0)](CodeSystem-eventReason.md): [Hl7VSeventReason](ValueSet-hl7VSeventReason.md)
* [Event Reported To (2.3.1 - 1.0.0)](CodeSystem-eventReportedTo.md): [Hl7VSeventReportedTo](ValueSet-hl7VSeventReportedTo.md)
* [Event Seriousness (2.3.1 - 1.0.0)](CodeSystem-eventSeriousness.md): [Hl7VSeventSeriousness](ValueSet-hl7VSeventSeriousness.md)
* [Yes/No Indicator (2.3.1 - 1.0.0)](CodeSystem-expandedYes-NoIndicator.md): [Hl7VSyes-no-Indicator](ValueSet-hl7VSyes-no-Indicator.md)
* [Facility Type (2.3.1 - 1.0.0)](CodeSystem-facilityType.md): [Hl7VSfacilityType](ValueSet-hl7VSfacilityType.md)
* [File Level Event Code (2.3.1 - 1.0.0)](CodeSystem-file-levelEvent.md): [Hl7VSfile-levelEventCode](ValueSet-hl7VSfile-levelEventCode.md)
* [Filler Status Codes (2.3.1 - 1.1.0)](CodeSystem-fillerStatus.md): [Hl7VSfillerStatusCodes](ValueSet-hl7VSfillerStatusCodes.md)
* [Identifier Type (2.3.1 - 1.1.0)](CodeSystem-identifierType.md): [Hl7VSidentifierType](ValueSet-hl7VSidentifierType.md)
* [Identity May Be Divulged (2.3.1 - 1.0.0)](CodeSystem-identityMayBeDivulged.md): [Hl7VSidentityMayBeDivulged](ValueSet-hl7VSidentityMayBeDivulged.md)
* [Indirect Exposure Mechanism (2.3.1 - 1.0.0)](CodeSystem-indirectExposureMechanism.md): [Hl7VSindirectExposureMechanism](ValueSet-hl7VSindirectExposureMechanism.md)
* [Invocation Event (2.3.1 - 1.0.0)](CodeSystem-invocationEvent.md): [Hl7VSwhenToCharge](ValueSet-hl7VSwhenToCharge.md)
* [Kind of Quantity (2.3.1 - 1.0.0)](CodeSystem-kindOfQuantity.md): [Hl7VSkindOfQuantity](ValueSet-hl7VSkindOfQuantity.md)
* [Level of Care (2.3.1 - 1.0.0)](CodeSystem-levelOfCare.md): [Hl7VSlevelOfCare](ValueSet-hl7VSlevelOfCare.md)
* [Living Arrangement (2.3.1 - 1.1.0)](CodeSystem-livingArrangement.md): [Hl7VSlivingArrangement](ValueSet-hl7VSlivingArrangement.md)
* [Living Dependency (2.3.1 - 1.0.0)](CodeSystem-livingDependency.md): [Hl7VSlivingDependency](ValueSet-hl7VSlivingDependency.md)
* [Living Will Code (2.3.1 - 1.0.0)](CodeSystem-livingWillCodes.md): [Hl7VSlivingWill](ValueSet-hl7VSlivingWill.md)
* [Location Characteristic ID (2.3.1 - 1.0.0)](CodeSystem-locationCharacteristic.md): [Hl7VSlocationCharacteristicId](ValueSet-hl7VSlocationCharacteristicId.md)
* [Location Equipment (2.3.1 - 1.0.0)](CodeSystem-locationEquipment.md): [Hl7VSlocationEquipment](ValueSet-hl7VSlocationEquipment.md)
* [Location Relationship ID (2.3.1 - 1.0.0)](CodeSystem-locationRelationship.md): [Hl7VSlocationRelationshipId](ValueSet-hl7VSlocationRelationshipId.md)
* [Mail Claim Party (2.3.1 - 1.0.0)](CodeSystem-mailClaimParty.md): [Hl7VSmailClaimParty](ValueSet-hl7VSmailClaimParty.md)
* [Manufacturers of Vaccines (code=MVX) (2.3.1 - 1.1.0)](CodeSystem-manufacturersOfVaccinesHL7.md): [Hl7VSmanufacturersOfVaccines](ValueSet-hl7VSmanufacturersOfVaccines.md)
* [Marital Status (2.3.1 - 1.0.0)](CodeSystem-maritalStatus.md): [Hl7VSmaritalStatus](ValueSet-hl7VSmaritalStatus.md)
* [Marketing Basis (2.3.1 - 1.0.0)](CodeSystem-marketingBasis.md): [Hl7VSmarketingBasis](ValueSet-hl7VSmarketingBasis.md)
* [Master File Identifier Code (2.3.1 - 1.0.0)](CodeSystem-masterFileIdentifierCodes.md): [Hl7VSmasterFileIdentifierCode](ValueSet-hl7VSmasterFileIdentifierCode.md)
* [Record-level Event Code (2.3.1 - 1.0.0)](CodeSystem-masterfileActionCode.md): [Hl7VSmasterfileActionCode](ValueSet-hl7VSmasterfileActionCode.md)
* [Message Error Condition Codes (2.3.1 - 1.0.0)](CodeSystem-messageErrorCondition.md): [Hl7VSmessageErrorConditionCodes](ValueSet-hl7VSmessageErrorConditionCodes.md)
* [Message Structure (2.3.1 - 1.0.0)](CodeSystem-messageStructure.md): [Hl7VSmessageStructure](ValueSet-hl7VSmessageStructure.md)
* [Message Type (2.3.1 - 1.3.0)](CodeSystem-messageType.md): [Hl7VSmessageType](ValueSet-hl7VSmessageType.md)
* [MFN Record-level Error Return (2.3.1 - 1.0.0)](CodeSystem-mfnRecord-levelErrorReturn.md): [Hl7VSmfnRecode-levelErrorReturn](ValueSet-hl7VSmfnRecode-levelErrorReturn.md)
* [Military Rank/Grade (2.3.1 - 1.0.0)](CodeSystem-militaryRank-Grade.md): [Hl7VSmilitaryRank-Grade](ValueSet-hl7VSmilitaryRank-Grade.md)
* [Military Service (2.3.1 - 1.0.0)](CodeSystem-militaryService.md): [Hl7VSmilitaryService](ValueSet-hl7VSmilitaryService.md)
* [Military Status (2.3.1 - 1.0.0)](CodeSystem-militaryStatus.md): [Hl7VSmilitaryStatus](ValueSet-hl7VSmilitaryStatus.md)
* [MIME base64 encoding Characters (2.3.1 - 1.0.0)](CodeSystem-mimeBase64EncodingCharacters.md): [Hl7VSmimeBase64EncodingCharacters](ValueSet-hl7VSmimeBase64EncodingCharacters.md)
* [Modality (2.3.1 - 1.0.0)](CodeSystem-modality.md): [Hl7VSmodality](ValueSet-hl7VSmodality.md)
* [Money or Percentage Indicator (2.3.1 - 1.0.0)](CodeSystem-moneyOrPercentageIndicator.md): [Hl7VSpenaltyType](ValueSet-hl7VSpenaltyType.md)
* [NameAddress representation (2.3.1 - 1.0.0)](CodeSystem-name-addressRepresentation.md): [Hl7VSname-addressRepresentation](ValueSet-hl7VSname-addressRepresentation.md)
* [Name Type (2.3.1 - 1.1.0)](CodeSystem-nameType.md): [Hl7VSnameType](ValueSet-hl7VSnameType.md)
* [Nature of Abnormal Testing (2.3.1 - 1.0.0)](CodeSystem-natureOfAbnormalTesting.md): [Hl7VSnatureOfAbnormalTesting](ValueSet-hl7VSnatureOfAbnormalTesting.md)
* [Nature of Challenge (2.3.1 - 1.0.0)](CodeSystem-natureOfChallenge.md): [Hl7VSnatureOfChallenge](ValueSet-hl7VSnatureOfChallenge.md)
* [Nature of Service/Test/Observation (2.3.1 - 1.0.0)](CodeSystem-natureOfServiceTestObservation.md): [Hl7VSnatureOfServiceTestObservation](ValueSet-hl7VSnatureOfServiceTestObservation.md)
* [Occurrence Code (2.3.1 - 1.0.0)](CodeSystem-nubc-OccurrenceCode-cs.md): [Hl7VSoccurrenceCode](ValueSet-hl7VSoccurrenceCode.md)
* [Occurrence Span (2.3.1 - 1.0.0)](CodeSystem-nubc-OccurrenceSpan-cs.md): [Hl7VSoccurrenceSpan](ValueSet-hl7VSoccurrenceSpan.md)
* [Abnormal Flags (2.3.1 - 1.3.0)](CodeSystem-observationInterpretation.md): [Hl7VSinterpretationCode](ValueSet-hl7VSinterpretationCode.md)
* [Observation Result Status Codes Interpretation (2.3.1 - 1.2.0)](CodeSystem-observationResultStatusCodesInterpretation.md): [Hl7VSobservationResultStatus](ValueSet-hl7VSobservationResultStatus.md)
* [Order Control Codes (2.3.1 - 1.3.0)](CodeSystem-orderControlCodes.md): [Hl7VSorderControl](ValueSet-hl7VSorderControl.md)
* [Order Status (2.3.1 - 1.2.0)](CodeSystem-orderStatus.md): [Hl7VSorderStatus](ValueSet-hl7VSorderStatus.md)
* [Organ Donor Code (2.3.1 - 1.1.0)](CodeSystem-organDonorCodes.md): [Hl7VSorganDonor](ValueSet-hl7VSorganDonor.md)
* [Organizational Name Type (2.3.1 - 1.0.0)](CodeSystem-organizationalNameType.md): [Hl7VSorganizationalNameType](ValueSet-hl7VSorganizationalNameType.md)
* [Override (2.3.1 - 1.0.0)](CodeSystem-override.md): [Hl7VSoverride](ValueSet-hl7VSoverride.md)
* [Patient Class (2.3.1 - 1.1.0)](CodeSystem-patientClass.md): [Hl7VSpatientClass](ValueSet-hl7VSpatientClass.md)
* [Patient Location Type (2.3.1 - 1.0.0)](CodeSystem-patientLocationType.md): [Hl7VSpatientLocationType](ValueSet-hl7VSpatientLocationType.md)
* [Patient Outcome (2.3.1 - 1.0.0)](CodeSystem-patientOutcome.md): [Hl7VSpatientOutcome](ValueSet-hl7VSpatientOutcome.md)
* [Patient's Relationship to Insured (2.3.1 - 1.0.0)](CodeSystem-patientsRelationshipToInsured.md): [Hl7VSpatient_sRelationshipToInsured](ValueSet-hl7VSpatient_sRelationshipToInsured.md)
* [Policy Type (2.3.1 - 1.0.0)](CodeSystem-policyType.md): [Hl7VSpolicyType](ValueSet-hl7VSpolicyType.md)
* [Practitioner ID Number Type (2.3.1 - 1.0.0)](CodeSystem-practitionerIdNumberType.md): [Hl7VSpractitionerIdNumberType](ValueSet-hl7VSpractitionerIdNumberType.md)
* [Preferred Method of Contact (2.3.1 - 1.1.0)](CodeSystem-preferredMethodOfContact.md): [Hl7VSpreferredMethodOfContrct](ValueSet-hl7VSpreferredMethodOfContrct.md)
* [Price Type (2.3.1 - 1.0.0)](CodeSystem-priceType.md): [Hl7VSpriceType](ValueSet-hl7VSpriceType.md)
* [Primary Key Value Type (2.3.1 - 1.0.0)](CodeSystem-primaryKeyValueType.md): [Hl7VSprimaryKeyValueType](ValueSet-hl7VSprimaryKeyValueType.md)
* [Primary Observer's Qualification (2.3.1 - 1.0.0)](CodeSystem-primaryObserverQualification.md): [Hl7VSprimaryObserver_sQualification](ValueSet-hl7VSprimaryObserver_sQualification.md)
* [Priority (2.3.1 - 1.2.0)](CodeSystem-priority.md): [Hl7VSpriority](ValueSet-hl7VSpriority.md)
* [Privacy Level (2.3.1 - 1.0.0)](CodeSystem-privacyLevel.md): [Hl7VSprivacyLevel](ValueSet-hl7VSprivacyLevel.md)
* [Procedure Functional Type (2.3.1 - 1.0.0)](CodeSystem-procedureFunctionalType.md): [Hl7VSprocedureFunctionalType](ValueSet-hl7VSprocedureFunctionalType.md)
* [Procedure Practitioner Identifier Type (2.3.1 - 1.1.0)](CodeSystem-procedurePractitionerIdentifierCodeType.md): [Hl7VSprocedurePractitionerType](ValueSet-hl7VSprocedurePractitionerType.md)
* [Processing ID (2.3.1 - 1.0.0)](CodeSystem-processingId.md): [Hl7VSprocessingId](ValueSet-hl7VSprocessingId.md)
* [Processing Mode (2.3.1 - 1.1.0)](CodeSystem-processingMode.md): [Hl7VSprocessingMode](ValueSet-hl7VSprocessingMode.md)
* [Processing Priority (2.3.1 - 1.0.0)](CodeSystem-processingPriority.md): [Hl7VSprocessingPriority](ValueSet-hl7VSprocessingPriority.md)
* [Product Source (2.3.1 - 1.0.0)](CodeSystem-productSource.md): [Hl7VSproductSource](ValueSet-hl7VSproductSource.md)
* [Provider Billing (2.3.1 - 1.0.0)](CodeSystem-providerBilling.md): [Hl7VSproviderBilling](ValueSet-hl7VSproviderBilling.md)
* [Provider Role (2.3.1 - 1.0.0)](CodeSystem-providerRole.md): [Hl7VSproviderRole](ValueSet-hl7VSproviderRole.md)
* [Purge Status Code (2.3.1 - 1.0.0)](CodeSystem-purgeStatus.md): [Hl7VSpurgeStatus](ValueSet-hl7VSpurgeStatus.md)
* [Quantity Limited Request (2.3.1 - 1.1.0)](CodeSystem-quantityLimitedRequest.md): [Hl7VSquantityLimitedRequest](ValueSet-hl7VSquantityLimitedRequest.md)
* [Quantity Method (2.3.1 - 1.0.0)](CodeSystem-quantityMethod.md): [Hl7VSquantityMethod](ValueSet-hl7VSquantityMethod.md)
* [Query Priority (2.3.1 - 1.0.0)](CodeSystem-queryPriority.md): [Hl7VSqueryPriority](ValueSet-hl7VSqueryPriority.md)
* [Query/Response Format Code (2.3.1 - 1.2.0)](CodeSystem-queryResponseFormat.md): [Hl7VSqueryFormatCode](ValueSet-hl7VSqueryFormatCode.md)
* [Query Response Status (2.3.1 - 1.1.0)](CodeSystem-queryResponseStatus.md): [Hl7VSqueryResponseStatus](ValueSet-hl7VSqueryResponseStatus.md)
* [Query Results Level (2.3.1 - 1.0.2)](CodeSystem-queryResultsLevel.md): [Hl7VSqueryResultsLevel](ValueSet-hl7VSqueryResultsLevel.md)
* [Referral Category (2.3.1 - 1.0.0)](CodeSystem-referralCategory.md): [Hl7VSreferralCategory](ValueSet-hl7VSreferralCategory.md)
* [Referral Disposition (2.3.1 - 1.0.0)](CodeSystem-referralDisposition.md): [Hl7VSreferralDisposition](ValueSet-hl7VSreferralDisposition.md)
* [Referral Priority (2.3.1 - 1.0.0)](CodeSystem-referralPriority.md): [Hl7VSreferralPriority](ValueSet-hl7VSreferralPriority.md)
* [Referral Reason (2.3.1 - 1.0.0)](CodeSystem-referralReason.md): [Hl7VSreferralReason](ValueSet-hl7VSreferralReason.md)
* [Referral Status (2.3.1 - 1.0.0)](CodeSystem-referralStatus.md): [Hl7VSreferralStatus](ValueSet-hl7VSreferralStatus.md)
* [Referral Type (2.3.1 - 1.0.0)](CodeSystem-referralType.md): [Hl7VSreferralType](ValueSet-hl7VSreferralType.md)
* [Relatedness Assessment (2.3.1 - 1.0.0)](CodeSystem-relatednessAssessment.md): [Hl7VSrelatednessAssessment](ValueSet-hl7VSrelatednessAssessment.md)
* [Relational Conjunction (2.3.1 - 1.0.0)](CodeSystem-relationalConjunction.md): [Hl7VSrelationalConjunction](ValueSet-hl7VSrelationalConjunction.md)
* [Relational Operator (2.3.1 - 1.0.0)](CodeSystem-relationalOperator.md): [Hl7VSrelationalOperator](ValueSet-hl7VSrelationalOperator.md)
* [Relationship Modifier (2.3.1 - 1.0.0)](CodeSystem-relationshipModifier.md): [Hl7VSrelationshipModifier](ValueSet-hl7VSrelationshipModifier.md)
* [Report Priority (2.3.1 - 1.0.0)](CodeSystem-reportPriority.md): [Hl7VSreportPriority](ValueSet-hl7VSreportPriority.md)
* [Report Source (2.3.1 - 1.0.0)](CodeSystem-reportSource.md): [Hl7VSreportSource](ValueSet-hl7VSreportSource.md)
* [Report Timing (2.3.1 - 1.0.0)](CodeSystem-reportTiming.md): [Hl7VSreportTiming](ValueSet-hl7VSreportTiming.md)
* [Reporting Priority (2.3.1 - 1.0.0)](CodeSystem-reportingPriority.md): [Hl7VSreportingPriority](ValueSet-hl7VSreportingPriority.md)
* [Response Flag (2.3.1 - 1.0.0)](CodeSystem-responseFlag.md): [Hl7VSresponseFlag](ValueSet-hl7VSresponseFlag.md)
* [Response Level (2.3.1 - 1.0.0)](CodeSystem-responseLevel.md): [Hl7VSresponseLevel](ValueSet-hl7VSresponseLevel.md)
* [Result Status (2.3.1 - 1.2.0)](CodeSystem-resultStatus.md): [Hl7VSresultStatus-Obr](ValueSet-hl7VSresultStatus-Obr.md)
* [Room Type (2.3.1 - 1.0.0)](CodeSystem-roomType.md): [Hl7VSroomType](ValueSet-hl7VSroomType.md)
* [Route of Administration (2.3.1 - 3.0.0)](CodeSystem-routeOfAdministration.md): [Hl7VSrouteOfAdministration](ValueSet-hl7VSrouteOfAdministration.md)
* [RX Component Type (2.3.1 - 1.0.0)](CodeSystem-rxComponentType.md): [Hl7VSrxComponentType](ValueSet-hl7VSrxComponentType.md)
* [Segment Action Code (2.3.1 - 1.0.0)](CodeSystem-segmentAction.md): [Hl7VSsegmentActionCode](ValueSet-hl7VSsegmentActionCode.md)
* [Sex (2.3.1 - 1.0.0)](CodeSystem-sex.md): [Hl7VSsex](ValueSet-hl7VSsex.md)
* [Source of Comment (2.3.1 - 1.1.0)](CodeSystem-sourceOfComment.md): [Hl7VSsourceOfComment](ValueSet-hl7VSsourceOfComment.md)
* [Source Type (2.3.1 - 1.0.0)](CodeSystem-sourceType.md): [Hl7VSnetworkSourceType](ValueSet-hl7VSnetworkSourceType.md)
* [Specialty Type (2.3.1 - 1.0.0)](CodeSystem-specialtyType.md): [Hl7VSspecialtyType](ValueSet-hl7VSspecialtyType.md)
* [Specimen Source Codes (2.3.1 - 1.2.0)](CodeSystem-specimenSourceCodes.md): [Hl7VSsourceOfSpecimen](ValueSet-hl7VSsourceOfSpecimen.md)
* [Status of Evaluation (2.3.1 - 1.0.0)](CodeSystem-statusOfEvaluation.md): [Hl7VSstartOfEvaluation](ValueSet-hl7VSstartOfEvaluation.md)
* [Student Status (2.3.1 - 1.0.0)](CodeSystem-studentStatus.md): [Hl7VSstudentStatus](ValueSet-hl7VSstudentStatus.md)
* [Substitution Status (2.3.1 - 1.1.0)](CodeSystem-substitutionStatus.md): [Hl7VSsubstitutionStatus](ValueSet-hl7VSsubstitutionStatus.md)
* [Subtype of Referenced Data (2.3.1 - 1.1.0)](CodeSystem-subtypeOfReferencedData.md): [Hl7VSsubtypeOfReferencedData](ValueSet-hl7VSsubtypeOfReferencedData.md)
* [Telecommunication Equipment Type (2.3.1 - 1.0.0)](CodeSystem-telecommunicationEquipmentType.md): [Hl7VStelecommunicationEquipmentType](ValueSet-hl7VStelecommunicationEquipmentType.md)
* [Telecommunication Use Code (2.3.1 - 1.1.0)](CodeSystem-telecommunicationUse.md): [Hl7VStelecommunicationUseCode](ValueSet-hl7VStelecommunicationUseCode.md)
* [Time Delay Post Challenge (2.3.1 - 1.0.0)](CodeSystem-timeDelayPostChallenge.md): [Hl7VStimeDelayPostChallenge](ValueSet-hl7VStimeDelayPostChallenge.md)
* [Time Selection Criteria Parameter Class Codes (2.3.1 - 1.0.0)](CodeSystem-timeSelectionCriteriaParameterClass.md): [Hl7VStimeSelectionCriteriaParameterClassCodes](ValueSet-hl7VStimeSelectionCriteriaParameterClassCodes.md)
* [Transaction Type (2.3.1 - 1.0.0)](CodeSystem-transactionType.md): [Hl7VStransactionType](ValueSet-hl7VStransactionType.md)
* [Transport Arranged (2.3.1 - 1.0.0)](CodeSystem-transportArranged.md): [Hl7VStransportArranged](ValueSet-hl7VStransportArranged.md)
* [Transportation Mode (2.3.1 - 1.0.0)](CodeSystem-transportationMode.md): [Hl7VStransportationMode](ValueSet-hl7VStransportationMode.md)
* [Tray Type (2.3.1 - 1.0.0)](CodeSystem-trayType.md): [Hl7VStrayType](ValueSet-hl7VStrayType.md)
* [Type of Referenced Data (2.3.1 - 1.2.0)](CodeSystem-typeOfReferencedData.md): [Hl7VStypeOfData](ValueSet-hl7VStypeOfData.md)
* [Universal ID Type (2.3.1 - 1.0.0)](CodeSystem-universalIdType.md): [Hl7VSuniversalIdType](ValueSet-hl7VSuniversalIdType.md)
* [Vaccines Administered (2.3.1 - 1.1.0)](CodeSystem-vaccinesAdministeredHL7.md): [Hl7VSvaccinesAdministered](ValueSet-hl7VSvaccinesAdministered.md)
* [Version ID (2.3.1 - 1.3.0)](CodeSystem-versionId.md): [Hl7VSversionControlTable](ValueSet-hl7VSversionControlTable.md)
* [Visit Indicator (2.3.1 - 1.0.0)](CodeSystem-visitIndicator.md): [Hl7VSvisitIndicator](ValueSet-hl7VSvisitIndicator.md)
* [What subject filter (2.3.1 - 1.3.0)](CodeSystem-whatSubjectFilter.md): [Hl7VSwhatSubjectFilter](ValueSet-hl7VSwhatSubjectFilter.md)
* [Which Date/Time Qualifier (2.3.1 - 1.1.0)](CodeSystem-whichDate-timeQualifier.md): [Hl7VSwhichDate-timeQualifier](ValueSet-hl7VSwhichDate-timeQualifier.md)
* [Which Date/Time Status Qualifier (2.3.1 - 1.0.0)](CodeSystem-whichDate-timeStatusQualifier.md): [Hl7VSwhichDate-timeStatusQualifier](ValueSet-hl7VSwhichDate-timeStatusQualifier.md)


