# Artifacts Summary - HL7 v2.3.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [V2CodeSystem](StructureDefinition-V2CodeSystem.md) | Profile for CodeSystem instances generated in this guide. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Codesystem tableNo](StructureDefinition-codesystem-tableNo.md) | extension for tableNo |
| [Codesystem v2versionCreated](StructureDefinition-codesystem-v2versionCreated.md) | extension for v2versionCreated |
| [Codesystem versionHistory](StructureDefinition-codesystem-versionHistory.md) | extension for versionHistory |
| [Codesystem versionIntroduced](StructureDefinition-codesystem-versionIntroduced.md) | extension for versionIntroduced |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Abnormal Flags (2.3.1 - 1.3.0)](ValueSet-hl7VSinterpretationCode.md) | A categorical assessment, providing a rough qualitative interpretation of the observation value, such as “normal”/ “abnormal”,”low” / “high”, “better” / “worse”, “susceptible” / “resistant”, “expected”/ “not expected”. The value set is intended to be for ANY use where coded representation of an interpretation is needed. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. Historically these values come from the laboratory domain, and these codes are extensively used. The value set binding is extensible, so codes outside the value set that are needed for interpretation concepts (i.e. particular meanings) that are not included in the value set can be used, and these new codes may also be added to the value set and published in a future version. |
| [Accept/Application Acknowledgment Conditions (2.3.1 - 1.0.0)](ValueSet-hl7VSaccept-applicationAcknowledgmentConditions.md) | Concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. |
| [Acknowledgment Code (2.3.1 - 1.2.0)](ValueSet-hl7VSacknowledgmentCode.md) | Concepts specifying acknowledgment codes used in Version 2.x message. For details of usage, see message processing rules in the published Standard. |
| [Action Code (2.3.1 - 1.0.0)](ValueSet-hl7VSactionCode.md) | Status codes of record operations. |
| [Action Taken in Response to the Event (2.3.1 - 1.0.0)](ValueSet-hl7VSactionTakenInResponseToTheEvent.md) | Value Set of codes that define the action taken as a result of an event related to a product issue. |
| [Active/Inactive (2.3.1 - 1.0.0)](ValueSet-hl7VSactive-inactive.md) | Value Set of codes that specify whether a person is currently a valid staff member. |
| [Address Type (2.3.1 - 1.2.0)](ValueSet-hl7VSaddressType.md) | Concepts specifying types or kinds of addresses. |
| [Administration Device (2.3.1 - 1.0.0)](ValueSet-hl7VSadministrationDevice.md) | Value Set of codes that specify the mechanical device used to aid in the administration of the drug or other treatment. Common examples are IV-sets of different types. |
| [Administration Method (2.3.1 - 1.0.0)](ValueSet-hl7VSadministrationMethod.md) | Value Set of codes that specify the specific method requested for the administration of the drug or treatment to the patient. |
| [Administrative Site (2.3.1 - 1.1.0)](ValueSet-hl7VSadministriveSite.md) | Concepts that specify a body site from which a specimen is obtained. |
| [Admission Type (2.3.1 - 1.0.0)](ValueSet-hl7VSadmissionType.md) | Value Set of codes that specify the circumstances under which the patient was or will be admitted. |
| [Admit Source (2.3.1 - 1.0.0)](ValueSet-hl7VSadmitSource.md) | Value Set of codes that specify where the patient was admitted. No suggested values. |
| [Advanced Beneficiary Notice Code (2.3.1 - 1.0.0)](ValueSet-hl7VSadvancedBeneficiaryNoticeCode.md) | Status codes specifying a patient's or a patient's representative's consent for responsibility to pay for potentially uninsured services. Note that this set of codes is generally used in the US only. |
| [Allergy Severity (2.3.1 - 1.0.0)](ValueSet-hl7VSallergySeverity.md) | Value Set of codes that specify the general severity of an allergy. |
| [Allergy Type (2.3.1 - 1.0.0)](ValueSet-hl7VSallergyType.md) | Value Set of codes that specify classification of general allergy categories (drug, food, pollen, etc.). |
| [Allow Substitution (2.3.1 - 1.0.0)](ValueSet-hl7VSallowSubstitution.md) | Value Set of codes that specify whether substitutions are allowed and, if so, the type of substitutions allowed. |
| [Allow Substitution Codes (2.3.1 - 1.1.0)](ValueSet-hl7VSallowSubstitutionCodes.md) | Value Set of codes that indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment. |
| [Alternate Character Set Handling Scheme (2.3.1 - 1.0.0)](ValueSet-hl7VSalternateCharacterSetHandlingScheme.md) | Concepts that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed. |
| [Alternate Character Sets (2.3.1 - 1.1.0)](ValueSet-hl7VSalternateCharacterSets.md) | Value Set of codes that identify one of a number of possible standard alternate character sets for a message, either single-byte or double-byte. |
| [Ambulatory Status (2.3.1 - 1.0.0)](ValueSet-hl7VSambulatoryStatus.md) | Value Set of codes that specify permanent or transient handicapped conditions of a person. |
| [Amount Class (2.3.1 - 1.0.0)](ValueSet-hl7VSamountClass.md) | Value Set of codes that specify the amount quantity class. |
| [Amount Type (2.3.1 - 1.0.0)](ValueSet-hl7VSamountType.md) | Value Set of codes that specify amount quantity type. |
| [Annotations (2.3.1 - 1.0.0)](ValueSet-hl7VSannotations.md) | Value Set of codes that specify the coded entry associated with a given point in time during the waveform recording. Note codes beyond 9903 may exist; extensions to this table may be done by incrementing the code value. |
| [Appointment Reason Codes (2.3.1 - 1.0.0)](ValueSet-hl7VSappointmentReasonCodes.md) | Value Set of codes that describe the kind of appointment or the reason why an appointment has been scheduled. |
| [Appointment Type Codes (2.3.1 - 1.0.0)](ValueSet-hl7VSappointmentTypeCodes.md) | Value Set of codes that an appointment request to describe the kind of appointment. |
| [Assignment of Benefits (2.3.1 - 1.0.0)](ValueSet-hl7VSassignmentOfBenefits.md) | Value Set of codes which indicate whether an insured person agreed to assign the insurance benefits to a healthcare provider. If so, the insurance will pay the provider directly. |
| [Bed Status (2.3.1 - 1.1.0)](ValueSet-hl7VSbedStatus.md) | Value Set of codes that specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not. |
| [CP Range Type (2.3.1 - 1.0.0)](ValueSet-hl7VSrangeType.md) | Value Set of codes that specify whether a composite price range is experssed as a flat rate or a percentage. |
| [CWE statuses (2.3.1 - 1.0.0)](ValueSet-hl7VScweStatuses.md) | Concepts that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended). These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in Version 2 messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype. |
| [Causality Observations (2.3.1 - 1.0.0)](ValueSet-hl7VScausalityObservations.md) | Value Set of codes that record event observations regarding what may have caused a product related event. |
| [Certification Patient Type (2.3.1 - 1.0.0)](ValueSet-hl7VSprecertificationPatientType.md) | Value Set of codes that specify the category or type of patient for which this certification is requested. |
| [Certification Status (2.3.1 - 1.0.0)](ValueSet-hl7VScertificationStatus.md) | Value Set of codes that specify the status of the practitioner's speciality certification. |
| [Charge On Indicator (2.3.1 - 1.0.0)](ValueSet-hl7VSchargeOnIndicator.md) | Value Set of codes that define the event upon which a charge should be generated. |
| [Charge Type (2.3.1 - 1.0.0)](ValueSet-hl7VSchargeType.md) | Value Set of codes that specify someone or something other than the patient to be billed for a service. |
| [Check Digit Scheme (2.3.1 - 1.2.0)](ValueSet-hl7VScheckDigitScheme.md) | Concepts used to identify the check digit scheme employed when a check digit is used in various HL7 Version 2.x datatypes. |
| [Comment Type (2.3.1 - 1.0.0)](ValueSet-hl7VScommentType.md) | Value Set of codes that identify the type of comment text being sent in the specific comment record. |
| [Completion Status (2.3.1 - 1.0.0)](ValueSet-hl7VScompletionStatus.md) | Status codes used in the workflow of treatment administration events. |
| [Condition Code (2.3.1 - 1.0.0)](ValueSet-hl7VSconditionCode.md) | Value Set of codes that specify the condition code. |
| [Confidentiality Code (2.3.1 - 1.0.0)](ValueSet-hl7VSconfidentialityCode.md) | Value Set of codes that specify the degree to which special confidentiality protection should be applied to the observation. |
| [Coordination of Benefits (2.3.1 - 1.0.0)](ValueSet-hl7VScoordinationOfBenefits.md) | Value Set of codes that specify whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient. |
| [Coverage Type (2.3.1 - 1.0.0)](ValueSet-hl7VScoverageType.md) | Note that this set of codes is used generally in the US only. |
| [DRG Payor (2.3.1 - 1.0.0)](ValueSet-hl7VSoutlierType.md) | Value Set of codes that identify a Diagnostic Resource Group Payor. US Realm. No suggested values. |
| [Date/Time Selection Qualifier (2.3.1 - 1.0.0)](ValueSet-hl7VSdate-timeSelectionQualifier.md) | Value Set of codes that allow the specification of certain types of values within the date/time range. |
| [Day Type (2.3.1 - 1.0.0)](ValueSet-hl7VSdayType.md) | Value Set of codes that specify whether the days are denied, pending or approved. |
| [Days of the Week (2.3.1 - 1.0.0)](ValueSet-hl7VSdaysOfTheWeek.md) | Value Set of codes that identify the day(s) of the week when a location may be scheduled for appointments. |
| [Deferred Response Type (2.3.1 - 1.0.0)](ValueSet-hl7VSdeferredResponseType.md) | Value Set of codes which specify which type of deferred query resonse is desired, as specified with the query parameters. |
| [Degree/license/certificate (2.3.1 - 1.0.0)](ValueSet-hl7VSdegree.md) | Concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging. Used in Version 2 messaging; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7. |
| [Delayed Acknowledgement Type (2.3.1 - 1.1.0)](ValueSet-hl7VSdelayedAcknowledgmentType.md) | Concepts which specify a response type used in deferred processing two phase reply for delayed acknowldgement mode of the original acknowledgement mechanism defined in HL7 Version 2.x messaging. |
| [Derived Specimen (2.3.1 - 1.0.0)](ValueSet-hl7VSderivedSpecimen.md) | Value Set of codes that specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture). The pro |
| [Diagnosis Classification (2.3.1 - 1.0.0)](ValueSet-hl7VSdiagnosisClassification.md) | Value Set of codes that classify whether a patient visit can be related to a diagnosis. |
| [Diagnosis Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSdiagnosisPriority.md) | Concepts that identify the significance or priority of the diagnosis code. Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis. Used in the DG1 segment in Version 2 messaging. |
| [Diagnosis Type (2.3.1 - 1.0.0)](ValueSet-hl7VSdiagnosisType.md) | Concepts specifying a type of diagnosis being sent in HL7 Version 2.x messages. |
| [Diagnostic Service Section ID (2.3.1 - 1.2.0)](ValueSet-hl7VSdiagnosticServiceSectionId.md) | Concepts which specify a section of a diagnostic service where the observation may be performed. |
| [Diet Code Specification Type (2.3.1 - 1.0.0)](ValueSet-hl7VSdietType.md) | Value Set of codes that specify the type of diet. |
| [Disabled Person Code (2.3.1 - 1.0.0)](ValueSet-hl7VSdisabledPerson.md) | Value Set of codes that specify to which person the disability information relates in the message. For example, if the value is PT, the disability information relates to the patient. |
| [Discharge Disposition (2.3.1 - 1.0.0)](ValueSet-hl7VSVS-dischargeDisposition.md) | Value Set of codes that specify the disposition of the patient at time of discharge (i.e., discharged to home, expired, etc.). No suggested values. In the US, this field should use the Official Uniform Billing (UB) 04 2008 numeric codes found on form |
| [Dispense Method (2.3.1 - 1.0.0)](ValueSet-hl7VSdispenseMethod.md) | Value Set of codes that specify the method by which treatment is dispensed. |
| [Document Availability Status (2.3.1 - 1.1.0)](ValueSet-hl7VSdocumentAvailabilityStatus.md) | Value Set of codes that define whether a patient document is appropriate or available for use in patient care. |
| [Document Completion Status (2.3.1 - 1.0.0)](ValueSet-hl7VSdocumentCompletionStatus.md) | Value Set of codes that record the state of a document in a workflow. |
| [Document Confidentiality Status (2.3.1 - 2.0.0)](ValueSet-hl7VSdocumentConfidentialityStatus.md) | Value Set of codes that specify the degree to which special confidentiality protection should be applied to information. The assignment of data elements to these categories is left to the discretion of the healthcare organization. |
| [Document Storage Status (2.3.1 - 1.0.0)](ValueSet-hl7VSdocumentStorageStatus.md) | Value Set of codes that describe the availability of a document in relation to the type of storage. |
| [Document Type (2.3.1 - 1.0.0)](ValueSet-hl7VSreportTypeCode.md) | Value Set of codes that identify the kind of patient document. |
| [Duration Categories (2.3.1 - 1.0.1)](ValueSet-hl7VSdurationCategories.md) | Value Set of codes that classify an observation definition as intended to measure a patient's state at a point in time. |
| [Eligibility Source (2.3.1 - 1.0.0)](ValueSet-hl7VSeligibilitySource.md) | Value Set of codes that specify the source of information about the insured's eligibility for benefits. |
| [Encoding (2.3.1 - 1.0.0)](ValueSet-hl7VSencoding.md) | Concept identifying the type of IETF encoding used to represent successive octets of binary data as displayable ASCII characters. |
| [Escort Required (2.3.1 - 1.0.0)](ValueSet-hl7VSescortRequired.md) | Value Set of codes indicating whether a patient must be accompanied while travelling to a diagnostic service department. |
| [Event (2.3.1 - 1.3.0)](ValueSet-hl7VSevent.md) | Concepts specifying the trigger event for Version 2.x interface messages. |
| [Event Consequence (2.3.1 - 1.0.0)](ValueSet-hl7VSeventConsequence.md) | Value Set of codes that describe the impact of an event on a patient. |
| [Event Expected (2.3.1 - 1.0.0)](ValueSet-hl7VSeventExpected.md) | Value Set of codes that communicate whether an event has been judged to be expected or unexpected. |
| [Event Qualification (2.3.1 - 1.0.0)](ValueSet-hl7VSeventQualification.md) | Value Set of codes that qualify an event related to a product experience. |
| [Event Reason (2.3.1 - 1.1.0)](ValueSet-hl7VSeventReason.md) | Value Set of codes that specify the reason for an event. |
| [Event Reported To (2.3.1 - 1.0.0)](ValueSet-hl7VSeventReportedTo.md) | Value Set of codes that identify the type of entity to which the event has been reported. |
| [Event Seriousness (2.3.1 - 1.0.0)](ValueSet-hl7VSeventSeriousness.md) | Value Set of codes that a sender to designate an event as serious or significant. |
| [Facility Type (2.3.1 - 1.0.0)](ValueSet-hl7VSfacilityType.md) | Value Set of codes that specify the type of facility. |
| [File Level Event Code (2.3.1 - 1.0.0)](ValueSet-hl7VSfile-levelEventCode.md) | Concepts specifying file-level events for master files. Used in HL7 Version 2 messaging in the MFI segment. |
| [Filler Status Codes (2.3.1 - 1.1.0)](ValueSet-hl7VSfillerStatusCodes.md) | Value Set of codes that describe an appointment status from the perspective of the entity assigned to fulfill the appointment. |
| [Identifier Type (2.3.1 - 1.1.0)](ValueSet-hl7VSidentifierType.md) | Concepts specifying types of identififiers, as used in person and organization identification datatypes in HL7 Version 2 standards. |
| [Identity May Be Divulged (2.3.1 - 1.0.0)](ValueSet-hl7VSidentityMayBeDivulged.md) | Value Set of codes that define whether the primary observer has given permission for their identification information to be provided to a product manufacturer. |
| [Indirect Exposure Mechanism (2.3.1 - 1.0.0)](ValueSet-hl7VSindirectExposureMechanism.md) | Value Set of codes that identify the mechanism of product transmission when the product has not been directly applied to the patient. |
| [Invocation Event (2.3.1 - 1.0.0)](ValueSet-hl7VSwhenToCharge.md) | Value Set of codes that specify codes for an event precipitating/triggering a charge activity. |
| [Kind of Quantity (2.3.1 - 1.0.0)](ValueSet-hl7VSkindOfQuantity.md) | Value Set of codes that describe the underlying kind of property represented by an observation. The categories distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so |
| [Level of Care (2.3.1 - 1.0.0)](ValueSet-hl7VSlevelOfCare.md) | Value Set of codes that identify the level of care a patient may be afforded when assigned to this location definition. |
| [Living Arrangement (2.3.1 - 1.1.0)](ValueSet-hl7VSlivingArrangement.md) | Concepts characterizing the situation that patient-associated parties live in at their residential address. |
| [Living Dependency (2.3.1 - 1.0.0)](ValueSet-hl7VSlivingDependency.md) | Value Set of codes identifying specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient's healthcare needs. |
| [Living Will Code (2.3.1 - 1.0.0)](ValueSet-hl7VSlivingWill.md) | Value Set of codes that specify whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility. If the patient does not have a living will, the value of this field indicates whether the |
| [Location Characteristic ID (2.3.1 - 1.0.0)](ValueSet-hl7VSlocationCharacteristicId.md) | Value Set of codes that specify an identifier code to show which characteristic is being communicated with the segment. |
| [Location Equipment (2.3.1 - 1.0.0)](ValueSet-hl7VSlocationEquipment.md) | Value Set of codes that identify the equipment available in a location definition identified as a room or bed. |
| [Location Relationship ID (2.3.1 - 1.0.0)](ValueSet-hl7VSlocationRelationshipId.md) | Value Set of codes that specify an identifier code to show which relationship is being communicated with the segment. |
| [MFN Record-level Error Return (2.3.1 - 1.0.0)](ValueSet-hl7VSmfnRecode-levelErrorReturn.md) | Concepts which code status values for requested master file record update operations. |
| [MIME base64 encoding Characters (2.3.1 - 1.0.0)](ValueSet-hl7VSmimeBase64EncodingCharacters.md) | Value Set of codes that are used for base64 MIME encoding. Base64 is defined as follows (adapted from MIME Internet standard RFC 1521). |
| [Mail Claim Party (2.3.1 - 1.0.0)](ValueSet-hl7VSmailClaimParty.md) | Value Set of codes that specify a party to which a claim should be mailed when claims are sent by mail. |
| [Manufacturers of Vaccines (code=MVX) (2.3.1 - 1.1.0)](ValueSet-hl7VSmanufacturersOfVaccines.md) | HL7-published value Set of codes that specify the organization that manufactures a vaccine. Superceded by 2.16.840.1.114222.4.11.826, published by the US Centers for Disease Control and Prevention (CDC). |
| [Marital Status (2.3.1 - 1.0.0)](ValueSet-hl7VSmaritalStatus.md) | Value Set of codes that specify a person's marital (civil/legal) status. |
| [Marketing Basis (2.3.1 - 1.0.0)](ValueSet-hl7VSmarketingBasis.md) | Value Set of codes that specify the basis for marketing approval. |
| [Master File Identifier Code (2.3.1 - 1.0.0)](ValueSet-hl7VSmasterFileIdentifierCode.md) | Concepts which are represented by codes identifying HL7Versions 2.x Master Files. |
| [Message Error Condition Codes (2.3.1 - 1.0.0)](ValueSet-hl7VSmessageErrorConditionCodes.md) | HL7 (communications) error codes, as transmitted in a message acknowledgement. |
| [Message Structure (2.3.1 - 1.0.0)](ValueSet-hl7VSmessageStructure.md) | HL7 abstract message structure codes. |
| [Message Type (2.3.1 - 1.3.0)](ValueSet-hl7VSmessageType.md) | Concepts which specify message types for HL7 Version 2.x messaging. |
| [Military Rank/Grade (2.3.1 - 1.0.0)](ValueSet-hl7VSmilitaryRank-Grade.md) | Value Set of codes that specify the military rank/grade of the patient. Australia: https://en.wikipedia.org/wiki/Australian_Defence_Force_ranks Canada: http://www.forces.gc.ca/en/honours-history-badges-insignia/rank.page United States: published in t |
| [Military Service (2.3.1 - 1.0.0)](ValueSet-hl7VSmilitaryService.md) | Value Set of codes that specify the military branch. This field is defined by CMS or other regulatory agencies. |
| [Military Status (2.3.1 - 1.0.0)](ValueSet-hl7VSmilitaryStatus.md) | Value Set of codes that specify the military status of the patient. This field is defined by CMS or other regulatory agencies. |
| [Modality (2.3.1 - 1.0.0)](ValueSet-hl7VSmodality.md) | Value Set of codes that define the imaging apparatus expected to be used to acquire an observation. This table has been removed from the standard as of 2.7 in favor of table 0910. |
| [Money or Percentage Indicator (2.3.1 - 1.0.0)](ValueSet-hl7VSpenaltyType.md) | Value Set of codes that specify whether the amount is currency or a percentage. |
| [Name Type (2.3.1 - 1.1.0)](ValueSet-hl7VSnameType.md) | Concepts for types of names for persons. |
| [NameAddress representation (2.3.1 - 1.0.0)](ValueSet-hl7VSname-addressRepresentation.md) | Value Set of codes that provide an indication of the kind of representation provided by a name or address, but does not necessarily specify the character sets used for the data. It is used to provides hints for a receiver, so it can make choic |
| [Nature of Abnormal Testing (2.3.1 - 1.0.0)](ValueSet-hl7VSnatureOfAbnormalTesting.md) | Value Set of codes that specify the nature of an abnormal test. |
| [Nature of Challenge (2.3.1 - 1.0.0)](ValueSet-hl7VSnatureOfChallenge.md) | Value Set of codes that further describe an observation definition that is characterized as a challenge observation. |
| [Nature of Service/Test/Observation (2.3.1 - 1.0.0)](ValueSet-hl7VSnatureOfServiceTestObservation.md) | Concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files. |
| [Observation Result Status Codes Interpretation (2.3.1 - 1.2.0)](ValueSet-hl7VSobservationResultStatus.md) | Concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. |
| [Occurrence Code (2.3.1 - 1.0.0)](ValueSet-hl7VSoccurrenceCode.md) | Concepts drawn from the National Uniform Billing Committee (NUBC) code for the event or occurrence relating to a bill that may affect payer processing. Used in Version 2 messaging in the Occurrence Code and Date (OCD) value. |
| [Occurrence Span (2.3.1 - 1.0.0)](ValueSet-hl7VSoccurrenceSpan.md) | Concepts drawn from the National Uniform Billing Committee (NUBC) code that identifies an event that relates to the payment of a claim. Used in Version 2 messaging in the Occurrence Span Code and Date (OSP) value. |
| [Order Control Codes (2.3.1 - 1.3.0)](ValueSet-hl7VSorderControl.md) | Concepts which are used to determine the function of the order segment. Depending on the message, the action specifies by one of these control codes may refer to an order or an individual service. |
| [Order Status (2.3.1 - 1.2.0)](ValueSet-hl7VSorderStatus.md) | Value Set of codes that specify the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is as |
| [Organ Donor Code (2.3.1 - 1.1.0)](ValueSet-hl7VSorganDonor.md) | Value Set of codes that specify whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization. |
| [Organizational Name Type (2.3.1 - 1.0.0)](ValueSet-hl7VSorganizationalNameType.md) | Concepts used to specify the type of name for an organization i.e., legal name, display name. |
| [Override (2.3.1 - 1.0.0)](ValueSet-hl7VSoverride.md) | Value Set of codes that define whether a Charge Description Master description may be overridden or if it must be overridden. |
| [PSRO/UR Approval Indicator (2.3.1 - 1.0.0)](ValueSet-hl7VSpsro-urApprovalIndicator.md) | Value Set of codes that specify PSRO/UR approval indicators. |
| [Patient Class (2.3.1 - 1.1.0)](ValueSet-hl7VSpatientClass.md) | Concepts used by systems to categorize patients by sites. |
| [Patient Location Type (2.3.1 - 1.0.0)](ValueSet-hl7VSpatientLocationType.md) | Value Set of codes that identify the kind of location described in the location definition. |
| [Patient Outcome (2.3.1 - 1.0.0)](ValueSet-hl7VSpatientOutcome.md) | Value Set of codes that describe the overall state of a patient as a result of patient care. |
| [Patient's Relationship to Insured (2.3.1 - 1.0.0)](ValueSet-hl7VSpatient_sRelationshipToInsured.md) | Value Set of codes that specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies. |
| [Policy Type (2.3.1 - 1.0.0)](ValueSet-hl7VSpolicyType.md) | Value Set of codes that specify the policy type. |
| [Practitioner ID Number Type (2.3.1 - 1.0.0)](ValueSet-hl7VSpractitionerIdNumberType.md) | Value Set of codes that specify the type of number used for the practitioner identification. |
| [Preferred Method of Contact (2.3.1 - 1.1.0)](ValueSet-hl7VSpreferredMethodOfContrct.md) | Value Set of codes that specify which of a group of multiple phone numbers is the preferred method of contact for this person. |
| [Price Type (2.3.1 - 1.0.0)](ValueSet-hl7VSpriceType.md) | Value Set of codes that identify the intent for the dollar amount on a pricing transaction. |
| [Primary Key Value Type (2.3.1 - 1.0.0)](ValueSet-hl7VSprimaryKeyValueType.md) | Value Set of codes that specify the type for the master file record identifier. |
| [Primary Observer's Qualification (2.3.1 - 1.0.0)](ValueSet-hl7VSprimaryObserver_sQualification.md) | Value Set of codes that provide a general description of the kind of health care professional who provided the primary observation. |
| [Priority (2.3.1 - 1.2.0)](ValueSet-hl7VSpriority.md) | Value Set of codes that specify the allowed priorities for obtaining the specimen. |
| [Privacy Level (2.3.1 - 1.0.0)](ValueSet-hl7VSprivacyLevel.md) | Value Set of codes that identify the level of privacy a patient will be afforded when assigned to this location definition. |
| [Procedure Functional Type (2.3.1 - 1.0.0)](ValueSet-hl7VSprocedureFunctionalType.md) | Value Set of codes that classify a procedure. |
| [Procedure Practitioner Identifier Type (2.3.1 - 1.1.0)](ValueSet-hl7VSprocedurePractitionerType.md) | Value Set of codes of concepts which specify the different types of practitioners associated with this procedure. This set of codes is known to be incomplete. |
| [Processing ID (2.3.1 - 1.0.0)](ValueSet-hl7VSprocessingId.md) | Value Set of codes that specify whether the message is part of a production, training or debugging system. |
| [Processing Mode (2.3.1 - 1.1.0)](ValueSet-hl7VSprocessingMode.md) | Concepts that indicate an archival process or an initial load process. |
| [Processing Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSprocessingPriority.md) | Value Set of codes that specify one or more available priorities for performing the observation or test. |
| [Product Source (2.3.1 - 1.0.0)](ValueSet-hl7VSproductSource.md) | Value Set of codes that describe the evaluation state of a product identified in an incident. |
| [Provider Billing (2.3.1 - 1.0.0)](ValueSet-hl7VSproviderBilling.md) | Value Set of codes that specify how provider services are billed. |
| [Provider Role (2.3.1 - 1.0.0)](ValueSet-hl7VSproviderRole.md) | Value Set of codes that define the relationship between a referral recipient and a patient or between a referral initiator and a patient. |
| [Purge Status Code (2.3.1 - 1.0.0)](ValueSet-hl7VSpurgeStatus.md) | Value Set of codes that define the state of a visit relative to its place in a purge workflow. |
| [Quantity Limited Request (2.3.1 - 1.1.0)](ValueSet-hl7VSquantityLimitedRequest.md) | Concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects. |
| [Quantity Method (2.3.1 - 1.0.0)](ValueSet-hl7VSquantityMethod.md) | Value Set of codes that specify the method by which the quantity distributed is measured. |
| [Query Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSqueryPriority.md) | Concepts which specify a time frame in which a querry response is expected. |
| [Query Response Status (2.3.1 - 1.1.0)](ValueSet-hl7VSqueryResponseStatus.md) | Concepts defining precise response status concepts in support of HL7 Version 2 query messaging. |
| [Query Results Level (2.3.1 - 1.0.2)](ValueSet-hl7VSqueryResultsLevel.md) | Value Set of codes which are used to control level of detail in query results. |
| [Query/Response Format Code (2.3.1 - 1.2.0)](ValueSet-hl7VSqueryFormatCode.md) | Value Set of codes which specify which of several types of formats for data to be returned in response to a query. |
| [RX Component Type (2.3.1 - 1.0.0)](ValueSet-hl7VSrxComponentType.md) | Value Set of codes that specify the RX component type. |
| [Record-level Event Code (2.3.1 - 1.0.0)](ValueSet-hl7VSmasterfileActionCode.md) | Concepts specifying an action for a master file record. Used in HL7 V2.x messaging in the MFE segment. |
| [Referral Category (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralCategory.md) | Value Set of codes that describe the patient care setting where a referral should take place. |
| [Referral Disposition (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralDisposition.md) | Value Set of codes that identify the expected response from the healthcare professional receiving a referral. |
| [Referral Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralPriority.md) | Value Set of codes that designate the urgency of a referral. |
| [Referral Reason (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralReason.md) | Value Set of codes that specify the reason for which the referral will take place. |
| [Referral Status (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralStatus.md) | Value Set of codes that define the state of a referral. |
| [Referral Type (2.3.1 - 1.0.0)](ValueSet-hl7VSreferralType.md) | Value Set of codes that identify the general category of healthcare professional desired to satisfy a referral. |
| [Relatedness Assessment (2.3.1 - 1.0.0)](ValueSet-hl7VSrelatednessAssessment.md) | Value Set of codes that provide an estimate of whether an issue with a product was the cause of an event. |
| [Relational Conjunction (2.3.1 - 1.0.0)](ValueSet-hl7VSrelationalConjunction.md) | Value Set of codes used with relational operator values to group more than one segment field name. |
| [Relational Operator (2.3.1 - 1.0.0)](ValueSet-hl7VSrelationalOperator.md) | Value Set of codes that define the relationship between HL7 segment field names identified in a query construct. |
| [Relationship Modifier (2.3.1 - 1.0.0)](ValueSet-hl7VSrelationshipModifier.md) | Value Set of codes that an observation definition to describe the subject of an observation in relation to a patient. |
| [Report Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSreportPriority.md) | Value Set of codes which specify the priority associated with a report or update run using a query. |
| [Report Source (2.3.1 - 1.0.0)](ValueSet-hl7VSreportSource.md) | Value Set of codes that identify where a report sender learned about an event. |
| [Report Timing (2.3.1 - 1.0.0)](ValueSet-hl7VSreportTiming.md) | Value Set of codes that identify the time span of a report or the reason for a report sent to a regulatory agency. |
| [Reporting Priority (2.3.1 - 1.0.0)](ValueSet-hl7VSreportingPriority.md) | Value Set of codes that specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority. |
| [Response Flag (2.3.1 - 1.0.0)](ValueSet-hl7VSresponseFlag.md) | Value Set of codes allowing the placer (sending) application to determine the amount of information to be returned from the filler. |
| [Response Level (2.3.1 - 1.0.0)](ValueSet-hl7VSresponseLevel.md) | Concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message. Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions. |
| [Result Status (2.3.1 - 1.2.0)](ValueSet-hl7VSresultStatus-Obr.md) | Concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Room Type (2.3.1 - 1.0.0)](ValueSet-hl7VSroomType.md) | Value Set of codes that specify the room type. |
| [Route of Administration (2.3.1 - 3.0.0)](ValueSet-hl7VSrouteOfAdministration.md) | Value Set of codes that specify the route of administration. |
| [Segment Action Code (2.3.1 - 1.0.0)](ValueSet-hl7VSsegmentActionCode.md) | Concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in "action code mode" (a kind of update mode in the Standard). |
| [Sex (2.3.1 - 1.0.0)](ValueSet-hl7VSsex.md) | Concepts specifying a person's sex. |
| [Source Type (2.3.1 - 1.0.0)](ValueSet-hl7VSnetworkSourceType.md) | Value Set of codes that indicate (in certain systems) whether a lower level source identifier is an initiate or accept type. |
| [Source of Comment (2.3.1 - 1.1.0)](ValueSet-hl7VSsourceOfComment.md) | Concepts which are used to specify the source of a comment, as used in HL7 Version 2.x messaging in the NTE segment. |
| [Specialty Type (2.3.1 - 1.0.0)](ValueSet-hl7VSspecialtyType.md) | Value Set of codes that identify the specialty of the care professional who is supported when using this location definition. |
| [Specimen Source Codes (2.3.1 - 1.2.0)](ValueSet-hl7VSsourceOfSpecimen.md) | Value Set of codes which specify sources for speciments for clinical testing. These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in table 0487 Specimen Type and table |
| [Status of Evaluation (2.3.1 - 1.0.0)](ValueSet-hl7VSstartOfEvaluation.md) | Value Set of codes that describes the status of product evaluation. |
| [Student Status (2.3.1 - 1.0.0)](ValueSet-hl7VSstudentStatus.md) | Value Set of codes that designate whether a guarantor is a full or part time student. |
| [Substitution Status (2.3.1 - 1.1.0)](ValueSet-hl7VSsubstitutionStatus.md) | Value Set of codes that specify the substitution status. |
| [Subtype of Referenced Data (2.3.1 - 1.1.0)](ValueSet-hl7VSsubtypeOfReferencedData.md) | A subset of the IANA media subtypes of binary data that are encoded in an ascii structure or stream. |
| [Telecommunication Equipment Type (2.3.1 - 1.0.0)](ValueSet-hl7VStelecommunicationEquipmentType.md) | Concepts for specifying a type of telecommunication equipment. |
| [Telecommunication Use Code (2.3.1 - 1.1.0)](ValueSet-hl7VStelecommunicationUseCode.md) | Concepts for specifying a specific use of a telecommunication number. |
| [Time Delay Post Challenge (2.3.1 - 1.0.0)](ValueSet-hl7VStimeDelayPostChallenge.md) | Value Set of codes that classify an observation definition as being a component of a challenge test. |
| [Time Selection Criteria Parameter Class Codes (2.3.1 - 1.0.0)](ValueSet-hl7VStimeSelectionCriteriaParameterClassCodes.md) | Value Set of codes that describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling. |
| [Transaction Type (2.3.1 - 1.0.0)](ValueSet-hl7VStransactionType.md) | Value Set of codes that specify a type of financial transaction. |
| [Transport Arranged (2.3.1 - 1.0.0)](ValueSet-hl7VStransportArranged.md) | Value Set of codes defining whether patient transportation preparations are in place. |
| [Transportation Mode (2.3.1 - 1.0.0)](ValueSet-hl7VStransportationMode.md) | Value Set of codes that specify how (or whether) to transport a patient, when applicable, for an ordered service. |
| [Tray Type (2.3.1 - 1.0.0)](ValueSet-hl7VStrayType.md) | Value Set of codes that specify the type of dietary tray. |
| [Type of Referenced Data (2.3.1 - 1.2.0)](ValueSet-hl7VStypeOfData.md) | Concepts declaring the general type of media data that is encoded. |
| [Universal ID Type (2.3.1 - 1.0.0)](ValueSet-hl7VSuniversalIdType.md) | Types of UID (Universal Identifiers). |
| [Vaccines Administered (2.3.1 - 1.1.0)](ValueSet-hl7VSvaccinesAdministered.md) | HL7-published value Set of codes that specify the administered vaccines. Superceded by 2.16.840.1.114222.4.11.934, published by the US Centers for Disease Control and Prevention (CDC). |
| [Version ID (2.3.1 - 1.3.0)](ValueSet-hl7VSversionControlTable.md) | Concepts which are used to identify an HL7 version in the Version 2.x family of published standards. |
| [Visit Indicator (2.3.1 - 1.0.0)](ValueSet-hl7VSvisitIndicator.md) | Value Set of codes that specify the level on which data are being sent. It is the indicator used to send data at two levels, visit and account. HL7 recommends sending an "A" or no value when the data in the message are at the account level or "V" to i |
| [What subject filter (2.3.1 - 1.3.0)](ValueSet-hl7VSwhatSubjectFilter.md) | Value Set of codes which specify the kind of information that is required to satisfy a query request. The values define the type of transaction inquiry. |
| [Which Date/Time Qualifier (2.3.1 - 1.1.0)](ValueSet-hl7VSwhichDate-timeQualifier.md) | Value Set of codes that specify the type of date referred to in the other date fields in the QRF segment. |
| [Which Date/Time Status Qualifier (2.3.1 - 1.0.0)](ValueSet-hl7VSwhichDate-timeStatusQualifier.md) | Value Set of codes that specify the status type of objects selected in date range defined by QRF-2 and QRF-3. |
| [Yes/No Indicator (2.3.1 - 1.0.0)](ValueSet-hl7VSyes-no-Indicator.md) | Codes specifying either Yes or No used in fields containing binary answers generally user-specified. |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Abnormal Flags (2.3.1 - 1.3.0)](CodeSystem-observationInterpretation.md) | HL7-defined code system of concepts which specify a categorical assessment of an observation value. Used in HL7 Version 2.x messaging in the OBX segment. Notes: This is being communicated in v2.x in OBX-8, in v3 in ObservationInterpretation (CWE) in R1 (Representative Realm) and in FHIR Observation.interpretation. |
| [Accept/Application Acknowledgment Conditions (2.3.1 - 1.0.0)](CodeSystem-accept-applicationAcknowledgmentConditions.md) | HL7-defined code system of concepts which identify conditions under which accept acknowledgments are required to be returned in response to a message, and required for enhanced acknowledgment mode. Used in HL7 Versions 2 messaging in the MSH segment. |
| [Acknowledgment Code (2.3.1 - 1.2.0)](CodeSystem-acknowledgmentCodes.md) | HL7-defined code system of concepts specifying acknowledgment codes. For details of usage, see message processing rules in the published Standard. Used in HL7 Version 2.x messaging in the MSA segment. |
| [Action Code (2.3.1 - 1.0.0)](CodeSystem-actionCodes.md) | HL7-defined code system of status codes of record operation. Used in Version 2 messaging, these are used in the RXA segment in the vaccine messages, where a method of correcting vaccination information transmitted with incorrect patient identifying information is needed. As of version 2.6, this table was replaced with table 0206, whose values are defined by code system xxxx. |
| [Action Taken in Response to the Event (2.3.1 - 1.0.0)](CodeSystem-actionTakenInResponseToTheEvent.md) | HL7-defined code system of concepts used to define the action taken as a result of an event related to a product issue. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Active/Inactive (2.3.1 - 1.0.0)](CodeSystem-active-inactive.md) | HL7-defined code system of concepts specifying whether a person is currently a valid staff member. Used in HL7 Version 2.x messaging in the STF segment. |
| [Address Type (2.3.1 - 1.2.0)](CodeSystem-addressType.md) | HL7-defined code system of concepts specifying types or kinds of addresses. Used in HL7 Version 2.x messaging in the XAD segment. |
| [Administration Device (2.3.1 - 1.0.0)](CodeSystem-administrationDevice.md) | Code system of concepts which specify the mechanical device used to aid in the administration of the drug or other treatment. Common examples are IV-sets of different types. Used in HL7 Version 2.x messaging in the RXR segment. |
| [Administration Method (2.3.1 - 1.0.0)](CodeSystem-administrationMethod.md) | Code system of concepts which specify the specific method requested for the administration of the drug or treatment to the patient. Used in HL7 Version 2.x messaging in the RXR segment. |
| [Administrative Site (2.3.1 - 1.1.0)](CodeSystem-bodySite.md) | HL7-defined code system of concepts that specify a body site from which a specimen is obtained. Used in HL7 Version 2.x messaging in the OBX and CH7 segments. |
| [Admission Type (2.3.1 - 1.0.0)](CodeSystem-admissionType.md) | Code system of concepts specifying the circumstances under which the patient was or will be admitted. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [Admit Source (2.3.1 - 1.0.0)](CodeSystem-admitSource.md) | HL7 published code system of values that indicate where a patient was admitted. In the US, this field is used on UB92 FL20 “Source of Admission”; note that the UB codes listed are not an exhaustive or current list; refer to a UB specification for additional information. This needs review by HTA and PA/FM; this may be a value set built on external CMS codes from the UB. It has not been published after the HL7 Version 2.6 release of the Standard. |
| [Advanced Beneficiary Notice Code (2.3.1 - 1.0.0)](CodeSystem-advancedBeneficiaryNotice.md) | Code system of concepts specifying the status of the patient's or the patient's representative's consent for responsibility to pay for potentially uninsured services. This element was introduced to satisfy CMS Medical Necessity requirements for outpatient services in the United States. Includes concepts such as (a) whether the associated diagnosis codes for the service are subject to medical necessity procedures, (b) whether, for this type of service, the patient has been informed that they may be responsible for payment for the service, and (c) whether the patient agrees to be billed for this service. Used in HL7 Version 2.x messaging in the ORC and FT1 segments. |
| [Allergy Severity (2.3.1 - 1.0.0)](CodeSystem-allergySeverity.md) | Code system of concepts which specify the general severity of an allergy. Used in HL7 Version 2.x messaging in the AL1 segment. |
| [Allergy Type (2.3.1 - 1.0.0)](CodeSystem-allergenType.md) | Code system of concepts speciying a classification of general allergy categories (drug, food, pollen, etc.). Used in HL7 Version 2.x messaging in the AL1 segment. |
| [Allow Substitution Codes (2.3.1 - 1.1.0)](CodeSystem-allowSubstitution.md) | Code system of concepts used to indicate whether the appointment resource may be substituted for another by the entity assigned to fulfill the appointment. Used in HL7 Version 2.x messaging in the AIS and AIG segments. |
| [Alternate Character Set Handling Scheme (2.3.1 - 1.0.0)](CodeSystem-alternateCharacterSetHandlingScheme.md) | HL7-defined code system of concept that specify the scheme used when any alternative character sets are specified in the second or later iterations of MSH-18 Character Set, and if any special handling scheme is needed. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Alternate Character Sets (2.3.1 - 1.1.0)](CodeSystem-alternateCharacterSets.md) | HL7-defined code system of concepts used to specify the character set(s) in use. Includes both single-byte and double-byte characters sets, and used in Version 2.x messaging in the MSH segment. |
| [Ambulatory Status (2.3.1 - 1.0.0)](CodeSystem-ambulatoryStatus.md) | Code system of concepts specifying permanent or transient handicapped conditions of a person. Used in HL7 Version 2.x messaging in the PV1 segment. |
| [Amount Class (2.3.1 - 1.0.0)](CodeSystem-amountClass.md) | Code system of concepts specifying the amount quantity class. Used in HL7 Version 2.x messaging in the PTA segment. |
| [Amount Type (2.3.1 - 1.0.0)](CodeSystem-amountType.md) | Code system of concepts which specify amount quantity type. Used in HL7 Version 2.x messaging in the RMC segment. |
| [Annotations (2.3.1 - 1.0.0)](CodeSystem-annotations.md) | Code system of concepts specifying the coded entry associated with a given point in time during the waveform recording. Used in HL7 Version 2.x messaging in the Observation Result (OBX) Another Observation (ANO) segments. |
| [Appointment Reason Codes (2.3.1 - 1.0.0)](CodeSystem-appointmentReason.md) | Code system of concepts used to describe the kind of appointment or the reason why an appointment has been scheduled. Used in HL7 Version 2.x messaging in the ARQ segment. |
| [Appointment Type Codes (2.3.1 - 1.0.0)](CodeSystem-appointmentType.md) | Code system of concepts used in an appointment request to describe the kind of appointment. Used in HL7 Version 2.x messaging in the ARQ segment. |
| [Assignment of Benefits (2.3.1 - 1.0.0)](CodeSystem-assignmentOfBenefits.md) | Code system of concepts which indicate whether an insured person agreed to assign the insurance benefits to the healthcare provider. If so, the insurance will pay the provider directly. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [Bed Status (2.3.1 - 1.1.0)](CodeSystem-bedStatus.md) | Code system of concepts which specify the state of a bed in an inpatient setting, and is used to determine if a patient may be assigned to it or not. Used in HL7 Version 2.x messaging in the DLD and PV1 segments. |
| [CP Range Type (2.3.1 - 1.0.0)](CodeSystem-cpRangeType.md) | HL7-defined code system of concepts used to define a type of range used in composite pricing in financial transacxtions. Used in HL7 Version 2 messaging in the CP datatype. |
| [CWE statuses (2.3.1 - 1.0.0)](CodeSystem-cweStatuses.md) | HL7-defined code system of comcepts that represent an exception identifier code; that is, a code that is not defined in the value set (either model or site-extended). These are occationsally referred to a 'flavors of null' although this set of concepts is specific to the CWE datatype used in HL7 Version 2.x messaging, and the codes may be used in the 'identifier' component of the 'triplets' in that datatype. |
| [Causality Observations (2.3.1 - 1.0.0)](CodeSystem-causalityObservations.md) | HL7-defined code system of concepts used to record event observations regarding what may have caused a product related event. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Certification Patient Type (2.3.1 - 1.0.0)](CodeSystem-certificationPatientType.md) | Code system of concepts which specify the category or type of patient for which this certification is requested. Used in HL7 Version 2.x messaging in the ICD segment. |
| [Certification Status (2.3.1 - 1.0.0)](CodeSystem-certificationStatus.md) | HL7-defined code system of concepts used to specify the status of the practitioner's speciality certification. Used in HL7 Version 2.x messaging in the Specialty Description (SPD) value and Practitioner Detail (PRA) segment. |
| [Charge On Indicator (2.3.1 - 1.0.0)](CodeSystem-chargeOnIndicator.md) | Code system of concepts used to define the event upon which a charge should be generated. Used in HL7 Version 2.x messaging in the PRC segment. |
| [Charge Type (2.3.1 - 1.0.0)](CodeSystem-chargeType.md) | HL7-defined code system of concepts which specify someone or something other than the patient to be billed for a service. Used in HL7 Version 2.x messaging in the BLG segment. |
| [Check Digit Scheme (2.3.1 - 1.2.0)](CodeSystem-checkDigitScheme.md) | HL7-defined code system of concepts specifying the check digit scheme employed. Used in HL7 Version 2.x messaging in PPN, XCN and XON segments. |
| [Comment Type (2.3.1 - 1.0.0)](CodeSystem-commentType.md) | Code system of concepts that identify the type of comment text being sent in the specific comment record. Used in the Notes and Comments (NTE) segment in HL7 Version 2.x messaging. |
| [Completion Status (2.3.1 - 1.0.0)](CodeSystem-completionStatus.md) | HL7-defined code system of concepts specifying the status of the treatment administration event segment. Used in HL7 Version 2.x messaging in the Pharmacy Order Administration (RXA) segment. |
| [Condition Code (2.3.1 - 1.0.0)](CodeSystem-conditionCodes.md) | HL7-defined code system of concepts specifying the condition code. This field is defined by CMS or other regulartory agencies. Used in HL7 Version 2.x messaging in the UB2 segment. |
| [Confidentiality Code (2.3.1 - 1.0.0)](CodeSystem-confidentialityCodes.md) | Code system of concepts specifying the degree to which special confidentiality protection should be applied to the observation. Used in HL7 Version 2.x messaging in the OM1 and ORC segments. |
| [Coordination of Benefits (2.3.1 - 1.0.0)](CodeSystem-coordinationOfBenefits.md) | Code system of concepts specifying whether this insurance works in conjunction with other insurance plans or if it provides independent coverage and payment of benefits regardless of other insurance that might be available to the patient. Used in HL7 Version 2.x messaging in the IN1 segment. |
| [Coverage Type (2.3.1 - 1.0.0)](CodeSystem-coverageType.md) | Code system of concepts specifying the type of insurance coverage or what types of services are covered for the purposes of a billing system. For example, a physician billing system will only want to receive insurance information for plans that cover physician/professional charges. Used in HL7 Version 2.x messaging in the Insurance (IN1) segment. |
| [DRG Payor (2.3.1 - 1.0.0)](CodeSystem-drgPayor.md) | HL7-defined code system of concepts used to identify a Diagnostic Resource Group Payor. US Realm. |
| [Date/Time Selection Qualifier (2.3.1 - 1.0.0)](CodeSystem-date-timeSelectionQualifier.md) | HL7-defined code system of conceptss that allow the specification of certain types of values within the date/time range. Used in HL7 Vesion 2 messaging in the QRF segment. |
| [Day Type (2.3.1 - 1.0.0)](CodeSystem-dayType.md) | Code system of concepts which specify whether the days are denied, pending or approved. Used in HL7 Version 2.x messaging in the DTN segment. |
| [Days of the Week (2.3.1 - 1.0.0)](CodeSystem-daysOfTheWeek.md) | HL7-defined code system of concepts used to identify the day(s) of the week when a location may be scheduled for appointments. Used in HL7 Version 2.x messaging in the UVC and LDP segments. |
| [Deferred Response Type (2.3.1 - 1.0.0)](CodeSystem-deferredResponseType.md) | HL7-defined code system of concepts which specify which type of deferred query resonse is desired, as specified with the query parameters. Used in HL7 Version 2 messaging in the QRD segment. |
| [Degree/license/certificate (2.3.1 - 1.0.0)](CodeSystem-degreeLicenseCertificate.md) | HL7-defined code system of concepts specifying an educational degree (e.g., MD). Used in the CNN datatype (names and identifiers of clinicians) in Version 2 messaging. Used in Version 2 messaging; note that in releases of HL7 prior to 2.3.1, was also used in person names (XPN), but this use was deprecated, then withdrawn in 2.7. |
| [Delayed Acknowledgement Type (2.3.1 - 1.1.0)](CodeSystem-delayedAcknowledgmentType.md) | HL7-defined code system of concepts which specify a response type used in deferred processing two phase reply for delayed acknowldgement mode of the original acknowledgement mechanism defined in HL7 Version 2.x messaging and used in the MSH segment. |
| [Derived Specimen (2.3.1 - 1.0.0)](CodeSystem-derivedSpecimen.md) | HL7-defined code system of concepts which specify the parents and children for diagnostic studies, especially in microbiology, where the initial specimen (e.g., blood) is processed to produce results (e.g., the identity of the bacteria grown out of the culture). The process also produces new "specimens" (e.g., pure culture of staphylococcus, and E. coli), and these are studied by a second order process (bacterial sensitivities). The parents (e.g., blood culture) and children (e.g., penicillin MIC) are identified in such cases. Used in HL7 Version 2.x messaging in the OM4 segment. |
| [Diagnosis Classification (2.3.1 - 1.0.0)](CodeSystem-diagnosisClassification.md) | Code system of concepts used to classify whether a patient visit can be related to a diagnosis. Used in HL7 Version 2.x messaging in the DG1 segment. |
| [Diagnosis Priority (2.3.1 - 1.0.0)](CodeSystem-diagnosisPriority.md) | Code system of concepts that identify the significance or priority of the diagnosis code. Note that the codes are numeric, and the number of the code represents the ordinal priority of the associated diagnosis. Used in the DG1 segment in HL7 Version 2.x messaging. The predefined codes are the most common, and just a starter set, as the codes are an unbounded list; additional ranked procedures may be signified by incrementing the code value as needed. |
| [Diagnosis Type (2.3.1 - 1.0.0)](CodeSystem-diagnosisType.md) | Code system of concepts specifying a type of diagnosis being sent. Used in HL7 Version 2.x messaging in the DG1 segment.. |
| [Diagnostic Service Section ID (2.3.1 - 1.2.0)](CodeSystem-diagnosticServiceSectionId.md) | HL7-defined code system of concepts which specify a section of a diagnostic service where the observation may be performed. Used in HL7 Version 2.x messaging in the OBR and OM4 segments. |
| [Diet Code Specification Type (2.3.1 - 1.0.0)](CodeSystem-dietCodeSpecificationType.md) | HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version 2.x messaging in the ODS segment. |
| [Disabled Person Code (2.3.1 - 1.0.0)](CodeSystem-disabilityInformationRelationship.md) | Code system of concepts used to specify to which person the disability information relates in the message. For example, if the value is PT, the disability information relates to the patient. Used in HL7 Version 2.x messaging in the Disability (DB1) segment. |
| [Discharge Disposition (2.3.1 - 1.0.0)](CodeSystem-dischargeDisposition.md) | Code system of concepts which specify the disposition of the patient at time of discharge (i.e., discharged to home, expired, etc.). Used in HL7 Version 2.x messaging in the PV1 segment. |
| [Dispense Method (2.3.1 - 1.0.0)](CodeSystem-dispenseMethod.md) | HL7-definde code system of concepts specifying the method by which treatment is dispensed. Used in HL7 Version 2.x messaging in the Pharmacy/Treatment Encoded order (RXE) and Pharmacy/Treatment dispense (RXD) segments. |
| [Document Availability Status (2.3.1 - 1.1.0)](CodeSystem-documentAvailabilityStatus.md) | HL7-defined code system of concepts used to define whether a patient document is appropriate or available for use in patient care. Used in HL7 Version 2.x messaging in the TXA segment. |
| [Document Completion Status (2.3.1 - 1.0.0)](CodeSystem-documentCompletionStatus.md) | HL7-defined code system of concepts used to record the state of a document in a workflow. Used in HL7 Version 2.x messaging in the TXA segment. |
| [Document Confidentiality Status (2.3.1 - 2.0.0)](CodeSystem-documentConfidentialityStatus2.md) | HL7-defined code system of concetps used to identify the degree to which special confidentiality protection should be applied to this information. Used in HL7 Version 2.x messaging in the TXA segment. |
| [Document Storage Status (2.3.1 - 1.0.0)](CodeSystem-documentStorageStatus.md) | HL7-defined code system of concepts used to describe the availability of a document in relation to the type of storage. Used in HL7 Version 2.x messaging in the TXA segment. |
| [Document Type (2.3.1 - 1.0.0)](CodeSystem-documentType.md) | Code system of concepts used to identify the kind of patient document. Used in HL7 Version 2.x messaging in the TXA segment. |
| [Duration Categories (2.3.1 - 1.0.1)](CodeSystem-durationCategories.md) | Code system of concepts used to classify an observation definition as intended to measure a patient's state at a point in time. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Eligibility Source (2.3.1 - 1.0.0)](CodeSystem-eligibilitySource.md) | Code system of concepts which specify the source of information about the insured's eligibility for benefits. Used in HL7 Version 2.x messaging in the IN2 segment. |
| [Encoding (2.3.1 - 1.0.0)](CodeSystem-encoding.md) | HL7-defined code system of concept identifying the type of encoding used to represent successive octets of binary data as displayable ASCII characters. These are defined by IETF; more information may be found at https://www.ietf.org/rfc/rfc1521.txt. Used in HL7 Version 2.x messaging in the ED datatypes. |
| [Escort Required (2.3.1 - 1.0.0)](CodeSystem-escortRequired.md) | HL7-defined code system of concepts defining whether patient transportation preparations are in place. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Event (2.3.1 - 1.3.0)](CodeSystem-event.md) | HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Event Consequence (2.3.1 - 1.0.0)](CodeSystem-eventConsequence.md) | HL7-defined code system of concepts used to describe the impact of an event on a patient. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Event Expected (2.3.1 - 1.0.0)](CodeSystem-eventExpected.md) | HL7-defined code system of concepts used to communicate whether an event has been judged to be expected or unexpected. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Event Qualification (2.3.1 - 1.0.0)](CodeSystem-eventQualification.md) | HL7-defined code system of concepts used to qualify an event related to a product experience. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Event Reason (2.3.1 - 1.1.0)](CodeSystem-eventReason.md) | Code system of concepts which specify the reason for an event. Used in HL7 Version 2.x messaging in the EVN segment. |
| [Event Reported To (2.3.1 - 1.0.0)](CodeSystem-eventReportedTo.md) | HL7-defined code system of concepts used to identify the type of entity to which the even has been reported. Used in HL7 Version 2.x messaging in the PES segment. |
| [Event Seriousness (2.3.1 - 1.0.0)](CodeSystem-eventSeriousness.md) | HL7-defined code system of concepts used by a sender to designate an event as serious or significant. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Facility Type (2.3.1 - 1.0.0)](CodeSystem-facilityType.md) | HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x messaging in the Facility (FAC) segment. |
| [File Level Event Code (2.3.1 - 1.0.0)](CodeSystem-file-levelEvent.md) | HL7-defined code system of concepts specifying file-level events for master files. Used in HL7 Version 2 messaging in the MFI segment. |
| [Filler Status Codes (2.3.1 - 1.1.0)](CodeSystem-fillerStatus.md) | Code system of concepts used to describe an appointment status from the perspective of the entity assigned to fulfill the appointment. Used in HL7 Version 2.x messaging in the SCH segment. |
| [Identifier Type (2.3.1 - 1.1.0)](CodeSystem-identifierType.md) | HL7-defined code system of concepts specifying type of identifier. Used in HL7 Version 2.x messaging data types CX, PLN, PPN, XCN and XON. |
| [Identity May Be Divulged (2.3.1 - 1.0.0)](CodeSystem-identityMayBeDivulged.md) | HL7-defined code system of concepts used to define whether the primary observer has given permission for their identification information to be provided to a product manufacturer. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Indirect Exposure Mechanism (2.3.1 - 1.0.0)](CodeSystem-indirectExposureMechanism.md) | HL7-defined code system of concepts used to identify the mechanism of product transmission when the product has not been directly applied to the patient. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Invocation Event (2.3.1 - 1.0.0)](CodeSystem-invocationEvent.md) | HL7-defined code system of concepts which specify codes for an event precipitating/triggering a charge activity. Used in HL7 Version 2.x messaging in the CCD and BLG segments. |
| [Kind of Quantity (2.3.1 - 1.0.0)](CodeSystem-kindOfQuantity.md) | HL7 published code system of concepts that describe categories of an underlying kind of property represented by an observation. These are intended to distinguish concentrations from total amounts, molar concentrations from mass concentrations, partial pressures from colors, and so forth. These are discussed more fully in the LOINC Users’ Manual. These defined categories are derived from the approach described in 1995 edition of the IUPAC Silver Book. These distinctions are used in IUPAC and LOINC standard codes. Needs review by OO and HTA to determined if this is a value set built on LOINC part codes or some other external vocabulary. |
| [Level of Care (2.3.1 - 1.0.0)](CodeSystem-levelOfCare.md) | Code system of concepts used to identify the level of care a patient may be afforded when assigned to this location definition. Used in HL7 Version 2.x messaging in the LCH segment. |
| [Living Arrangement (2.3.1 - 1.1.0)](CodeSystem-livingArrangement.md) | Code system of concepts characterizing the situation that patient-associated parties live in at their residential address. Used in HL7 Version 2.x messaging in the NK1 and PD1 segments. |
| [Living Dependency (2.3.1 - 1.0.0)](CodeSystem-livingDependency.md) | HL7-defined code system of concepts that identify specific living conditions (e.g., spouse dependent on patient, walk-up) that are relevant to an evaluation of the patient’s healthcare needs. This information can be used for discharge planning. Examples might include Spouse Dependent, Medical Supervision Required, Small Children Dependent. Used in Version 2.s messaging in the NK1 segment. Used in HL7 Version 2 messaging only in Versions 2.3 and 2.3.1; superceded by 2.16.840.1.113883.18.124 livingDependency2 in Version 2.4 of the Standard. |
| [Living Will Code (2.3.1 - 1.0.0)](CodeSystem-livingWillCodes.md) | Code system of concepts specifying whether or not the patient has a living will and, if so, whether a copy fo the living will is on file at the healthcare facility. If the patient does not have a living will, the value of this field indicates whether the patient was provided information on living wills. Used in HL7 Version 2.x messaging in the Patient Visit - Additional Information ( PV2) and Patient Additional Demographic (PD1) segments. |
| [Location Characteristic ID (2.3.1 - 1.0.0)](CodeSystem-locationCharacteristic.md) | Code system of concepts specifying an identifier code to show which characteristic is being communicated with the segment. Used in HL7 Version 2.x messaging in the Location Characteristic (LCH) segment. |
| [Location Equipment (2.3.1 - 1.0.0)](CodeSystem-locationEquipment.md) | Code system of concepts used to identify the equipment available in a location definition identified as a room or bed. Used in HL7 Version 2.x messaging in the LOC segment. |
| [Location Relationship ID (2.3.1 - 1.0.0)](CodeSystem-locationRelationship.md) | Code system of concepts specifying an identifier code to show which relationship is being communicated with the segment. Used in HL7 Version 2.x messaging in the Location Relationship (LRL) segment. |
| [MFN Record-level Error Return (2.3.1 - 1.0.0)](CodeSystem-mfnRecord-levelErrorReturn.md) | Code system of concepts specifying the status of the requested update. Site-defined table, specific to each master file being updated via this transaction. Used in HL7 Version 2.x messaging in the MFA segment. |
| [MIME base64 encoding Characters (2.3.1 - 1.0.0)](CodeSystem-mimeBase64EncodingCharacters.md) | HL7-defined code system of concepts specifying the characters used in the MIME Base 64 encoding mechanism. These are for reference only, as they are not carried as explicit code values in any HL7 coded field. This table was published only in releases 2.3, 2.3.1, and 2.4 of the Standard, and was removed thereafter. |
| [Mail Claim Party (2.3.1 - 1.0.0)](CodeSystem-mailClaimParty.md) | Code system of concepts which specify a party to which a claim should be mailed when claims are sent by mail. Used in HL7 Version 2.x messaging in the IN2 segment. |
| [Manufacturers of Vaccines (code=MVX) (2.3.1 - 1.1.0)](CodeSystem-manufacturersOfVaccinesHL7.md) | Code system of concepts specifying the organization that manufactures a vaccine. The values are maintained by the US Centers of Disease Control. Used in HL7 Version 2.x messaging in the RXA, RXD and RXG segments. |
| [Marital Status (2.3.1 - 1.0.0)](CodeSystem-maritalStatus.md) | Code system of concepts specifying a person's marital (civil/legal) status. Used in HL7 Version 2.x messages in the PID segment. |
| [Marketing Basis (2.3.1 - 1.0.0)](CodeSystem-marketingBasis.md) | HL7-defined code system of concepts used to specify the basis for marketing approval. Used in HL7 Version 2.x messaging in the Product Detail Country (PDC) segment. |
| [Master File Identifier Code (2.3.1 - 1.0.0)](CodeSystem-masterFileIdentifierCodes.md) | HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Master Files. Used in HL7 Version 2.x messaging in the MFI segment. |
| [Message Error Condition Codes (2.3.1 - 1.0.0)](CodeSystem-messageErrorCondition.md) | HL7-defined code system of concepts specifying the HL7 (communications) error code. Used in the ERR segment in HL7 Version 2.x messaging. |
| [Message Structure (2.3.1 - 1.0.0)](CodeSystem-messageStructure.md) | HL7-defined code system of abstract message structure codes. Each code identifies a specific message structure abstract syntax as published in the HL7 Version 2 standard. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Message Type (2.3.1 - 1.3.0)](CodeSystem-messageType.md) | HL7-defined code system of concepts which specify message types. Used in HL7 Version 2.x messaging in the MSH segment. |
| [Military Rank/Grade (2.3.1 - 1.0.0)](CodeSystem-militaryRank-Grade.md) | Code system of concepts which specify the military rank/grade of the patient. Used in HL7 Version 2.x messaging in the PD1 segment. |
| [Military Service (2.3.1 - 1.0.0)](CodeSystem-militaryService.md) | Code system of concepts which specify the military branch. This field is defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the PD1 segment. |
| [Military Status (2.3.1 - 1.0.0)](CodeSystem-militaryStatus.md) | Code system of concepts which specify the military status of the patient. This field is defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the PD1 segment. |
| [Modality (2.3.1 - 1.0.0)](CodeSystem-modality.md) | Code system of concepts used to define the imaging apparatus expected to be used to acquire an observation. This table has been removed from the standard as of 2.7 in favor of table 0910. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Money or Percentage Indicator (2.3.1 - 1.0.0)](CodeSystem-moneyOrPercentageIndicator.md) | HL7-defined code system of concepts which specify whether the amount is currency or a percentage. Used in HL7 Version 2.x messaging in the MOP segment. |
| [Name Type (2.3.1 - 1.1.0)](CodeSystem-nameType.md) | HL7-defined code system of concepts for types of names for persons. |
| [NameAddress representation (2.3.1 - 1.0.0)](CodeSystem-name-addressRepresentation.md) | HL7-defined cdoe system of concepts that provide an indication of the kind of representation provided by a name or address, but does not necessarily specify the character sets used for the data. It is used to provides hints for a receiver, so it can make choices regarding what it has been sent and what it is capable of displaying. |
| [Nature of Abnormal Testing (2.3.1 - 1.0.0)](CodeSystem-natureOfAbnormalTesting.md) | HL7-defined code system of concepts specifying the nature of an abnormal test. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Nature of Challenge (2.3.1 - 1.0.0)](CodeSystem-natureOfChallenge.md) | HL7-defined code system of concepts used to further describe an observation definition that is characterized as a challenge observation. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Nature of Service/Test/Observation (2.3.1 - 1.0.0)](CodeSystem-natureOfServiceTestObservation.md) | Code system of concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Observation Result Status Codes Interpretation (2.3.1 - 1.2.0)](CodeSystem-observationResultStatusCodesInterpretation.md) | HL7-defined code system of concepts which specify observation result status. These codes reflect the current completion status of the results for one Observation Identifier. Used in HL7 Version 2.x messaging in the OBX segment. |
| [Occurrence Code (2.3.1 - 1.0.0)](CodeSystem-nubc-OccurrenceCode-cs.md) | National Uniform Billing Committee (NUBC) UB-04 Data Specifications Manual, UB form locator 31 - 34, Occurrence Codes and Amounts - code and associated date defining a significant event relating to the bill that may affect payer processing the claim. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the OCD segment. Updated by NUBC annually; see the coding instructions for more detail. |
| [Occurrence Span (2.3.1 - 1.0.0)](CodeSystem-nubc-OccurrenceSpan-cs.md) | HL7-defined code system of concepts specifying a National Uniform Billing Committee (NUBC) code that identifies an event that relates to the payment of a claim. The UB-04 Data Specifications Manual with the codes is available by subscription from NUBC at http://www.nubc.org/become.html. Used in HL7 Version 2.x messaging in the Occurrence Span Code and Date (OSP) value. Updated by NUBC annually; see the coding instructions for more detail. |
| [Order Control Codes (2.3.1 - 1.3.0)](CodeSystem-orderControlCodes.md) | HL7-defined code system of concepts which are used to determine the function of the order segment. Depending on the message, the action specified by one of these control codes may refer to an order or an individual service. Used in Version 2.x messaging of orders in the ORC segment. |
| [Order Status (2.3.1 - 1.2.0)](CodeSystem-orderStatus.md) | HL7-defined code system of concepts specifying the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent. Only the filler can originate these values. Used in HL7 Version 2.x messaging in the ORC segment. |
| [Organ Donor Code (2.3.1 - 1.1.0)](CodeSystem-organDonorCodes.md) | Code system of concepts specifying whether the patient wants to donate his/her organs and whether an organ donor card or similar documentation is on file with the healthcare organization. Used in HL7 Version 2.x messaging in the Patient Visit - Additional Information ( PV2) and Patient Additional Demographic (PD1) segments. |
| [Organizational Name Type (2.3.1 - 1.0.0)](CodeSystem-organizationalNameType.md) | Code system of concepts used to specify the type of name for an organization i.e., legal name, display name. Used in HL7 Version 2.x messaging in the XON and PD1 segments. |
| [Outlier Type (2.3.1 - 1.0.0)](CodeSystem-outlierType.md) | HL7-defined code system of concepts specifying the type of outlier (i.e. period of care beyond DRG-standard stay in facility) that has been paid. Used in HL7 Vesrion 2.x messaghing in the DRG segment. |
| [Override (2.3.1 - 1.0.0)](CodeSystem-override.md) | Code system of concepts used to define whether a Charge Description Master description may be overridden or if it must be overridden. Used in HL7 Version 2.x messaging in the CDM and PRC segments. |
| [PSRO/UR Approval Indicator (2.3.1 - 1.0.0)](CodeSystem-approvalIndicator.md) | HL7-defined code system of concepts for PSRO/UR approval indicators, as used in the UB82 field 87. This field is defined by HCFA (in the US) or other regulatory agencies. Note that this form type is no longer used in the US, and the codes listed (as examples) are not an exhaustive or current list; refer to a UB84 specification for additional information. Used in HL7 Version 2 messaging in UB82 segment. |
| [Patient Class (2.3.1 - 1.1.0)](CodeSystem-patientClass.md) | Code system of concepts used by systems to categorize patients by site in HL7 Version 2.x interfaces in the PV1 segment. |
| [Patient Location Type (2.3.1 - 1.0.0)](CodeSystem-patientLocationType.md) | Code system of concepts used to identify the kind of location described in the location definition. Used in HL7 Version 2.x messaging in the LOC segment. |
| [Patient Outcome (2.3.1 - 1.0.0)](CodeSystem-patientOutcome.md) | HL7-defined code system of concepts used to describe the overall state of a patient as a result of patient care. Used in HL7 Version 2.x messaging in the PEO segment. |
| [Patient's Relationship to Insured (2.3.1 - 1.0.0)](CodeSystem-patientsRelationshipToInsured.md) | Code system of concepts used to specify the relationship of the patient to the insured, as defined by CMS or other regulatory agencies. Used in HL7 Version 2.x messaging in the Insurance Additional Information (IN2) segment. |
| [Policy Type (2.3.1 - 1.0.0)](CodeSystem-policyType.md) | Code system of concepts which specify the policy type. Used in HL7 Version 2.x messaging in the PTA segment. |
| [Practitioner ID Number Type (2.3.1 - 1.0.0)](CodeSystem-practitionerIdNumberType.md) | Code system of concepts used to specify the type of number used for the practitioner identification. Used in HL7 Version 2.x messaging in the Practitioner License or Other ID Number (PLN) value as well as the Provider Data (PRD) and Contact Data (CTD)segments. |
| [Preferred Method of Contact (2.3.1 - 1.1.0)](CodeSystem-preferredMethodOfContact.md) | HL7-defined code system of concepts specifying which of a group of multiple phone numbers is the preferred method of contact for this person. Used in HL7 Version 2.x messaging in the STF, PRD, and CTD segments. |
| [Price Type (2.3.1 - 1.0.0)](CodeSystem-priceType.md) | HL7-defined code system of concepts used to identify the intent for the dollar amount on a pricing transaction. Used in HL7 Version 2.x messaging in the CP datatype. |
| [Primary Key Value Type (2.3.1 - 1.0.0)](CodeSystem-primaryKeyValueType.md) | HL7-defined code system of concepts used to specify the type for the master file record identifier. Used in HL7 Version 2.x messaging in the Master File Entry (MFE) segment. |
| [Primary Observer's Qualification (2.3.1 - 1.0.0)](CodeSystem-primaryObserverQualification.md) | HL7-defined code system of concepts used to provide a general description of the kind of health care professional who provided the primary observation. Used in HL7 Version 2.x messaging in the PEO and PCR segments. |
| [Priority (2.3.1 - 1.2.0)](CodeSystem-priority.md) | HL7-defined code system of concepts specifying the allowed priorities for obtaining the specimen. Used in HL7 Version 2.x messaging in the OM4 segment. |
| [Privacy Level (2.3.1 - 1.0.0)](CodeSystem-privacyLevel.md) | Code system of concepts used to identify the level of privacy a patient will be afforded when assigned to this location definition. Used in HL7 Version 2.x messaging in the LCH segment. |
| [Problem/Goal Action Code (2.3.1 - 1.0.0)](CodeSystem-problem-goalAction.md) | HL7-defined code system of concepts used in Patient Care for the intent of a problem or goal. Used in HL7 Version 2.x messaging in the GOL, ROL, PRB and PTH segments. |
| [Procedure Functional Type (2.3.1 - 1.0.0)](CodeSystem-procedureFunctionalType.md) | Code system of concepts used to classify a procedure. Used in HL7 Version 2.x messaging in the PR1 segment. |
| [Procedure Practitioner Identifier Type (2.3.1 - 1.1.0)](CodeSystem-procedurePractitionerIdentifierCodeType.md) | HL7-defined table of concepts which specify the different types of practitioners associated with this procedure. This set of codes is known to be incomplete. Note that as of v2.6, this table and the field(s) it was used in was replaced by table 443 used in the ROL segment. Used in Version 2.x messaging in the PR1 segment, but was discontinued as of 2.6; usage replaced with code system 2.16.840.1.113883.18.283 providerRole. |
| [Processing ID (2.3.1 - 1.0.0)](CodeSystem-processingId.md) | HL7-defined code system of concepts which specify whether the message is part of a production, training or debugging system. Used in HL7 Version 2.x messaging in the PT datatype. |
| [Processing Mode (2.3.1 - 1.1.0)](CodeSystem-processingMode.md) | HL7-defined code system of concepts that indicate an archival process or an initial load process. Used in HL7 Version 2.x messaging in the PT datatype. |
| [Processing Priority (2.3.1 - 1.0.0)](CodeSystem-processingPriority.md) | HL7-defined code system of concepts which specify one or more available priorities for performing the observation or test. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Product Source (2.3.1 - 1.0.0)](CodeSystem-productSource.md) | HL7-defined code system of concepts used to describe the evaluation state of a product identified in an incident. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Provider Billing (2.3.1 - 1.0.0)](CodeSystem-providerBilling.md) | HL7-defined code system of concepts specifying how provider services are billed. Used in HL7 Version 2.x messaging in the PRA segment. |
| [Provider Role (2.3.1 - 1.0.0)](CodeSystem-providerRole.md) | Code system of concepts used to define the relationship between a referral recipient and a patient or between a referral initiator and a patient. Used in HL7 Version 2.x messaging in the PRD segment. |
| [Purge Status Code (2.3.1 - 1.0.0)](CodeSystem-purgeStatus.md) | Code system of concepts used to define the state of a visit relative to its place in a purge workflow. Used in HL7 Version 2.x messaging in the PV2 segment. |
| [Quantity Limited Request (2.3.1 - 1.1.0)](CodeSystem-quantityLimitedRequest.md) | HL7-defined code system of concepts which specify the maximum length of a query response that can be accepted by a requesting system, and are expressed as units of mesaure of query response objects. Used in HL7 Version 2.x messaging in the RCP segment. |
| [Quantity Method (2.3.1 - 1.0.0)](CodeSystem-quantityMethod.md) | HL7-defined code system of concepts used to specify the method by which the quantity distributed is measured. Used in HL7 Version 2.x messaging in the Product Summary Header (PSH) segment. |
| [Query Priority (2.3.1 - 1.0.0)](CodeSystem-queryPriority.md) | HL7-defined code system of concepts which specify a time frame in which a querry response is expected. Used in HL7 Verson 2.x messaging in the RCP segment. |
| [Query Response Status (2.3.1 - 1.1.0)](CodeSystem-queryResponseStatus.md) | HL7-defined code system of concepts defining precise response status concepts in support of HL7 Version 2 query messaging. It is commonly used to indicate no data is found that matches the query parameters, but no error. Used in HL7 Version 2.x messaging in the QAK segment. |
| [Query Results Level (2.3.1 - 1.0.2)](CodeSystem-queryResultsLevel.md) | HL7-defined code system of concepts which are used to control level of detail in query results. Used in HL7 Version 2 messaging in the URD segment. |
| [Query/Response Format Code (2.3.1 - 1.2.0)](CodeSystem-queryResponseFormat.md) | HL7-defined code system of concepts which specify which of several types of formats for data to be returned in response to a query. Used in HL7 Version 2 messaging in the EQL segment. |
| [RX Component Type (2.3.1 - 1.0.0)](CodeSystem-rxComponentType.md) | HL7-defined code system of concepts which specify the RX component type. Used in HL7 Version 2.x messaging in the RXC segment. |
| [Record-level Event Code (2.3.1 - 1.0.0)](CodeSystem-masterfileActionCode.md) | HL7-defined code system of concepts specifying an action for a master file record. Used in HL7 Version 2.x messaging in the MFE segment. |
| [Referral Category (2.3.1 - 1.0.0)](CodeSystem-referralCategory.md) | Code system of concepts used to describe the patient care setting where a referral should take place. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [Referral Disposition (2.3.1 - 1.0.0)](CodeSystem-referralDisposition.md) | Code system of concepts used to identify the expected response from the healthcare professional receiving a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [Referral Priority (2.3.1 - 1.0.0)](CodeSystem-referralPriority.md) | Code system of concepts used to designate the urgency of a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [Referral Reason (2.3.1 - 1.0.0)](CodeSystem-referralReason.md) | Code system of concepts used to specify the reason for which the referral will take place. Used in HL7 Version 2.x messaging in the Referral Information (RF1) segment. |
| [Referral Status (2.3.1 - 1.0.0)](CodeSystem-referralStatus.md) | Code system of concepts used to define the state of a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [Referral Type (2.3.1 - 1.0.0)](CodeSystem-referralType.md) | Code system of concepts used to identify the general category of healthcare professional desired to satisfy a referral. Used in HL7 Version 2.x messaging in the RF1 segment. |
| [Relatedness Assessment (2.3.1 - 1.0.0)](CodeSystem-relatednessAssessment.md) | HL7-defined code system of concepts used to provide an estimate of whether an issue with a product was the cause of an event. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Relational Conjunction (2.3.1 - 1.0.0)](CodeSystem-relationalConjunction.md) | HL7-defined code system of concepts used with relationalOperator values to group more than one segment field name. Used in HL7 Version 2.x messaging in the QSC segment. |
| [Relational Operator (2.3.1 - 1.0.0)](CodeSystem-relationalOperator.md) | HL7-defined code system of concepts used to define the relationship between HL7 segment field names identified in a query construct. Used in HL7 Version 2.x messaging in the QSC segment. |
| [Relationship Modifier (2.3.1 - 1.0.0)](CodeSystem-relationshipModifier.md) | HL7-defined code system of concepts used in an observation definition to describe the subject of an observation in relation to a patient. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Report Priority (2.3.1 - 1.0.0)](CodeSystem-reportPriority.md) | HL7-defined code system of concepts which specify the priority associated with a report or update run using a query. Used in HL7 Version 2 messaging in the URD segment. |
| [Report Source (2.3.1 - 1.0.0)](CodeSystem-reportSource.md) | HL7-defined code system of concepts used to identify where a report sender learned about an event. Used in HL7 Version 2.x messaging in the PES segment. |
| [Report Timing (2.3.1 - 1.0.0)](CodeSystem-reportTiming.md) | HL7-defined code system of concepts used to identify the time span of a report or the reason for a report sent to a regulatory agency. Used in HL7 Version 2.x messaging in the PES segment. |
| [Reporting Priority (2.3.1 - 1.0.0)](CodeSystem-reportingPriority.md) | HL7-defined code system of concepts which specify the available priorities reporting the test results when the user is asked to specify the reporting priority independent of the processing priority. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Response Flag (2.3.1 - 1.0.0)](CodeSystem-responseFlag.md) | HL7-defined code system of concepts allowing the placer (sending) application to determine the amount of information to be returned from the filler. Used in HL7 Version 2.x messaging in the ORC segment. |
| [Response Level (2.3.1 - 1.0.0)](CodeSystem-responseLevel.md) | HL7-defined code system of concepts specifying application response levels defined for a given Master File Message at the MFE segment level, and used for MFN-Master File Notification message. Specifies additional detail (beyond MSH-15 - Accept Acknowledgment Type and MSH-16 - Application Acknowledgment Type) for application-level acknowledgment paradigms for Master Files transactions. Used in HL7 Version 2.x messaging in the MFI segment. |
| [Result Status (2.3.1 - 1.2.0)](CodeSystem-resultStatus.md) | HL7-defined code system of concepts which specify a status of results for an order. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Room Type (2.3.1 - 1.0.0)](CodeSystem-roomType.md) | Code system of concepts which specify the room type. Used in HL7 Version 2.x messaging in the RMC segment. |
| [Route of Administration (2.3.1 - 3.0.0)](CodeSystem-routeOfAdministration.md) | Code system of concepts which specify the route of administration. Used in HL7 Version 2.x messaging in the RXR segment. |
| [Segment Action Code (2.3.1 - 1.0.0)](CodeSystem-segmentAction.md) | HL7-defined code system of concepts specifying actions to be applied for segments when an HL7 version 2 interface is operating in "action code mode" (a kind of update mode in the Standard). Used in HL7 Version 2.x messaging in the RXA, RXV, LCH, IAM, ARV, IN1 and OH1 segments. |
| [Sex (2.3.1 - 1.0.0)](CodeSystem-sex.md) | HL7-defined code system of concepts specifying a person's sex. |
| [Source Type (2.3.1 - 1.0.0)](CodeSystem-sourceType.md) | HL7-defined code system of concepts used to specify the type of facility. Used in HL7 Version 2.x messaging in the Facility (FAC) segment. |
| [Source of Comment (2.3.1 - 1.1.0)](CodeSystem-sourceOfComment.md) | HL7-defined code system of concepts which are used to specify the source of a comment. Used in HL7 Version 2.x messaging in the NTE segment. |
| [Specialty Type (2.3.1 - 1.0.0)](CodeSystem-specialtyType.md) | Code system of concepts used to identify the specialty of the care professional who is supported when using this location definition. Used in HL7 Version 2.x messaging in the LDP segment. |
| [Specimen Action Code (2.3.1 - 2.1.0)](CodeSystem-specimenAction.md) | HL7-defined code system of concepts which specify actions to be taken with respect to the specimens that accompany or precede an order. The purpose of these are to further qualify (when appropriate) the general action indicated by the order control code (code system xxxx). Used in HL7 Version 2.x messaging in the OBR segment. |
| [Specimen Source Codes (2.3.1 - 1.2.0)](CodeSystem-specimenSourceCodes.md) | HL7-defined code system of concepts which specify sources for speciments for clinical testing. These concepts are used in HL7 Version 2.x messaging in the OBR segment prior to version 2.7, and was replaced by the concepts in code system 2.16.840.1.133883.18.311 specimenType and code system 2.16.840.1.133883.18.312 specimenCollectionMethod as of version 2.5 and thereafter. |
| [Status of Evaluation (2.3.1 - 1.0.0)](CodeSystem-statusOfEvaluation.md) | HL7-defined code system of concepts that describes the status of product evaluation. Used in HL7 Version 2.x messaging in the PCR segment. |
| [Student Status (2.3.1 - 1.0.0)](CodeSystem-studentStatus.md) | Code system of concepts used to designate whether a guarantor is a full or part time student. Used in HL7 Version 2.x messaging in the GT1, NK1 and PD1 segments. |
| [Substitution Status (2.3.1 - 1.1.0)](CodeSystem-substitutionStatus.md) | HL7-defined code system of concepts which specify the substitution status. Used in HL7 Version 2.x messaging in the RXE, RXD, and RXG segments. |
| [Subtype of Referenced Data (2.3.1 - 1.1.0)](CodeSystem-subtypeOfReferencedData.md) | Code system of a subset of the media subtypes of binary data that are encoded in an ascii structure or stream. Used in Version 2 messaging ED and RP datatypes, but only in standard 2.5.1 and earlier; after that, it was recommended that the IANA media types be used instead of this short list of HL7-defined codes. More information on the standard media types and subtypes may be found at http://www.iana.org/assignments/media-types/media-types.xhtml. |
| [Telecommunication Equipment Type (2.3.1 - 1.0.0)](CodeSystem-telecommunicationEquipmentType.md) | HL7-defined code system of concepts for specifying a type of telecommunication equipment. Best practice is to use this concept whenever a telecommunication number or access string for particular equipment is specified. Used in HL7 Version 2.x messaging in the XTN segment. |
| [Telecommunication Use Code (2.3.1 - 1.1.0)](CodeSystem-telecommunicationUse.md) | HL7-defined code system of concepts for specifying a specific use of a telecommunication number. Best practice is to use this concept whenever a telecommunication number or access string is specified. Used in HL7 Version 2.x messaging in the XTN segment. |
| [Time Delay Post Challenge (2.3.1 - 1.0.0)](CodeSystem-timeDelayPostChallenge.md) | HL7-defined code system of concepts used to classify an observation definition as being a component of a challenge test. Used in HL7 Version 2.x messaging in the OM1 segment. |
| [Time Selection Criteria Parameter Class Codes (2.3.1 - 1.0.0)](CodeSystem-timeSelectionCriteriaParameterClass.md) | Code system of concepts used to describe acceptable start and end times, as well as days of the week, for appointment or resource scheduling. Used in HL7 Version 2.x messaging in the SCV and APR segments. |
| [Transaction Type (2.3.1 - 1.0.0)](CodeSystem-transactionType.md) | Code system of concepts specifying a type of financial transaction. Used in HL7 Version 2.x messaging in the FT1 segment. |
| [Transport Arranged (2.3.1 - 1.0.0)](CodeSystem-transportArranged.md) | HL7-defined code system of concepts defining whether patient transportation preparations are in place. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Transportation Mode (2.3.1 - 1.0.0)](CodeSystem-transportationMode.md) | HL7-defined code system of concepts which specify how (or whether) to transport a patient, when applicable, for an ordered service. Used in HL7 Version 2.x messaging in the OBR segment. |
| [Tray Type (2.3.1 - 1.0.0)](CodeSystem-trayType.md) | HL7-defined code system of concepts which specify whether the type of diet. Used in HL7 Version 2.x messaging in the ODT segment. |
| [Type of Referenced Data (2.3.1 - 1.2.0)](CodeSystem-typeOfReferencedData.md) | HL7-defined code system of concepts declaring the general type of media data that is encoded. Used in v2.5.1 interfaces and earlier, and replaced with the full set of IANA media types as a standard coding system for this after HL7 version 2.6 (see value set 2.16.840.1.113883.21.425 hl7VS-mimeTypes for HL7 table 0834 built on MIME types). More information may be found at http://www.iana.org/assignments/media-types/media-types.xhtml |
| [Universal ID Type (2.3.1 - 1.0.0)](CodeSystem-universalIdType.md) | HL7-defined code system of types of UID (Universal Identifiers). Used in HL7 Version 2.x messaging HD and EI datatypes. |
| [Vaccines Administered (2.3.1 - 1.1.0)](CodeSystem-vaccinesAdministeredHL7.md) | Code system of codes specifying the administered vaccines, and used only in HL7 releases 2.3, 2.3.1, and 2.4 of the standard. This code system was superceded when the US Centers of Disease Control began publishing the codes directly; the code system to be used now is 2.16.840.1.113883.12.292 PH_VaccinesAdministeredCVX_CDC_NIP. |
| [Version ID (2.3.1 - 1.3.0)](CodeSystem-versionId.md) | HL7-defined code system of concepts which are used to identify an HL7 version in the Version 2.x family of published standards. Used in HL7 Version 2.x messaging in the VID segment. |
| [Visit Indicator (2.3.1 - 1.0.0)](CodeSystem-visitIndicator.md) | Code system of concepts specifying the level on which data are being sent. It is the indicator used to send data at two levels, visit and account. HL7 recommends sending an "A" or no value when the data in the message are at the account level or "V" to indicate that the data sent in the message are at the visit level. Used in HL7 Version 2.x messaging in the Patient Visit (PV1) segment. |
| [What subject filter (2.3.1 - 1.3.0)](CodeSystem-whatSubjectFilter.md) | HL7-defined code system of concepts which specify the kind of information that is required to satisfy a query request. The values define the type of transaction inquiry. Used in HL7 Version 2 messaging in the URD segment. |
| [Which Date/Time Qualifier (2.3.1 - 1.1.0)](CodeSystem-whichDate-timeQualifier.md) | HL7-defined code system of concepts that specify a type of date referred to in query specifications. Used in HL7 Version 2 messaging in the QRF segment. |
| [Which Date/Time Status Qualifier (2.3.1 - 1.0.0)](CodeSystem-whichDate-timeStatusQualifier.md) | HL7-defined code system of concepts that specify the status type of objects selected in a date range. Used in HL7 Vesion 2 messaging in the QRF segment. |
| [Yes/No Indicator (2.3.1 - 1.0.0)](CodeSystem-expandedYes-NoIndicator.md) | HL7-defined code system of concepts used to specify an expansion on the original Yes/No indicator table by including "flavors of null". It is intended to be applied to fields where the response is not limited to "yes" or "no". Used in numerous locations in HL7 Version 2.x messaging. |

