# Message Structure (2.3.1 - 1.0.0) - HL7 v2.3.1 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Message Structure (2.3.1 - 1.0.0)**

## CodeSystem: Message Structure (2.3.1 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/messageStructure | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:MessageStructure |
| *Other Identifiers:*OID:2.16.840.1.113883.18.214 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of abstract message structure codes. Each code identifies a specific message structure abstract syntax as published in the HL7 Version 2 standard. Used in HL7 Version 2.x messaging in the MSH segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmessageStructure](ValueSet-hl7VSmessageStructure.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "messageStructure",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3.1"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0354"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/messageStructure",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.214"
    }
  ],
  "version" : "1.0.0",
  "name" : "MessageStructure",
  "title" : "Message Structure (2.3.1 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:22:40+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of abstract message structure codes. Each code identifies a specific message structure abstract syntax as published in the HL7 Version 2 standard.  Used in HL7 Version 2.x messaging in the MSH segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VShl7VSevent"
        }
      ],
      "code" : "event",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#event",
      "description" : "event",
      "type" : "code"
    },
    {
      "code" : "trigger",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#trigger",
      "description" : "trigger",
      "type" : "boolean"
    }
  ],
  "concept" : [
    {
      "code" : "ACK",
      "display" : "ACK",
      "definition" : "ACK",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A01"
        },
        {
          "code" : "event",
          "valueCode" : "A02"
        },
        {
          "code" : "event",
          "valueCode" : "A03"
        },
        {
          "code" : "event",
          "valueCode" : "A04"
        },
        {
          "code" : "event",
          "valueCode" : "A05"
        },
        {
          "code" : "event",
          "valueCode" : "A06"
        },
        {
          "code" : "event",
          "valueCode" : "A07"
        },
        {
          "code" : "event",
          "valueCode" : "A08"
        },
        {
          "code" : "event",
          "valueCode" : "A09"
        },
        {
          "code" : "event",
          "valueCode" : "A10"
        },
        {
          "code" : "event",
          "valueCode" : "A11"
        },
        {
          "code" : "event",
          "valueCode" : "A12"
        },
        {
          "code" : "event",
          "valueCode" : "A13"
        },
        {
          "code" : "event",
          "valueCode" : "A14"
        },
        {
          "code" : "event",
          "valueCode" : "A15"
        },
        {
          "code" : "event",
          "valueCode" : "A16"
        },
        {
          "code" : "event",
          "valueCode" : "A17"
        },
        {
          "code" : "event",
          "valueCode" : "A18"
        },
        {
          "code" : "event",
          "valueCode" : "A20"
        },
        {
          "code" : "event",
          "valueCode" : "A21"
        },
        {
          "code" : "event",
          "valueCode" : "A22"
        },
        {
          "code" : "event",
          "valueCode" : "A23"
        },
        {
          "code" : "event",
          "valueCode" : "A24"
        },
        {
          "code" : "event",
          "valueCode" : "A25"
        },
        {
          "code" : "event",
          "valueCode" : "A26"
        },
        {
          "code" : "event",
          "valueCode" : "A27"
        },
        {
          "code" : "event",
          "valueCode" : "A28"
        },
        {
          "code" : "event",
          "valueCode" : "A29"
        },
        {
          "code" : "event",
          "valueCode" : "A30"
        },
        {
          "code" : "event",
          "valueCode" : "A31"
        },
        {
          "code" : "event",
          "valueCode" : "A32"
        },
        {
          "code" : "event",
          "valueCode" : "A33"
        },
        {
          "code" : "event",
          "valueCode" : "A34"
        },
        {
          "code" : "event",
          "valueCode" : "A35"
        },
        {
          "code" : "event",
          "valueCode" : "A36"
        },
        {
          "code" : "event",
          "valueCode" : "A37"
        },
        {
          "code" : "event",
          "valueCode" : "A38"
        },
        {
          "code" : "event",
          "valueCode" : "A39"
        },
        {
          "code" : "event",
          "valueCode" : "A40"
        },
        {
          "code" : "event",
          "valueCode" : "A41"
        },
        {
          "code" : "event",
          "valueCode" : "A42"
        },
        {
          "code" : "event",
          "valueCode" : "A43"
        },
        {
          "code" : "event",
          "valueCode" : "A44"
        },
        {
          "code" : "event",
          "valueCode" : "A45"
        },
        {
          "code" : "event",
          "valueCode" : "A46"
        },
        {
          "code" : "event",
          "valueCode" : "A47"
        },
        {
          "code" : "event",
          "valueCode" : "A48"
        },
        {
          "code" : "event",
          "valueCode" : "A49"
        },
        {
          "code" : "event",
          "valueCode" : "A50"
        },
        {
          "code" : "event",
          "valueCode" : "A51"
        },
        {
          "code" : "event",
          "valueCode" : "I07"
        },
        {
          "code" : "event",
          "valueCode" : "N02"
        },
        {
          "code" : "event",
          "valueCode" : "P01"
        },
        {
          "code" : "event",
          "valueCode" : "P02"
        },
        {
          "code" : "event",
          "valueCode" : "P03"
        },
        {
          "code" : "event",
          "valueCode" : "P05"
        },
        {
          "code" : "event",
          "valueCode" : "P06"
        },
        {
          "code" : "event",
          "valueCode" : "PC1"
        },
        {
          "code" : "event",
          "valueCode" : "PC2"
        },
        {
          "code" : "event",
          "valueCode" : "PC3"
        },
        {
          "code" : "event",
          "valueCode" : "PC4"
        },
        {
          "code" : "event",
          "valueCode" : "PC5"
        },
        {
          "code" : "event",
          "valueCode" : "PC6"
        },
        {
          "code" : "event",
          "valueCode" : "PC7"
        },
        {
          "code" : "event",
          "valueCode" : "PC8"
        },
        {
          "code" : "event",
          "valueCode" : "PC9"
        },
        {
          "code" : "event",
          "valueCode" : "PCA"
        },
        {
          "code" : "event",
          "valueCode" : "PCB"
        },
        {
          "code" : "event",
          "valueCode" : "PCC"
        },
        {
          "code" : "event",
          "valueCode" : "PCD"
        },
        {
          "code" : "event",
          "valueCode" : "PCE"
        },
        {
          "code" : "event",
          "valueCode" : "PCF"
        },
        {
          "code" : "event",
          "valueCode" : "PCG"
        },
        {
          "code" : "event",
          "valueCode" : "PCH"
        },
        {
          "code" : "event",
          "valueCode" : "PCJ"
        },
        {
          "code" : "event",
          "valueCode" : "PCK"
        },
        {
          "code" : "event",
          "valueCode" : "PCL"
        },
        {
          "code" : "event",
          "valueCode" : "Q03"
        },
        {
          "code" : "event",
          "valueCode" : "Q05"
        },
        {
          "code" : "event",
          "valueCode" : "R01"
        },
        {
          "code" : "event",
          "valueCode" : "S12"
        },
        {
          "code" : "event",
          "valueCode" : "S13"
        },
        {
          "code" : "event",
          "valueCode" : "S14"
        },
        {
          "code" : "event",
          "valueCode" : "S15"
        },
        {
          "code" : "event",
          "valueCode" : "S16"
        },
        {
          "code" : "event",
          "valueCode" : "S17"
        },
        {
          "code" : "event",
          "valueCode" : "S18"
        },
        {
          "code" : "event",
          "valueCode" : "S19"
        },
        {
          "code" : "event",
          "valueCode" : "S20"
        },
        {
          "code" : "event",
          "valueCode" : "S21"
        },
        {
          "code" : "event",
          "valueCode" : "S22"
        },
        {
          "code" : "event",
          "valueCode" : "S23"
        },
        {
          "code" : "event",
          "valueCode" : "S24"
        },
        {
          "code" : "event",
          "valueCode" : "S26"
        },
        {
          "code" : "event",
          "valueCode" : "T01"
        },
        {
          "code" : "event",
          "valueCode" : "T02"
        },
        {
          "code" : "event",
          "valueCode" : "T03"
        },
        {
          "code" : "event",
          "valueCode" : "T04"
        },
        {
          "code" : "event",
          "valueCode" : "T05"
        },
        {
          "code" : "event",
          "valueCode" : "T06"
        },
        {
          "code" : "event",
          "valueCode" : "T07"
        },
        {
          "code" : "event",
          "valueCode" : "T08"
        },
        {
          "code" : "event",
          "valueCode" : "T09"
        },
        {
          "code" : "event",
          "valueCode" : "T10"
        },
        {
          "code" : "event",
          "valueCode" : "T11"
        }
      ]
    },
    {
      "code" : "ADR_A19",
      "display" : "A19",
      "definition" : "A19",
      "property" : [
        {
          "code" : "usage",
          "valueString" : "correction of typo"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A19"
        }
      ]
    },
    {
      "code" : "ADT_A01",
      "display" : "A01, A04, A05, A08, A13, A14, A28, A31",
      "definition" : "A01, A04, A05, A08, A13, A14, A28, A31",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A01"
        },
        {
          "code" : "event",
          "valueCode" : "A04"
        },
        {
          "code" : "event",
          "valueCode" : "A05"
        },
        {
          "code" : "event",
          "valueCode" : "A08"
        },
        {
          "code" : "event",
          "valueCode" : "A13"
        },
        {
          "code" : "event",
          "valueCode" : "A14"
        },
        {
          "code" : "event",
          "valueCode" : "A28"
        },
        {
          "code" : "event",
          "valueCode" : "A31"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A02",
      "display" : "A02, A21, A22, A23, A25, A26, A27, A29, A32, A33",
      "definition" : "A02, A21, A22, A23, A25, A26, A27, A29, A32, A33",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A02"
        },
        {
          "code" : "event",
          "valueCode" : "A21"
        },
        {
          "code" : "event",
          "valueCode" : "A22"
        },
        {
          "code" : "event",
          "valueCode" : "A23"
        },
        {
          "code" : "event",
          "valueCode" : "A25"
        },
        {
          "code" : "event",
          "valueCode" : "A26"
        },
        {
          "code" : "event",
          "valueCode" : "A27"
        },
        {
          "code" : "event",
          "valueCode" : "A29"
        },
        {
          "code" : "event",
          "valueCode" : "A32"
        },
        {
          "code" : "event",
          "valueCode" : "A33"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A03",
      "display" : "A03",
      "definition" : "A03",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A03"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A06",
      "display" : "A06, A07",
      "definition" : "A06, A07",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A06"
        },
        {
          "code" : "event",
          "valueCode" : "A07"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A09",
      "display" : "A09, A10, A11, A15",
      "definition" : "A09, A10, A11, A15",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A09"
        },
        {
          "code" : "event",
          "valueCode" : "A10"
        },
        {
          "code" : "event",
          "valueCode" : "A11"
        },
        {
          "code" : "event",
          "valueCode" : "A15"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A12",
      "display" : "A12",
      "definition" : "A12",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A12"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A16",
      "display" : "A16",
      "definition" : "A16",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A16"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A17",
      "display" : "A17",
      "definition" : "A17",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A17"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A18",
      "display" : "A18",
      "definition" : "A18",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A18"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A20",
      "display" : "A20",
      "definition" : "A20",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A20"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A24",
      "display" : "A24",
      "definition" : "A24",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A24"
        },
        {
          "code" : "event",
          "valueCode" : "A37"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A28",
      "display" : "A28, A31",
      "definition" : "A28, A31",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ADT_A30",
      "display" : "A30, A34, A35, 136, A46, A47, A48, A49",
      "definition" : "A30, A34, A35, 136, A46, A47, A48, A49",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A30"
        },
        {
          "code" : "event",
          "valueCode" : "A34"
        },
        {
          "code" : "event",
          "valueCode" : "A35"
        },
        {
          "code" : "event",
          "valueCode" : "A36"
        },
        {
          "code" : "event",
          "valueCode" : "A46"
        },
        {
          "code" : "event",
          "valueCode" : "A47"
        },
        {
          "code" : "event",
          "valueCode" : "A48"
        },
        {
          "code" : "event",
          "valueCode" : "A49"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A37",
      "display" : "A37",
      "definition" : "A37",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ADT_A38",
      "display" : "A38",
      "definition" : "A38",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A38"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A39",
      "display" : "A39, A40, A41, A42",
      "definition" : "A39, A40, A41, A42",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A39"
        },
        {
          "code" : "event",
          "valueCode" : "A40"
        },
        {
          "code" : "event",
          "valueCode" : "A41"
        },
        {
          "code" : "event",
          "valueCode" : "A42"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A43",
      "display" : "A43, A44",
      "definition" : "A43, A44",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A43"
        },
        {
          "code" : "event",
          "valueCode" : "A44"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A45",
      "display" : "A45",
      "definition" : "A45",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A45"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ADT_A50",
      "display" : "A50, A51",
      "definition" : "A50, A51",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A50"
        },
        {
          "code" : "event",
          "valueCode" : "A51"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "BAR_P01",
      "display" : "P01, P05",
      "definition" : "P01, P05",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "P01"
        },
        {
          "code" : "event",
          "valueCode" : "P05"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "BAR_P02",
      "display" : "P02",
      "definition" : "P02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "P02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "BAR_P06",
      "display" : "P06",
      "definition" : "P06",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "P06"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "CRM_C01",
      "display" : "C01, C02, C03, C04, C05, C06, C07, C08",
      "definition" : "C01, C02, C03, C04, C05, C06, C07, C08",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "C01"
        },
        {
          "code" : "event",
          "valueCode" : "C02"
        },
        {
          "code" : "event",
          "valueCode" : "C03"
        },
        {
          "code" : "event",
          "valueCode" : "C04"
        },
        {
          "code" : "event",
          "valueCode" : "C05"
        },
        {
          "code" : "event",
          "valueCode" : "C06"
        },
        {
          "code" : "event",
          "valueCode" : "C07"
        },
        {
          "code" : "event",
          "valueCode" : "C08"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "CSU_C09",
      "display" : "C09, C10, C11, C12",
      "definition" : "C09, C10, C11, C12",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "C09"
        },
        {
          "code" : "event",
          "valueCode" : "C10"
        },
        {
          "code" : "event",
          "valueCode" : "C11"
        },
        {
          "code" : "event",
          "valueCode" : "C12"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "DFT_P03",
      "display" : "P03",
      "definition" : "P03",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "P03"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "DOC_T12",
      "display" : "T12",
      "definition" : "T12",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "T12"
        }
      ]
    },
    {
      "code" : "DSR_Q01",
      "display" : "Q01",
      "definition" : "Q01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q01"
        }
      ]
    },
    {
      "code" : "DSR_Q03",
      "display" : "Q03",
      "definition" : "Q03",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q03"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "EDR_R07",
      "display" : "R07",
      "definition" : "R07",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "R07"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "EQQ_Q04",
      "display" : "Q04",
      "definition" : "Q04",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q04"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ERP_R09",
      "display" : "R09",
      "definition" : "R09",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "R09"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "MDM_T01",
      "display" : "T01, T03, T05, T07, T09, T11",
      "definition" : "T01, T03, T05, T07, T09, T11",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "T01"
        },
        {
          "code" : "event",
          "valueCode" : "T03"
        },
        {
          "code" : "event",
          "valueCode" : "T05"
        },
        {
          "code" : "event",
          "valueCode" : "T07"
        },
        {
          "code" : "event",
          "valueCode" : "T09"
        },
        {
          "code" : "event",
          "valueCode" : "T11"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "MDM_T02",
      "display" : "T02, T04, T06, T08, T10",
      "definition" : "T02, T04, T06, T08, T10",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "T02"
        },
        {
          "code" : "event",
          "valueCode" : "T04"
        },
        {
          "code" : "event",
          "valueCode" : "T06"
        },
        {
          "code" : "event",
          "valueCode" : "T08"
        },
        {
          "code" : "event",
          "valueCode" : "T10"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "MFK_M01",
      "display" : "M01, M03, M05, M06, M07, M08, M09, M10, M11",
      "definition" : "M01, M03, M05, M06, M07, M08, M09, M10, M11",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "M01"
        },
        {
          "code" : "event",
          "valueCode" : "M02"
        },
        {
          "code" : "event",
          "valueCode" : "M03"
        },
        {
          "code" : "event",
          "valueCode" : "M04"
        },
        {
          "code" : "event",
          "valueCode" : "M05"
        },
        {
          "code" : "event",
          "valueCode" : "M06"
        },
        {
          "code" : "event",
          "valueCode" : "M07"
        },
        {
          "code" : "event",
          "valueCode" : "M08"
        },
        {
          "code" : "event",
          "valueCode" : "M09"
        },
        {
          "code" : "event",
          "valueCode" : "M10"
        },
        {
          "code" : "event",
          "valueCode" : "M11"
        }
      ]
    },
    {
      "code" : "MFN_M01",
      "display" : "M01",
      "definition" : "M01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "M01"
        },
        {
          "code" : "event",
          "valueCode" : "M03"
        },
        {
          "code" : "event",
          "valueCode" : "M04"
        },
        {
          "code" : "event",
          "valueCode" : "M05"
        },
        {
          "code" : "event",
          "valueCode" : "M06"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "MFN_M02",
      "display" : "M02",
      "definition" : "M02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "M02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "MFN_M03",
      "display" : "M03",
      "definition" : "M03",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MFN_M05",
      "display" : "M05",
      "definition" : "M05",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MFN_M06",
      "display" : "M06",
      "definition" : "M06",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "MFN_M07",
      "display" : "M07",
      "definition" : "M07",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "M07"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "MFN_M08",
      "display" : "M08",
      "definition" : "M08",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "M08"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "MFN_M09",
      "display" : "M09",
      "definition" : "M09",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "M09"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "MFN_M10",
      "display" : "M10",
      "definition" : "M10",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "M10"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "MFN_M11",
      "display" : "M11",
      "definition" : "M11",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "M11"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "OMD_O01",
      "display" : "O01",
      "definition" : "O01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "OMN_O01",
      "display" : "O01",
      "definition" : "O01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "OMS_O01",
      "display" : "O01",
      "definition" : "O01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ORD_O02",
      "display" : "O02",
      "definition" : "O02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ORF_R02",
      "display" : "R02, R04",
      "definition" : "R02, R04",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ORM_O01",
      "display" : "O01",
      "definition" : "O01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ORM_Q06",
      "display" : "Q06",
      "definition" : "Q06",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ORN_O02",
      "display" : "O02",
      "definition" : "O02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ORR_O02",
      "display" : "O02",
      "definition" : "O02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ORR_Q06",
      "display" : "Q06",
      "definition" : "Q06",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "ORS_O02",
      "display" : "O02",
      "definition" : "O02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ORU_R01",
      "display" : "R01",
      "definition" : "R01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "R01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ORU_W01",
      "display" : "W01",
      "definition" : "W01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "OSQ_Q06",
      "display" : "Q06",
      "definition" : "Q06",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q06"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "OSR_Q06",
      "display" : "Q06",
      "definition" : "Q06",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q06"
        }
      ]
    },
    {
      "code" : "PEX_P07",
      "display" : "P07, P08",
      "definition" : "P07, P08",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "P07"
        },
        {
          "code" : "event",
          "valueCode" : "P08"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "PGL_PC6",
      "display" : "PC6, PC7, PC8",
      "definition" : "PC6, PC7, PC8",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "PC6"
        },
        {
          "code" : "event",
          "valueCode" : "PC7"
        },
        {
          "code" : "event",
          "valueCode" : "PC8"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "PIN_I07",
      "display" : "I07",
      "definition" : "I07",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I07"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "PPG_PCG",
      "display" : "PCC, PCH, PCJ",
      "definition" : "PCC, PCH, PCJ",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "PCG"
        },
        {
          "code" : "event",
          "valueCode" : "PCH"
        },
        {
          "code" : "event",
          "valueCode" : "PCJ"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "PPP_PCB",
      "display" : "PCB, PCD",
      "definition" : "PCB, PCD",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "PCB"
        },
        {
          "code" : "event",
          "valueCode" : "PCC"
        },
        {
          "code" : "event",
          "valueCode" : "PCD"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "PPR_PC1",
      "display" : "PC1, PC2, PC3",
      "definition" : "PC1, PC2, PC3",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "PC1"
        },
        {
          "code" : "event",
          "valueCode" : "PC2"
        },
        {
          "code" : "event",
          "valueCode" : "PC3"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "PPT_PCL",
      "display" : "PCL",
      "definition" : "PCL",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "PCL"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "PPV_PCA",
      "display" : "PCA",
      "definition" : "PCA",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "PCA"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "PRR_PC5",
      "display" : "PC5",
      "definition" : "PC5",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "PC5"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "PTR_PCF",
      "display" : "PCF",
      "definition" : "PCF",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "PCF"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "QCK_Q02",
      "display" : "Q02",
      "definition" : "Q02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q02"
        }
      ]
    },
    {
      "code" : "QRY_A19",
      "display" : "A19",
      "definition" : "A19",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "A19"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "QRY_PC4",
      "display" : "PC4, PC9, PCE, PCK",
      "definition" : "PC4, PC9, PCE, PCK",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "PC4"
        },
        {
          "code" : "event",
          "valueCode" : "PC9"
        },
        {
          "code" : "event",
          "valueCode" : "PCE"
        },
        {
          "code" : "event",
          "valueCode" : "PCK"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "QRY_Q01",
      "display" : "Q01",
      "definition" : "Q01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "QRY_Q02",
      "display" : "Q02",
      "definition" : "Q02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "QRY_R02",
      "display" : "R02, R04",
      "definition" : "R02, R04",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "R02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "QRY_T12",
      "display" : "T12",
      "definition" : "T12",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "T12"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RAR_RAR",
      "display" : "RAR",
      "definition" : "RAR",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "RAR"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RAS_O01",
      "display" : "O01",
      "definition" : "O01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RAS_O02",
      "display" : "O022",
      "definition" : "O022",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "RCI_I05",
      "display" : "I05",
      "definition" : "I05",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I05"
        }
      ]
    },
    {
      "code" : "RCL_I06",
      "display" : "I06",
      "definition" : "I06",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I06"
        }
      ]
    },
    {
      "code" : "RDE_O01",
      "display" : "O01",
      "definition" : "O01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RDO_O01",
      "display" : "O01",
      "definition" : "O01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RDR_RDR",
      "display" : "RDR",
      "definition" : "RDR",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "RDR"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RDS_O01",
      "display" : "O01",
      "definition" : "O01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "REF_I12",
      "display" : "I12, I13, I14, I15",
      "definition" : "I12, I13, I14, I15",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I12"
        },
        {
          "code" : "event",
          "valueCode" : "I13"
        },
        {
          "code" : "event",
          "valueCode" : "I14"
        },
        {
          "code" : "event",
          "valueCode" : "I15"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RER_RER",
      "display" : "RER",
      "definition" : "RER",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "RER"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RGR_RGR",
      "display" : "RGR",
      "definition" : "RGR",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "RGR"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RGV_O01",
      "display" : "O01",
      "definition" : "O01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "ROR_ROR",
      "display" : "ROR",
      "definition" : "ROR",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "R0R"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RPA_I08",
      "display" : "I08, I09. I10, 1II",
      "definition" : "I08, I09. I10, 1II",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I08"
        },
        {
          "code" : "event",
          "valueCode" : "I09"
        },
        {
          "code" : "event",
          "valueCode" : "I10"
        },
        {
          "code" : "event",
          "valueCode" : "I11"
        }
      ]
    },
    {
      "code" : "RPI_I0I",
      "display" : "I01, I04",
      "definition" : "I01, I04",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "RPL_I02",
      "display" : "I02",
      "definition" : "I02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I02"
        },
        {
          "code" : "event",
          "valueCode" : "I03"
        }
      ]
    },
    {
      "code" : "RPR_I03",
      "display" : "I03",
      "definition" : "I03",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "RQA_I08",
      "display" : "I08, I09, I10, I11",
      "definition" : "I08, I09, I10, I11",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I08"
        },
        {
          "code" : "event",
          "valueCode" : "I09"
        },
        {
          "code" : "event",
          "valueCode" : "I10"
        },
        {
          "code" : "event",
          "valueCode" : "I11"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RQC_I05",
      "display" : "I05",
      "definition" : "I05",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I05"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RQC_I06",
      "display" : "I06",
      "definition" : "I06",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I06"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RQI_I0I",
      "display" : "I01, I02, I03",
      "definition" : "I01, I02, I03",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "RQP_I04",
      "display" : "I04",
      "definition" : "I04",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I04"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RQQ_Q09",
      "display" : "Q09",
      "definition" : "Q09",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q09"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RRA_O02",
      "display" : "O02",
      "definition" : "O02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RRD_O02",
      "display" : "O02",
      "definition" : "O02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RRE_O02",
      "display" : "O02",
      "definition" : "O02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RRG_O02",
      "display" : "O02",
      "definition" : "O02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "RRI_I12",
      "display" : "I12, I13, I14, I15",
      "definition" : "I12, I13, I14, I15",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "I12"
        },
        {
          "code" : "event",
          "valueCode" : "I13"
        },
        {
          "code" : "event",
          "valueCode" : "I14"
        },
        {
          "code" : "event",
          "valueCode" : "I15"
        }
      ]
    },
    {
      "code" : "RRO_O02",
      "display" : "O02",
      "definition" : "O02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "O02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "SIU_S12",
      "display" : "S12, S13, S14, S15, S16, S17, S18, S19, S20, S21, S22, S23, S24, S26",
      "definition" : "S12, S13, S14, S15, S16, S17, S18, S19, S20, S21, S22, S23, S24, S26",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "S12"
        },
        {
          "code" : "event",
          "valueCode" : "S13"
        },
        {
          "code" : "event",
          "valueCode" : "S14"
        },
        {
          "code" : "event",
          "valueCode" : "S15"
        },
        {
          "code" : "event",
          "valueCode" : "S16"
        },
        {
          "code" : "event",
          "valueCode" : "S17"
        },
        {
          "code" : "event",
          "valueCode" : "S18"
        },
        {
          "code" : "event",
          "valueCode" : "S19"
        },
        {
          "code" : "event",
          "valueCode" : "S20"
        },
        {
          "code" : "event",
          "valueCode" : "S21"
        },
        {
          "code" : "event",
          "valueCode" : "S22"
        },
        {
          "code" : "event",
          "valueCode" : "S23"
        },
        {
          "code" : "event",
          "valueCode" : "S24"
        },
        {
          "code" : "event",
          "valueCode" : "S26"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "SPQ_Q08",
      "display" : "Q08",
      "definition" : "Q08",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q08"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "SQM_S25",
      "display" : "S25",
      "definition" : "S25",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "S25"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "SQR_S25",
      "display" : "S25",
      "definition" : "S25",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "S25"
        }
      ]
    },
    {
      "code" : "SRM_S01",
      "display" : "S01, S02, S03, S04, S05, S06, S07, S08, S09, S10, S11",
      "definition" : "S01, S02, S03, S04, S05, S06, S07, S08, S09, S10, S11",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "S01"
        },
        {
          "code" : "event",
          "valueCode" : "S02"
        },
        {
          "code" : "event",
          "valueCode" : "S03"
        },
        {
          "code" : "event",
          "valueCode" : "S04"
        },
        {
          "code" : "event",
          "valueCode" : "S05"
        },
        {
          "code" : "event",
          "valueCode" : "S06"
        },
        {
          "code" : "event",
          "valueCode" : "S07"
        },
        {
          "code" : "event",
          "valueCode" : "S08"
        },
        {
          "code" : "event",
          "valueCode" : "S09"
        },
        {
          "code" : "event",
          "valueCode" : "S10"
        },
        {
          "code" : "event",
          "valueCode" : "S11"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "SRM_T12",
      "display" : "T12",
      "definition" : "T12",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "SRR_S01",
      "display" : "S01, S02, S03, S04, S05, S06, S07, S08, S09, S10, S11",
      "definition" : "S01, S02, S03, S04, S05, S06, S07, S08, S09, S10, S11",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "S01"
        },
        {
          "code" : "event",
          "valueCode" : "S02"
        },
        {
          "code" : "event",
          "valueCode" : "S03"
        },
        {
          "code" : "event",
          "valueCode" : "S04"
        },
        {
          "code" : "event",
          "valueCode" : "S05"
        },
        {
          "code" : "event",
          "valueCode" : "S06"
        },
        {
          "code" : "event",
          "valueCode" : "S07"
        },
        {
          "code" : "event",
          "valueCode" : "S08"
        },
        {
          "code" : "event",
          "valueCode" : "S09"
        },
        {
          "code" : "event",
          "valueCode" : "S10"
        },
        {
          "code" : "event",
          "valueCode" : "S11"
        }
      ]
    },
    {
      "code" : "SRR_T12",
      "display" : "T12",
      "definition" : "T12",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        }
      ]
    },
    {
      "code" : "SUR_P09",
      "display" : "P09",
      "definition" : "P09",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "P09"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "UDM_Q05",
      "display" : "Q05",
      "definition" : "Q05",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q05"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "VQQ_Q07",
      "display" : "Q07",
      "definition" : "Q07",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "Q07"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "VXQ_V01",
      "display" : "V01",
      "definition" : "V01",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "V01"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "VXR_V03",
      "display" : "V03",
      "definition" : "V03",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "V03"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "VXU_V04",
      "display" : "V04",
      "definition" : "V04",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "V04"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    },
    {
      "code" : "VXX_V02",
      "display" : "V02",
      "definition" : "V02",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3.1"
        },
        {
          "code" : "event",
          "valueCode" : "V02"
        },
        {
          "code" : "trigger",
          "valueBoolean" : true
        }
      ]
    }
  ]
}

```
