# Order Status (2.3 - 1.2.0) - HL7 v2.3 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Order Status (2.3 - 1.2.0)**

## CodeSystem: Order Status (2.3 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/orderStatus | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:OrderStatus |
| *Other Identifiers:*OID:2.16.840.1.113883.18.18 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action. It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent. Only the filler can originate these values. Used in HL7 Version 2.x messaging in the ORC segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSorderStatus](ValueSet-hl7VSorderStatus.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "orderStatus",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0038"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/orderStatus",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.18"
    }
  ],
  "version" : "1.2.0",
  "name" : "OrderStatus",
  "title" : "Order Status (2.3 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:17:20+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the status of an order. The purpose of these values are to report the status of an order either upon request (solicited), or when the status changes (unsolicited). The values are not intended to initiate action.  It is assumed that the order status value always reflects the status as it is known to the sending application at the time that a message is sent.  Only the filler can originate these values.  Used in HL7 Version 2.x messaging in the ORC segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Some, but not all, results available",
      "definition" : "Some, but not all, results available",
      "designation" : [
        {
          "language" : "de",
          "value" : "einige, aber nicht alle, Resultate verfügbar"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CA",
      "display" : "Order was canceled",
      "definition" : "Order was canceled",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag storniert"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "CM",
      "display" : "Order is completed",
      "definition" : "Order is completed",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag ausgeführt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "DC",
      "display" : "Order was discontinued",
      "definition" : "Order was discontinued",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ausführung des Auftrags abgebrochen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "ER",
      "display" : "Error, order not found",
      "definition" : "Error, order not found",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag nicht gefunden"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "HD",
      "display" : "Order is on hold",
      "definition" : "Order is on hold",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsbearbeitung ausgesetzt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "IP",
      "display" : "In process, unspecified",
      "definition" : "In process, unspecified",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag in Bearbeitung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    },
    {
      "code" : "RP",
      "display" : "Order has been replaced",
      "definition" : "Order has been replaced",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag ist ersetzt worden"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "SC",
      "display" : "In process, scheduled",
      "definition" : "In process, scheduled",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag hat Termin oder ist in Ausführung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        }
      ]
    }
  ]
}

```
