# Nature of Service/Test/Observation (2.3 - 1.0.0) - HL7 v2.3 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Nature of Service/Test/Observation (2.3 - 1.0.0)**

## CodeSystem: Nature of Service/Test/Observation (2.3 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/natureOfServiceTestObservation | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:NatureOfServiceTestObservation |
| *Other Identifiers:*OID:2.16.840.1.113883.18.90 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files. Used in HL7 Version 2.x messaging in the OM1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSnatureOfServiceTestObservation](ValueSet-hl7VSnatureOfServiceTestObservation.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "natureOfServiceTestObservation",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0174"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/natureOfServiceTestObservation",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.90"
    }
  ],
  "version" : "1.0.0",
  "name" : "NatureOfServiceTestObservation",
  "title" : "Nature of Service/Test/Observation (2.3 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:17:20+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of concepts specifying an identification of a test battery, an entire functional procedure or study, a single test value (observation), multiple test batteries or functional procedures as an orderable unit (profile), or a single test value (observation) calculated from other independent observations, typically used as an indicator for Master Files.  Used in HL7 Version 2.x messaging in the OM1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "A",
      "display" : "Atomic test/observation",
      "definition" : "Atomic test/observation (test code or treatment code)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Einzeluntersuchung"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-08-02"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "C",
      "display" : "Single observation, calculated",
      "definition" : "Single observation calculated via a rule or formula from other independent observations (e.g., Alveolar--arterial ratio, cardiac output)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Berechnetes Einzelergebnis"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-08-02"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "F",
      "display" : "Functional procedure",
      "definition" : "Functional procedure that may consist of one or more interrelated measures (e.g., glucose tolerance test, creatine clearance), usually done at different times and/or on different specimens",
      "designation" : [
        {
          "language" : "de",
          "value" : "Funktionstest"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-08-02"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "P",
      "display" : "Profile or battery",
      "definition" : "Profile or battery consisting of many independent atomic observations (e.g., SMA12, electrolytes), usually done at one instrument on one specimen",
      "designation" : [
        {
          "language" : "de",
          "value" : "Batterieanordnung"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-08-02"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "S",
      "display" : "Superset-a set of batteries or procedures",
      "definition" : "Superset-a set of batteries or procedures ordered under a single code unit but processed as separate batteries (e.g., routines = CBC, UA, electrolytes)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Latte von mehreren Batterieanforderungen (Aufnahmelatte)"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2025-08-02"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
