# Master File Identifier Code (2.3 - 1.1.0) - HL7 v2.3 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Master File Identifier Code (2.3 - 1.1.0)**

## CodeSystem: Master File Identifier Code (2.3 - 1.1.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/masterFileIdentifierCodes | *Version*:1.1.0 |
| Active as of 2026-01-27 | *Computable Name*:MasterFileIdentifierCodes |
| *Other Identifiers:*OID:2.16.840.1.113883.18.91 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Master Files. Used in HL7 Version 2.x messaging in the MFI segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSmasterFileIdentifierCode](ValueSet-hl7VSmasterFileIdentifierCode.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "masterFileIdentifierCodes",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0175"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/masterFileIdentifierCodes",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.91"
    }
  ],
  "version" : "1.1.0",
  "name" : "MasterFileIdentifierCodes",
  "title" : "Master File Identifier Code (2.3 - 1.1.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:17:20+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts which are represented by codes identifying HL7 Versions 2.x Master Files.  Used in HL7 Version 2.x messaging in the MFI segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "CDM",
      "display" : "Charge description master file",
      "definition" : "Charge description master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Leistungskatalog"
        }
      ],
      "property" : [
        {
          "code" : "comment",
          "valueString" : "see chapter 6, appendix"
        },
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "CM0",
      "display" : "Clinical study master",
      "definition" : "Clinical study master",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CM1",
      "display" : "Clinical study phase master",
      "definition" : "Clinical study phase master",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "CM2",
      "display" : "Clinical study Data Schedule Master",
      "definition" : "Clinical study Data Schedule Master",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "LOC",
      "display" : "Location master file",
      "definition" : "Location master file (see Chapter 3, Appendix)",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "OM1",
      "display" : "Observation text master file segments (e.g., Lab)",
      "definition" : "Observation text master file segments (e.g., Lab) (see Chapter 87, Appendix B):",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OM2",
      "display" : "Observation text master file segments (e.g., Lab)",
      "definition" : "Observation text master file segments (e.g., Lab) (see Chapter 87, Appendix B):",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OM3",
      "display" : "Observation text master file segments (e.g., Lab)",
      "definition" : "Observation text master file segments (e.g., Lab) (see Chapter 87, Appendix B):",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OM4",
      "display" : "Observation text master file segments (e.g., Lab)",
      "definition" : "Observation text master file segments (e.g., Lab) (see Chapter 87, Appendix B):",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OM5",
      "display" : "Observation text master file segments (e.g., Lab)",
      "definition" : "Observation text master file segments (e.g., Lab) (see Chapter 87, Appendix B):",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "OM6",
      "display" : "Observation text master file segments (e.g., Lab)",
      "definition" : "Observation text master file segments (e.g., Lab) (see Chapter 87, Appendix B):",
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "PRA",
      "display" : "Practitioner master file",
      "definition" : "Practitioner master file (see Chapter 8, Appendix)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ärztekatalog"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    },
    {
      "code" : "STF",
      "display" : "Staff Master File",
      "definition" : "Staff Master File (see Chapter 8, Appendix)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Mitarbeiterkatalog"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-08-21"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        }
      ]
    }
  ]
}

```
