# Event (2.3 - 1.2.0) - HL7 v2.3 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Event (2.3 - 1.2.0)**

## CodeSystem: Event (2.3 - 1.2.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/event | *Version*:1.2.0 |
| Active as of 2026-01-27 | *Computable Name*:Event |
| *Other Identifiers:*OID:2.16.840.1.113883.18.4 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages. Used in HL7 Version 2.x messaging in the MSH segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSevent](ValueSet-hl7VSevent.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "event",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0003"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/event",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.4"
    }
  ],
  "version" : "1.2.0",
  "name" : "Event",
  "title" : "Event (2.3 - 1.2.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:17:20+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts specifying the trigger event for Version 2.x interface messages.  Used in HL7 Version 2.x messaging in the MSH segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VS354-3"
        }
      ],
      "code" : "msgstruct",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#msgstruct",
      "description" : "msgstruct",
      "type" : "code"
    },
    {
      "extension" : [
        {
          "url" : "http://hl7.org/fhir/StructureDefinition/codesystem-property-valueset",
          "valueCanonical" : "http://terminology.hl7.org/v2plusvocab/ValueSet/hl7VShl7VSmessageType"
        }
      ],
      "code" : "msgtype",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#msgtype",
      "description" : "msgtype",
      "type" : "code"
    }
  ],
  "concept" : [
    {
      "code" : "A01",
      "display" : "ADT/ACK - Admit a patient",
      "definition" : "ADT/ACK - Admit a patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "stationäre Aufnahme"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        }
      ]
    },
    {
      "code" : "A02",
      "display" : "ADT/ACK -  Transfer a patient",
      "definition" : "ADT/ACK -  Transfer a patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verlegung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A02"
        }
      ]
    },
    {
      "code" : "A03",
      "display" : "ADT/ACK -  Discharge a patient",
      "definition" : "ADT/ACK -  Discharge a patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Entlassung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A03"
        }
      ]
    },
    {
      "code" : "A04",
      "display" : "ADT/ACK -  Register a patient",
      "definition" : "ADT/ACK -  Register a patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Besuchsmeldung (nicht-stationär)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        }
      ]
    },
    {
      "code" : "A05",
      "display" : "ADT/ACK -  Preadmit a patient",
      "definition" : "ADT/ACK -  Preadmit a patient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Voraufnahme eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        }
      ]
    },
    {
      "code" : "A06",
      "display" : "ADT/ACK -  Transfer an outpatient to inpatient",
      "definition" : "ADT/ACK -  Transfer an outpatient to inpatient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung von ambulant in stationär"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A06"
        }
      ]
    },
    {
      "code" : "A07",
      "display" : "ADT/ACK -  Transfer an inpatient to outpatient",
      "definition" : "ADT/ACK -  Transfer an inpatient to outpatient",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung von stationär in ambulant"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A06"
        }
      ]
    },
    {
      "code" : "A08",
      "display" : "ADT/ACK -  Update patient information",
      "definition" : "ADT/ACK -  Update patient information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung von Patienteninformationen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        }
      ]
    },
    {
      "code" : "A09",
      "display" : "ADT/ACK -  Patient departing",
      "definition" : "ADT/ACK -  Patient departing",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patient verläßt Einrichtung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A09"
        }
      ]
    },
    {
      "code" : "A10",
      "display" : "ADT/ACK -  Patient arriving",
      "definition" : "ADT/ACK -  Patient arriving",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patient erreicht Einrichtung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A09"
        }
      ]
    },
    {
      "code" : "A11",
      "display" : "ADT/ACK -  Cancel admit",
      "definition" : "ADT/ACK -  Cancel admit",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung für A01 und A04"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A09"
        }
      ]
    },
    {
      "code" : "A12",
      "display" : "ADT/ACK -  Cancel transfer",
      "definition" : "ADT/ACK -  Cancel transfer",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung für A02"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A12"
        }
      ]
    },
    {
      "code" : "A13",
      "display" : "ADT/ACK -  Cancel discharge",
      "definition" : "ADT/ACK -  Cancel discharge",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung für A03"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        }
      ]
    },
    {
      "code" : "A14",
      "display" : "ADT/ACK -  Pending admit",
      "definition" : "ADT/ACK -  Pending admit",
      "designation" : [
        {
          "language" : "de",
          "value" : "Geplante Aufnahme"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        }
      ]
    },
    {
      "code" : "A15",
      "display" : "ADT/ACK -  Pending transfer",
      "definition" : "ADT/ACK -  Pending transfer",
      "designation" : [
        {
          "language" : "de",
          "value" : "Geplante Verlegung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A09"
        }
      ]
    },
    {
      "code" : "A16",
      "display" : "ADT/ACK -  Pending discharge",
      "definition" : "ADT/ACK -  Pending discharge",
      "designation" : [
        {
          "language" : "de",
          "value" : "Geplante Entlassung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A16"
        }
      ]
    },
    {
      "code" : "A17",
      "display" : "ADT/ACK -  Swap patients",
      "definition" : "ADT/ACK -  Swap patients",
      "designation" : [
        {
          "language" : "de",
          "value" : "Bettentausch zweier Patienten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A17"
        }
      ]
    },
    {
      "code" : "A18",
      "display" : "ADT/ACK -  Merge patient information",
      "definition" : "ADT/ACK -  Merge patient information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patienteninf. zusammenf. (veraltet, neu: A34ff.)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A18"
        }
      ]
    },
    {
      "code" : "A19",
      "display" : "QRY/ACK -  Patient query",
      "definition" : "QRY/ACK -  Patient query",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfrage nach Patientendaten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QRY_A19"
        }
      ]
    },
    {
      "code" : "A20",
      "display" : "ADT/ACK - Bed status update",
      "definition" : "ADT/ACK -  Bed status update",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung des Bettenstatus"
        }
      ],
      "property" : [
        {
          "code" : "modified",
          "valueDateTime" : "2015-05-07"
        },
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A20"
        }
      ]
    },
    {
      "code" : "A21",
      "display" : "ADT/ACK -  Leave of absence - out (leaving)",
      "definition" : "ADT/ACK -  Leave of absence - out (leaving)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Beginn einer Patientenabwesenheit"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A02"
        }
      ]
    },
    {
      "code" : "A22",
      "display" : "ADT/ACK -  Leave of absence - in (returning)",
      "definition" : "ADT/ACK -  Leave of absence - in (returning)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ende einer Patientenabwesenheit"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A02"
        }
      ]
    },
    {
      "code" : "A23",
      "display" : "ADT/ACK -  Delete a patient record",
      "definition" : "ADT/ACK -  Delete a patient record",
      "designation" : [
        {
          "language" : "de",
          "value" : "Löschen eines Patientensatzes"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A02"
        }
      ]
    },
    {
      "code" : "A24",
      "display" : "ADT/ACK -  Link patient information",
      "definition" : "ADT/ACK -  Link patient information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verknüpfen von Patientendaten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A24"
        }
      ]
    },
    {
      "code" : "A25",
      "display" : "ADT/ACK -  Cancel pending discharge",
      "definition" : "ADT/ACK -  Cancel pending discharge",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung einer eingeleiteten Entlassung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A02"
        }
      ]
    },
    {
      "code" : "A26",
      "display" : "ADT/ACK -  Cancel pending transfer",
      "definition" : "ADT/ACK -  Cancel pending transfer",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung einer eingeleiteten Verlegung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A02"
        }
      ]
    },
    {
      "code" : "A27",
      "display" : "ADT/ACK -  Cancel pending admit",
      "definition" : "ADT/ACK -  Cancel pending admit",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung einer eingeleiteten Aufnahme"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A02"
        }
      ]
    },
    {
      "code" : "A28",
      "display" : "ADT/ACK -  Add person information",
      "definition" : "ADT/ACK -  Add person information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Personendaten hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        }
      ]
    },
    {
      "code" : "A29",
      "display" : "ADT/ACK -  Delete person information",
      "definition" : "ADT/ACK -  Delete person information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Löschung von personenbezogenen Daten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A02"
        }
      ]
    },
    {
      "code" : "A30",
      "display" : "ADT/ACK -  Merge person information",
      "definition" : "ADT/ACK -  Merge person information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abgleich personenbezogener Daten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A30"
        }
      ]
    },
    {
      "code" : "A31",
      "display" : "ADT/ACK -  Update person information",
      "definition" : "ADT/ACK -  Update person information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ändern personenbezogener Daten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A01"
        }
      ]
    },
    {
      "code" : "A32",
      "display" : "ADT/ACK -  Cancel patient arriving",
      "definition" : "ADT/ACK -  Cancel patient arriving",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung eines Patientenzugangs (Bettenzuweisung)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A02"
        }
      ]
    },
    {
      "code" : "A33",
      "display" : "ADT/ACK -  Cancel patient departing",
      "definition" : "ADT/ACK -  Cancel patient departing",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung eines Patientenabgangs (Bettenfreigabe)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A02"
        }
      ]
    },
    {
      "code" : "A34",
      "display" : "ADT/ACK -  Merge patient information - patient ID only",
      "definition" : "ADT/ACK -  Merge patient information - patient ID only",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abgleich nur der Patientennummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A30"
        }
      ]
    },
    {
      "code" : "A35",
      "display" : "ADT/ACK -  Merge patient information - account number only",
      "definition" : "ADT/ACK -  Merge patient information - account number only",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abgleich nur der Abrechnungsnummer / Debitorenkontonummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A30"
        }
      ]
    },
    {
      "code" : "A36",
      "display" : "ADT/ACK -  Merge patient information - patient ID and account number",
      "definition" : "ADT/ACK -  Merge patient information - patient ID and account number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abgleich von Patientennummer und Abrechnungsnummer / Debitorenkontonummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A30"
        }
      ]
    },
    {
      "code" : "A37",
      "display" : "ADT/ACK -  Unlink patient information",
      "definition" : "ADT/ACK -  Unlink patient information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auflösung einer Verknüpfung von Patientendaten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A24"
        }
      ]
    },
    {
      "code" : "A38",
      "display" : "ADT/ACK - Cancel pre-admit",
      "definition" : "ADT/ACK - Cancel pre-admit",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung zu A05"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A38"
        }
      ]
    },
    {
      "code" : "A39",
      "display" : "ADT/ACK - Merge person - external ID",
      "definition" : "ADT/ACK - Merge person - external ID",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zusammenführung von Information über externe ID"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A39"
        }
      ]
    },
    {
      "code" : "A40",
      "display" : "ADT/ACK - Merge patient - internal ID",
      "definition" : "ADT/ACK - Merge patient - internal ID",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zusammenführung v. Pat-Information über interne ID"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A39"
        }
      ]
    },
    {
      "code" : "A41",
      "display" : "ADT/ACK - Merge account - patient account number",
      "definition" : "ADT/ACK - Merge account - patient account number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zusammenführung von Konten über Kontonummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A39"
        }
      ]
    },
    {
      "code" : "A42",
      "display" : "ADT/ACK - Merge visit - visit number",
      "definition" : "ADT/ACK - Merge visit - visit number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Zusammenführung v.Fall-Information über Fallnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A39"
        }
      ]
    },
    {
      "code" : "A43",
      "display" : "ADT/ACK - Move patient information - internal ID",
      "definition" : "ADT/ACK - Move patient information - internal ID",
      "designation" : [
        {
          "language" : "de",
          "value" : "Korrektur einer falschen Zuordnung bzgl. interne PID"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A43"
        }
      ]
    },
    {
      "code" : "A44",
      "display" : "ADT/ACK - Move account information - internal ID",
      "definition" : "ADT/ACK - Move account information - internal ID",
      "designation" : [
        {
          "language" : "de",
          "value" : "Korrektur einer falschen Zuordnung bzgl.Abrechungsnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A43"
        }
      ]
    },
    {
      "code" : "A45",
      "display" : "ADT/ACK - Move visit information - visit number",
      "definition" : "ADT/ACK - Move visit information - visit number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Korrektur einer falschen Zuordnung bzgl.Fallnummer"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A45"
        }
      ]
    },
    {
      "code" : "A46",
      "display" : "ADT/ACK - Change external ID",
      "definition" : "ADT/ACK - Change external ID",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung der externen Pat.ID (PID-2)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A30"
        }
      ]
    },
    {
      "code" : "A47",
      "display" : "ADT/ACK - Change internal ID",
      "definition" : "ADT/ACK - Change internal ID",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung der internen Pat.ID (PID-3)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A30"
        }
      ]
    },
    {
      "code" : "A48",
      "display" : "ADT/ACK - Change alternate patient ID",
      "definition" : "ADT/ACK - Change alternate patient ID",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung der alternativen Pat.ID (PID-4)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A30"
        }
      ]
    },
    {
      "code" : "A49",
      "display" : "ADT/ACK - Change patient account number",
      "definition" : "ADT/ACK - Change patient account number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung der Abrechungsnummer (PID-18)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A30"
        }
      ]
    },
    {
      "code" : "A50",
      "display" : "ADT/ACK - Change visit number",
      "definition" : "ADT/ACK - Change visit number",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung der Fallnummer (PV1-19)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A50"
        }
      ]
    },
    {
      "code" : "A51",
      "display" : "ADT/ACK - Change alternate visit ID",
      "definition" : "ADT/ACK - Change alternate visit ID",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung der alternativen Fallnummer (PV1-50)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ADT_A50"
        }
      ]
    },
    {
      "code" : "C01",
      "display" : "SRM - Register a patient on a clinical trial",
      "definition" : "SRM - Register a patient on a clinical trial",
      "designation" : [
        {
          "language" : "de",
          "value" : "Registrierung eines Patienten f.eine klin.Studie"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        }
      ]
    },
    {
      "code" : "C02",
      "display" : "SRM - Cancel a patient registration on clinical trial (for clerical mistakes only)",
      "definition" : "SRM - Cancel a patient registration on clinical trial (for clerical mistakes only)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Löschung der Registrierung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        }
      ]
    },
    {
      "code" : "C03",
      "display" : "SRM - Correct/update registration information",
      "definition" : "SRM - Correct/update registration information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Korrektur/Änderung der Registrierung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        }
      ]
    },
    {
      "code" : "C04",
      "display" : "SRM - Patient has gone off a clinical trial",
      "definition" : "SRM - Patient has gone off a clinical trial",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patient ist aus der Studie ausgeschieden"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        }
      ]
    },
    {
      "code" : "C05",
      "display" : "SRM - Patient enters phase of clinical trial",
      "definition" : "SRM - Patient enters phase of clinical trial",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patient tritt in Studienphase ein"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        }
      ]
    },
    {
      "code" : "C06",
      "display" : "SRM - Cancel patient entering a phase (clerical mistake)",
      "definition" : "SRM - Cancel patient entering a phase (clerical mistake)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Löschung des Eintritts in eine Studienphase"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        }
      ]
    },
    {
      "code" : "C07",
      "display" : "SRM - Correct/update phase information",
      "definition" : "SRM - Correct/update phase information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Korrektur/Änderung der Angaben zur Studienphase"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        }
      ]
    },
    {
      "code" : "C08",
      "display" : "SRM - Patient has gone off phase of clinical trial",
      "definition" : "SRM - Patient has gone off phase of clinical trial",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patient ist aus Studienphase ausgeschieden"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CRM_C01"
        }
      ]
    },
    {
      "code" : "C09",
      "display" : "CSU - Automated time intervals for reporting, like monthly",
      "definition" : "CSU - Automated time intervals for reporting, like monthly",
      "designation" : [
        {
          "language" : "de",
          "value" : "Festlegung des Zeitintervalls für autom. Berichte"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "C10",
      "display" : "CSU - Patient completes the clinical trial",
      "definition" : "CSU - Patient completes the clinical trial",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patient beendet Studie"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "C11",
      "display" : "CSU - Patient completes a phase of the clinical trial",
      "definition" : "CSU - Patient completes a phase of the clinical trial",
      "designation" : [
        {
          "language" : "de",
          "value" : "Patient beendet eine Studienphase"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "C12",
      "display" : "CSU - Update/correction of patient order/result information",
      "definition" : "CSU - Update/correction of patient order/result information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Korrektur/Änderung von Anforderungen/Ergebnissen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "CSU_C09"
        }
      ]
    },
    {
      "code" : "CNQ",
      "display" : "QRY/EQQ/SPQ/VQQ/RQQ - Cancel query",
      "definition" : "QRY/EQQ/SPQ/VQQ/RQQ - Cancel query",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung einer Anfrage"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "I01",
      "display" : "RQI/RPI - Request for insurance information",
      "definition" : "RQI/RPI - Request for insurance information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderung von Versicherungsdaten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQI_I01"
        }
      ]
    },
    {
      "code" : "I02",
      "display" : "RQI/RPL - Request/receipt of patient selection display list",
      "definition" : "RQI/RPL - Request/receipt of patient selection display list",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderg.einer Patientenauswahlliste (zur Anzeige)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQI_I01"
        }
      ]
    },
    {
      "code" : "I03",
      "display" : "RQI/RPR - Request/receipt of patient selection list",
      "definition" : "RQI/RPR - Request/receipt of patient selection list",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderg.einer strukt. Patientenauswahlliste"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQI_I01"
        }
      ]
    },
    {
      "code" : "I04",
      "display" : "RQD/RPI - Request for patient demographic data",
      "definition" : "RQD/RPI - Request for patient demographic data",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderung demographischer Informationen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQP_I04"
        }
      ]
    },
    {
      "code" : "I05",
      "display" : "RQC/RCI - Request for patient clinical information",
      "definition" : "RQC/RCI - Request for patient clinical information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderung klinischer Informationen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQC_I05"
        }
      ]
    },
    {
      "code" : "I06",
      "display" : "RQC/RCL - Request/receipt of clinical data listing",
      "definition" : "RQC/RCL - Request/receipt of clinical data listing",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderung strukt. klinischer Informationen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQC_I06"
        }
      ]
    },
    {
      "code" : "I07",
      "display" : "PIN/ACK - Unsolicited insurance information",
      "definition" : "PIN/ACK - Unsolicited insurance information",
      "designation" : [
        {
          "language" : "de",
          "value" : "unaufgeforderte Übermittlung v. Versicherungsdaten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PIN_I07"
        }
      ]
    },
    {
      "code" : "I08",
      "display" : "RQA/RPA - Request for treatment authorization information",
      "definition" : "RQA/RPA - Request for treatment authorization information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderung Kostenübernahmeerklärung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        }
      ]
    },
    {
      "code" : "I09",
      "display" : "RQA/RPA - Request for modification to an authorization",
      "definition" : "RQA/RPA - Request for modification to an authorization",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderg bzgl. Änderung Kostenübernahmeerklärung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        }
      ]
    },
    {
      "code" : "I10",
      "display" : "RQA/RPA - Request for resubmission of an authorization",
      "definition" : "RQA/RPA - Request for resubmission of an authorization",
      "designation" : [
        {
          "language" : "de",
          "value" : "erneute Anforderung Kostenübernahmeerklärung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        }
      ]
    },
    {
      "code" : "I11",
      "display" : "RQA/RPA - Request for cancellation of an authorization",
      "definition" : "RQA/RPA - Request for cancellation of an authorization",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfordrg Stornierg einer Kostenübernahmeerklärung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RQA_I08"
        }
      ]
    },
    {
      "code" : "I12",
      "display" : "REF/RRI - Patient referral",
      "definition" : "REF/RRI - Patient referral",
      "designation" : [
        {
          "language" : "de",
          "value" : "Überweisung eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        }
      ]
    },
    {
      "code" : "I13",
      "display" : "REF/RRI - Modify patient referral",
      "definition" : "REF/RRI - Modify patient referral",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung einer Patientenüberweisung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        }
      ]
    },
    {
      "code" : "I14",
      "display" : "REF/RRI - Cancel patient referral",
      "definition" : "REF/RRI - Cancel patient referral",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung einer Patientenüberweisung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        }
      ]
    },
    {
      "code" : "I15",
      "display" : "REF/RRI - Request patient referral status",
      "definition" : "REF/RRI - Request patient referral status",
      "designation" : [
        {
          "language" : "de",
          "value" : "Statusabfrage bzgl. Patientenüberweisung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "REF_I12"
        }
      ]
    },
    {
      "code" : "M01",
      "display" : "MFN/MFK - Master file not otherwise specified (for backward compatibility only)",
      "definition" : "MFN/MFK - Master file not otherwise specified (for backward compatibility only)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung (veraltet)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M01"
        }
      ]
    },
    {
      "code" : "M02",
      "display" : "MFN/MFK - Master file - Staff Practioner",
      "definition" : "MFN/MFK - Master file - Staff Practioner",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung - Ärzte"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M02"
        }
      ]
    },
    {
      "code" : "M03",
      "display" : "MFN/MFK - Master file - Test/Observation",
      "definition" : "MFN/MFK - Master file - Test/Observation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung - Tests / Untersuchungen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M03"
        }
      ]
    },
    {
      "code" : "M04",
      "display" : "MFD/ACK - Master files delayed application acknowledgement",
      "definition" : "MFD/ACK - Master files delayed application acknowledgement",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung - delayed appl ack"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M06"
        }
      ]
    },
    {
      "code" : "M05",
      "display" : "MFN/MFK - Patient location master file",
      "definition" : "MFN/MFK - Patient location master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung - Aufenthaltsorte"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M05"
        }
      ]
    },
    {
      "code" : "M06",
      "display" : "MFN/MFK - Charge description master file",
      "definition" : "MFN/MFK - Charge description master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung - Abrechnungskataloge"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M06"
        }
      ]
    },
    {
      "code" : "M07",
      "display" : "MFN/MFK - Clinical study without phases but with schedules master file",
      "definition" : "MFN/MFK - Clinical study without phases but with schedules master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung - klinische Studien ohne Phasen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M07"
        }
      ]
    },
    {
      "code" : "M08",
      "display" : "MFN/MFK - Test/Observation (Numeric) master file",
      "definition" : "MFN/MFK - Test/Observation (Nurmeric) master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung - Tests/Untersuchung mit numerischen Ergebnissen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M08"
        }
      ]
    },
    {
      "code" : "M09",
      "display" : "MFN/MFK - Test/Observation (Categorical) master file",
      "definition" : "MFN/MFK - Test/Observation (Categorical) master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung - Tests mit nicht numerischen Ergebnissen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M09"
        }
      ]
    },
    {
      "code" : "M10",
      "display" : "MFN/MFK - Test/Observation batteries master file",
      "definition" : "MFN/MFK - Test/Observation batteries master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung - Testprofile"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M10"
        }
      ]
    },
    {
      "code" : "M11",
      "display" : "MFN/MFK - Test/calculated observation master file",
      "definition" : "MFN/MFK - Test/calculated observation master file",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stammdatenänderung - berechnete Ergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MFN_M11"
        }
      ]
    },
    {
      "code" : "O01",
      "display" : "ORM - Order message (also RDE, RDS, RGV, RAS,",
      "definition" : "ORM - Order message (also RDE, RDS, RGV, RAS,",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftrag / Verordnung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORM_O01"
        }
      ]
    },
    {
      "code" : "O02",
      "display" : "ORR - Order response (also RRE, RRD, RRG, RRA,",
      "definition" : "ORR - Order response (also RRE, RRD, RRG, RRA,",
      "designation" : [
        {
          "language" : "de",
          "value" : "Auftragsbestätigung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORR_O02"
        }
      ]
    },
    {
      "code" : "P01",
      "display" : "BAR/ACK - Add and update patient account",
      "definition" : "BAR/ACK - Add and update patient account",
      "designation" : [
        {
          "language" : "de",
          "value" : "Eröffnung eines Patientenkontos"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P01"
        }
      ]
    },
    {
      "code" : "P02",
      "display" : "BAR/ACK - Purge patient account",
      "definition" : "BAR/ACK - Purge patient account",
      "designation" : [
        {
          "language" : "de",
          "value" : "Löschen der Abrechnungsdaten eines Patientenkontos"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P02"
        }
      ]
    },
    {
      "code" : "P03",
      "display" : "DFT/ACK - Post detail financial transaction",
      "definition" : "DFT/ACK - Post detail financial transaction",
      "designation" : [
        {
          "language" : "de",
          "value" : "Leistungs- und Abrechnungsinformationen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DFT_P03"
        }
      ]
    },
    {
      "code" : "P04",
      "display" : "QRY/DSP - Generate bill and A/R statements",
      "definition" : "QRY/DSP - Generate bill and A/R statements",
      "designation" : [
        {
          "language" : "de",
          "value" : "Druck und Anzeige von Rechnungen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "?"
        }
      ]
    },
    {
      "code" : "P05",
      "display" : "BAR/ACK - Update account",
      "definition" : "BAR/ACK - Update account",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung eines Patientenkontos"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P01"
        }
      ]
    },
    {
      "code" : "P06",
      "display" : "BAR/ACK - End account",
      "definition" : "BAR/ACK - End account",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abschluß eines Patientenkontos"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "BAR_P06"
        }
      ]
    },
    {
      "code" : "P07",
      "display" : "PEX - Unsolicited initial individual product experience report",
      "definition" : "PEX - Unsolicited initial individual product experience report",
      "designation" : [
        {
          "language" : "de",
          "value" : "unaufgeforderte individueller Produktersterfahrungsbericht"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "P08",
      "display" : "PEX - Unsolicited update individual product experience report",
      "definition" : "PEX - Unsolicited update individual product experience report",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderung individueller Produktersterfahrungsbericht"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PEX_P07"
        }
      ]
    },
    {
      "code" : "P09",
      "display" : "SUR - Summary product experience report",
      "definition" : "SUR - Summary product experience report",
      "designation" : [
        {
          "language" : "de",
          "value" : "zusammenfassender Produkterfahrungsbericht"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SUR_P09"
        }
      ]
    },
    {
      "code" : "PC1",
      "display" : "PPR - PC/Problem Add",
      "definition" : "PPR - PC/Problem Add",
      "designation" : [
        {
          "language" : "de",
          "value" : "Problem hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "PC2",
      "display" : "PPR - PC/Problem Update",
      "definition" : "PPR - PC/Problem Update",
      "designation" : [
        {
          "language" : "de",
          "value" : "Problem ändern"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "PC3",
      "display" : "PPR - PC/Problem Delete",
      "definition" : "PPR - PC/Problem Delete",
      "designation" : [
        {
          "language" : "de",
          "value" : "Problem löschen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPR_PC1"
        }
      ]
    },
    {
      "code" : "PC4",
      "display" : "PPR - PC/Problem Query",
      "definition" : "PPR - PC/Problem Query",
      "designation" : [
        {
          "language" : "de",
          "value" : "Problem abfragen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QRY_PC4"
        }
      ]
    },
    {
      "code" : "PC5",
      "display" : "PPR - PC/Problem Reponse",
      "definition" : "PPR - PC/Problem Reponse",
      "designation" : [
        {
          "language" : "de",
          "value" : "Problem Anfrage beantworten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PRR_PC5"
        }
      ]
    },
    {
      "code" : "PC6",
      "display" : "PGL - PC/Goal Add",
      "definition" : "PGL - PC/Goal Add",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ziel hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        }
      ]
    },
    {
      "code" : "PC7",
      "display" : "PGL - PC/Goal Update",
      "definition" : "PGL - PC/Goal Update",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ziel ändern"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        }
      ]
    },
    {
      "code" : "PC8",
      "display" : "PGL - PC/Goal Delete",
      "definition" : "PGL - PC/Goal Delete",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ziel löschen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PGL_PC6"
        }
      ]
    },
    {
      "code" : "PC9",
      "display" : "PGL - PC/Goal Query",
      "definition" : "PGL - PC/Goal Query",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ziel abfragen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QRY_PC4"
        }
      ]
    },
    {
      "code" : "PCA",
      "display" : "PGL - PC/Goal Response",
      "definition" : "PGL - PC/Goal Response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Ziel Anfrage beantworten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPV_PCA"
        }
      ]
    },
    {
      "code" : "PCB",
      "display" : "PPP - PC/Pathway (Problem Oriented) Add",
      "definition" : "PPP - PC/Pathway (Problem Oriented) Add",
      "designation" : [
        {
          "language" : "de",
          "value" : "(problemorientierte) Leitlinie hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        }
      ]
    },
    {
      "code" : "PCC",
      "display" : "PPP - PC/Pathway (Problem Oriented) Update",
      "definition" : "PPP - PC/Pathway (Problem Oriented) Update",
      "designation" : [
        {
          "language" : "de",
          "value" : "(problemorientierte) Leitlinie ändern"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        }
      ]
    },
    {
      "code" : "PCD",
      "display" : "PPP - PC/Pathway (Problem Oriented) Delete",
      "definition" : "PPP - PC/Pathway (Problem Oriented) Delete",
      "designation" : [
        {
          "language" : "de",
          "value" : "(problemorientierte) Leitlinie löschen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPP_PCB"
        }
      ]
    },
    {
      "code" : "PCE",
      "display" : "PPP - PC/Pathway (Problem Oriented) Query",
      "definition" : "PPP - PC/Pathway (Problem Oriented) Query",
      "designation" : [
        {
          "language" : "de",
          "value" : "(problemorientierte) Leitlinie abfragen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QRY_PC4"
        }
      ]
    },
    {
      "code" : "PCF",
      "display" : "PPP - PC/Pathway (Problem Oriented) Query Response",
      "definition" : "PPP - PC/Pathway (Problem Oriented) Query Response",
      "designation" : [
        {
          "language" : "de",
          "value" : "(problemorientierte) Leitlinie Anfrage beantworten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PTR_PCF"
        }
      ]
    },
    {
      "code" : "PCG",
      "display" : "PPP - PC/Pathway (Goal Oriented) Add",
      "definition" : "PPP - PC/Pathway (Goal Oriented) Add",
      "designation" : [
        {
          "language" : "de",
          "value" : "(zielorientierte) Leitlinie hinzufügen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        }
      ]
    },
    {
      "code" : "PCH",
      "display" : "PPP - PC/Pathway (Goal Oriented) Update",
      "definition" : "PPP - PC/Pathway (Goal Oriented) Update",
      "designation" : [
        {
          "language" : "de",
          "value" : "(zielorientierte) Leitlinie ändern"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        }
      ]
    },
    {
      "code" : "PCJ",
      "display" : "PPP - PC/Pathway (Goal Oriented) Delete",
      "definition" : "PPP - PC/Pathway (Goal Oriented) Delete",
      "designation" : [
        {
          "language" : "de",
          "value" : "(zielorientierte) Leitlinie löschen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPG_PCG"
        }
      ]
    },
    {
      "code" : "PCK",
      "display" : "PPP - PC/Pathway (Goal Oriented) Query",
      "definition" : "PPP - PC/Pathway (Goal Oriented) Query",
      "designation" : [
        {
          "language" : "de",
          "value" : "(zielorientierte) Leitlinie abfragen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QRY_PC4"
        }
      ]
    },
    {
      "code" : "PCL",
      "display" : "PPP - PC/Pathway (Goal Oriented) Query Response",
      "definition" : "PPP - PC/Pathway (Goal Oriented) Query Response",
      "designation" : [
        {
          "language" : "de",
          "value" : "(zielorientierte) Leitlinie Anfrage beantworten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "PPT_PCL"
        }
      ]
    },
    {
      "code" : "Q01",
      "display" : "QRY/DSR - Query sent for immediate response",
      "definition" : "QRY/DSR - Query sent for immediate response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfrage mit sofortiger Antwort"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QRY_Q01"
        }
      ]
    },
    {
      "code" : "Q02",
      "display" : "QRY/ACK - Query sent for deferred response",
      "definition" : "QRY/ACK - Query sent for deferred response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfrage mit verzögerter Antwort"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QRY_Q02"
        }
      ]
    },
    {
      "code" : "Q03",
      "display" : "DSR/ACK - Deferred response to a query",
      "definition" : "DSR/ACK - Deferred response to a query",
      "designation" : [
        {
          "language" : "de",
          "value" : "Verzögerte Antwort auf Anfrage"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "DSR_Q03"
        }
      ]
    },
    {
      "code" : "Q05",
      "display" : "UDM/ACK - Unsolicited display update",
      "definition" : "UDM/ACK - Unsolicited display update",
      "designation" : [
        {
          "language" : "de",
          "value" : "Sofortige Bildschirmanzeige (Eilmeldung)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "UDM_Q05"
        }
      ]
    },
    {
      "code" : "Q06",
      "display" : "OSQ/OSR - Query for order status",
      "definition" : "OSQ/OSR - Query for order status",
      "designation" : [
        {
          "language" : "de",
          "value" : "Abfrage des Auftragsstatus"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "OSQ_Q06"
        }
      ]
    },
    {
      "code" : "R01",
      "display" : "ORU/ACK - Unsolicited transmission of an observation",
      "definition" : "ORU/ACK - Unsolicited transmission of an observation",
      "designation" : [
        {
          "language" : "de",
          "value" : "unangeforderte Übermittlung eines Befundes"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_R01"
        }
      ]
    },
    {
      "code" : "R02",
      "display" : "QRY - Query for results of observation",
      "definition" : "QRY - Query for results of observation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfrage nach Untersuchungsergebnis"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QRY_R02"
        }
      ]
    },
    {
      "code" : "R03",
      "display" : "Display-oriented results, query/unsol. update (for backward compatibility only)",
      "definition" : "Display-oriented results, query/unsol. update (for backward compatibility only)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anzeigeorientiertes Ergebnis"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.1"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "?"
        }
      ]
    },
    {
      "code" : "R04",
      "display" : "ORF - Response to query; transmission of requested observation",
      "definition" : "ORF - Response to query; transmission of requested observation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Anfrage / Übermittlung eines angeforderten Ergebnisses"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.2"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "NUL"
        }
      ]
    },
    {
      "code" : "R05",
      "display" : "QRY/DSR- query für display results",
      "definition" : "QRY/DSR- query für display results",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfrage nach anzeigeorientierten Ergebnissen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "?"
        }
      ]
    },
    {
      "code" : "R06",
      "display" : "UDM-unsolicited update/display results",
      "definition" : "UDM-unsolicited update/display results",
      "designation" : [
        {
          "language" : "de",
          "value" : "unaufgeforderte Änderung anzeigeorientierter Ergebnisse"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RAR",
      "display" : "RAR - Pharmacy administration information query response",
      "definition" : "RAR - Pharmacy administration information query response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort bzgl. der Behandlungs-/Darreichungsform"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RAR_RAR"
        }
      ]
    },
    {
      "code" : "RDR",
      "display" : "RDR - Pharmacy dispense information query response",
      "definition" : "RDR - Pharmacy dispense information query response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort bzgl. des zu verabreichenden Medikamentes bzw. der Behandlung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RDR_RDR"
        }
      ]
    },
    {
      "code" : "RER",
      "display" : "RER - Pharmacy encoded order information query response",
      "definition" : "RER - Pharmacy encoded order information query response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort bzgl. des zu verabreichenden Medikamentes bzw. der Behandlung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RER_RER"
        }
      ]
    },
    {
      "code" : "RGR",
      "display" : "RGR - Pharmacy dose information query response",
      "definition" : "RGR - Pharmacy dose information query response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort bzgl. der Dosis bzw. der Frequenz der Behandlung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "RGR_RGR"
        }
      ]
    },
    {
      "code" : "ROR",
      "display" : "ROR - Pharmacy prescription order query response",
      "definition" : "ROR - Pharmacy prescription order query response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort bzgl. der Verschreibungsanforderung des Arzneiverordnung bzw. d.Behandlg"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ROR_ROR"
        }
      ]
    },
    {
      "code" : "S01",
      "display" : "SRM/SRR - Request new appointment booking",
      "definition" : "SRM/SRR - Request new appointment booking",
      "designation" : [
        {
          "language" : "de",
          "value" : "Terminanforderung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S02",
      "display" : "SRM/SRR - Request appointment rescheduling",
      "definition" : "SRM/SRR - Request appointment rescheduling",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderung für Terminverschiebung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S03",
      "display" : "SRM/SRR - Request appointment modification",
      "definition" : "SRM/SRR - Request appointment modification",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderung für inhaltliche Terminänderung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S04",
      "display" : "SRM/SRR - Request appointment cancellation",
      "definition" : "SRM/SRR - Request appointment cancellation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Absage eines Termins"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S05",
      "display" : "SRM/SRR - Request appointment discontinuation",
      "definition" : "SRM/SRR - Request appointment discontinuation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Aussetzung des aktuellen oder weiterer Termine"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S06",
      "display" : "SRM/SRR - Request appointment deletion",
      "definition" : "SRM/SRR - Request appointment deletion",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung eines Termins"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S07",
      "display" : "SRM/SRR - Request addition of service/resource on appointment",
      "definition" : "SRM/SRR - Request addition of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anforderung zusätzlicher Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S08",
      "display" : "SRM/SRR - Request modification of service/resource on appointment",
      "definition" : "SRM/SRR - Request modification of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderungsanforderung für zusätzliche Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S09",
      "display" : "SRM/SRR - Request cancellation of servic/resource on appointment",
      "definition" : "SRM/SRR - Request cancellation of servic/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Absage für zusätzliche Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S10",
      "display" : "SRM/SRR - Request discontinuation of servic/resource on appointment",
      "definition" : "SRM/SRR - Request discontinuation of servic/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Aussetzung für zusätzliche Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S11",
      "display" : "SRM/SRR - Request deletion of servic/resource on appointment",
      "definition" : "SRM/SRR - Request deletion of servic/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Stornierung für zusätzliche Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SRM_S01"
        }
      ]
    },
    {
      "code" : "S12",
      "display" : "SIU/ACK - Notification of new appointment booking",
      "definition" : "SIU/ACK - Notification of new appointment booking",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über Terminvergabe"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S13",
      "display" : "SIU/ACK - Notification of appointment rescheduling",
      "definition" : "SIU/ACK - Notification of appointment rescheduling",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung für Terminverschiebung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S14",
      "display" : "SIU/ACK - Notification of appointment modification",
      "definition" : "SIU/ACK - Notification of appointment modification",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung für inhaltliche Terminänderung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S15",
      "display" : "SIU/ACK - Notification of appointment cancellation",
      "definition" : "SIU/ACK - Notification of appointment cancellation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über Terminabsage"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S16",
      "display" : "SIU/ACK - Notification of appointment discontinuation",
      "definition" : "SIU/ACK - Notification of appointment discontinuation",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über Aussetzung des aktuellen oder weiterer Termine"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S17",
      "display" : "SIU/ACK - Notification of appointmentdeletion",
      "definition" : "SIU/ACK - Notification of appointmentdeletion",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über Stornierung eines Termins"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S18",
      "display" : "SIU/ACK - Notification of addition of service/resource on appointment",
      "definition" : "SIU/ACK - Notification of addition of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über  zusätzlicher Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S19",
      "display" : "SIU/ACK - Notification ofmodification of service/resource on appointment",
      "definition" : "SIU/ACK - Notification ofmodification of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Änderungsbenachrichtigung f.zusätzl. Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S20",
      "display" : "SIU/ACK - Notification of cancellation of service/resource on appointment",
      "definition" : "SIU/ACK - Notification of cancellation of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung f. zusätzliche Leistungen/Voraussetzungen zu einem Terminabsage"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S21",
      "display" : "SIU/ACK - Notification of discontinuation of service/resource on appointment",
      "definition" : "SIU/ACK - Notification of discontinuation of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über Aussetzung für zusätzliche Leistungen/Voraussetzungen"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S22",
      "display" : "SIU/ACK - Notification of deletion of service/resource on appointment",
      "definition" : "SIU/ACK - Notification of deletion of service/resource on appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung Stornierg.f.zusätzl.Leistungen/Voraussetzungen zu einem Termin"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S23",
      "display" : "SIU/ACK - Notification of blocked schedule time slot(s)",
      "definition" : "SIU/ACK - Notification of blocked schedule time slot(s)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über nicht verfügbare Zeitbereiche"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S24",
      "display" : "SIU/ACK - Notification of open (“unblocked”) schedule time slot(s)",
      "definition" : "SIU/ACK - Notification of open (“unblocked”) schedule time slot(s)",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über (wieder) verfügbare Zeitbereiche"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "S25",
      "display" : "SQM/SQR - Query schedule information",
      "definition" : "SQM/SQR - Query schedule information",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfrage nach Zeitplaninformation"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SQM_S25"
        }
      ]
    },
    {
      "code" : "S26",
      "display" : "notification that patient did not show up for schedule appointment",
      "definition" : "notification that patient did not show up for schedule appointment",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über Nichterscheinen eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "SIU_S12"
        }
      ]
    },
    {
      "code" : "T01",
      "display" : "MDM/ACK - Original document notification",
      "definition" : "MDM/ACK - Original document notification",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über die Neuanlage eines Dokuments ohne Inhalt"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T01"
        }
      ]
    },
    {
      "code" : "T02",
      "display" : "MDM/ACK - Original document notification and content",
      "definition" : "MDM/ACK - Original document notification and content",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über die Neuanlage eines Dokuments mit Inhaltsübermittlung"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T02"
        }
      ]
    },
    {
      "code" : "T03",
      "display" : "MDM/ACK - Document status change notification",
      "definition" : "MDM/ACK - Document status change notification",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über die Statusänderung eines Dokuments (ohne Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T01"
        }
      ]
    },
    {
      "code" : "T04",
      "display" : "MDM/ACK - Document status change notification and content",
      "definition" : "MDM/ACK - Document status change notification and content",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über die Statusänderung eines Dokuments (mit Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T02"
        }
      ]
    },
    {
      "code" : "T05",
      "display" : "MDM/ACK - Document addendum notification",
      "definition" : "MDM/ACK - Document addendum notification",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über die Ergänzung eines Dokuments (ohne Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T01"
        }
      ]
    },
    {
      "code" : "T06",
      "display" : "MDM/ACK - Document addendum notification and content",
      "definition" : "MDM/ACK - Document addendum notification and content",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über die Ergänzung eines Dokuments (mit Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T02"
        }
      ]
    },
    {
      "code" : "T07",
      "display" : "MDM/ACK - Document replace notification",
      "definition" : "MDM/ACK - Document replace notification",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über die Änderung eines Dokuments (ohne Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T01"
        }
      ]
    },
    {
      "code" : "T08",
      "display" : "MDM/ACK - Document replace notification and content",
      "definition" : "MDM/ACK - Document replace notification and content",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über die Änderung eines Dokuments (mit Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T02"
        }
      ]
    },
    {
      "code" : "T09",
      "display" : "MDM/ACK - Document cancel notification",
      "definition" : "MDM/ACK - Document cancel notification",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über den Austausch eines Dokuments (ohne Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T01"
        }
      ]
    },
    {
      "code" : "T10",
      "display" : "MDM/ACK - Document replacement notification and content",
      "definition" : "MDM/ACK - Document replacement notification and content",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über den Austausch eines Dokuments (mit Inhalt)"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T02"
        }
      ]
    },
    {
      "code" : "T11",
      "display" : "MDM/ACK - Document cancel notification",
      "definition" : "MDM/ACK - Document cancel notification",
      "designation" : [
        {
          "language" : "de",
          "value" : "Benachrichtigung über die Löschung eines Dokuments"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "MDM_T01"
        }
      ]
    },
    {
      "code" : "T12",
      "display" : "QRY/DOC - Document query",
      "definition" : "QRY/DOC - Document query",
      "designation" : [
        {
          "language" : "de",
          "value" : "Dokumentanfrage"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "QRY_T12"
        }
      ]
    },
    {
      "code" : "V01",
      "display" : "VXQ - Query for vaccination record",
      "definition" : "VXQ - Query for vaccination record",
      "designation" : [
        {
          "language" : "de",
          "value" : "Anfrage nach Impfstatus eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "VXQ_V01"
        }
      ]
    },
    {
      "code" : "V02",
      "display" : "VXX - Response to vaccination query returning multiple PID matches",
      "definition" : "VXX - Response to vaccination query returning multiple PID matches",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Impfstatusanfrage bei nicht-eindeutiger Patienten-ID"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "VXX_V02"
        }
      ]
    },
    {
      "code" : "V03",
      "display" : "VXR - Vaccination record response",
      "definition" : "VXR - Vaccination record response",
      "designation" : [
        {
          "language" : "de",
          "value" : "Antwort auf Impfstatusanfrage zu einem Patienten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "VXR_V03"
        }
      ]
    },
    {
      "code" : "V04",
      "display" : "VXU - Unsolicited vaccination record update",
      "definition" : "VXU - Unsolicited vaccination record update",
      "designation" : [
        {
          "language" : "de",
          "value" : "unaufgeforderte Änderung zu dem Impfstatus eines Patienten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "VXU_V04"
        }
      ]
    },
    {
      "code" : "W01",
      "display" : "ORU - Waveform result, unsolicited transmission of requested information",
      "definition" : "ORU - Waveform result, unsolicited transmission of requested information",
      "designation" : [
        {
          "language" : "de",
          "value" : "unaufgeforderte Übermittlung von Signaldaten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        },
        {
          "code" : "msgstruct",
          "valueCode" : "ORU_W01"
        }
      ]
    },
    {
      "code" : "W02",
      "display" : "QRF - Waveform result, response to query",
      "definition" : "QRF - Waveform result, response to query",
      "designation" : [
        {
          "language" : "de",
          "value" : "angeforderte Übermittlung von Signaldaten"
        }
      ],
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "X01",
      "display" : "PEX - Product experience",
      "definition" : "PEX - Product experience",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
