# V2CodeSystem - HL7 v2.3 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **V2CodeSystem**

## Resource Profile: V2CodeSystem 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/StructureDefinition/V2CodeSystem | *Version*: |
| Draft as of 2026-01-27 | *Computable Name*:V2CodeSystem |

 
Profile for CodeSystem instances generated in this guide. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.v2.uv.terminology.v23|current/StructureDefinition/V2CodeSystem)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-V2CodeSystem.csv), [Excel](StructureDefinition-V2CodeSystem.xlsx), [Schematron](StructureDefinition-V2CodeSystem.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "V2CodeSystem",
  "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/V2CodeSystem",
  "name" : "V2CodeSystem",
  "status" : "draft",
  "date" : "2026-01-27T19:17:20+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Profile for CodeSystem instances generated in this guide.",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "objimpl",
      "uri" : "http://hl7.org/fhir/object-implementation",
      "name" : "Object Implementation Information"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "CodeSystem",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/CodeSystem",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "CodeSystem",
        "path" : "CodeSystem"
      },
      {
        "id" : "CodeSystem.url",
        "path" : "CodeSystem.url",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.identifier",
        "path" : "CodeSystem.identifier",
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.version",
        "path" : "CodeSystem.version",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.name",
        "path" : "CodeSystem.name",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.title",
        "path" : "CodeSystem.title",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.status",
        "path" : "CodeSystem.status",
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.concept",
        "path" : "CodeSystem.concept",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.concept.code",
        "path" : "CodeSystem.concept.code",
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.concept.display",
        "path" : "CodeSystem.concept.display",
        "min" : 1,
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.concept.definition",
        "path" : "CodeSystem.concept.definition",
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.concept.designation",
        "path" : "CodeSystem.concept.designation",
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.concept.property",
        "path" : "CodeSystem.concept.property",
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.concept.property.code",
        "path" : "CodeSystem.concept.property.code",
        "mustSupport" : true
      },
      {
        "id" : "CodeSystem.concept.concept",
        "path" : "CodeSystem.concept.concept",
        "mustSupport" : true
      }
    ]
  }
}

```
