# Time Delay Post Challenge (2.3 - 1.0.0) - HL7 v2.3 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Time Delay Post Challenge (2.3 - 1.0.0)**

## CodeSystem: Time Delay Post Challenge (2.3 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/timeDelayPostChallenge | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:TimeDelayPostChallenge |
| *Other Identifiers:*OID:2.16.840.1.113883.18.151 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
HL7-defined code system of concepts used to classify an observation definition as being a component of a challenge test. Used in HL7 Version 2.x messaging in the OM1 segment. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VStimeDelayPostChallenge](ValueSet-hl7VStimeDelayPostChallenge.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "timeDelayPostChallenge",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0256"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/timeDelayPostChallenge",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.151"
    }
  ],
  "version" : "1.0.0",
  "name" : "TimeDelayPostChallenge",
  "title" : "Time Delay Post Challenge (2.3 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:17:20+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "HL7-defined code system of concepts used to classify an observation definition as being a component of a challenge test.  Used in HL7 Version 2.x messaging in the OM1 segment.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : true,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "10D",
      "display" : "10 days",
      "definition" : "10 days",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "10M",
      "display" : "10 minutes post challenge",
      "definition" : "10 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "12H",
      "display" : "12 hours post challenge",
      "definition" : "12 hours post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "15M",
      "display" : "15 minutes post challenge",
      "definition" : "15 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "1H",
      "display" : "1 hour post challenge",
      "definition" : "1 hour post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "1L",
      "display" : "1 month (30 days) post challenge",
      "definition" : "1 month (30 days) post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "1M",
      "display" : "1 minute post challenge",
      "definition" : "1 minute post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "1W",
      "display" : "1 week",
      "definition" : "1 week",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "2.5H",
      "display" : "2 1/2 hours post challenge",
      "definition" : "2 1/2 hours post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "20M",
      "display" : "20 minutes post challenge",
      "definition" : "20 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "24H",
      "display" : "24 hours post challenge",
      "definition" : "24 hours post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "25M",
      "display" : "25 minutes post challenge",
      "definition" : "25 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "2D",
      "display" : "2 days",
      "definition" : "2 days",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "2H",
      "display" : "2 hours post challenge",
      "definition" : "2 hours post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "2L",
      "display" : "2 months (60 days) post challenge",
      "definition" : "2 months (60 days) post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "2M",
      "display" : "2 minutes post challenge",
      "definition" : "2 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "2W",
      "display" : "2 weeks",
      "definition" : "2 weeks",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "30M",
      "display" : "30 minutes post challenge",
      "definition" : "30 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "3D",
      "display" : "3 days",
      "definition" : "3 days",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "3H",
      "display" : "3 hours post challenge",
      "definition" : "3 hours post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "3L",
      "display" : "3 months (90 days) post challenge",
      "definition" : "3 months (90 days) post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "3M",
      "display" : "3 minutes post challenge",
      "definition" : "3 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "3W",
      "display" : "3 weeks",
      "definition" : "3 weeks",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "4D",
      "display" : "4 days",
      "definition" : "4 days",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "4H",
      "display" : "4 hours post challenge",
      "definition" : "4 hours post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "4M",
      "display" : "4 minutes post challenge",
      "definition" : "4 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "4W",
      "display" : "4 weeks",
      "definition" : "4 weeks",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "5D",
      "display" : "5 days",
      "definition" : "5 days",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "5H",
      "display" : "5 hours post challenge",
      "definition" : "5 hours post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "5M",
      "display" : "5 minutes post challenge",
      "definition" : "5 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "6D",
      "display" : "6 days",
      "definition" : "6 days",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "6H",
      "display" : "6 hours post challenge",
      "definition" : "6 hours post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "6M",
      "display" : "6 minutes post challenge",
      "definition" : "6 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "7D",
      "display" : "7 days",
      "definition" : "7 days",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "7H",
      "display" : "7 hours post challenge",
      "definition" : "7 hours post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "7M",
      "display" : "7 minutes post challenge",
      "definition" : "7 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8H",
      "display" : "8 hours post challenge",
      "definition" : "8 hours post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8H SHIFT",
      "display" : "8 hours aligned on nursing shifts",
      "definition" : "8 hours aligned on nursing shifts",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "8M",
      "display" : "8 minutes post challenge",
      "definition" : "8 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "9M",
      "display" : "9 minutes post challenge",
      "definition" : "9 minutes post challenge",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "BS",
      "display" : "Baseline (time just before the challenge)",
      "definition" : "Baseline (time just before the challenge)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PEAK",
      "display" : "The time post drug dose at which the highest drug level is reached (differs by drug)",
      "definition" : "The time post drug dose at which the highest drug level is reached (differs by drug)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RANDOM",
      "display" : "Time from the challenge, or dose not specified. (random)",
      "definition" : "Time from the challenge, or dose not specified. (random)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TROUGH",
      "display" : "The time post drug dose at which the lowest drug level is reached (varies with drug)",
      "definition" : "The time post drug dose at which the lowest drug level is reached (varies with drug)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
