# Subtype of Referenced Data (2.3 - 1.0.0) - HL7 v2.3 Vocabulary v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Subtype of Referenced Data (2.3 - 1.0.0)**

## CodeSystem: Subtype of Referenced Data (2.3 - 1.0.0) (Experimental) 

| | |
| :--- | :--- |
| *Official URL*:http://terminology.hl7.org/v2plusvocab/CodeSystem/subtypeOfReferencedData | *Version*:1.0.0 |
| Active as of 2026-01-27 | *Computable Name*:SubtypeOfReferencedData |
| *Other Identifiers:*OID:2.16.840.1.113883.18.181 | |
| **Copyright/Legal**: HL7 Inc., 2026 | |

 
Code system of a subset of the media subtypes of binary data that are encoded in an ascii structure or stream. Used in Version 2 messaging ED and RP datatypes, but only in standard 2.5.1 and earlier; after that, it was recommended that the IANA media types be used instead of this short list of HL7-defined codes. More information on the standard media types and subtypes may be found at http://www.iana.org/assignments/media-types/media-types.xhtml. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [Hl7VSsubtypeOfReferencedData](ValueSet-hl7VSsubtypeOfReferencedData.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "subtypeOfReferencedData",
  "extension" : [
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-v2versionCreated",
      "valueString" : "2.3"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-versionHistory",
      "valueString" : "generate correct history somehow"
    },
    {
      "url" : "http://terminology.hl7.org/v2plusvocab/StructureDefinition/codesystem-tableNo",
      "valueString" : "0291"
    }
  ],
  "url" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/subtypeOfReferencedData",
  "identifier" : [
    {
      "system" : "urn:ietf:rfc:3986",
      "value" : "urn:oid:2.16.840.1.113883.18.181"
    }
  ],
  "version" : "1.0.0",
  "name" : "SubtypeOfReferencedData",
  "title" : "Subtype of Referenced Data (2.3 - 1.0.0)",
  "status" : "active",
  "experimental" : true,
  "date" : "2026-01-27T19:17:20+00:00",
  "publisher" : "HL7/FO",
  "contact" : [
    {
      "name" : "HL7/FO",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://www.hl7.org"
        }
      ]
    }
  ],
  "description" : "Code system of a subset of the media subtypes of binary data that are encoded in an ascii structure or stream.  Used in Version 2 messaging  ED and RP datatypes, but only in standard 2.5.1 and earlier; after that, it was recommended that the IANA media types be used instead of this short list of HL7-defined codes.   More information on the standard media types and subtypes may be found at http://www.iana.org/assignments/media-types/media-types.xhtml.",
  "copyright" : "HL7 Inc., 2026",
  "caseSensitive" : false,
  "compositional" : false,
  "content" : "complete",
  "property" : [
    {
      "code" : "versionIntroduced",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionIntroduced",
      "description" : "version when was this code introduced",
      "type" : "string"
    },
    {
      "code" : "versionDeprecated",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#versionDeprecated",
      "description" : "version when was this code deprecated",
      "type" : "string"
    },
    {
      "code" : "status",
      "uri" : "http://hl7.org/fhir/concept-properties#status",
      "description" : "A code that indicates the status of the concept. Typical values are active, experimental, deprecated, and retired",
      "type" : "code"
    },
    {
      "code" : "comment",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#comment",
      "description" : "A string that provides additional detail pertinent to the use or understanding of the concept",
      "type" : "string"
    },
    {
      "code" : "usage",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#usage",
      "description" : "usage notes for this code",
      "type" : "string"
    },
    {
      "code" : "modified",
      "uri" : "http://terminology.hl7.org/v2plusvocab/CodeSystem/Property#modified",
      "description" : "date of last modification",
      "type" : "dateTime"
    }
  ],
  "concept" : [
    {
      "code" : "BASIC",
      "display" : "ISDN PCM audio data",
      "definition" : "ISDN PCM audio data",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "DICOM",
      "display" : "Digital Imaging and Communications in Medicine",
      "definition" : "Digital Imaging and Communications in Medicine",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "FAX",
      "display" : "Facsimile data",
      "definition" : "Facsimile data",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "GIF",
      "display" : "Needs formal description",
      "definition" : "Needs formal description",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "HTML",
      "display" : "Hypertext Markup Language",
      "definition" : "Hypertext Markup Language",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "JOT",
      "display" : "Electronic ink data (Jot 1.0 standard)",
      "definition" : "Electronic ink data (Jot 1.0 standard)",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "JPEG",
      "display" : "Needs formal description",
      "definition" : "Needs formal description",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "Octet-stream",
      "display" : "Uninterpreted binary data",
      "definition" : "Uninterpreted binary data",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PICT",
      "display" : "PICT format image data",
      "definition" : "PICT format image data",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "PostScript",
      "display" : "PostScript program",
      "definition" : "PostScript program",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "RTF",
      "display" : "Rich Text Format",
      "definition" : "Rich Text Format",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    },
    {
      "code" : "TIFF",
      "display" : "TIFF image data",
      "definition" : "TIFF image data",
      "property" : [
        {
          "code" : "versionIntroduced",
          "valueString" : "2.3"
        }
      ]
    }
  ]
}

```
